(function() {
'use strict';

const app = angular.module('dataiku.datasets');


app.controller("LabelsDatasetController", function($scope, $stateParams, $controller, LoggerProvider, DataikuAPI) {
	$controller("BaseRowDatasetController", {$scope: $scope, withConsistency: true});
	
	const Logger = LoggerProvider.getLogger('datasets.labels');
    $scope.viewTypes = [
            {
                name: 'VERIFIED_ONLY',
                displayName: 'Only validated annotations'
            },
            {
                name: 'ALL',
                displayName: 'All annotations'
            }
        ];
    
    $scope.viewChanged = function() {
        // View change will change the schema of the labels dataset, therefore we force fetching it again
        $scope.test();
    };

	$scope.test = function () {
            $scope.testResult = null;
            $scope.testing = true;
            $scope.testable = true;
    
            DataikuAPI.datasets.labels.test($stateParams.projectKey, $scope.dataset).success(function (data) {
                Logger.info('Got test result');
                $scope.testing = false;
                $scope.testResult = data;
                if ($scope.testResult.querySchema) {
                    $scope.dataset.schema = $scope.testResult.querySchema;
                }
                if (!$scope.dataset.name && !$scope.new_dataset_name_manually_edited) {
                    $scope.new_dataset_name = $scope.testResult.suggestedName;
                }
            }).error(function (a, b, c) {
                $scope.testing = false;
                setErrorInScope.call($scope,a,b,c);
            });
        };
    $scope.onLoadComplete = function(){
        $scope.test(true);
    };
    });
}());