-- tmp_mig_time is a temp table that contains the unique timestamp for the whole migration (set up in V11000Migration class)

INSERT INTO history_actions (history_action_json) VALUES (
    jsonb_build_object(
        'id', nextval('history_actions_seq'),
        'type', 'INTERNAL_LOAD_HISTORY',
        'timestamp', (SELECT mig_time FROM tmp_mig_time)
    )
);

INSERT INTO blueprints_history (_revision_json, blueprint_json)
SELECT
    jsonb_build_object(
        'id', nextval('history_revisions_seq'),
        'actionId', (SELECT max(history_action_id) FROM history_actions),
        'timestamp', (SELECT mig_time FROM tmp_mig_time),
        'operation', 'UPDATE',
        'entityType', 'BLUEPRINT'
    ) as _revision_json,
    blueprint_json
FROM blueprints;

INSERT INTO blueprint_versions_history (_revision_json, blueprint_version_json)
SELECT
    jsonb_build_object(
        'id', nextval('history_revisions_seq'),
        'actionId', (SELECT max(history_action_id) FROM history_actions),
        'timestamp', (SELECT mig_time FROM tmp_mig_time),
        'operation', 'UPDATE',
        'entityType', 'BLUEPRINT_VERSION'
    ) as _revision_json,
    blueprint_version_json
FROM blueprint_versions;

INSERT INTO blueprint_version_traces_history (_revision_json, blueprint_version_trace_json)
SELECT
    jsonb_build_object(
        'id', nextval('history_revisions_seq'),
        'actionId', (SELECT max(history_action_id) FROM history_actions),
        'timestamp', (SELECT mig_time FROM tmp_mig_time),
        'operation', 'UPDATE',
        'entityType', 'BLUEPRINT_VERSION_TRACE'
    ) as _revision_json,
    blueprint_version_trace_json
FROM blueprint_version_traces;

INSERT INTO artifacts_history (_revision_json, artifact_json)
SELECT
    jsonb_build_object(
        'id', nextval('history_revisions_seq'),
        'actionId', (SELECT max(history_action_id) FROM history_actions),
        'timestamp', (SELECT mig_time FROM tmp_mig_time),
        'operation', 'UPDATE',
        'entityType', 'ARTIFACT'
    ) as _revision_json,
    artifact_json
FROM artifacts;

INSERT INTO reference_relationships_history (_revision_json, reference_relationship_json)
SELECT
    jsonb_build_object(
        'id', nextval('history_revisions_seq'),
        'actionId', (SELECT max(history_action_id) FROM history_actions),
        'timestamp', (SELECT mig_time FROM tmp_mig_time),
        'operation', 'UPDATE',
        'entityType', 'REFERENCE_RELATIONSHIP'
    ) as _revision_json,
    reference_relationship_json
FROM reference_relationships;

INSERT INTO uploaded_files_history (_revision_json, uploaded_file_json, uploaded_file_data)
SELECT
    jsonb_build_object(
        'id', nextval('history_revisions_seq'),
        'actionId', (SELECT max(history_action_id) FROM history_actions),
        'timestamp', (SELECT mig_time FROM tmp_mig_time),
        'operation', 'UPDATE',
        'entityType', 'UPLOADED_FILE'
    ) as _revision_json,
    uploaded_file_json,
    uploaded_file_data
FROM uploaded_files;

INSERT INTO uploaded_file_relationships_history (_revision_json, uploaded_file_relationship_json)
SELECT
    jsonb_build_object(
        'id', nextval('history_revisions_seq'),
        'actionId', (SELECT max(history_action_id) FROM history_actions),
        'timestamp', (SELECT mig_time FROM tmp_mig_time),
        'operation', 'UPDATE',
        'entityType', 'UPLOADED_FILE_RELATIONSHIP'
    ) as _revision_json,
    uploaded_file_relationship_json
FROM uploaded_file_relationships;

INSERT INTO time_series_history (_revision_json, time_series_json)
SELECT
    jsonb_build_object(
        'id', nextval('history_revisions_seq'),
        'actionId', (SELECT max(history_action_id) FROM history_actions),
        'timestamp', (SELECT mig_time FROM tmp_mig_time),
        'operation', 'UPDATE',
        'entityType', 'TIME_SERIES'
    ) as _revision_json,
    time_series_json
FROM time_series;

INSERT INTO time_series_relationships_history (_revision_json, time_series_relationship_json)
SELECT
    jsonb_build_object(
        'id', nextval('history_revisions_seq'),
        'actionId', (SELECT max(history_action_id) FROM history_actions),
        'timestamp', (SELECT mig_time FROM tmp_mig_time),
        'operation', 'UPDATE',
        'entityType', 'TIME_SERIES_RELATIONSHIP'
    ) as _revision_json,
    time_series_relationship_json
FROM time_series_relationships;

INSERT INTO custom_pages_history (_revision_json, custom_page_json)
SELECT
    jsonb_build_object(
        'id', nextval('history_revisions_seq'),
        'actionId', (SELECT max(history_action_id) FROM history_actions),
        'timestamp', (SELECT mig_time FROM tmp_mig_time),
        'operation', 'UPDATE',
        'entityType', 'CUSTOM_PAGE'
    ) as _revision_json,
    custom_page_json
FROM custom_pages;

INSERT INTO user_mappings_history (_revision_json, user_mapping_json)
SELECT
    jsonb_build_object(
        'id', nextval('history_revisions_seq'),
        'actionId', (SELECT max(history_action_id) FROM history_actions),
        'timestamp', (SELECT mig_time FROM tmp_mig_time),
        'operation', 'UPDATE',
        'entityType', 'USER_MAPPING'
    ) as _revision_json,
    user_mapping_json
FROM user_mappings;

INSERT INTO group_mappings_history (_revision_json, group_mapping_json)
SELECT
    jsonb_build_object(
        'id', nextval('history_revisions_seq'),
        'actionId', (SELECT max(history_action_id) FROM history_actions),
        'timestamp', (SELECT mig_time FROM tmp_mig_time),
        'operation', 'UPDATE',
        'entityType', 'GROUP_MAPPING'
    ) as _revision_json,
    group_mapping_json
FROM group_mappings;

INSERT INTO global_api_key_mappings_history (_revision_json, global_api_key_mapping_json)
SELECT
    jsonb_build_object(
        'id', nextval('history_revisions_seq'),
        'actionId', (SELECT max(history_action_id) FROM history_actions),
        'timestamp', (SELECT mig_time FROM tmp_mig_time),
        'operation', 'UPDATE',
        'entityType', 'GLOBAL_API_KEY_MAPPING'
    ) as _revision_json,
    global_api_key_mapping_json
FROM global_api_key_mappings;

INSERT INTO roles_history (_revision_json, role_json)
SELECT
    jsonb_build_object(
        'id', nextval('history_revisions_seq'),
        'actionId', (SELECT max(history_action_id) FROM history_actions),
        'timestamp', (SELECT mig_time FROM tmp_mig_time),
        'operation', 'UPDATE',
        'entityType', 'ROLE'
    ) as _revision_json,
    role_json
FROM roles;

INSERT INTO blueprint_role_assignments_history (_revision_json, blueprint_role_assignments_json)
SELECT
    jsonb_build_object(
        'id', nextval('history_revisions_seq'),
        'actionId', (SELECT max(history_action_id) FROM history_actions),
        'timestamp', (SELECT mig_time FROM tmp_mig_time),
        'operation', 'UPDATE',
        'entityType', 'BLUEPRINT_ROLE_ASSIGNMENTS'
    ) as _revision_json,
    blueprint_role_assignments_json
FROM blueprint_role_assignments;

INSERT INTO blueprint_permissions_history (_revision_json, blueprint_permissions_json)
SELECT
    jsonb_build_object(
        'id', nextval('history_revisions_seq'),
        'actionId', (SELECT max(history_action_id) FROM history_actions),
        'timestamp', (SELECT mig_time FROM tmp_mig_time),
        'operation', 'UPDATE',
        'entityType', 'BLUEPRINT_PERMISSIONS'
    ) as _revision_json,
    blueprint_permissions_json
FROM blueprint_permissions;

INSERT INTO govern_configuration_history (_revision_json, configuration_item_json)
SELECT
    jsonb_build_object(
        'id', nextval('history_revisions_seq'),
        'actionId', (SELECT max(history_action_id) FROM history_actions),
        'timestamp', (SELECT mig_time FROM tmp_mig_time),
        'operation', 'UPDATE',
        'entityType', 'GOVERN_CONFIGURATION'
    ) as _revision_json,
    configuration_item_json
FROM govern_configuration;

INSERT INTO blueprint_version_signoff_configurations_history (_revision_json, blueprint_version_signoff_configurations_json)
SELECT
    jsonb_build_object(
        'id', nextval('history_revisions_seq'),
        'actionId', (SELECT max(history_action_id) FROM history_actions),
        'timestamp', (SELECT mig_time FROM tmp_mig_time),
        'operation', 'UPDATE',
        'entityType', 'BLUEPRINT_VERSION_SIGNOFF_CONFIGURATIONS'
    ) as _revision_json,
    blueprint_version_signoff_configurations_json
FROM blueprint_version_signoff_configurations;

INSERT INTO artifact_signoffs_history (_revision_json, artifact_signoffs_json)
SELECT
    jsonb_build_object(
        'id', nextval('history_revisions_seq'),
        'actionId', (SELECT max(history_action_id) FROM history_actions),
        'timestamp', (SELECT mig_time FROM tmp_mig_time),
        'operation', 'UPDATE',
        'entityType', 'ARTIFACT_SIGNOFFS'
    ) as _revision_json,
    artifact_signoffs_json
FROM artifact_signoffs;

