/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.AuthenticationType;
import com.amazonaws.services.glue.model.OAuth2PropertiesInput;
import com.amazonaws.services.glue.model.transform.AuthenticationConfigurationInputMarshaller;
import java.io.Serializable;

public class AuthenticationConfigurationInput
implements Serializable,
Cloneable,
StructuredPojo {
    private String authenticationType;
    private String secretArn;
    private OAuth2PropertiesInput oAuth2Properties;

    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public AuthenticationConfigurationInput withAuthenticationType(String authenticationType) {
        this.setAuthenticationType(authenticationType);
        return this;
    }

    public AuthenticationConfigurationInput withAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType.toString();
        return this;
    }

    public void setSecretArn(String secretArn) {
        this.secretArn = secretArn;
    }

    public String getSecretArn() {
        return this.secretArn;
    }

    public AuthenticationConfigurationInput withSecretArn(String secretArn) {
        this.setSecretArn(secretArn);
        return this;
    }

    public void setOAuth2Properties(OAuth2PropertiesInput oAuth2Properties) {
        this.oAuth2Properties = oAuth2Properties;
    }

    public OAuth2PropertiesInput getOAuth2Properties() {
        return this.oAuth2Properties;
    }

    public AuthenticationConfigurationInput withOAuth2Properties(OAuth2PropertiesInput oAuth2Properties) {
        this.setOAuth2Properties(oAuth2Properties);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAuthenticationType() != null) {
            sb.append("AuthenticationType: ").append(this.getAuthenticationType()).append(",");
        }
        if (this.getSecretArn() != null) {
            sb.append("SecretArn: ").append(this.getSecretArn()).append(",");
        }
        if (this.getOAuth2Properties() != null) {
            sb.append("OAuth2Properties: ").append(this.getOAuth2Properties());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationConfigurationInput)) {
            return false;
        }
        AuthenticationConfigurationInput other = (AuthenticationConfigurationInput)obj;
        if (other.getAuthenticationType() == null ^ this.getAuthenticationType() == null) {
            return false;
        }
        if (other.getAuthenticationType() != null && !other.getAuthenticationType().equals(this.getAuthenticationType())) {
            return false;
        }
        if (other.getSecretArn() == null ^ this.getSecretArn() == null) {
            return false;
        }
        if (other.getSecretArn() != null && !other.getSecretArn().equals(this.getSecretArn())) {
            return false;
        }
        if (other.getOAuth2Properties() == null ^ this.getOAuth2Properties() == null) {
            return false;
        }
        return other.getOAuth2Properties() == null || other.getOAuth2Properties().equals(this.getOAuth2Properties());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAuthenticationType() == null ? 0 : this.getAuthenticationType().hashCode());
        hashCode = 31 * hashCode + (this.getSecretArn() == null ? 0 : this.getSecretArn().hashCode());
        hashCode = 31 * hashCode + (this.getOAuth2Properties() == null ? 0 : this.getOAuth2Properties().hashCode());
        return hashCode;
    }

    public AuthenticationConfigurationInput clone() {
        try {
            return (AuthenticationConfigurationInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AuthenticationConfigurationInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

