/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.util;

import java.io.Serializable;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.delta.util.FileNames$CheckpointFile$;
import org.apache.spark.sql.delta.util.FileNames$ChecksumFile$;
import org.apache.spark.sql.delta.util.FileNames$CompactedDeltaFile$;
import org.apache.spark.sql.delta.util.FileNames$DeltaFile$;
import org.apache.spark.sql.delta.util.FileNames$UnbackfilledDeltaFile$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class FileNames$ {
    public static FileNames$ MODULE$;
    private final Regex deltaFileRegex;
    private final Regex uuidDeltaFileRegex;
    private final Regex compactedDeltaFileRegex;
    private final Regex checksumFileRegex;
    private final Regex checkpointFileRegex;
    private final Pattern compactedDeltaFilePattern;
    private final Pattern checksumFilePattern;
    private final Pattern checkpointFilePattern;
    private final String SIDECAR_SUBDIR;
    private final String COMMIT_SUBDIR;

    static {
        new FileNames$();
    }

    public Regex deltaFileRegex() {
        return this.deltaFileRegex;
    }

    public Regex uuidDeltaFileRegex() {
        return this.uuidDeltaFileRegex;
    }

    public Regex compactedDeltaFileRegex() {
        return this.compactedDeltaFileRegex;
    }

    public Regex checksumFileRegex() {
        return this.checksumFileRegex;
    }

    public Regex checkpointFileRegex() {
        return this.checkpointFileRegex;
    }

    private Pattern compactedDeltaFilePattern() {
        return this.compactedDeltaFilePattern;
    }

    private Pattern checksumFilePattern() {
        return this.checksumFilePattern;
    }

    private Pattern checkpointFilePattern() {
        return this.checkpointFilePattern;
    }

    public Path unsafeDeltaFile(Path path, long version) {
        long arg$macro$1 = version;
        return new Path(path, new StringOps("%020d.json").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1)})));
    }

    public Path deltaFile(Path path, long version) {
        return this.unsafeDeltaFile(path, version);
    }

    public Path unbackfilledDeltaFile(Path logPath, long version, Option<String> uuidString) {
        Path basePath = this.commitDirPath(logPath);
        String uuid = (String)uuidString.getOrElse((Function0 & Serializable & scala.Serializable)() -> UUID.randomUUID().toString());
        long arg$macro$1 = version;
        String arg$macro$2 = uuid;
        return new Path(basePath, new StringOps("%020d.%s.json").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1), arg$macro$2})));
    }

    public Option<String> unbackfilledDeltaFile$default$3() {
        return None$.MODULE$;
    }

    public Path sampleFile(Path path, long version) {
        long arg$macro$1 = version;
        return new Path(path, new StringOps("%020d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1)})));
    }

    public Path checksumFile(Path path, long version) {
        long arg$macro$1 = version;
        return new Path(path, new StringOps("%020d.crc").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1)})));
    }

    public Path compactedDeltaFile(Path path, long fromVersion, long toVersion) {
        long arg$macro$1 = fromVersion;
        long arg$macro$2 = toVersion;
        return new Path(path, new StringOps("%020d.%020d.compacted.json").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1), BoxesRunTime.boxToLong((long)arg$macro$2)})));
    }

    public long deltaVersion(Path path) {
        return new StringOps(Predef$.MODULE$.augmentString(path.getName().split("\\.")[0])).toLong();
    }

    public long deltaVersion(FileStatus file) {
        return this.deltaVersion(file.getPath());
    }

    public long checksumVersion(Path path) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(path.getName())).stripSuffix(".crc"))).toLong();
    }

    public long checksumVersion(FileStatus file) {
        return this.checksumVersion(file.getPath());
    }

    public Tuple2<Object, Object> compactedDeltaVersions(Path path) {
        String[] parts = path.getName().split("\\.");
        return new Tuple2.mcJJ.sp(new StringOps(Predef$.MODULE$.augmentString(parts[0])).toLong(), new StringOps(Predef$.MODULE$.augmentString(parts[1])).toLong());
    }

    public Tuple2<Object, Object> compactedDeltaVersions(FileStatus file) {
        return this.compactedDeltaVersions(file.getPath());
    }

    public Path listingPrefix(Path path, long version) {
        long arg$macro$1 = version;
        return new Path(path, new StringOps("%020d.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1)})));
    }

    public Path checkpointFileSingular(Path path, long version) {
        long arg$macro$1 = version;
        return new Path(path, new StringOps("%020d.checkpoint.parquet").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1)})));
    }

    public Seq<Path> checkpointFileWithParts(Path path, long version, int numParts) {
        return (Seq)package$.MODULE$.Range().apply(1, numParts + 1).map((Function1 & Serializable & scala.Serializable)i -> FileNames$.$anonfun$checkpointFileWithParts$1(path, version, numParts, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public Option<Object> numCheckpointParts(Path path) {
        String[] segments = path.getName().split("\\.");
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])segments)).size() != 5) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(segments[3])).toInt()));
    }

    public boolean isCheckpointFile(Path path) {
        return this.checkpointFilePattern().matcher(path.getName()).matches();
    }

    public boolean isCheckpointFile(FileStatus file) {
        return this.isCheckpointFile(file.getPath());
    }

    public boolean isDeltaFile(Path path) {
        return FileNames$DeltaFile$.MODULE$.unapply(path).isDefined();
    }

    public boolean isDeltaFile(FileStatus file) {
        return this.isDeltaFile(file.getPath());
    }

    public boolean isUnbackfilledDeltaFile(Path path) {
        return FileNames$UnbackfilledDeltaFile$.MODULE$.unapply(path).isDefined();
    }

    public boolean isUnbackfilledDeltaFile(FileStatus file) {
        return this.isUnbackfilledDeltaFile(file.getPath());
    }

    public boolean isChecksumFile(Path path) {
        return this.checksumFilePattern().matcher(path.getName()).matches();
    }

    public boolean isChecksumFile(FileStatus file) {
        return this.isChecksumFile(file.getPath());
    }

    public boolean isCompactedDeltaFile(Path path) {
        return this.compactedDeltaFilePattern().matcher(path.getName()).matches();
    }

    public boolean isCompactedDeltaFile(FileStatus file) {
        return this.isCompactedDeltaFile(file.getPath());
    }

    public long checkpointVersion(Path path) {
        return new StringOps(Predef$.MODULE$.augmentString(path.getName().split("\\.")[0])).toLong();
    }

    public long checkpointVersion(FileStatus file) {
        return this.checkpointVersion(file.getPath());
    }

    public Option<Object> getFileVersionOpt(Path path) {
        Path path2 = path;
        Option<Tuple2<Path, Object>> option = FileNames$DeltaFile$.MODULE$.unapply(path2);
        if (!option.isEmpty()) {
            long version = ((Tuple2)option.get())._2$mcJ$sp();
            return new Some((Object)BoxesRunTime.boxToLong((long)version));
        }
        Option<Tuple2<Path, Object>> option2 = FileNames$ChecksumFile$.MODULE$.unapply(path2);
        if (!option2.isEmpty()) {
            long version = ((Tuple2)option2.get())._2$mcJ$sp();
            return new Some((Object)BoxesRunTime.boxToLong((long)version));
        }
        Option<Tuple2<Path, Object>> option3 = FileNames$CheckpointFile$.MODULE$.unapply(path2);
        if (!option3.isEmpty()) {
            long version = ((Tuple2)option3.get())._2$mcJ$sp();
            return new Some((Object)BoxesRunTime.boxToLong((long)version));
        }
        Option<Tuple3<Path, Object, Object>> option4 = FileNames$CompactedDeltaFile$.MODULE$.unapply(path2);
        if (!option4.isEmpty()) {
            long endVersion = BoxesRunTime.unboxToLong((Object)((Tuple3)option4.get())._3());
            return new Some((Object)BoxesRunTime.boxToLong((long)endVersion));
        }
        return None$.MODULE$;
    }

    public long getFileVersion(Path path) {
        return BoxesRunTime.unboxToLong((Object)this.getFileVersionOpt(path).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(47).append("Unexpected file type found in transaction log: ").append(path).toString());
        }));
    }

    public long getFileVersion(FileStatus file) {
        return this.getFileVersion(file.getPath());
    }

    public Path newV2CheckpointJsonFile(Path path, long version) {
        long arg$macro$1 = version;
        String arg$macro$2 = UUID.randomUUID().toString();
        return new Path(path, new StringOps("%020d.checkpoint.%s.json").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1), arg$macro$2})));
    }

    public Path newV2CheckpointParquetFile(Path path, long version) {
        long arg$macro$1 = version;
        String arg$macro$2 = UUID.randomUUID().toString();
        return new Path(path, new StringOps("%020d.checkpoint.%s.parquet").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1), arg$macro$2})));
    }

    public Path newV2CheckpointSidecarFile(Path logPath, long version, int numParts, int currentPart) {
        Path basePath = this.sidecarDirPath(logPath);
        String uuid = UUID.randomUUID().toString();
        long arg$macro$1 = version;
        int arg$macro$2 = currentPart;
        int arg$macro$3 = numParts;
        String arg$macro$4 = uuid;
        return new Path(basePath, new StringOps("%020d.checkpoint.%010d.%010d.%s.parquet").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1), BoxesRunTime.boxToInteger((int)arg$macro$2), BoxesRunTime.boxToInteger((int)arg$macro$3), arg$macro$4})));
    }

    public String SIDECAR_SUBDIR() {
        return this.SIDECAR_SUBDIR;
    }

    public String COMMIT_SUBDIR() {
        return this.COMMIT_SUBDIR;
    }

    public Path sidecarDirPath(Path logPath) {
        return new Path(logPath, this.SIDECAR_SUBDIR());
    }

    public Path commitDirPath(Path logPath) {
        return new Path(logPath, this.COMMIT_SUBDIR());
    }

    public static final /* synthetic */ Path $anonfun$checkpointFileWithParts$1(Path path$1, long version$1, int numParts$1, int i) {
        long arg$macro$1 = version$1;
        int arg$macro$2 = i;
        int arg$macro$3 = numParts$1;
        return new Path(path$1, new StringOps("%020d.checkpoint.%010d.%010d.parquet").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1), BoxesRunTime.boxToInteger((int)arg$macro$2), BoxesRunTime.boxToInteger((int)arg$macro$3)})));
    }

    private FileNames$() {
        MODULE$ = this;
        this.deltaFileRegex = new StringOps(Predef$.MODULE$.augmentString("(\\d+)\\.json")).r();
        this.uuidDeltaFileRegex = new StringOps(Predef$.MODULE$.augmentString("(\\d+)\\.([^.]+)\\.json")).r();
        this.compactedDeltaFileRegex = new StringOps(Predef$.MODULE$.augmentString("(\\d+).(\\d+).compacted.json")).r();
        this.checksumFileRegex = new StringOps(Predef$.MODULE$.augmentString("(\\d+)\\.crc")).r();
        this.checkpointFileRegex = new StringOps(Predef$.MODULE$.augmentString("(\\d+)\\.checkpoint((\\.\\d+\\.\\d+)?\\.parquet|\\.[^.]+\\.(json|parquet))")).r();
        this.compactedDeltaFilePattern = this.compactedDeltaFileRegex().pattern();
        this.checksumFilePattern = this.checksumFileRegex().pattern();
        this.checkpointFilePattern = this.checkpointFileRegex().pattern();
        this.SIDECAR_SUBDIR = "_sidecars";
        this.COMMIT_SUBDIR = "_commits";
    }
}

