/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.transaction;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.ExecutionContext;
import org.datanucleus.transaction.NucleusTransactionException;
import org.datanucleus.transaction.Transaction;

public class TransactionManager {
    private boolean containerManagedConnections = false;
    private Map<ExecutionContext, Transaction> txnForExecutionContext = new ConcurrentHashMap<ExecutionContext, Transaction>();

    public void setContainerManagedConnections(boolean flag) {
        this.containerManagedConnections = flag;
    }

    public void begin(ExecutionContext ec) {
        if (this.txnForExecutionContext.get(ec) != null) {
            throw new NucleusTransactionException("Invalid state. Transaction has already started");
        }
        this.txnForExecutionContext.put(ec, new Transaction());
    }

    public void commit(ExecutionContext ec) {
        Transaction tx = this.txnForExecutionContext.get(ec);
        if (tx == null) {
            throw new NucleusTransactionException("Invalid state. Transaction does not exist");
        }
        try {
            if (!this.containerManagedConnections) {
                tx.commit();
            }
        }
        finally {
            this.txnForExecutionContext.remove(ec);
        }
    }

    public void rollback(ExecutionContext ec) {
        Transaction tx = this.txnForExecutionContext.get(ec);
        if (tx == null) {
            throw new NucleusTransactionException("Invalid state. Transaction does not exist");
        }
        try {
            if (!this.containerManagedConnections) {
                tx.rollback();
            }
        }
        finally {
            this.txnForExecutionContext.remove(ec);
        }
    }

    public Transaction getTransaction(ExecutionContext ec) {
        if (ec == null) {
            return null;
        }
        return this.txnForExecutionContext.get(ec);
    }

    public void setRollbackOnly(ExecutionContext ec) {
        Transaction tx = this.txnForExecutionContext.get(ec);
        if (tx == null) {
            throw new NucleusTransactionException("Invalid state. Transaction does not exist");
        }
        tx.setRollbackOnly();
    }

    public void setTransactionTimeout(ExecutionContext ec, int millis) {
        throw new UnsupportedOperationException();
    }

    public void resume(ExecutionContext ec, Transaction tx) {
        throw new UnsupportedOperationException();
    }

    public Transaction suspend(ExecutionContext ec) {
        throw new UnsupportedOperationException();
    }
}

