/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.opencensus.implcore.trace;

import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.common.Clock;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.implcore.internal.EventQueue;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.implcore.internal.SimpleEventQueue;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.implcore.trace.StartEndHandlerImpl;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.implcore.trace.TracerImpl;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.implcore.trace.config.TraceConfigImpl;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.implcore.trace.export.ExportComponentImpl;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.implcore.trace.internal.RandomHandler;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.implcore.trace.propagation.PropagationComponentImpl;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.trace.Tracer;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.trace.config.TraceConfig;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.trace.export.ExportComponent;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.trace.propagation.PropagationComponent;

public final class TraceComponentImplBase {
    private final ExportComponentImpl exportComponent;
    private final PropagationComponent propagationComponent = new PropagationComponentImpl();
    private final Clock clock;
    private final TraceConfig traceConfig = new TraceConfigImpl();
    private final Tracer tracer;

    public TraceComponentImplBase(Clock clock, RandomHandler randomHandler, EventQueue eventQueue) {
        this.clock = clock;
        this.exportComponent = eventQueue instanceof SimpleEventQueue ? ExportComponentImpl.createWithoutInProcessStores(eventQueue) : ExportComponentImpl.createWithInProcessStores(eventQueue);
        StartEndHandlerImpl startEndHandler = new StartEndHandlerImpl(this.exportComponent.getSpanExporter(), this.exportComponent.getRunningSpanStore(), this.exportComponent.getSampledSpanStore(), eventQueue);
        this.tracer = new TracerImpl(randomHandler, startEndHandler, clock, this.traceConfig);
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public PropagationComponent getPropagationComponent() {
        return this.propagationComponent;
    }

    public final Clock getClock() {
        return this.clock;
    }

    public ExportComponent getExportComponent() {
        return this.exportComponent;
    }

    public TraceConfig getTraceConfig() {
        return this.traceConfig;
    }
}

