/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.CreateVerifiedAccessEndpointEniOptions;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.CreateVerifiedAccessEndpointLoadBalancerOptions;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.CreateVerifiedAccessEndpointRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.TagSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.VerifiedAccessSseSpecificationRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.IdempotentUtils;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class CreateVerifiedAccessEndpointRequestMarshaller
implements Marshaller<Request<CreateVerifiedAccessEndpointRequest>, CreateVerifiedAccessEndpointRequest> {
    @Override
    public Request<CreateVerifiedAccessEndpointRequest> marshall(CreateVerifiedAccessEndpointRequest createVerifiedAccessEndpointRequest) {
        SdkInternalList createVerifiedAccessEndpointRequestTagSpecificationsList;
        CreateVerifiedAccessEndpointEniOptions networkInterfaceOptions;
        CreateVerifiedAccessEndpointLoadBalancerOptions loadBalancerOptions;
        SdkInternalList createVerifiedAccessEndpointRequestSecurityGroupIdsList;
        if (createVerifiedAccessEndpointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateVerifiedAccessEndpointRequest> request = new DefaultRequest<CreateVerifiedAccessEndpointRequest>(createVerifiedAccessEndpointRequest, "AmazonEC2");
        request.addParameter("Action", "CreateVerifiedAccessEndpoint");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVerifiedAccessEndpointRequest.getVerifiedAccessGroupId() != null) {
            request.addParameter("VerifiedAccessGroupId", StringUtils.fromString(createVerifiedAccessEndpointRequest.getVerifiedAccessGroupId()));
        }
        if (createVerifiedAccessEndpointRequest.getEndpointType() != null) {
            request.addParameter("EndpointType", StringUtils.fromString(createVerifiedAccessEndpointRequest.getEndpointType()));
        }
        if (createVerifiedAccessEndpointRequest.getAttachmentType() != null) {
            request.addParameter("AttachmentType", StringUtils.fromString(createVerifiedAccessEndpointRequest.getAttachmentType()));
        }
        if (createVerifiedAccessEndpointRequest.getDomainCertificateArn() != null) {
            request.addParameter("DomainCertificateArn", StringUtils.fromString(createVerifiedAccessEndpointRequest.getDomainCertificateArn()));
        }
        if (createVerifiedAccessEndpointRequest.getApplicationDomain() != null) {
            request.addParameter("ApplicationDomain", StringUtils.fromString(createVerifiedAccessEndpointRequest.getApplicationDomain()));
        }
        if (createVerifiedAccessEndpointRequest.getEndpointDomainPrefix() != null) {
            request.addParameter("EndpointDomainPrefix", StringUtils.fromString(createVerifiedAccessEndpointRequest.getEndpointDomainPrefix()));
        }
        if (!(createVerifiedAccessEndpointRequestSecurityGroupIdsList = (SdkInternalList)createVerifiedAccessEndpointRequest.getSecurityGroupIds()).isEmpty() || !createVerifiedAccessEndpointRequestSecurityGroupIdsList.isAutoConstruct()) {
            int securityGroupIdsListIndex = 1;
            for (String createVerifiedAccessEndpointRequestSecurityGroupIdsListValue : createVerifiedAccessEndpointRequestSecurityGroupIdsList) {
                if (createVerifiedAccessEndpointRequestSecurityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString(createVerifiedAccessEndpointRequestSecurityGroupIdsListValue));
                }
                ++securityGroupIdsListIndex;
            }
        }
        if ((loadBalancerOptions = createVerifiedAccessEndpointRequest.getLoadBalancerOptions()) != null) {
            SdkInternalList createVerifiedAccessEndpointLoadBalancerOptionsSubnetIdsList;
            if (loadBalancerOptions.getProtocol() != null) {
                request.addParameter("LoadBalancerOptions.Protocol", StringUtils.fromString(loadBalancerOptions.getProtocol()));
            }
            if (loadBalancerOptions.getPort() != null) {
                request.addParameter("LoadBalancerOptions.Port", StringUtils.fromInteger(loadBalancerOptions.getPort()));
            }
            if (loadBalancerOptions.getLoadBalancerArn() != null) {
                request.addParameter("LoadBalancerOptions.LoadBalancerArn", StringUtils.fromString(loadBalancerOptions.getLoadBalancerArn()));
            }
            if (!(createVerifiedAccessEndpointLoadBalancerOptionsSubnetIdsList = (SdkInternalList)loadBalancerOptions.getSubnetIds()).isEmpty() || !createVerifiedAccessEndpointLoadBalancerOptionsSubnetIdsList.isAutoConstruct()) {
                int subnetIdsListIndex = 1;
                for (String createVerifiedAccessEndpointLoadBalancerOptionsSubnetIdsListValue : createVerifiedAccessEndpointLoadBalancerOptionsSubnetIdsList) {
                    if (createVerifiedAccessEndpointLoadBalancerOptionsSubnetIdsListValue != null) {
                        request.addParameter("LoadBalancerOptions.SubnetId." + subnetIdsListIndex, StringUtils.fromString(createVerifiedAccessEndpointLoadBalancerOptionsSubnetIdsListValue));
                    }
                    ++subnetIdsListIndex;
                }
            }
        }
        if ((networkInterfaceOptions = createVerifiedAccessEndpointRequest.getNetworkInterfaceOptions()) != null) {
            if (networkInterfaceOptions.getNetworkInterfaceId() != null) {
                request.addParameter("NetworkInterfaceOptions.NetworkInterfaceId", StringUtils.fromString(networkInterfaceOptions.getNetworkInterfaceId()));
            }
            if (networkInterfaceOptions.getProtocol() != null) {
                request.addParameter("NetworkInterfaceOptions.Protocol", StringUtils.fromString(networkInterfaceOptions.getProtocol()));
            }
            if (networkInterfaceOptions.getPort() != null) {
                request.addParameter("NetworkInterfaceOptions.Port", StringUtils.fromInteger(networkInterfaceOptions.getPort()));
            }
        }
        if (createVerifiedAccessEndpointRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(createVerifiedAccessEndpointRequest.getDescription()));
        }
        if (createVerifiedAccessEndpointRequest.getPolicyDocument() != null) {
            request.addParameter("PolicyDocument", StringUtils.fromString(createVerifiedAccessEndpointRequest.getPolicyDocument()));
        }
        if (!(createVerifiedAccessEndpointRequestTagSpecificationsList = (SdkInternalList)createVerifiedAccessEndpointRequest.getTagSpecifications()).isEmpty() || !createVerifiedAccessEndpointRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createVerifiedAccessEndpointRequestTagSpecificationsListValue : createVerifiedAccessEndpointRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createVerifiedAccessEndpointRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(createVerifiedAccessEndpointRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createVerifiedAccessEndpointRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString(createVerifiedAccessEndpointRequest.getClientToken()));
        VerifiedAccessSseSpecificationRequest sseSpecification = createVerifiedAccessEndpointRequest.getSseSpecification();
        if (sseSpecification != null) {
            if (sseSpecification.getCustomerManagedKeyEnabled() != null) {
                request.addParameter("SseSpecification.CustomerManagedKeyEnabled", StringUtils.fromBoolean(sseSpecification.getCustomerManagedKeyEnabled()));
            }
            if (sseSpecification.getKmsKeyArn() != null) {
                request.addParameter("SseSpecification.KmsKeyArn", StringUtils.fromString(sseSpecification.getKmsKeyArn()));
            }
        }
        return request;
    }
}

