/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.pipelines;

import com.dataiku.dss.shadelib.javax.annotation.Nullable;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.tuple.Pair;
import com.dataiku.scoring.Try;
import com.dataiku.scoring.builders.DimensionType;
import com.dataiku.scoring.models.Classifier;
import com.dataiku.scoring.models.ProbabilisticClassifier;
import com.dataiku.scoring.models.Regressor;
import com.dataiku.scoring.pipelines.AbstractPipeline;
import com.dataiku.scoring.pipelines.BinaryProbabilisticPipeline;
import com.dataiku.scoring.pipelines.ClassificationPipeline;
import com.dataiku.scoring.pipelines.ClassificationResult;
import com.dataiku.scoring.pipelines.MulticlassProbabilisticPipeline;
import com.dataiku.scoring.pipelines.NonProbabilisticClassificationPipeline;
import com.dataiku.scoring.pipelines.NonProbabilisticClassificationResult;
import com.dataiku.scoring.pipelines.Pipeline;
import com.dataiku.scoring.pipelines.PreprocessingPipeline;
import com.dataiku.scoring.pipelines.RegressionPipeline;
import com.dataiku.scoring.pipelines.RegressionResult;
import com.dataiku.scoring.pipelines.Result;
import com.dataiku.scoring.util.DateUtils;
import com.dataiku.scoring.util.RawObservation;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public abstract class PartitionedPipeline<P extends Pipeline<PT, Y>, M, PT, Y extends Result<PT>>
extends AbstractPipeline<M, PT, Y> {
    protected final String[] partitioning;
    protected final DimensionType[] partitioningTypes;
    protected final Map<String, P> partitions;
    public static final Logger logger = Logger.getLogger("dku.scoring");

    protected PartitionedPipeline(String[] partitioning, DimensionType[] partitioningTypes, Map<String, P> partitions, Class<PT> predictionColumnType) {
        super(null, null, null, predictionColumnType);
        this.partitioning = partitioning;
        this.partitions = partitions;
        if (partitioning.length == 0) {
            throw new IllegalArgumentException("Empty partitioning");
        }
        if (partitions.isEmpty()) {
            throw new IllegalArgumentException("Partitioned pipeline with no partitions");
        }
        if (null == partitioningTypes) {
            partitioningTypes = new DimensionType[this.partitioning.length];
            for (int i = 0; i < this.partitioning.length; ++i) {
                partitioningTypes[i] = DimensionType.DISCRETE;
            }
        }
        if (partitioningTypes.length != this.partitioning.length) {
            throw new IllegalArgumentException("Different length of partitioning dimensions and types");
        }
        this.partitioningTypes = partitioningTypes;
    }

    @Override
    public void init() {
        if (this.partitions != null) {
            for (Pipeline p : this.partitions.values()) {
                p.init();
            }
        }
        super.init();
    }

    @Override
    public M getModel() {
        throw new UnsupportedOperationException("Trying to fetch unpartitioned model of partitioned pipeline");
    }

    @Override
    public PreprocessingPipeline getPreprocessing() {
        throw new UnsupportedOperationException("Trying to fetch unpartitioned perprocessing of partitioned pipeline");
    }

    public String[] getPartitioning() {
        return this.partitioning;
    }

    public Try<P> getPipeline(String partition) {
        this.checkInitialized();
        if (!this.partitions.containsKey(partition)) {
            return Try.failure("Couldn't find model partition: " + partition);
        }
        return Try.success((Pipeline)this.partitions.get(partition));
    }

    public Try<P> getPipeline(RawObservation o) {
        Try<String> partition = this.getPartition(o);
        if (partition.isError()) {
            return Try.failure(partition.getMessage());
        }
        return this.getPipeline(partition.get());
    }

    public Try<String> getPartition(RawObservation o) {
        if (this.partitioning == null) {
            return Try.success(null);
        }
        StringBuilder sb = new StringBuilder();
        boolean separate = false;
        for (int curPartitioning = 0; curPartitioning < this.partitioning.length; ++curPartitioning) {
            String dimensionValue;
            String dimension = this.partitioning[curPartitioning];
            DimensionType dimensionType = this.partitioningTypes[curPartitioning];
            if (!o.contains(dimension)) {
                return Try.failure("Can't get model partition without missing dimension: " + dimension);
            }
            if (separate) {
                sb.append('|');
            } else {
                separate = true;
            }
            if (DimensionType.DISCRETE == dimensionType) {
                logger.fine("Handling dimension " + dimension + " as discrete");
                dimensionValue = o.getAsString(dimension);
            } else {
                logger.fine("Handling dimension " + dimension + " as time based");
                dimensionValue = this.getTimeDimensionValue(o, dimension, dimensionType);
            }
            logger.fine("Appending value " + dimensionValue + " to partition name for dimension " + dimension);
            sb.append(dimensionValue);
        }
        return Try.success(sb.toString());
    }

    @Override
    public Try<Y> getPredictionResults(RawObservation o) {
        Try<P> p = this.getPipeline(o);
        if (p.isError()) {
            return Try.failure(p.getMessage());
        }
        return ((Pipeline)p.get()).getPredictionResults(o);
    }

    private String getTimeDimensionValue(RawObservation o, String dimension, DimensionType dimensionType) {
        Object dimensionObjValue = o.get(dimension);
        logger.fine("Analyzing time dimension " + dimension + " with value " + String.valueOf(dimensionObjValue));
        String dimensionValue = null;
        if (dimensionObjValue instanceof String) {
            dimensionValue = this.getTimeDimensionValueFromString((String)dimensionObjValue, dimensionType);
        } else if (dimensionObjValue instanceof Number) {
            dimensionValue = this.getTimeDimensionValueFromTimeStamp(((Number)dimensionObjValue).longValue(), dimensionType);
        } else {
            throw new UnsupportedOperationException("Unknown dimension value type for " + dimension + " / " + String.valueOf((Object)dimensionType) + ": " + (dimensionObjValue == null ? "null" : dimensionObjValue.getClass().getName()));
        }
        return dimensionValue;
    }

    private String getTimeDimensionValueFromTimeStamp(long value, DimensionType dt) {
        Object dimensionValue = "";
        Date date = new Date(value);
        Calendar cal = DateUtils.getUTCCalendar();
        cal.setTime(date);
        switch (dt) {
            case HOUR: {
                dimensionValue = String.format("-%02d", cal.get(11));
            }
            case DAY: {
                dimensionValue = String.format("-%02d", cal.get(5)) + (String)dimensionValue;
            }
            case MONTH: {
                dimensionValue = String.format("-%02d", cal.get(2) + 1) + (String)dimensionValue;
            }
            case YEAR: {
                dimensionValue = String.format("%02d", cal.get(1)) + (String)dimensionValue;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unhandled dimension type " + dt.name());
            }
        }
        logger.fine("Generated dimension value " + (String)dimensionValue + " from epoch " + value);
        return dimensionValue;
    }

    private String getTimeDimensionValueFromString(String value, DimensionType dt) {
        if (dt == DimensionType.YEAR && Pattern.matches("^\\d{4}$", value)) {
            return value;
        }
        try {
            long epoch = Long.parseLong(value);
            logger.fine("Matched " + value + " as long / timestamp");
            return this.getTimeDimensionValueFromTimeStamp(epoch, dt);
        }
        catch (NumberFormatException nfe) {
            try {
                long epoch = DateUtils.parseISOUTCWithMicroseconds(value);
                logger.fine("Matched " + value + " as ISO UTC");
                return this.getTimeDimensionValueFromTimeStamp(epoch, dt);
            }
            catch (ParseException pe) {
                logger.fine("Not an epoch nor a date ; returning as is");
                return value;
            }
        }
    }

    @Override
    public List<Pair<String, Class<Object>>> getComputedColumnsTypes(@Nullable List<String> columnsWhitelist) {
        if (!this.partitions.isEmpty()) {
            Map.Entry firstPartitionEntry = (Map.Entry)this.partitions.entrySet().stream().findFirst().get();
            Pipeline firstPartition = (Pipeline)this.partitions.values().stream().findFirst().get();
            logger.info("Arbitrary using the pipeline of partition '" + (String)firstPartitionEntry.getKey() + "' to retrieve computed output column names");
            return firstPartition.getComputedColumnsTypes(columnsWhitelist);
        }
        throw new IllegalStateException("Partitioned pipeline with no partitions");
    }

    @Override
    public List<Pair<String, Optional<Object>>> getComputedColumnsValues(RawObservation observation, Y result, @Nullable List<String> columnsWhitelist) {
        Try<P> p = this.getPipeline(observation);
        if (p.isError()) {
            throw new IllegalArgumentException(p.getMessage());
        }
        return ((Pipeline)p.get()).getComputedColumnsValues(observation, result, columnsWhitelist);
    }

    public static class BinaryProbabilistic
    extends Classification<BinaryProbabilisticPipeline, ProbabilisticClassifier, ClassificationResult>
    implements BinaryProbabilisticPipeline {
        public BinaryProbabilistic(String[] partitioning, DimensionType[] partitioningTypes, Map<String, BinaryProbabilisticPipeline> partitions) {
            super(partitioning, partitioningTypes, partitions);
        }

        @Override
        public double getThreshold() {
            throw new UnsupportedOperationException("Unpartitioned operation on partitioned pipeline");
        }

        @Override
        public Try<Short> getProbaPercentile(ClassificationResult result) {
            return ((BinaryProbabilisticPipeline)this.getPipeline(result)).getProbaPercentile(result);
        }

        @Override
        public Map<String, Double> remapProbabilities(ClassificationResult result) {
            return ((BinaryProbabilisticPipeline)this.getPipeline(result)).remapProbabilities(result);
        }
    }

    public static class MulticlassProbabilistic
    extends Classification<MulticlassProbabilisticPipeline, ProbabilisticClassifier, ClassificationResult>
    implements MulticlassProbabilisticPipeline {
        public MulticlassProbabilistic(String[] partitioning, DimensionType[] partitioningTypes, Map<String, MulticlassProbabilisticPipeline> partitions) {
            super(partitioning, partitioningTypes, partitions);
        }

        @Override
        public Map<String, Double> remapProbabilities(ClassificationResult result) {
            return ((MulticlassProbabilisticPipeline)this.getPipeline(result)).remapProbabilities(result);
        }
    }

    public static class NonProbabilisticClassification
    extends Classification<NonProbabilisticClassificationPipeline, Classifier, NonProbabilisticClassificationResult>
    implements NonProbabilisticClassificationPipeline {
        public NonProbabilisticClassification(String[] partitioning, DimensionType[] partitioningTypes, Map<String, NonProbabilisticClassificationPipeline> partitions) {
            super(partitioning, partitioningTypes, partitions);
        }
    }

    static abstract class Classification<P extends ClassificationPipeline<Y>, M extends Classifier, Y extends Result<String>>
    extends PartitionedPipeline<P, M, String, Y>
    implements ClassificationPipeline<Y> {
        protected Classification(String[] partitioning, DimensionType[] partitioningTypes, Map<String, P> partitions) {
            super(partitioning, partitioningTypes, partitions, String.class);
        }

        @Override
        public String[] getClasses() {
            return ((ClassificationPipeline)this.partitions.values().iterator().next()).getClasses();
        }

        protected P getPipeline(ClassificationResult result) {
            if (result.getPartition() == null) {
                throw new IllegalArgumentException("No partition specified");
            }
            Try p = this.getPipeline(result.getPartition());
            if (p.isError()) {
                throw new IllegalArgumentException(p.getMessage());
            }
            return (P)((ClassificationPipeline)p.get());
        }
    }

    public static class Regression
    extends PartitionedPipeline<RegressionPipeline, Regressor, Double, RegressionResult>
    implements RegressionPipeline {
        public Regression(String[] partitioning, DimensionType[] partitioningTypes, Map<String, RegressionPipeline> partitions) {
            super(partitioning, partitioningTypes, partitions, Double.class);
        }
    }
}

