/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.pipelines.overrides;

import com.dataiku.scoring.models.overrides.MLOverridesParamsBase;
import com.dataiku.scoring.pipelines.NonProbabilisticClassificationResult;
import com.dataiku.scoring.pipelines.OverrideInfo;
import com.dataiku.scoring.pipelines.overrides.OverridesLayerBase;
import com.dataiku.scoring.pipelines.overrides.OverridesOutcomeComputer;
import com.dataiku.scoring.util.RawObservation;

public class NonProbabilisticClassificationOverridesLayer
extends OverridesLayerBase<NonProbabilisticClassificationResult> {
    public NonProbabilisticClassificationOverridesLayer(OverridesOutcomeComputer<RawObservation> outcomeComputer) {
        super(outcomeComputer);
    }

    @Override
    void prepareRowForOverride(RawObservation originalRow, NonProbabilisticClassificationResult rawResult) {
        originalRow.put("prediction", rawResult.getPrediction());
    }

    @Override
    NonProbabilisticClassificationResult applyOverride(OverridesOutcomeComputer.OutcomeCandidate<RawObservation> candidate, NonProbabilisticClassificationResult rawResult) {
        MLOverridesParamsBase.MLOverride.Outcome outcome = candidate.outcome;
        NonProbabilisticClassificationResult result = new NonProbabilisticClassificationResult(outcome.category);
        NonProbabilisticClassificationResult.RawResult rawResultInfo = new NonProbabilisticClassificationResult.RawResult(rawResult);
        switch (outcome.type) {
            case CATEGORY: {
                result.setOverrideInfo(new OverrideInfo(candidate.overrideName, !((String)rawResult.getPrediction()).equals(result.getPrediction()), rawResultInfo));
                break;
            }
            case DECLINED: {
                result.setOverrideInfo(OverrideInfo.declined(candidate.overrideName, rawResultInfo));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Outcome Type (" + String.valueOf((Object)outcome.type) + "). Classification only supports category or declined override");
            }
        }
        return result;
    }
}

