/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.formats.FormatCodes;
import com.dataiku.dip.input.stream.CloseableLineReader;
import java.io.IOException;
import java.io.Reader;

public class BoundedBufferedLineReader
implements CloseableLineReader {
    private Reader br;
    private char[] buffer;
    private boolean skipLF;
    private int nextChar;
    private int nChars;
    private static int defaultCharBufferSize = 8192;
    private final Integer bound;
    private StringBuilder s;

    public BoundedBufferedLineReader(Reader reader, Integer bound) {
        this.br = reader;
        this.buffer = new char[defaultCharBufferSize];
        this.skipLF = false;
        this.nextChar = 0;
        this.nChars = 0;
        this.bound = bound;
        this.s = null;
    }

    private int fillBuffer() throws IOException {
        return this.br.read(this.buffer);
    }

    @Override
    public synchronized String readLine() throws IOException {
        while (true) {
            if (this.nextChar >= this.nChars) {
                this.nChars = this.fillBuffer();
                if (this.nChars == -1) {
                    if (this.s != null && this.s.length() > 0) {
                        String str = this.s.toString();
                        this.s.setLength(0);
                        return str;
                    }
                    return null;
                }
                this.nextChar = 0;
            }
            if (!this.skipLF || this.buffer[this.nextChar] == '\n') {
                // empty if block
            }
            this.skipLF = false;
            int startChar = ++this.nextChar;
            int end = -1;
            char c = '\u0000';
            for (int i = startChar; i < this.nChars; ++i) {
                c = this.buffer[i];
                if (c != '\n' && c != '\r') continue;
                end = i;
                break;
            }
            if (end != -1) {
                String str;
                if (c == '\r') {
                    this.skipLF = true;
                }
                if (this.s == null || this.s.length() == 0) {
                    str = new String(this.buffer, startChar, end - startChar);
                } else {
                    this.s.append(this.buffer, startChar, end - startChar);
                    str = this.s.toString();
                    this.s.setLength(0);
                }
                this.nextChar = end + 1;
                return str;
            }
            if (this.s == null) {
                this.s = new StringBuilder();
            }
            this.s.append(this.buffer, startChar, this.nChars - startChar);
            this.nextChar = this.nChars;
            this.checkBound(this.s);
        }
    }

    private void checkBound(StringBuilder s) throws IOException {
        if (this.bound != null && this.bound > 0 && s.length() > this.bound) {
            String extract = s.substring(0, Math.min(this.bound, 50));
            throw new CodedIOException((InfoMessage.MessageCode)FormatCodes.ERR_FORMAT_LINE_TOO_LARGE, "LineReader is reading a line: '" + extract + "...' which exceeds its bound: " + this.bound);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.br == null) {
            return;
        }
        try {
            this.br.close();
        }
        finally {
            this.br = null;
            this.buffer = null;
        }
    }
}

