/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DkuBackendInitializer;
import com.dataiku.dip.server.ApplicationStarter;
import com.dataiku.dip.server.CountWriterFilter;
import com.dataiku.dip.server.EarlyCallTimingStartFilter;
import com.dataiku.dip.server.controllers.DKUDispatcherServlet;
import com.dataiku.dip.server.controllers.WebSocketController;
import com.dataiku.dip.util.ServletUtils;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import java.io.File;
import java.util.EnumSet;
import java.util.EventListener;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Controller;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.filter.DelegatingFilterProxy;

public class DSSBackendInitializer
implements WebApplicationInitializer {
    public void onStartup(ServletContext servletContext) {
        AnnotationConfigWebApplicationContext rootContext = new AnnotationConfigWebApplicationContext();
        rootContext.register(new Class[]{RootContextConfiguration.class});
        AnnotationConfigWebApplicationContext dispatcherContext = new AnnotationConfigWebApplicationContext();
        dispatcherContext.setParent((ApplicationContext)rootContext);
        dispatcherContext.register(new Class[]{DispatcherServletConfiguration.class});
        servletContext.addListener((EventListener)new ContextLoaderListener((WebApplicationContext)rootContext));
        servletContext.addListener((EventListener)((Object)new ApplicationStarter()));
        FilterRegistration.Dynamic filterConfig = servletContext.addFilter("EarlyCallTimingStartFilter", EarlyCallTimingStartFilter.class);
        filterConfig.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, new String[]{"/*"});
        filterConfig = servletContext.addFilter("CountWriterFilter", CountWriterFilter.class);
        filterConfig.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, new String[]{"/*"});
        filterConfig = servletContext.addFilter("CorsFilter", DelegatingFilterProxy.class);
        filterConfig.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, new String[]{"/publicapi/*"});
        filterConfig.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, new String[]{"/api/connections/init-import-from-alation-open"});
        ServletRegistration.Dynamic servletConfig = servletContext.addServlet("dispatcher", (Servlet)new DKUDispatcherServlet((WebApplicationContext)dispatcherContext));
        servletConfig.setLoadOnStartup(1);
        servletConfig.addMapping(new String[]{"/"});
        servletConfig.setMultipartConfig(ServletUtils.getMultipartConfigElement((File)new File(ApplicationConfigurator.getBaseFolderF(), "tmp/upload-multipart"), (int)1000000));
        servletConfig = servletContext.addServlet("webSocketController", WebSocketController.class);
        servletConfig.setLoadOnStartup(1);
        servletConfig.addMapping(new String[]{"/websocket"});
    }

    @Configuration
    @Import(value={DkuBackendInitializer.RootContextConfiguration.class})
    @ComponentScan(basePackages={"com.dataiku.dip"}, excludeFilters={@ComponentScan.Filter(value={Controller.class}, type=FilterType.ANNOTATION), @ComponentScan.Filter(value={DkuBackendInitializer.NotInRootContext.class})})
    public static class RootContextConfiguration {
    }

    @DkuBackendInitializer.NotInRootContext
    @Configuration
    @Import(value={DkuBackendInitializer.DispatcherServletConfiguration.class})
    @ComponentScan(basePackages={"com.dataiku.dip.shaker.server", "com.dataiku.dip.server"}, useDefaultFilters=false, includeFilters={@ComponentScan.Filter(value={Controller.class}, type=FilterType.ANNOTATION)})
    public static class DispatcherServletConfiguration {
    }
}

