/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.model;

import com.dataiku.dip.analysis.docgen.helpers.ModelDetailsBaseUtil;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import java.io.IOException;
import org.apache.log4j.Logger;

public class OriginAnalysisDetails {
    public final String analysisId;
    public final String mlTaskId;
    public final String sessionId;
    public FullModelId fmi;
    private static Logger logger = Logger.getLogger((String)"dku.analysis.docgen");

    public OriginAnalysisDetails(FullModelId fmi, MLTask mlTask) throws IOException {
        if (fmi.getType() == FullModelId.Type.ANALYSIS) {
            this.fmi = fmi;
        } else {
            ModelDetailsBase modelDetailsBase;
            try {
                modelDetailsBase = ModelDetailsBaseUtil.getModel(mlTask, fmi);
            }
            catch (IOException e) {
                logger.warn((Object)"Unable to get the details from fullModelId");
                throw e;
            }
            String smOriginFmi = modelDetailsBase.smOrigin.fullModelId;
            this.fmi = FullModelId.parse(smOriginFmi);
        }
        this.analysisId = this.fmi.getTaskLoc().analysisId;
        this.mlTaskId = this.fmi.getTaskLoc().mlTaskId;
        this.sessionId = this.fmi.getSessionId();
    }
}

