/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.flow;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.analysis.ml.prediction.flow.EvaluationRecipePayloadParams;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.utils.DKULogger;
import java.util.List;

public class EvaluationDatasetHelper {
    public static final String API_NODE_FEATURE_PREFIX = "clientEvent.features.";
    public static final String CLOUD_API_NODE_FEATURE_PREFIX = "message.features.";
    public static final String SAGEMAKER_FEATURE_PREFIX = "captureData.";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.analysis.flow");

    public static void detectApiLogsDataset(EvaluationRecipePayloadParams desc, Dataset inputDataset, String evaluatedDeploymentId) {
        desc.evaluationDatasetType = desc.evaluationDatasetTypeDetected = EvaluationDatasetHelper.detectEvaluationDatasetType(inputDataset);
        logger.infoV("%s dataset has been detected", new Object[]{desc.evaluationDatasetType});
        switch (desc.evaluationDatasetTypeDetected) {
            case API_NODE_LOGS: 
            case CLOUD_API_NODE_LOGS: {
                desc.dontComputePerformance = true;
                desc.filterApiLogsOnSmvId = true;
                desc.skipScoring = true;
                desc.evaluatedDeploymentId = evaluatedDeploymentId;
                break;
            }
            case SAGEMAKER_LOGS: {
                desc.dontComputePerformance = true;
                desc.skipScoring = true;
            }
        }
    }

    private static EvaluationDatasetType detectEvaluationDatasetType(Dataset inputDataset) {
        List columns = inputDataset.getSchema().columns;
        for (SchemaColumn column : columns) {
            String columnName = column.getName();
            if (columnName.startsWith(API_NODE_FEATURE_PREFIX)) {
                return EvaluationDatasetType.API_NODE_LOGS;
            }
            if (DKUApp.isDataikuCloud() && columnName.startsWith(CLOUD_API_NODE_FEATURE_PREFIX)) {
                return EvaluationDatasetType.CLOUD_API_NODE_LOGS;
            }
            if (!columnName.startsWith(SAGEMAKER_FEATURE_PREFIX)) continue;
            return EvaluationDatasetType.SAGEMAKER_LOGS;
        }
        return EvaluationDatasetType.CLASSIC;
    }

    public static enum EvaluationDatasetType {
        CLASSIC,
        API_NODE_LOGS,
        CLOUD_API_NODE_LOGS,
        SAGEMAKER_LOGS;

    }
}

