/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.flow;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.coreservices.AnalysisDataService;
import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLFlowUtils;
import com.dataiku.dip.analysis.ml.prediction.MLSchemaComparator;
import com.dataiku.dip.analysis.ml.prediction.PredictionResultsReader;
import com.dataiku.dip.analysis.ml.prediction.flow.AbstractPredictionScoringRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.flow.DeepHubScoringRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.flow.EvaluationDatasetHelper;
import com.dataiku.dip.analysis.ml.prediction.flow.EvaluationRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.flow.EvaluationRecipeSchemaComputer;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionRecipesBasicService;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionRecipesMeta;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionRecipesService;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionSMMgmtService;
import com.dataiku.dip.analysis.ml.prediction.flow.StandaloneEvaluationRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.flow.TabularPredictionScoringRecipePayloadParams;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.core.GpuConfig;
import com.dataiku.dip.analysis.model.prediction.CausalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.ClassicalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.MetricParams;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.ResolvedDeepHubPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedPredictionPreprocessingParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedTimeseriesForecastingCoreParams;
import com.dataiku.dip.analysis.model.prediction.TabularPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelDetails;
import com.dataiku.dip.analysis.model.prediction.assertions.MLAssertionsParams;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.ContainerRecipeParams;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.externalml.mlflow.MLFlowModelVersionInfo;
import com.dataiku.dip.labeling.ImageViewSettings;
import com.dataiku.dip.llm.LLMRefEnricherService;
import com.dataiku.dip.mec.drift.ImageDriftParams;
import com.dataiku.dip.mec.drift.TextDriftParams;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.services.PDepsFixuper;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.recipes.ShakerRecipeService;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.WithMessages;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class PredictionRecipesHelper
extends PredictionRecipesBasicService {
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private DatasetSaveService datasetSaveService;
    @Autowired
    private PredictionSMMgmtService savedModelsMgmtService;
    @Autowired
    private SavedModelsCRUDService savedModelsService;
    @Autowired
    private RecipeSaveService recipeSaveService;
    @Autowired
    private ShakerRecipeService shakerRecipeService;
    @Autowired
    private AnalysisDataService dataService;
    @Autowired
    private ManagedDatasetsCreationService mdcService;
    @Autowired
    private GenericRecipesValidationService recipesValidationService;
    @Autowired
    private FlowZonesService flowZonesService;
    @Autowired
    private LLMRefEnricherService llmRefEnricherService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.analysis.flow");

    public RecipeCreator.CreationResult createScoringRecipe_NT(AuthCtx u, String projectKey, PredictionRecipesService.ScoringRecipeCreationOptions options) throws Exception {
        Dataset inputDataset;
        SavedModel sm;
        TransactionContext.assertNoAttachedTransaction();
        RecipeCreator.CreationResult ret = new RecipeCreator.CreationResult();
        AnyLoc savedModelLoc = AnyLoc.resolveSmart(projectKey, options.savedModelSmartName);
        DatasetLocUtils.DatasetLoc inputDatasetLoc = DatasetLocUtils.resolveSmart(projectKey, options.inputDatasetSmartName);
        DatasetLocUtils.DatasetLoc outputDatasetLoc = new DatasetLocUtils.DatasetLoc(projectKey, options.outputDatasetSmartName);
        Dataset outputDataset = null;
        try (Transaction t = this.transactionService.beginRead();){
            sm = this.savedModelsService.getMandatory(savedModelLoc.getProjectKey(), savedModelLoc.getId());
            inputDataset = this.datasetAccessService.getMandatory(inputDatasetLoc);
            if (options.createOutput) {
                outputDataset = this.mdcService.prepareCopyPartitioning(u, projectKey, options.outputDatasetSmartName, options.outputDatasetCreationSettings);
            }
        }
        FullModelId fmi = null;
        if (sm.savedModelType == SavedModel.SavedModelType.DSS_MANAGED) {
            fmi = this.savedModelsMgmtService.getActiveVersionFMI(sm);
        }
        AbstractPredictionScoringRecipePayloadParams desc = null;
        SerializedShakerScript script = null;
        switch (sm.savedModelType.savedModelHandlingType) {
            case INTERNAL: {
                assert (fmi != null);
                PredictionModelDetails details = PredictionResultsReader.makeModelDetails(fmi);
                ResolvedPredictionCoreParams rcp = (ResolvedPredictionCoreParams)fmi.getResolvedCoreParams();
                GpuConfig gpuConfig = details.getCoreParams().executionParams.gpuConfig;
                if (rcp.backendType == MLTask.BackendType.DEEP_HUB) {
                    desc = new DeepHubScoringRecipePayloadParams(rcp.prediction_type, gpuConfig);
                } else if (rcp.prediction_type == PredictionMLTask.PredictionType.TIMESERIES_FORECAST) {
                    predictionDesc = new TabularPredictionScoringRecipePayloadParams(PredictionMLTask.PredictionType.TIMESERIES_FORECAST, sm.savedModelType, gpuConfig);
                    String algorithmName = details.actualParams.resolved.getAlgorithmName();
                    if (PreTrainPredictionModelingParams.Algorithm.SEASONAL_LOESS.name().equals(algorithmName) || PreTrainPredictionModelingParams.Algorithm.CROSTON.name().equals(algorithmName)) {
                        predictionDesc.refitModel = true;
                    }
                    predictionDesc.predictionLength = ((ResolvedTimeseriesForecastingCoreParams)rcp).predictionLength;
                    desc = predictionDesc;
                } else if (rcp.prediction_type == PredictionMLTask.PredictionType.CAUSAL_REGRESSION || rcp.prediction_type == PredictionMLTask.PredictionType.CAUSAL_BINARY_CLASSIFICATION) {
                    predictionDesc = new TabularPredictionScoringRecipePayloadParams(rcp.prediction_type, sm.savedModelType, gpuConfig);
                    predictionDesc.computePropensity = ((CausalPredictionModelDetails)details).modeling.propensityModeling.enabled;
                    desc = predictionDesc;
                } else {
                    predictionDesc = new TabularPredictionScoringRecipePayloadParams(rcp.prediction_type, sm.savedModelType, gpuConfig);
                    SparkSettings sparkSettings = new ClusterSelector().selectForProject(u, projectKey).getSparkSettings();
                    if (sparkSettings.sparkEnabled) {
                        predictionDesc.sparkParams.sparkConf = rcp.executionParams.sparkParams.sparkConf;
                        predictionDesc.sparkParams.sparkUseGlobalMetastore = rcp.executionParams.sparkParams.sparkUseGlobalMetastore;
                    }
                    desc = predictionDesc;
                }
                desc.backendType = rcp.backendType;
                script = details.trainedWithScript;
                if (!options.createOutput) break;
                assert (outputDataset != null);
                Schema expectedPreparationOutputSchema = this.dataService.getInferredSchemaForML_NT(script, projectKey, inputDataset, outputDataset.getType(), u);
                List<InfoMessage> messages = MLSchemaComparator.checkForScore(details.getPreprocessing(), expectedPreparationOutputSchema);
                if (InfoMessage.anyFatal(messages)) {
                    throw ErrorContext.iae((String)("Cannot apply the model with the dataset schema (" + InfoMessage.firstFatal(messages).message + ")"));
                }
                Schema actualPreparedSchema = MLFlowUtils.getSchemaToUseForPreparedScoringInput(details.getPreprocessing(), details.splitDesc.schema, expectedPreparationOutputSchema);
                this.filterInputColumns(rcp, fmi, actualPreparedSchema, desc);
                Schema outputSchema = this.getBaseScoringOutputSchema(actualPreparedSchema, desc, details, sm);
                outputDataset.setSchema(outputSchema);
                break;
            }
            case EXTERNAL_MLFLOW: {
                PredictionMLTask pMiniTask = (PredictionMLTask)sm.miniTask;
                Optional<String> proxyModelProtocolOpt = sm.proxyModelConfiguration != null ? Optional.of(sm.proxyModelConfiguration.protocol) : Optional.empty();
                desc = new TabularPredictionScoringRecipePayloadParams(pMiniTask != null ? pMiniTask.predictionType : null, sm.savedModelType, proxyModelProtocolOpt);
                break;
            }
            case PYTHON_AGENT: 
            case PLUGIN_AGENT: 
            case TOOLS_USING_AGENT: {
                throw new IllegalArgumentException("Agents are not supported in scoring recipe");
            }
            case LLM_GENERIC: {
                throw new IllegalArgumentException("Fine-tuned LLMs are not supported in scoring recipe");
            }
            case RETRIEVAL_AUGMENTED_LLM: {
                throw new IllegalArgumentException("Retrieval Augmented LLMs are not supported in scoring recipe");
            }
        }
        desc.needsInputDataFolder = sm.needsInputDataFolder;
        SerializedRecipe sr = new SerializedRecipe();
        sr.addInput("model", savedModelLoc.getSmartName(outputDatasetLoc.getProjectKey()));
        sr.addInput("main", inputDatasetLoc.getSmartName(outputDatasetLoc.getProjectKey()));
        if (desc.needsInputDataFolder) {
            AnyLoc managedFolderLoc = AnyLoc.resolveSmart(projectKey, options.managedFolderSmartId);
            sr.addInput("data", managedFolderLoc.getSmartName(outputDatasetLoc.getProjectKey()));
        }
        sr.addOutput("main", outputDatasetLoc.getName(), false);
        sr.type = PredictionRecipesMeta.SCORING_META.getType();
        sr.params = new ContainerRecipeParams();
        try (RWTransaction rwt = this.transactionService.beginWriteAsLoggedInUser(u);){
            String recipeName;
            sr.name = recipeName = this.recipeSaveService.transmogrifyName(outputDatasetLoc.getProjectKey(), "score_" + inputDatasetLoc.getName());
            sr.projectKey = projectKey;
            if (StringUtils.isBlank((String)options.zone)) {
                options.zone = this.flowZonesService.retrieveInputZone(sr);
            }
            if (options.outputDatasetCreationSettings != null && StringUtils.isBlank((String)options.outputDatasetCreationSettings.zone)) {
                options.outputDatasetCreationSettings.zone = options.zone;
            }
            if (options.createOutput && outputDataset != null) {
                DatasetSaveService.DatasetCreationContext dsCtx = DatasetSaveService.DatasetCreationContext.buildFromRecipe(sr);
                SerializedDataset sds = outputDataset.serialize();
                if (desc.backendType == MLTask.BackendType.DEEP_HUB) {
                    assert (fmi != null);
                    assert (StringUtils.isNotBlank((String)options.managedFolderSmartId));
                    sds.imageViewSettings = PredictionRecipesHelper.getImageViewSettingsForDeephubScoringOutput(fmi, options.managedFolderSmartId);
                }
                logger.info((Object)("Creating dataset " + JSON.pretty((Object)sds)));
                if (options.outputDatasetCreationSettings != null) {
                    this.flowZonesService.attachObjectToZone(options.outputDatasetCreationSettings.zone, projectKey, sds);
                }
                WithMessages<SerializedDataset> dsWithMsg = this.datasetSaveService.create(outputDatasetLoc.getProjectKey(), sds, dsCtx, u);
                ret.messages.mergeFrom(dsWithMsg.messages);
            }
            if (script != null) {
                this.shakerRecipeService.updateDependenciesOnAnyRecipe(projectKey, sr, script);
            }
            this.flowZonesService.attachObjectToZone(options.zone, projectKey, sr);
            new PDepsFixuper().fixupInPlace(sr);
            this.recipeSaveService.create(outputDatasetLoc.getProjectKey(), sr, JSON.pretty((Object)desc));
            rwt.commit("Created scoring recipe for scoring " + inputDatasetLoc.getName() + " : " + sr.projectKey + "." + sr.name);
            ret.id = recipeName;
            RecipeCreator.CreationResult creationResult = ret;
            return creationResult;
        }
    }

    private static ImageViewSettings getImageViewSettingsForDeephubScoringOutput(FullModelId fmi, String managedFolderSmartId) throws IOException {
        ImageViewSettings ret = new ImageViewSettings();
        ResolvedDeepHubPredictionCoreParams coreParams = (ResolvedDeepHubPredictionCoreParams)fmi.getResolvedCoreParams();
        ResolvedPredictionPreprocessingParams preprocessingParams = (ResolvedPredictionPreprocessingParams)fmi.getResolvedPreprocessingParams();
        ret.defaultViewOnExplore = true;
        ret.enabled = true;
        ret.pathColumn = coreParams.pathColumn;
        ret.managedFolderSmartId = managedFolderSmartId;
        ret.annotationParams.enabled = true;
        ret.annotationParams.annotationColumn = "prediction";
        ret.annotationParams.annotationType = PredictionRecipesHelper.getAnnotationTypeFromPredictionType(coreParams.prediction_type);
        ret.annotationParams.annotationCategories = preprocessingParams.target_remapping.stream().map(e -> e.sourceValue).collect(Collectors.toList());
        return ret;
    }

    private static ImageViewSettings.AnnotationType getAnnotationTypeFromPredictionType(PredictionMLTask.PredictionType predictionType) {
        switch (predictionType) {
            case DEEP_HUB_IMAGE_OBJECT_DETECTION: {
                return ImageViewSettings.AnnotationType.OBJECT_DETECTION;
            }
            case DEEP_HUB_IMAGE_CLASSIFICATION: {
                return ImageViewSettings.AnnotationType.IMAGE_CLASSIFICATION;
            }
        }
        throw new IllegalArgumentException("prediction type '" + String.valueOf((Object)predictionType) + "' does not support images view");
    }

    private void setEvalRecipeCustomMetrics(TabularPredictionModelDetails details, EvaluationRecipePayloadParams evaluationRecipePayloadParams) {
        evaluationRecipePayloadParams.setCustomMetrics(new ArrayList<String>(details.modeling.metrics.getCustomMetricNames()));
        evaluationRecipePayloadParams.setPossibleCustomMetrics(evaluationRecipePayloadParams.getCustomMetrics());
    }

    public String createEvaluationRecipe_NT(AuthCtx u, String projectKey, String name, PredictionRecipesService.EvaluationRecipeCreationOptions options) throws Exception {
        EvaluationRecipeSchemaComputer sc;
        GpuConfig gpuConfig;
        Dataset inputDataset;
        Dataset metricsDataset;
        Dataset mainDataset;
        SavedModel sm;
        TransactionContext.assertNoAttachedTransaction();
        AnyLoc savedModelLoc = AnyLoc.resolveSmart(projectKey, options.savedModelSmartName);
        DatasetLocUtils.DatasetLoc inputDatasetLoc = DatasetLocUtils.resolveSmart(projectKey, options.inputDatasetSmartName);
        DatasetLocUtils.DatasetLoc mainDatasetLoc = StringUtils.isBlank((String)options.scoredDatasetSmartName) ? null : DatasetLocUtils.resolveSmart(projectKey, options.scoredDatasetSmartName);
        DatasetLocUtils.DatasetLoc metricsDatasetLoc = StringUtils.isBlank((String)options.metricsDatasetSmartName) ? null : DatasetLocUtils.resolveSmart(projectKey, options.metricsDatasetSmartName);
        DatasetLocUtils.DatasetLoc evaluationStoreLoc = StringUtils.isBlank((String)options.evaluationStoreSmartName) ? null : DatasetLocUtils.resolveSmart(projectKey, options.evaluationStoreSmartName);
        try (Transaction t = this.transactionService.beginRead();){
            sm = this.savedModelsService.getMandatory(savedModelLoc.getProjectKey(), savedModelLoc.getId());
            mainDataset = mainDatasetLoc == null ? null : this.datasetAccessService.getMandatory(mainDatasetLoc);
            metricsDataset = metricsDatasetLoc == null ? null : this.datasetAccessService.getMandatory(metricsDatasetLoc);
            inputDataset = this.datasetAccessService.getMandatory(inputDatasetLoc);
        }
        FullModelId fmi = this.savedModelsMgmtService.getActiveVersionFMI(sm);
        if (sm.savedModelType.savedModelHandlingType == SavedModel.SavedModelHandlingType.INTERNAL) {
            PredictionModelDetails details = PredictionResultsReader.makeModelDetails(fmi);
            gpuConfig = details.getCoreParams().executionParams.gpuConfig;
        } else {
            gpuConfig = new GpuConfig();
        }
        EvaluationRecipePayloadParams desc = new EvaluationRecipePayloadParams(gpuConfig);
        desc.treatDriftFailureAsError = true;
        desc.modelVersionId = options.modelVersionId;
        this.setDefaultDriftEmbeddingParams(desc);
        SerializedShakerScript script = null;
        EvaluationDatasetHelper.detectApiLogsDataset(desc, inputDataset, options.evaluatedDeploymentId);
        block6 : switch (sm.savedModelType.savedModelHandlingType) {
            case INTERNAL: {
                MLAssertionsParams assertionsParams;
                PredictionModelDetails details = PredictionResultsReader.makeModelDetails(fmi);
                if (details.backendType == MLTask.BackendType.DEEP_HUB) {
                    throw new IllegalArgumentException("Computer vision models cannot be evaluated");
                }
                ResolvedPredictionCoreParams rcp = (ResolvedPredictionCoreParams)fmi.getResolvedCoreParams();
                desc.backendType = rcp.backendType;
                if (desc.backendType.isSparkBased()) {
                    desc.sparkParams.sparkConf = rcp.executionParams.sparkParams.sparkConf;
                    desc.sparkParams.sparkUseGlobalMetastore = rcp.executionParams.sparkParams.sparkUseGlobalMetastore;
                }
                if (fmi.getAssertionsFile().exists() && (assertionsParams = fmi.getAssertionsParams()).hasAssertions()) {
                    desc.computeAssertions = true;
                }
                switch (rcp.prediction_type) {
                    case REGRESSION: {
                        desc.metrics = EvaluationRecipePayloadParams.REGRESSION_METRICS;
                        desc.outputs = EvaluationRecipePayloadParams.DEFAULT_REGRESSION_OUTPUTS;
                        this.setEvalRecipeCustomMetrics((ClassicalPredictionModelDetails)details, desc);
                        break;
                    }
                    case MULTICLASS: {
                        desc.metrics = EvaluationRecipePayloadParams.MULTICLASS_METRICS;
                        desc.outputs = EvaluationRecipePayloadParams.DEFAULT_CLASSIFICATION_OUTPUTS;
                        this.setEvalRecipeCustomMetrics((ClassicalPredictionModelDetails)details, desc);
                        break;
                    }
                    case BINARY_CLASSIFICATION: {
                        desc.metrics = EvaluationRecipePayloadParams.BINARY_METRICS;
                        desc.outputs = EvaluationRecipePayloadParams.DEFAULT_CLASSIFICATION_OUTPUTS;
                        this.setEvalRecipeCustomMetrics((ClassicalPredictionModelDetails)details, desc);
                        break;
                    }
                    case TIMESERIES_FORECAST: {
                        desc.outputs = new ArrayList<String>();
                        desc.metrics = EvaluationRecipePayloadParams.TIMESERIES_METRICS;
                        String algorithmName = ((TimeseriesForecastingModelDetails)details).actualParams.resolved.getAlgorithmName();
                        if (PreTrainPredictionModelingParams.Algorithm.SEASONAL_LOESS.name().equals(algorithmName) || PreTrainPredictionModelingParams.Algorithm.CROSTON.name().equals(algorithmName)) {
                            desc.refitModel = true;
                        }
                        this.setEvalRecipeCustomMetrics((TimeseriesForecastingModelDetails)details, desc);
                        break;
                    }
                    case CAUSAL_BINARY_CLASSIFICATION: 
                    case CAUSAL_REGRESSION: {
                        if (null != evaluationStoreLoc) {
                            throw new IllegalArgumentException("Evaluation stores do not support causal prediction models.");
                        }
                        desc.computePropensity = ((CausalPredictionModelDetails)details).modeling.propensityModeling.enabled;
                        desc.metrics = EvaluationRecipePayloadParams.CAUSAL_PREDICTION_METRICS;
                        desc.outputs = EvaluationRecipePayloadParams.DEFAULT_CAUSAL_PREDICTION_OUTPUT;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported prediction type: " + String.valueOf((Object)rcp.prediction_type));
                    }
                }
                desc.predictionType = rcp.prediction_type;
                desc.taskType = rcp.taskType;
                script = details.trainedWithScript;
                break;
            }
            case EXTERNAL_MLFLOW: {
                File mlflowModelInfoFile = fmi.getModelFile("mlflow_imported_model.json");
                MLFlowModelVersionInfo mmvi = (MLFlowModelVersionInfo)JSON.parseFile((File)mlflowModelInfoFile, MLFlowModelVersionInfo.class);
                if (mmvi.predictionType == null) {
                    throw new IllegalArgumentException("The MLflow model version does not declare a prediction type, cannot create evaluation recipe on it.");
                }
                if (mmvi.isProxyModel()) {
                    desc.proxyModelProtocol = mmvi.proxyModelVersionConfiguration.protocol;
                }
                desc.predictionType = mmvi.predictionType;
                desc.taskType = MLTask.MLTaskType.PREDICTION;
                switch (mmvi.predictionType) {
                    case REGRESSION: {
                        desc.metrics = EvaluationRecipePayloadParams.REGRESSION_METRICS;
                        desc.outputs = EvaluationRecipePayloadParams.DEFAULT_REGRESSION_OUTPUTS;
                        break block6;
                    }
                    case MULTICLASS: {
                        desc.metrics = EvaluationRecipePayloadParams.MULTICLASS_METRICS;
                        desc.outputs = EvaluationRecipePayloadParams.DEFAULT_CLASSIFICATION_OUTPUTS;
                        break block6;
                    }
                    case BINARY_CLASSIFICATION: {
                        desc.metrics = EvaluationRecipePayloadParams.BINARY_METRICS;
                        desc.outputs = EvaluationRecipePayloadParams.DEFAULT_CLASSIFICATION_OUTPUTS;
                        break block6;
                    }
                }
                throw new IllegalArgumentException("Unsupported prediction type: " + String.valueOf((Object)mmvi.predictionType));
            }
            case PYTHON_AGENT: 
            case PLUGIN_AGENT: 
            case TOOLS_USING_AGENT: {
                throw new IllegalArgumentException("Agents are not supported in evaluation recipe");
            }
            case LLM_GENERIC: {
                throw new IllegalArgumentException("Fine-tuned LLMs are not supported in evaluation recipe");
            }
            case RETRIEVAL_AUGMENTED_LLM: {
                throw new IllegalArgumentException("Retrieval Augmented LLMs are not supported in evaluation recipe");
            }
        }
        desc.savedModelType = sm.savedModelType;
        desc.needsInputDataFolder = sm.needsInputDataFolder;
        SerializedRecipe sr = new SerializedRecipe();
        sr.addInput("main", inputDataset.getSmartName(projectKey));
        sr.addInput("model", savedModelLoc.getSmartName(projectKey));
        if (desc.needsInputDataFolder) {
            AnyLoc managedFolderLoc = AnyLoc.resolveSmart(projectKey, options.managedFolderSmartId);
            sr.addInput("data", managedFolderLoc.getSmartName(projectKey));
        }
        if (mainDataset != null) {
            sr.addOutput("main", mainDataset.getSmartName(projectKey), false);
        }
        if (metricsDataset != null) {
            sr.addOutput("metrics", metricsDataset.getSmartName(projectKey), true);
        }
        if (evaluationStoreLoc != null) {
            sr.addOutput("evaluationStore", evaluationStoreLoc.getSmartName(projectKey), false);
        }
        sr.type = PredictionRecipesMeta.EVALUATION_META.getType();
        sr.projectKey = projectKey;
        sr.params = new ContainerRecipeParams();
        try (RWTransaction rwt = this.transactionService.beginWriteAsLoggedInUser(u);){
            JobActivity activity = new JobActivity(this.recipesValidationService.getSampleSubgraph(new FlowRecipe(sr)));
            sc = (EvaluationRecipeSchemaComputer)PredictionRecipesMeta.EVALUATION_META.buildSchemaComputer(u, activity);
            sc.setPayload(JSON.json((Object)desc));
        }
        if (sm.savedModelType == SavedModel.SavedModelType.DSS_MANAGED && mainDataset != null) {
            ResolvedPredictionCoreParams rcp = (ResolvedPredictionCoreParams)fmi.getResolvedCoreParams();
            Schema outputSchemaBeforeFiltering = sc.getSchemasForOutputRole_NT("main").get(0);
            this.filterInputColumns(rcp, fmi, outputSchemaBeforeFiltering, desc);
            sc.setPayload(JSON.json((Object)desc));
            Schema outputSchemaAfterFiltering = sc.getSchemasForOutputRole_NT("main").get(0);
            mainDataset.setSchema(outputSchemaAfterFiltering);
        }
        if (metricsDataset != null) {
            Schema metricsSchema = sc.getSchemasForOutputRole_NT("metrics").get(0);
            metricsDataset.setSchema(metricsSchema);
        }
        rwt = this.transactionService.beginWriteAsLoggedInUser(u);
        try {
            if (StringUtils.isBlank((String)name)) {
                name = "evaluate_on_" + inputDataset.getName();
            }
            String recipeName = this.recipeSaveService.transmogrifyName(projectKey, (String)name);
            if (mainDataset != null) {
                this.datasetSaveService.save(mainDataset.getLoc(), mainDataset.serialize(), u);
            }
            if (metricsDataset != null) {
                this.datasetSaveService.save(metricsDataset.getLoc(), metricsDataset.serialize(), u);
            }
            sr.name = recipeName;
            if (script != null) {
                this.shakerRecipeService.updateDependenciesOnAnyRecipe(projectKey, sr, script, "main", "evaluationStore", "metrics");
            }
            new PDepsFixuper().fixupInPlace(sr);
            if (StringUtils.isBlank((String)options.zone)) {
                options.zone = this.flowZonesService.retrieveInputZone(sr);
            }
            this.flowZonesService.attachObjectToZone(options.zone, projectKey, sr);
            this.recipeSaveService.create(projectKey, sr, JSON.pretty((Object)desc));
            rwt.commit("Created evaluation recipe for scoring " + inputDataset.getName() + " : " + sr.projectKey + "." + sr.name);
            String string = recipeName;
            return string;
        }
        finally {
            if (rwt != null) {
                rwt.close();
            }
        }
    }

    public String createStandaloneEvaluationRecipe_NT(AuthCtx u, String projectKey, PredictionRecipesService.StandaloneEvaluationRecipeCreationOptions options) throws Exception {
        Dataset referenceDataset;
        Dataset inputDataset;
        TransactionContext.assertNoAttachedTransaction();
        DatasetLocUtils.DatasetLoc inputDatasetLoc = DatasetLocUtils.resolveSmart(projectKey, options.inputDatasetSmartName);
        DatasetLocUtils.DatasetLoc referenceDatasetLoc = StringUtils.isBlank((String)options.referenceDatasetSmartName) ? null : DatasetLocUtils.resolveSmart(projectKey, options.referenceDatasetSmartName);
        DatasetLocUtils.DatasetLoc evaluationStoreLoc = DatasetLocUtils.resolveSmart(projectKey, options.evaluationStoreSmartName);
        try (Transaction t = this.transactionService.beginRead();){
            inputDataset = this.datasetAccessService.getMandatory(inputDatasetLoc);
            referenceDataset = referenceDatasetLoc == null ? null : this.datasetAccessService.getMandatory(referenceDatasetLoc);
        }
        StandaloneEvaluationRecipePayloadParams desc = new StandaloneEvaluationRecipePayloadParams();
        desc.autoOptimizeThreshold = true;
        desc.metricParams.thresholdOptimizationMetric = MetricParams.ThresholdOptimizationMetric.F1;
        desc.treatDriftFailureAsError = true;
        desc.hasModel = referenceDataset == null;
        this.setDefaultDriftEmbeddingParams(desc);
        SerializedRecipe sr = new SerializedRecipe();
        sr.addInput("main", inputDataset.getSmartName(projectKey));
        if (referenceDataset != null) {
            sr.addInput("reference", referenceDataset.getSmartName(projectKey));
        }
        sr.addOutput("main", evaluationStoreLoc.getName(), false);
        if (StringUtils.isNotBlank((String)options.managedFolderSmartId)) {
            AnyLoc managedFolderLoc = AnyLoc.resolveSmart(projectKey, options.managedFolderSmartId);
            sr.addInput("data", managedFolderLoc.getSmartName(projectKey));
        }
        if (StringUtils.isNotBlank((String)options.referenceManagedFolderSmartId)) {
            AnyLoc referenceManagedFolderLoc = AnyLoc.resolveSmart(projectKey, options.referenceManagedFolderSmartId);
            sr.addInput("referenceData", referenceManagedFolderLoc.getSmartName(projectKey));
        }
        sr.type = PredictionRecipesMeta.STANDALONE_EVALUATION_META.getType();
        sr.projectKey = projectKey;
        sr.params = new ContainerRecipeParams();
        try (RWTransaction rwt = this.transactionService.beginWriteAsLoggedInUser(u);){
            String recipeName;
            sr.name = recipeName = this.recipeSaveService.transmogrifyName(projectKey, "standalone_evaluate_on_" + inputDataset.getName());
            new PDepsFixuper().fixupInPlace(sr);
            if (StringUtils.isBlank((String)options.zone)) {
                options.zone = this.flowZonesService.retrieveInputZone(sr);
            }
            this.flowZonesService.attachObjectToZone(options.zone, projectKey, sr);
            this.recipeSaveService.create(projectKey, sr, JSON.pretty((Object)desc));
            rwt.commit("Created evaluation recipe for scoring " + inputDataset.getName() + " : " + sr.projectKey + "." + sr.name);
            String string = recipeName;
            return string;
        }
    }

    private void filterInputColumns(ResolvedPredictionCoreParams rcp, FullModelId fmi, Schema actualPreparedSchema, AbstractPredictionScoringRecipePayloadParams desc) throws IOException {
        if (rcp.prediction_type != PredictionMLTask.PredictionType.TIMESERIES_FORECAST) {
            return;
        }
        boolean filterInputColumns = false;
        ArrayList<String> keptInputColumns = new ArrayList<String>();
        ResolvedTimeseriesForecastingCoreParams rtfcp = (ResolvedTimeseriesForecastingCoreParams)rcp;
        if (rtfcp.isPartitioned() && null != rtfcp.partitionedModel.dimensionNames) {
            for (String partitionColumn : rtfcp.partitionedModel.dimensionNames) {
                if (!actualPreparedSchema.hasColumn(partitionColumn)) continue;
                keptInputColumns.add(partitionColumn);
            }
        }
        Map<String, FeaturePreprocessingParams> features = fmi.getResolvedPreprocessingParams().per_feature;
        for (Map.Entry<String, FeaturePreprocessingParams> entry : features.entrySet()) {
            String featureName = entry.getKey();
            FeaturePreprocessingParams.Role featureRole = entry.getValue().role;
            if (EnumSet.of(FeaturePreprocessingParams.Role.INPUT, FeaturePreprocessingParams.Role.INPUT_PAST_ONLY, FeaturePreprocessingParams.Role.TARGET, FeaturePreprocessingParams.Role.TIMESERIES_IDENTIFIER, FeaturePreprocessingParams.Role.TIME).contains((Object)featureRole)) {
                keptInputColumns.add(featureName);
                continue;
            }
            filterInputColumns = true;
        }
        if (filterInputColumns) {
            desc.filterInputColumns = true;
            desc.keptInputColumns = keptInputColumns;
        }
    }

    private void setDefaultDriftEmbeddingParams(EvaluationRecipePayloadParams desc) {
        desc.hasTextDrift = false;
        desc.textDriftParams = new TextDriftParams();
        desc.hasImageDrift = false;
        desc.imageDriftParams = new ImageDriftParams();
        try {
            GeneralSettingsDAO.GenerativeAISettings generativeAISettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().generativeAISettings;
            if (StringUtils.isNotBlank((String)generativeAISettings.defaultEvalTextEmbeddingModelId)) {
                desc.textDriftParams.embeddingModelId = generativeAISettings.defaultEvalTextEmbeddingModelId;
            }
            if (StringUtils.isNotBlank((String)generativeAISettings.defaultEvalImageEmbeddingModelId)) {
                desc.imageDriftParams.embeddingModelId = generativeAISettings.defaultEvalImageEmbeddingModelId;
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to set default drift embedding models.", (Throwable)e);
        }
    }

    private void setDefaultDriftEmbeddingParams(StandaloneEvaluationRecipePayloadParams desc) {
        desc.hasTextDrift = false;
        desc.textDriftParams = new TextDriftParams();
        desc.hasImageDrift = false;
        desc.imageDriftParams = new ImageDriftParams();
        try {
            GeneralSettingsDAO.GenerativeAISettings generativeAISettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().generativeAISettings;
            if (StringUtils.isNotBlank((String)generativeAISettings.defaultEvalTextEmbeddingModelId)) {
                desc.textDriftParams.embeddingModelId = generativeAISettings.defaultEvalTextEmbeddingModelId;
            }
            if (StringUtils.isNotBlank((String)generativeAISettings.defaultEvalImageEmbeddingModelId)) {
                desc.imageDriftParams.embeddingModelId = generativeAISettings.defaultEvalImageEmbeddingModelId;
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to set default drift embedding models.", (Throwable)e);
        }
    }
}

