/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.flow;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLDiagnostics;
import com.dataiku.dip.analysis.ml.MLFlowUtils;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.analysis.ml.ModelLikeId;
import com.dataiku.dip.analysis.ml.prediction.PredictionResultsReader;
import com.dataiku.dip.analysis.ml.prediction.flow.AbstractPredictionEvaluationRecipeRunner;
import com.dataiku.dip.analysis.ml.prediction.flow.PyPredictionScoringRecipeSubrunner;
import com.dataiku.dip.analysis.ml.shared.EvaluationLabelsHelper;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.core.ModelUserMeta;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.ResolvedTimeseriesForecastingCoreParams;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelDetails;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowSavedModel;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.mec.KernelsModelEvaluationStoresService;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.mec.TabularModelEvaluation;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.services.SingleWriteTransactionTransactionService;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class TimeseriesForecastingEvaluationRecipeRunner
extends AbstractPredictionEvaluationRecipeRunner {
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private KernelsModelEvaluationStoresService modelEvaluationStoresService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.prediction.evaluation");

    public TimeseriesForecastingEvaluationRecipeRunner(JobActivity activity) {
        super(activity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        File evaluationStoreFolder;
        TabularModelEvaluation modelEvaluation;
        Schema inferredPreparedSchema;
        if (this.desc.backendType != MLTask.BackendType.PY_MEMORY) {
            throw new IllegalArgumentException("Unsupported backend type: " + String.valueOf((Object)this.desc.backendType));
        }
        if (this.desc.predictionType != PredictionMLTask.PredictionType.TIMESERIES_FORECAST) {
            throw new IllegalArgumentException("Unsupported prediction type: " + String.valueOf((Object)this.desc.predictionType));
        }
        List<FlowDataset> inputFDS = this.activity.getSubgraph().getSourceDatasets();
        if (inputFDS.isEmpty()) {
            throw ErrorContext.iae((String)"Missing input dataset in scoring recipe");
        }
        Dataset inputDataset = this.getInputDataset("main");
        String outputDatasetType = inputDataset.getType();
        String inputDatasetSmartName = AnyLoc.resolveFull(inputDataset.getFullName()).getSmartName(this.recipe.getProjectKey());
        String outputDatasetSmartName = this.getOutputDatasetSmartName();
        String metricsDatasetSmartName = this.getMetricsDatasetSmartName();
        FlowSavedModel fsm = MLFlowUtils.getSMInput(this.activity);
        SavedModel sm = fsm.getSavedModel();
        MLFlowUtils.checkActiveVersion(sm);
        File activeModelFolder = MLPaths.savedModelVersionFolder(sm, sm.activeVersion);
        FullModelId fmiGlobal = new FullModelId(sm.projectKey, sm.id, sm.activeVersion);
        assert (activeModelFolder != null);
        TimeseriesForecastingModelDetails details = (TimeseriesForecastingModelDetails)PredictionResultsReader.makeModelDetails(fmiGlobal);
        this.executionParams = details.coreParams.executionParams;
        SerializedShakerScript script = (SerializedShakerScript)JSON.parseFile((File)new File(activeModelFolder, "script.json"), SerializedShakerScript.class);
        script.contextProjectKey = sm.projectKey;
        ResolvedTimeseriesForecastingCoreParams coreParams = (ResolvedTimeseriesForecastingCoreParams)JSON.parseFile((File)new File(activeModelFolder.getAbsoluteFile(), "core_params.json"), ResolvedTimeseriesForecastingCoreParams.class);
        Pair<MLFlowUtils.ModelPartitionMode, FullModelId> modelPartitionModeFullModelIdPair = MLFlowUtils.getModelPartitionModeAndFullModelId(this.activity, coreParams, fmiGlobal);
        FullModelId partitionFmi = (FullModelId)modelPartitionModeFullModelIdPair.second;
        if (partitionFmi.isModelPartition()) {
            activeModelFolder = fmiGlobal.getPartitionModelFolder(partitionFmi.getPartitionName());
        }
        ((SingleWriteTransactionTransactionService)SpringUtils.getBean(SingleWriteTransactionTransactionService.class)).stashTheSingleTransaction();
        try {
            inferredPreparedSchema = MLFlowUtils.getInferredPreparationOutputSchema_NT(sm.projectKey, inputDataset, script, outputDatasetType, this.authCtx);
        }
        finally {
            ((SingleWriteTransactionTransactionService)SpringUtils.getBean(SingleWriteTransactionTransactionService.class)).unstashTheSingleTransaction();
        }
        Schema preparationOSchemaToUse = MLFlowUtils.getSchemaToUseForPreparedScoringInput(details.preprocessing, details.splitDesc.schema, inferredPreparedSchema, false, true, this.activity);
        List<SerializedRecipe.RecipeOutput> evaluationStoreRole = this.recipe.getModel().getOutputsForRole("evaluationStore");
        File preprocessingFile = fmiGlobal.getPreprocessingFile("rpreprocessing_params.json");
        if (!evaluationStoreRole.isEmpty()) {
            File mlModelFile;
            File featureSelectionFile;
            File overridesFile;
            File assertionParamsFile;
            File modelDiagnosticsFile;
            File trainInfoFile;
            File modelingParamsFile;
            File coreParamsFile;
            File columnImportanceFile;
            File collectorFile;
            File globalExplanationsFactsFile;
            File globalExplanationsAbsoluteImportanceFile;
            File globalExplanationsObservationsFile;
            File iperfFile;
            if (this.desc.backendType.isSparkBased()) {
                throw new NotImplementedException("Writing to model evaluation stores is only possible in python");
            }
            if (sm.isPartitioned()) {
                throw new NotImplementedException("Output to an evaluation store is not possible for partitioned models");
            }
            KernelsModelEvaluationStoresService.DataTypeAndParams trainDataTypeAndParams = this.modelEvaluationStoresService.makeTrainDataTypeAndParams(details.splitDesc, details.smOrigin == null ? null : details.smOrigin.fullModelId);
            ModelUserMeta mum = fmiGlobal.getUserMetaOpt().orElse(null);
            evaluationStoreLoc = DatasetLocUtils.DatasetLoc.resolveSmart(this.recipe.getProjectKey(), evaluationStoreRole.get((int)0).ref);
            RecipeRunnableSubgraph subgraph = (RecipeRunnableSubgraph)this.activity.getSubgraph();
            List<Partition> inputPartitions = subgraph.getSourcePartitions(inputFDS.get(0));
            KernelsModelEvaluationStoresService.ModelTypeAndParams modelTypeAndParams = this.modelEvaluationStoresService.makeModelTypeAndParams(this.recipe.getProjectKey(), sm, fmiGlobal, details.trainInfo);
            KernelsModelEvaluationStoresService.DataTypeAndParams datasetTypeAndParams = this.modelEvaluationStoresService.makeDataTypeAndParams(this.recipe.getProjectKey(), inputDataset, inputPartitions);
            KernelsModelEvaluationStoresService.TabularEvaluationModelInfo evaluationModelInfo = this.modelEvaluationStoresService.makeTimeseriesEvaluationInfo(details);
            evaluationModelInfo.evaluationId = this.desc.evaluationId;
            evaluationModelInfo.name = this.desc.name;
            evaluationModelInfo.predictionVariable = "forecast";
            evaluationModelInfo.labels = EvaluationLabelsHelper.getTSEvaluationTimeLabels_T(this.recipe.getProjectKey(), mum, inputDataset.serialize(), this.desc.labels, inputPartitions, this.desc.treatDataDriftColumnHandling ? this.desc.dataDriftColumnHandling : null, this.desc.maxNbForecastTimeSteps);
            evaluationModelInfo.evaluateRecipeParams = new KernelsModelEvaluationStoresService.EvaluateRecipeParams(false);
            evaluationModelInfo.evaluationDatasetType = this.desc.evaluationDatasetType;
            evaluationModelInfo.limitSampling = this.desc.limitSampling;
            evaluationModelInfo.skipScoring = this.desc.skipScoring;
            ModelEvaluationStore mes = this.modelEvaluationStoresService.getMandatory(evaluationStoreLoc.getProjectKey(), evaluationStoreLoc.getId());
            modelEvaluation = this.modelEvaluationStoresService.setupTabularRun(mes, modelTypeAndParams, datasetTypeAndParams, trainDataTypeAndParams, evaluationModelInfo);
            evaluationStoreFolder = modelEvaluation.ref.getMainFolder();
            if (preprocessingFile.exists()) {
                FileUtils.copyFile((File)preprocessingFile, (File)modelEvaluation.ref.getEvaluationFile("rpreprocessing_params.json"));
            }
            if ((iperfFile = fmiGlobal.getModelFile("iperf.json")).exists()) {
                FileUtils.copyFile((File)iperfFile, (File)modelEvaluation.ref.getEvaluationFile("iperf.json"));
            }
            if ((globalExplanationsObservationsFile = fmiGlobal.getGlobalExplanationsObservationsFile()).exists()) {
                FileUtils.copyFile((File)globalExplanationsObservationsFile, (File)modelEvaluation.ref.getEvaluationFile("global_explanations_observations.json"));
            }
            if ((globalExplanationsAbsoluteImportanceFile = fmiGlobal.getGlobalExplanationsAbsoluteImportanceFile()).exists()) {
                FileUtils.copyFile((File)globalExplanationsAbsoluteImportanceFile, (File)modelEvaluation.ref.getEvaluationFile("global_explanations_absolute_importance.json"));
            }
            if ((globalExplanationsFactsFile = fmiGlobal.getGlobalExplanationsFactsFile()).exists()) {
                FileUtils.copyFile((File)globalExplanationsFactsFile, (File)modelEvaluation.ref.getEvaluationFile("global_explanations_facts.json"));
            }
            if ((collectorFile = fmiGlobal.getPreprocessingFile("collector_data.json")).exists()) {
                FileUtils.copyFile((File)collectorFile, (File)modelEvaluation.ref.getEvaluationFile("collector_data.json"));
            }
            if ((columnImportanceFile = fmiGlobal.getModelFile("column_importance.json")).exists()) {
                FileUtils.copyFile((File)columnImportanceFile, (File)modelEvaluation.ref.getEvaluationFile("column_importance.json"));
            }
            if ((coreParamsFile = fmiGlobal.getModelFile("core_params.json")).exists()) {
                FileUtils.copyFile((File)coreParamsFile, (File)modelEvaluation.ref.getEvaluationFile("core_params.json"));
            }
            if ((modelingParamsFile = fmiGlobal.getPreprocessingFile("rmodeling_params.json")).exists()) {
                FileUtils.copyFile((File)modelingParamsFile, (File)modelEvaluation.ref.getEvaluationFile("rmodeling_params.json"));
            }
            if ((trainInfoFile = fmiGlobal.getModelFile("train_info.json")).exists()) {
                FileUtils.copyFile((File)trainInfoFile, (File)modelEvaluation.ref.getEvaluationFile("train_info.json"));
            }
            if ((modelDiagnosticsFile = fmiGlobal.getMLDiagnosticsFile()).exists()) {
                FileUtils.copyFile((File)modelDiagnosticsFile, (File)modelEvaluation.ref.getEvaluationFile("train_diagnostics.json"));
            }
            if (this.desc.computeAssertions && (assertionParamsFile = fmiGlobal.getAssertionsFile()).exists()) {
                FileUtils.copyFile((File)assertionParamsFile, (File)modelEvaluation.ref.getEvaluationFile("rassertions.json"));
            }
            if ((overridesFile = fmiGlobal.getOverridesFile()).exists()) {
                FileUtils.copyFile((File)overridesFile, (File)DKUFileUtils.getWithinFollowLink((File)evaluationStoreFolder, (String[])new String[]{"roverrides.json"}));
            }
            if ((featureSelectionFile = fmiGlobal.getModelFile("feature_selection.json")).exists()) {
                FileUtils.copyFile((File)featureSelectionFile, (File)modelEvaluation.ref.getEvaluationFile("feature_selection.json"));
            }
            if ((mlModelFile = fmiGlobal.getModelFile("MLModel")).exists()) {
                FileUtils.copyFile((File)mlModelFile, (File)modelEvaluation.ref.getEvaluationFile("MLModel"));
            }
            FilesystemACLUtils.grantFSFullACLs(this.authCtx, this.recipe.getProjectKey(), true, evaluationStoreFolder);
            if (fmiGlobal.hasPredictionStatisticsFile()) {
                FileUtils.copyFile((File)fmiGlobal.getPredictionStatisticsFile(), (File)modelEvaluation.ref.getReferencePredictionStatisticsFile());
            }
        } else {
            evaluationStoreFolder = null;
            evaluationStoreLoc = null;
            modelEvaluation = null;
        }
        try (AutoDelete outputTmpDir = FlowJobUtils.getTmpFolder("evaluation-recipe", "pyrun");){
            JSON.prettyToFile((Object)this.desc, (File)new File((File)outputTmpDir, "desc.json"));
            JSON.prettyToFile((Object)preparationOSchemaToUse, (File)new File((File)outputTmpDir, "preparation_output_schema.json"));
            JSON.prettyToFile((Object)script, (File)new File((File)outputTmpDir, "script.json"));
            JobContext.getCurrentActivitySummary().engineType = "PYTHON";
            JsonObject containerPayload = new JsonObject();
            containerPayload.addProperty("inputDatasetSmartName", inputDatasetSmartName);
            containerPayload.addProperty("outputDatasetSmartName", outputDatasetSmartName);
            containerPayload.addProperty("metricsDatasetSmartName", metricsDatasetSmartName);
            containerPayload.addProperty("inputModel", fmiGlobal.toString());
            if (evaluationStoreFolder != null) {
                containerPayload.addProperty("evaluationStoreFolder", evaluationStoreFolder.getAbsolutePath());
            }
            PyPredictionScoringRecipeSubrunner.Evaluation runner = new PyPredictionScoringRecipeSubrunner.Evaluation(this.activity, fmiGlobal, activeModelFolder, evaluationStoreFolder, this.authCtx, this.executionParams.envName, this.desc, RemoteRunsRegistry.ExecutionType.RECIPE_PREDICTION_EVAL_TIMESERIES, outputTmpDir, containerPayload, "dataiku.doctor.timeseries.evaluate.launch_evaluation_recipe", activeModelFolder.getAbsolutePath(), inputDatasetSmartName, StringUtils.defaultIfBlank((String)outputDatasetSmartName, (String)""), StringUtils.defaultIfBlank((String)metricsDatasetSmartName, (String)""), new File((File)outputTmpDir, "desc.json").getAbsolutePath(), new File((File)outputTmpDir, "script.json").getAbsolutePath(), new File((File)outputTmpDir, "preparation_output_schema.json").getAbsolutePath(), evaluationStoreFolder != null ? evaluationStoreFolder.getAbsolutePath() : "", outputTmpDir.getAbsolutePath(), fmiGlobal.toString());
            this.startRunner(runner);
            File diagnosticsFile = DKUFileUtils.getWithin((File)outputTmpDir, (String[])new String[]{"ml_diagnostics.json"});
            if (diagnosticsFile.exists()) {
                MLDiagnostics mlDiagnostics = ModelLikeId.parseJsonFile(diagnosticsFile, MLDiagnostics.class);
                mlDiagnostics.mergeIntoWarnings(this.activity.warnContext);
            }
        }
        if (modelEvaluation != null) {
            this.activity.getTargetStatus((String)evaluationStoreLoc.getFullName()).evaluationId = modelEvaluation.ref.evaluationId;
            if (!this.desc.treatDriftFailureAsError && !modelEvaluation.ref.hasDataEvaluationMetrics()) {
                this.activity.warnContext.addWarning(WarningsContext.WarningType.DATA_DRIFT_COMPUTATION_ERROR, "Failed to compute input data drift", logger);
            }
            this.modelEvaluationStoresService.finaliseRun(modelEvaluation);
        }
    }

    private Dataset getInputDataset(String role) throws IOException {
        return this.datasetAccessService.getMandatory(this.recipe.getModel().getSingleInput(role).getLoc(this.recipe.getProjectKey()));
    }

    @Override
    public void finalCommit() throws Exception {
        List<SerializedRecipe.RecipeOutput> evaluationStoreRole = this.recipe.getModel().getOutputsForRole("evaluationStore");
        if (!evaluationStoreRole.isEmpty()) {
            if (this.desc.backendType.isSparkBased()) {
                throw new NotImplementedException("Writing to model evaluation stores is only possible in python");
            }
            AnyLoc evaluationStoreLoc = DatasetLocUtils.DatasetLoc.resolveSmart(this.recipe.getProjectKey(), evaluationStoreRole.get((int)0).ref);
            String secret = this.ticketService.getSingleTicket().getSecret();
            try (TicketBasedIntercomAPIClient tClient = TicketBasedIntercomAPIClient.forLocalHost(secret);){
                tClient.postFormToJSON("/dip/api/tintercom/model-evaluation-stores/new-evaluation", Void.class, new Object[]{"projectKey", evaluationStoreLoc.getProjectKey(), "id", evaluationStoreLoc.getId(), "evaluationId", this.activity.getTargetStatus((String)evaluationStoreLoc.getFullName()).evaluationId});
            }
        }
    }
}

