/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.guess;

import com.dataiku.dip.analysis.ml.prediction.guess.GuessPolicyMeta;
import java.util.HashMap;
import java.util.Map;

public enum PredictionGuessPolicy {
    DEFAULT(new GuessPolicyMeta.PrototypesPolicyMeta()),
    INTERPRETABLE(new GuessPolicyMeta.InterpretablePolicyMeta()),
    PERFORMANCE(new GuessPolicyMeta.PerformancePolicyMeta()),
    ALGORITHMS(new GuessPolicyMeta.AlgorithmsPolicyMeta()),
    DEEP(new GuessPolicyMeta.DeepLearningPolicyMeta()),
    CUSTOM(new GuessPolicyMeta.CustomPolicyMeta()),
    DEEP_HUB_IMAGE_OBJECT_DETECTION(new GuessPolicyMeta.DeepHubObjectDetectionPolicyMeta()),
    DEEP_HUB_IMAGE_CLASSIFICATION(new GuessPolicyMeta.DeepHubImageClassificationPolicyMeta()),
    CAUSAL_PREDICTION(new GuessPolicyMeta.CausalPolicyMeta()),
    TIMESERIES_DEFAULT(new GuessPolicyMeta.TimeseriesForecastingDefaultPolicyMeta()),
    TIMESERIES_STATISTICAL(new GuessPolicyMeta.TimeseriesForecastingStatisticalPolicyMeta()),
    TIMESERIES_DEEP_LEARNING(new GuessPolicyMeta.TimeseriesForecastingDeepLearningPolicyMeta()),
    SIMPLE_FORMULA(new GuessPolicyMeta.SimpleFormulaPolicyMeta()),
    DECISION_TREE(new GuessPolicyMeta.DecisionTreePolicyMeta()),
    EXPLANATORY(new GuessPolicyMeta.ExplanatoryPolicyMeta());

    public final GuessPolicyMeta meta;

    private PredictionGuessPolicy(GuessPolicyMeta meta) {
        this.meta = meta;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", this.toString());
        map.put("name", this.meta.name());
        map.put("thumbnail", this.meta.thumbnail());
        map.put("icon", this.meta.icon());
        map.put("analysis_name", this.meta.analysisDefaultName());
        map.put("description", this.meta.description());
        map.put("supported_backends", this.meta.supportedBackends());
        return map;
    }
}

