/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.model.prediction.TimeseriesEvaluationForecasts;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelPerf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class TimeseriesPerFoldMetrics {
    Map<String, List<PerFoldTimeseriesForecastingMetrics>> perFoldMetrics = new TreeMap<String, List<PerFoldTimeseriesForecastingMetrics>>();

    public void add(String timeseriesIdentifier, PerFoldTimeseriesForecastingMetrics foldMetric) {
        if (!this.perFoldMetrics.containsKey(timeseriesIdentifier)) {
            this.perFoldMetrics.put(timeseriesIdentifier, new ArrayList());
        }
        this.perFoldMetrics.get(timeseriesIdentifier).add(foldMetric);
    }

    public static TimeseriesPerFoldMetrics computeTimeseriesPerFoldMetrics(FullModelId fmi, Map<String, TimeseriesForecastingModelPerf> perFoldPerf) throws IOException {
        TimeseriesEvaluationForecasts forecasts = fmi.getTimeseriesEvaluationForecasts();
        Map<String, List<TimeseriesEvaluationForecasts.FoldDateRange>> dateRanges = forecasts.getTimeseriesFoldsDateRange();
        TimeseriesPerFoldMetrics returner = new TimeseriesPerFoldMetrics();
        for (String tsIdentifier : dateRanges.keySet()) {
            List<TimeseriesEvaluationForecasts.FoldDateRange> foldDateRanges = dateRanges.get(tsIdentifier);
            for (TimeseriesEvaluationForecasts.FoldDateRange foldDateRange : foldDateRanges) {
                String foldId = foldDateRange.foldId;
                PerFoldTimeseriesForecastingMetrics foldMetrics = new PerFoldTimeseriesForecastingMetrics();
                foldMetrics.foldId = foldId;
                foldMetrics.startDate = foldDateRange.startDate;
                foldMetrics.endDate = foldDateRange.endDate;
                foldMetrics.metrics = perFoldPerf.get((Object)foldId).perTimeseriesMetrics.get(tsIdentifier);
                returner.add(tsIdentifier, foldMetrics);
            }
        }
        return returner;
    }

    public static class PerFoldTimeseriesForecastingMetrics {
        public String foldId;
        public String startDate;
        public String endDate;
        public TimeseriesForecastingModelPerf.TimeseriesForecastingMetrics metrics;
    }
}

