/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.config;

import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentBasicInfo;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractProjectDeploymentInfra;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.projects.importexport.model.BundleContainerSettings;
import com.dataiku.dip.projects.importexport.model.ProjectRemappingSettings;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractProjectDeployment
extends AbstractDeployment {
    public static final String DEPLOYMENT_TAG_DEPLOYED_AS_USER_KEY = "deployedAsUser";
    public String publishedProjectKey;
    @Nullable
    public String deployedProjectKey;
    public String projectFolderId;
    public String bundleId;
    private BundleContainerSettings bundleContainerSettings = new BundleContainerSettings();
    private boolean includeInfraConnectionRemapping;
    public JsonObject localVariables = new JsonObject();
    public Map<String, Boolean> scenariosToActivate = new HashMap<String, Boolean>();
    public boolean disableAutomaticTriggers = false;

    protected AbstractProjectDeployment() {
    }

    protected AbstractProjectDeployment(String id, String infraId, String publishedProjectKey, String bundleId, String deployedProjectKey, String projectFolderId, VersionTag creationTag) {
        super(id, infraId, creationTag);
        this.publishedProjectKey = publishedProjectKey;
        this.bundleId = bundleId;
        this.deployedProjectKey = deployedProjectKey;
        this.projectFolderId = projectFolderId;
    }

    protected AbstractProjectDeployment(AbstractProjectDeployment existingDeployment, String deploymentId, String infraId, String deployedProjectKey, String projectFolderId, VersionTag creationTag) {
        this(deploymentId, infraId, existingDeployment.publishedProjectKey, existingDeployment.bundleId, deployedProjectKey, projectFolderId, creationTag);
        this.tags = existingDeployment.tags;
        this.bundleContainerSettings = existingDeployment.bundleContainerSettings;
        this.localVariables = existingDeployment.localVariables;
        this.scenariosToActivate = existingDeployment.scenariosToActivate;
        this.disableAutomaticTriggers = existingDeployment.disableAutomaticTriggers;
    }

    @Nonnull
    public BundleContainerSettings getBundleContainerSettings(@Nonnull AbstractProjectDeploymentInfra infra) {
        BundleContainerSettings result = (BundleContainerSettings)JSON.deepCopy((Object)this.bundleContainerSettings);
        result.remapping.containerExecs = infra.defaultContainerExecRemapping;
        result.remapping.enableContainerExecRemapping = infra.enableContainerExecRemapping;
        result.remapping.connections = AbstractProjectDeployment.getMergedRemapping(this.bundleContainerSettings.remapping.connections, infra.defaultConnectionRemapping, this.includeInfraConnectionRemapping);
        return result;
    }

    private static <T extends ProjectRemappingSettings.AbstractRemapping> List<T> getMergedRemapping(List<T> fromDeployment, List<T> fromInfra, boolean includeInfraFields) {
        if (!includeInfraFields) {
            return fromDeployment;
        }
        HashMap<String, ProjectRemappingSettings.AbstractRemapping> map = new HashMap<String, ProjectRemappingSettings.AbstractRemapping>();
        Map<String, ProjectRemappingSettings.AbstractRemapping> infraEntries = fromInfra.stream().collect(Collectors.toMap(r -> r.source, r -> r));
        Map<String, ProjectRemappingSettings.AbstractRemapping> deploymentEntries = fromDeployment.stream().collect(Collectors.toMap(r -> r.source, r -> r));
        map.putAll(infraEntries);
        map.putAll(deploymentEntries);
        return new ArrayList(map.values());
    }

    public void setConnectionRemappingSettingsFromInfra(@Nonnull AbstractProjectDeploymentInfra infra) {
        this.bundleContainerSettings.remapping.connections = infra.defaultConnectionRemapping;
    }

    @Override
    public AbstractDeploymentBasicInfo.ProjectDeploymentBasicInfo basicInfoUnsafe() {
        AbstractDeploymentBasicInfo.ProjectDeploymentBasicInfo projectDeploymentBI = new AbstractDeploymentBasicInfo.ProjectDeploymentBasicInfo();
        projectDeploymentBI.id = this.id;
        projectDeploymentBI.publishedProjectKey = this.publishedProjectKey;
        projectDeploymentBI.deployedProjectKey = this.deployedProjectKey;
        projectDeploymentBI.infraId = this.infraId;
        projectDeploymentBI.bundleId = this.bundleId;
        projectDeploymentBI.tags = this.tags;
        projectDeploymentBI.typeBadges = this.typeBadges;
        projectDeploymentBI.creationTag = this.creationTag;
        projectDeploymentBI.versionTag = this.versionTag;
        projectDeploymentBI.deploymentTag = this.deploymentTag;
        return projectDeploymentBI;
    }

    @Override
    public String getKey() {
        return "project+" + this.id;
    }

    @Override
    public String getTargetId() {
        return this.getTargetProjectKey();
    }

    @Override
    public String getPublishedItemId() {
        return this.publishedProjectKey;
    }

    @Override
    public boolean hasPublishedItemAndPackageVersion(String publishedProjectKey, String bundleId) {
        return this.publishedProjectKey.equals(publishedProjectKey) && this.bundleId.equals(bundleId);
    }

    public String getTargetProjectKey() {
        return StringUtils.isBlank((String)this.deployedProjectKey) ? this.publishedProjectKey : this.deployedProjectKey;
    }

    @Override
    public void switchVersion(String bundleId) {
        this.bundleId = bundleId;
    }

    @Override
    public void verifyFields(AbstractDeploymentInfra infra, AbstractDeployment oldDeployment, boolean isDeployed) {
        super.verifyFields(infra, oldDeployment, isDeployed);
        if (!(oldDeployment instanceof AbstractProjectDeployment)) {
            throw ErrorContext.iaef((String)"Old deployment with id %s is not a ProjectDeployment.", (Object)oldDeployment.id, (Object[])new Object[0]);
        }
        AbstractProjectDeployment oldProjectDeployment = (AbstractProjectDeployment)oldDeployment;
        AbstractProjectDeployment.verifyImmutableField(oldProjectDeployment.publishedProjectKey, this.publishedProjectKey, "source project key");
        AbstractProjectDeployment.verifyImmutableField(oldProjectDeployment.deployedProjectKey, this.deployedProjectKey, "target project key");
        AbstractProjectDeployment.verifyImmutableField(oldProjectDeployment.projectFolderId, this.projectFolderId, "target project folder");
    }
}

