/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections.helpers;

import com.dataiku.dip.connections.helpers.AbstractRetryPolicyExecutor;
import com.dataiku.dip.connections.helpers.RetryPolicyExecutor;

public class RetryExceptionPolicyExecutor
extends AbstractRetryPolicyExecutor {
    @Override
    public <T, E extends Throwable> T execute(RetryPolicyExecutor.Callable<T, E> callable) throws E, InterruptedException {
        while (true) {
            ++this.currentRetry;
            try {
                return callable.call();
            }
            catch (InterruptedException | RuntimeException passThroughException) {
                throw passThroughException;
            }
            catch (Exception exception) {
                if (this.currentRetry == this.maxRetries || this.retryPredicate != null && !this.retryPredicate.apply((Object)exception)) {
                    throw exception;
                }
                this.throttle();
                if (this.currentRetry < this.maxRetries) continue;
                throw new RuntimeException("Unreachable");
            }
            break;
        }
    }

    @Override
    public <E extends Throwable> void execute(RetryPolicyExecutor.Runnable<E> runnable) throws E, InterruptedException {
        this.execute(() -> {
            runnable.run();
            return null;
        });
    }
}

