/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FilesSelectionRules;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatConfig;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.stream.Collectors;

public class TrinoSupport {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sync.trino");

    public static void setCompatible(AuthCtx authCtx, Dataset blobLikeDS, Dataset trinoDS, RecipeEngineStatus status, boolean fromCloudToTrino) throws IOException, DKUSecurityException {
        if (blobLikeDS.getPartitioningSchema() != null && blobLikeDS.getPartitioningSchema().isPartitioned() && !FilePartitioner.isSchemeRepresentableAsFolder(blobLikeDS.getPartitioningSchema())) {
            throw new TrinoCloudFastpathImpossibleException("Partitions of the input dataset don't map to folders");
        }
        if (blobLikeDS.getParamsAs(AbstractFSDatasetHandler.AbstractMetastoreAwareFSConfig.class).filesSelectionRules.mode != FilesSelectionRules.Mode.ALL) {
            throw new TrinoCloudFastpathImpossibleException("Input dataset is filtering data files");
        }
        TrinoSupport.getCopyMode(blobLikeDS, fromCloudToTrino);
    }

    protected static CopyMode getCopyMode(Dataset ds, boolean fromCloudToTrino) {
        String dsFullName = ds.getFullName();
        if ("csv".equals(ds.getFormatType())) {
            CSVFormatConfig config = ds.getFormatParamsAs(CSVFormatConfig.class);
            if (!StringUtils.isUtf8((String)config.charset)) {
                throw new TrinoCloudFastpathImpossibleException(String.format("charset not supported: %s for dataset: %s", config.charset, dsFullName));
            }
            if (config.getSeparatorChar() == '\u0000' || config.getSeparatorChar() > '\u00ff') {
                throw new TrinoCloudFastpathImpossibleException(String.format("separator not supported: '%s' for dataset: %s", config.getSeparatorStr(), dsFullName));
            }
            CopyMode mode = new CopyMode();
            mode.csvSeparator = config.getSeparatorChar();
            switch (config.style) {
                case EXCEL: {
                    throw ErrorContext.iaef((String)"CSV quoting style %s is not supported", (Object)((Object)config.style), (Object[])new Object[0]);
                }
                case UNIX: {
                    mode.type = CopyMode.CopyModeType.CSV;
                    mode.csvEscape = config.getEscapeChar();
                    mode.csvQuote = config.getQuoteChar();
                    break;
                }
                case ESCAPE_ONLY_NO_QUOTE: {
                    mode.type = CopyMode.CopyModeType.TEXTFILE;
                    mode.csvEscape = config.getEscapeChar();
                    break;
                }
                case NO_ESCAPE_NO_QUOTE: {
                    mode.type = CopyMode.CopyModeType.TEXTFILE;
                    break;
                }
                default: {
                    throw new TrinoCloudFastpathImpossibleException(String.format("format not supported: %s for dataset: %s", ds.getFormatType(), dsFullName));
                }
            }
            mode.csvSkipHeaderLineCount = config.skipRowsAfterHeader + config.skipRowsBeforeHeader;
            if (config.parseHeaderRow) {
                ++mode.csvSkipHeaderLineCount;
            }
            return mode;
        }
        if ("parquet".equals(ds.getFormatType())) {
            CopyMode mode = new CopyMode();
            mode.type = CopyMode.CopyModeType.PARQUET;
            ParquetFormatConfig config = ds.getFormatParamsAs(ParquetFormatConfig.class);
            switch (config.parquetCompressionMethod) {
                case UNCOMPRESSED: 
                case SNAPPY: 
                case GZIP: 
                case LZO: 
                case ZSTD: {
                    break;
                }
                default: {
                    throw new TrinoCloudFastpathImpossibleException(String.format("Unsupported compression type %s for parquet files", new Object[]{config.parquetCompressionMethod}));
                }
            }
            return mode;
        }
        if ("orcfile".equals(ds.getFormatType())) {
            CopyMode mode = new CopyMode();
            mode.type = CopyMode.CopyModeType.ORC;
            ORCFileFormatConfig config = ds.getFormatParamsAs(ORCFileFormatConfig.class);
            switch (config.compressionMethod) {
                case NONE: 
                case SNAPPY: 
                case ZLIB: {
                    break;
                }
                default: {
                    throw new TrinoCloudFastpathImpossibleException(String.format("Unsupported compression type %s for orc files", new Object[]{config.compressionMethod}));
                }
            }
            return mode;
        }
        throw new TrinoCloudFastpathImpossibleException(String.format("format not supported: %s for dataset: %s", ds.getFormatType(), dsFullName));
    }

    public static class TrinoCloudFastpathImpossibleException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        TrinoCloudFastpathImpossibleException(String message) {
            super(message);
        }
    }

    public static class CopyMode {
        public CopyModeType type;
        public char csvSeparator;
        public char csvQuote;
        public char csvEscape;
        public int csvSkipHeaderLineCount;

        public static String quotedChar(char c2) {
            if (c2 >= ' ' && c2 < '\u007f' && c2 != '\'') {
                return "'" + Character.toString(c2) + "'";
            }
            return String.format("U&'\\%04x'", c2);
        }

        public static String quotedObject(Object o) {
            if (o instanceof Character) {
                return CopyMode.quotedChar(((Character)o).charValue());
            }
            if (o instanceof String) {
                return "'" + String.valueOf(o) + "'";
            }
            return String.valueOf(o);
        }

        public String generateFormatOptions() {
            logger.info((Object)String.format("Generating options for CopyMode: %s", this));
            HashMap<String, Object> props = new HashMap<String, Object>();
            if (CopyModeType.CSV.equals((Object)this.type)) {
                props.put("format", "CSV");
                props.put("csv_separator", Character.valueOf(this.csvSeparator));
                if (this.csvSkipHeaderLineCount > 0) {
                    props.put("skip_header_line_count", this.csvSkipHeaderLineCount);
                }
                if (this.csvQuote != '\u0000') {
                    props.put("csv_quote", Character.valueOf(this.csvQuote));
                }
                if (this.csvEscape != '\u0000') {
                    props.put("csv_escape", Character.valueOf(this.csvEscape));
                }
            } else if (CopyModeType.TEXTFILE.equals((Object)this.type)) {
                props.put("format", "TEXTFILE");
                props.put("null_format", "");
                props.put("textfile_field_separator", Character.valueOf(this.csvSeparator));
                if (this.csvSkipHeaderLineCount > 0) {
                    props.put("skip_header_line_count", this.csvSkipHeaderLineCount);
                }
                if (this.csvEscape != '\u0000') {
                    props.put("textfile_field_separator_escape", Character.valueOf(this.csvEscape));
                }
            } else if (CopyModeType.PARQUET.equals((Object)this.type)) {
                props.put("format", "PARQUET");
            } else if (CopyModeType.ORC.equals((Object)this.type)) {
                props.put("format", "ORC");
            } else {
                throw new UnsupportedOperationException("Unsupported copy mode for Snowflake: " + String.valueOf((Object)this.type));
            }
            return props.entrySet().stream().map(e -> (String)e.getKey() + "=" + CopyMode.quotedObject(e.getValue())).collect(Collectors.joining(", "));
        }

        public String toString() {
            return "CopyMode{type=" + String.valueOf((Object)this.type) + ", csvQuote=" + this.csvQuote + ", csvEscape=" + this.csvEscape + ", csvSeparator=" + this.csvSeparator + ", csvSkipHeaderLineCount=" + this.csvSkipHeaderLineCount + "}";
        }

        static enum CopyModeType {
            CSV,
            TEXTFILE,
            ORC,
            PARQUET;

        }
    }
}

