/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graphtools;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.dataflow.graphtools.AbstractFlowTool;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class FileformatsView
extends AbstractFlowTool.FlowView {
    private FileformatsViewState state;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.flow.tools.fileformat");

    public FileformatsView(AuthCtx authCtx, String projectKey, JsonObject toolInitialData) {
        super(authCtx, projectKey);
    }

    @Override
    public AbstractFlowTool.FlowState getFlowState(JsonObject options) throws Exception {
        if (this.state != null) {
            Collection<String> currentFocus = this.state.focused;
            this.computeState();
            this.state.focused = currentFocus;
        } else {
            this.computeState();
        }
        return this.state;
    }

    @Override
    public synchronized FileformatsViewState computeState() throws Exception {
        this.state = new FileformatsViewState();
        try (Transaction tr = this.transactionService.beginRead();){
            for (SerializedDataset sd : this.datasetsDAO.listUnsafe(this.projectKey)) {
                FutureProgressState.checkInterrupt();
                String nodeId = GraphIds.forDataset(sd.projectKey, sd.name);
                try {
                    Dataset dataset;
                    String connectionName = sd.getParams().getConnection();
                    if (StringUtils.isBlank((String)connectionName) || !DatasetHandlerFactory.getMeta(dataset = Dataset.fromSerialized(sd)).isFSLike()) continue;
                    String formatType = sd.formatType;
                    if (sd.formatType == null) continue;
                    this.add(nodeId, connectionName, formatType);
                }
                catch (Exception e) {
                    logger.info((Object)"Failed to get dataset connection", (Throwable)e);
                }
            }
        }
        return this.state;
    }

    @Override
    public void setFocus(Collection<String> focused) throws Exception {
        if (this.state == null) {
            this.computeState();
        }
        this.state.focused = focused == null ? new HashSet<String>() : focused;
    }

    private void add(String nodeId, String connection, String formatType) {
        NodeConnectionInfo val = new NodeConnectionInfo();
        val.connection = connection;
        val.formatType = formatType;
        this.state.valueByNode.put(nodeId, val);
    }

    public static class FileformatsViewState
    implements AbstractFlowTool.FlowState {
        Map<String, NodeConnectionInfo> valueByNode = new HashMap<String, NodeConnectionInfo>();
        public Collection<String> focused = new HashSet<String>();
    }

    public static class NodeConnectionInfo {
        String connection;
        String formatType;
    }
}

