/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.suggester;

import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.common.GroupedComputation;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.computations.transformers.TransformedComputation;
import com.dataiku.dip.eda.compute.engine.ComputationResultSession;
import com.dataiku.dip.eda.compute.engine.ComputationRunner;
import com.dataiku.dip.eda.compute.engine.NoStreamingComputationResultSession;
import com.dataiku.dip.eda.compute.engine.WrappedComputationResultSession;
import com.dataiku.dip.eda.compute.grouping.SubsampledGrouping;
import com.dataiku.dip.eda.compute.grouping.TopNTimeGrouping;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ComputationSampler {
    private static final int MAX_SIZE = 1000;
    private final List<TransformedComputation> sampledComputations = new ArrayList<TransformedComputation>();

    public void withRandomSampling(Computation computation) {
        GroupedComputation wrapped = new GroupedComputation(computation, new SubsampledGrouping(1000));
        TransformedComputation sampledComputation = new TransformedComputation(wrapped){

            @Override
            public ComputationResult reconstruct(ComputationResult result) {
                return result.isAvailable() ? result.asGrouped().results.get(0) : result.getFirstFailedResult();
            }
        };
        this.sampledComputations.add(sampledComputation);
    }

    public void withTopNTimeSampling(Computation computation, String variableName) {
        GroupedComputation wrapped = new GroupedComputation(computation, new TopNTimeGrouping(variableName, 1000));
        TransformedComputation sampledComputation = new TransformedComputation(wrapped){

            @Override
            public ComputationResult reconstruct(ComputationResult result) {
                return result.isAvailable() ? result.asGrouped().results.get(0) : result.getFirstFailedResult();
            }
        };
        this.sampledComputations.add(sampledComputation);
    }

    public ComputationResultSession computeSession(ComputationRunner fullSampleRunner) throws Exception {
        if (this.sampledComputations.isEmpty()) {
            MultiComputation.MultiComputationResult emptyMcr = new MultiComputation.MultiComputationResult(new ComputationResult[0]);
            return new NoStreamingComputationResultSession(emptyMcr);
        }
        MultiComputation multiComputation = new MultiComputation(this.sampledComputations.stream().map(sc -> sc.computation).collect(Collectors.toList()));
        ComputationResultSession session = fullSampleRunner.computeAndOpenSession(multiComputation);
        MultiComputation.MultiComputationResult multiResult = session.getComputationResult().asMulti();
        ArrayList<ComputationResult> results = new ArrayList<ComputationResult>();
        for (int i = 0; i < this.sampledComputations.size(); ++i) {
            ComputationResult result = this.sampledComputations.get(i).reconstruct(multiResult.get(i));
            results.add(result);
        }
        MultiComputation.MultiComputationResult mcr = new MultiComputation.MultiComputationResult(results);
        return new WrappedComputationResultSession(session, mcr);
    }

    public MultiComputation.MultiComputationResult compute(ComputationRunner fullSampleRunner) throws Exception {
        try (ComputationResultSession session = this.computeSession(fullSampleRunner);){
            MultiComputation.MultiComputationResult multiComputationResult = session.getComputationResult().asMulti();
            return multiComputationResult;
        }
    }
}

