/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.suggester;

import com.dataiku.dip.eda.compute.distributions.KDE2D;
import com.dataiku.dip.eda.worksheets.cards.Fit2DDistributionCard;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.dataiku.dip.eda.worksheets.queries.SuggestCards;
import com.dataiku.dip.eda.worksheets.suggester.SniffedVariable;
import com.dataiku.dip.eda.worksheets.suggester.Suggester;
import java.util.Collections;
import java.util.List;

public class KDE2DSuggester
implements Suggester {
    @Override
    public List<SuggestCards.SuggestedCard> suggestCards(List<SniffedVariable> sniffedVariables) {
        if (sniffedVariables.size() != 2) {
            return Collections.emptyList();
        }
        if (!sniffedVariables.stream().allMatch(SniffedVariable::isLikelyNumerical)) {
            return Collections.emptyList();
        }
        Variable firstVariable = Suggester.toContinuousVariable(sniffedVariables.get(0));
        Variable secondVariable = Suggester.toContinuousVariable(sniffedVariables.get(1));
        Fit2DDistributionCard card = new Fit2DDistributionCard(firstVariable, secondVariable, 640, 480, new KDE2D(15.0, 15.0));
        SuggestCards.SuggestedCard suggestion = new SuggestCards.SuggestedCard("KDE 2D", card);
        return Collections.singletonList(suggestion);
    }
}

