/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hadoop;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.formats.avro.AvroFormatConfig;
import com.dataiku.dip.input.formats.CompressibleFormatParams;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatConfig;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;

public class MapredCompressionSetter {
    private MapredOutputCompression outputCompression = null;
    private MapredAvroCompression avroCompression = null;
    private MapredParquetCompression parquetCompression = null;
    private MapredORCCompression orcCompression = null;

    public void inspectOutputDataset(Dataset dataset) throws Exception {
        if (dataset.getFormatParams() instanceof AvroFormatConfig) {
            MapredAvroCompression wantedAvro = null;
            wantedAvro = ((AvroFormatConfig)dataset.getFormatParams()).avroCompressionMethod == AvroFormatConfig.AvroCompressionMethod.SNAPPY ? MapredAvroCompression.SNAPPY : (((AvroFormatConfig)dataset.getFormatParams()).avroCompressionMethod == AvroFormatConfig.AvroCompressionMethod.NONE ? MapredAvroCompression.NONE : MapredAvroCompression.DEFLATE);
            if (this.avroCompression != null && this.avroCompression != wantedAvro) {
                throw new Exception("All AVRO outputs of the recipe must use the same compression (" + String.valueOf((Object)this.avroCompression) + " and " + String.valueOf((Object)wantedAvro) + " used)");
            }
            this.avroCompression = wantedAvro;
        } else if (dataset.getFormatParams() instanceof CompressibleFormatParams) {
            MapredOutputCompression wantedOuput = null;
            String compress = ((CompressibleFormatParams)dataset.getFormatParams()).compress;
            MapredOutputCompression mapredOutputCompression = wantedOuput = "gz".equalsIgnoreCase(compress) ? MapredOutputCompression.GZIP : MapredOutputCompression.NONE;
            if (this.outputCompression != null && this.outputCompression != wantedOuput) {
                throw new Exception("All TEXTFILE outputs of the recipe must use the same compression (" + String.valueOf((Object)this.outputCompression) + " and " + String.valueOf((Object)wantedOuput) + " used)");
            }
            this.outputCompression = wantedOuput;
        } else if (dataset.getFormatParams() instanceof ParquetFormatConfig) {
            this.compressParquet(dataset);
        } else if (dataset.getFormatParams() instanceof ORCFileFormatConfig) {
            this.compressOrc(dataset);
        }
    }

    private void compressParquet(Dataset dataset) throws Exception {
        MapredParquetCompression wantedParquet = null;
        switch (((ParquetFormatConfig)dataset.getFormatParams()).parquetCompressionMethod) {
            case SNAPPY: {
                wantedParquet = MapredParquetCompression.SNAPPY;
                break;
            }
            case GZIP: {
                wantedParquet = MapredParquetCompression.GZIP;
                break;
            }
            case LZO: {
                wantedParquet = MapredParquetCompression.LZO;
                break;
            }
            case ZSTD: {
                wantedParquet = MapredParquetCompression.ZSTD;
                break;
            }
            default: {
                wantedParquet = MapredParquetCompression.UNCOMPRESSED;
            }
        }
        if (this.parquetCompression != null && this.parquetCompression != wantedParquet) {
            throw new Exception("All PARQUET outputs of the recipe must use the same compression (" + String.valueOf((Object)this.parquetCompression) + " and " + String.valueOf((Object)wantedParquet) + " used)");
        }
        this.parquetCompression = wantedParquet;
    }

    private void compressOrc(Dataset dataset) throws Exception {
        MapredORCCompression wantedOrc = null;
        switch (((ORCFileFormatConfig)dataset.getFormatParams()).compressionMethod) {
            case SNAPPY: {
                wantedOrc = MapredORCCompression.SNAPPY;
                break;
            }
            case ZLIB: {
                wantedOrc = MapredORCCompression.ZLIB;
                break;
            }
            default: {
                wantedOrc = MapredORCCompression.NONE;
            }
        }
        if (this.orcCompression != null && this.orcCompression != wantedOrc) {
            throw new Exception("All ORC outputs of the recipe must use the same compression (" + String.valueOf((Object)this.orcCompression) + " and " + String.valueOf((Object)wantedOrc) + " used)");
        }
        this.orcCompression = wantedOrc;
    }

    public String getCompressionCommands(boolean pigStyle) throws Exception {
        String eol;
        StringBuilder query = new StringBuilder();
        boolean compressNeeded = false;
        boolean noCompressNeeded = false;
        String string = eol = pigStyle ? " " : "\n";
        if (this.outputCompression != null) {
            if (this.outputCompression == MapredOutputCompression.GZIP) {
                compressNeeded = true;
                query.append("SET mapred.output.compression.type" + (pigStyle ? (char)' ' : '=') + "BLOCK;" + eol);
                query.append("SET mapred.output.compression.codec" + (pigStyle ? (char)' ' : '=') + "org.apache.hadoop.io.compress.GzipCodec;" + eol);
            } else if (this.outputCompression == MapredOutputCompression.NONE) {
                noCompressNeeded = true;
            }
        }
        if (this.avroCompression != null) {
            if (this.avroCompression == MapredAvroCompression.SNAPPY) {
                compressNeeded = true;
                query.append("SET avro.output.codec" + (pigStyle ? (char)' ' : '=') + "snappy;" + eol);
            } else if (this.avroCompression == MapredAvroCompression.DEFLATE) {
                compressNeeded = true;
                query.append("SET avro.output.codec" + (pigStyle ? (char)' ' : '=') + "deflate;" + eol);
            } else if (this.avroCompression == MapredAvroCompression.NONE) {
                noCompressNeeded = true;
            }
        }
        if (this.parquetCompression != null) {
            compressNeeded = true;
            query.append("SET parquet.compression" + (pigStyle ? (char)' ' : '=') + this.parquetCompression.name() + ";" + eol);
        }
        if (this.orcCompression != null) {
            compressNeeded = true;
            query.append("SET orc.compress" + (pigStyle ? (char)' ' : '=') + this.orcCompression.name() + ";" + eol);
        }
        if (compressNeeded && noCompressNeeded) {
            throw new Exception("Cannot setup output compression: some of the outputs need compression, while other need no compression.");
        }
        if (pigStyle) {
            query.append("SET mapred.output.compress " + compressNeeded + ";" + eol);
        } else {
            query.append("SET hive.exec.compress.output=" + compressNeeded + ";" + eol);
        }
        return query.toString();
    }

    private static enum MapredOutputCompression {
        NONE,
        GZIP;

    }

    private static enum MapredAvroCompression {
        NONE,
        SNAPPY,
        DEFLATE;

    }

    private static enum MapredParquetCompression {
        UNCOMPRESSED,
        GZIP,
        SNAPPY,
        LZO,
        ZSTD;

    }

    private static enum MapredORCCompression {
        NONE,
        ZLIB,
        SNAPPY,
        ZSTD;

    }
}

