/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm;

import com.dataiku.dip.llm.governance.forbiddenterms.ForbiddenTermsDetectionGuardrail;
import com.dataiku.dip.llm.governance.formats.ResponseFormatChecker;
import com.dataiku.dip.llm.governance.pii.PIIDetectionGuardrail;
import com.dataiku.dip.llm.governance.promptinjection.PromptInjectionDetectionGuardrail;
import com.dataiku.dip.llm.governance.toxicity.ToxicityDetectionGuardrail;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.util.JsonUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class RawAgentTrajectoryExtractor {
    private static final Set<String> builtinGuardrailsTypes = Set.of(ToxicityDetectionGuardrail.META.getType(), PIIDetectionGuardrail.META.getType(), ForbiddenTermsDetectionGuardrail.META.getType(), PromptInjectionDetectionGuardrail.META.getType(), ResponseFormatChecker.META.getType());
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.trajectoryExtractor");
    private static final Set<String> COMPLETION_QUERY_SPAN_NAMES = Set.of("DKU_LLM_MESH_COMPLETION_QUERY", "DKU_LLM_MESH_COMPLETION_QUERY_STREAMED");
    private static final Set<String> LLM_CALL_SPAN_NAMES = Set.of("DKU_LLM_MESH_LLM_CALL", "DKU_LLM_MESH_LLM_CALL_STREAMED");

    private RawAgentTrajectoryExtractor() {
    }

    public static RawAgentTrajectory toTrajectory(LLMClient.SimpleCompletionResponseOrError result, LLMClient.LLMMeshTraceSpan trace) {
        JsonObject outputs;
        TrajectoryError trajectoryError;
        TraceType traceType;
        List<Object> innerSubTrajectory;
        InputsAndOutputs inputsAndOutputs = RawAgentTrajectoryExtractor.extractInputsAndOutputs(trace);
        TriggeredGuardrails triggeredAgentGuardrails = RawAgentTrajectoryExtractor.extractGuardrails(trace, TrajectoryLevel.AGENT);
        if (result.ok) {
            AgentSubtrajectoryAndType agentTrajectoryAndType = RawAgentTrajectoryExtractor.extractAgentTrajectory(trace);
            innerSubTrajectory = agentTrajectoryAndType.subtrajectory();
            traceType = agentTrajectoryAndType.traceType();
            trajectoryError = null;
            outputs = inputsAndOutputs.outputs;
        } else {
            innerSubTrajectory = List.of();
            traceType = TraceType.UNKNOWN;
            trajectoryError = RawAgentTrajectoryExtractor.extractError(result, trace);
            outputs = null;
        }
        return new RawAgentTrajectory(traceType, trace.begin, trace.end, trace.duration, inputsAndOutputs.inputs, outputs, trajectoryError, RawAgentTrajectoryExtractor.concatenate(triggeredAgentGuardrails.queryGuardrails(), innerSubTrajectory, triggeredAgentGuardrails.responseGuardrails()));
    }

    private static InputsAndOutputs extractInputsAndOutputs(LLMClient.LLMMeshTraceSpan trace) {
        JsonObject inputs = trace.inputs == null ? new JsonObject() : trace.inputs;
        return new InputsAndOutputs(inputs, trace.outputs);
    }

    private static TriggeredGuardrails extractGuardrails(LLMClient.LLMMeshTraceSpan completionQuerySpan, TrajectoryLevel trajectoryLevel) {
        if (completionQuerySpan == null) {
            return new TriggeredGuardrails(List.of(), List.of());
        }
        String llmId = JsonUtils.getOrNullStr(completionQuerySpan.attributes, "llmId");
        LLMClient.LLMMeshTraceSpan queryEnforcement = RawAgentTrajectoryExtractor.getFirstChildWithName((LLMClient.LLMMeshTraceObservation)completionQuerySpan, "DKU_LLM_MESH_QUERY_ENFORCEMENT");
        List<GuardrailTrajectoryElement> triggeredQueryGuardrails = RawAgentTrajectoryExtractor.extractTriggeredGuardrailElements(queryEnforcement, llmId, GuardrailEnforcementType.QUERY, trajectoryLevel);
        LLMClient.LLMMeshTraceSpan responseEnforcement = RawAgentTrajectoryExtractor.getFirstChildWithName((LLMClient.LLMMeshTraceObservation)completionQuerySpan, "DKU_LLM_MESH_RESPONSE_ENFORCEMENT");
        List<GuardrailTrajectoryElement> triggeredResponseGuardrails = RawAgentTrajectoryExtractor.extractTriggeredGuardrailElements(responseEnforcement, llmId, GuardrailEnforcementType.RESPONSE, trajectoryLevel);
        return new TriggeredGuardrails(triggeredQueryGuardrails, triggeredResponseGuardrails);
    }

    private static TrajectoryError extractError(LLMClient.SimpleCompletionResponseOrError result, LLMClient.LLMMeshTraceSpan trace) {
        if (trace.attributes == null || !trace.attributes.has("completionResponse")) {
            return new TrajectoryError(result.errorType.toString(), result.errorMessage, TrajectoryLevel.AGENT);
        }
        JsonObject completionResponse = JsonUtils.getOrEmptyObj(trace.attributes, "completionResponse");
        String errorType = JsonUtils.getOrNullStr(completionResponse, "errorType");
        if (errorType == null) {
            return new TrajectoryError("", "", TrajectoryLevel.ORCHESTRATOR);
        }
        return new TrajectoryError(JsonUtils.getOrNullStr(completionResponse, "errorType"), JsonUtils.getOrNullStr(completionResponse, "errorMessage"), TrajectoryLevel.ORCHESTRATOR);
    }

    private static List<GuardrailTrajectoryElement> extractTriggeredGuardrailElements(LLMClient.LLMMeshTraceSpan enforcementSpan, String llmId, GuardrailEnforcementType guardrailEnforcementType, TrajectoryLevel trajectoryLevel) {
        if (enforcementSpan == null) {
            return List.of();
        }
        List<LLMClient.LLMMeshTraceSpan> guardrailSpans = RawAgentTrajectoryExtractor.getChildrenAsLLMMeshTraceSpans(enforcementSpan);
        return guardrailSpans.stream().filter(RawAgentTrajectoryExtractor::hasSoftTriggered).map(guardrailSpan -> new GuardrailTrajectoryElement(guardrailSpan.name, guardrailSpan.begin, guardrailSpan.end, guardrailSpan.duration, guardrailSpan.inputs, guardrailSpan.outputs, llmId, guardrailEnforcementType, trajectoryLevel)).toList();
    }

    private static boolean hasSoftTriggered(LLMClient.LLMMeshTraceSpan guardrailSpan) {
        String guardrailType = RawAgentTrajectoryExtractor.getGuardrailType(guardrailSpan.name);
        if (!builtinGuardrailsTypes.contains(guardrailType)) {
            return true;
        }
        if (!PIIDetectionGuardrail.META.getType().equals(guardrailType)) {
            return false;
        }
        return guardrailSpan.outputs != null && guardrailSpan.outputs.size() != 0 && guardrailSpan.outputs.has("detectedEntities");
    }

    private static String getGuardrailType(String guardrailName) {
        String prefix = "GUARDRAIL_";
        int start = prefix.length();
        int end = guardrailName.lastIndexOf("_");
        if (end <= start) {
            return "";
        }
        return guardrailName.substring(start, end);
    }

    @Nonnull
    private static AgentSubtrajectoryAndType extractAgentTrajectory(LLMClient.LLMMeshTraceSpan trace) {
        LLMClient.LLMMeshTraceSpan llmMeshLlmCall = RawAgentTrajectoryExtractor.getFirstChildWithName((LLMClient.LLMMeshTraceObservation)trace, LLM_CALL_SPAN_NAMES);
        if (llmMeshLlmCall == null) {
            return new AgentSubtrajectoryAndType(TraceType.UNKNOWN, List.of());
        }
        LLMClient.LLMMeshTraceSpan agentCall = RawAgentTrajectoryExtractor.getFirstChildWithName((LLMClient.LLMMeshTraceObservation)llmMeshLlmCall, "DKU_AGENT_CALL");
        if (agentCall == null) {
            return new AgentSubtrajectoryAndType(TraceType.UNKNOWN, List.of());
        }
        if (RawAgentTrajectoryExtractor.getFirstChildWithName((LLMClient.LLMMeshTraceObservation)agentCall, "LangGraph") != null) {
            logger.info((Object)"Extracting visual agent trajectory");
            return new AgentSubtrajectoryAndType(TraceType.VISUAL_AGENT_V1, RawAgentTrajectoryExtractor.extractVisualAgentV1Trajectory(agentCall));
        }
        if (RawAgentTrajectoryExtractor.getFirstChildWithName((LLMClient.LLMMeshTraceObservation)agentCall, "DKU_AGENT_ITERATION") != null) {
            logger.info((Object)"Extracting visual agent trajectory");
            return new AgentSubtrajectoryAndType(TraceType.VISUAL_AGENT_V2, RawAgentTrajectoryExtractor.extractVisualAgentV2Trajectory(agentCall));
        }
        if (RawAgentTrajectoryExtractor.getFirstChildWithName((LLMClient.LLMMeshTraceObservation)agentCall, "AgentExecutor") != null) {
            logger.info((Object)"Extracting code agent trajectory");
            return new AgentSubtrajectoryAndType(TraceType.CODE_AGENT, RawAgentTrajectoryExtractor.extractCodeAgentTrajectory(agentCall));
        }
        logger.debug((Object)"Unknown agent format, not parsing its trace");
        return new AgentSubtrajectoryAndType(TraceType.UNKNOWN, List.of());
    }

    @Nonnull
    private static List<TrajectoryElement> extractVisualAgentV1Trajectory(LLMClient.LLMMeshTraceSpan trace) {
        LLMClient.LLMMeshTraceSpan langGraph = RawAgentTrajectoryExtractor.getFirstChildWithName((LLMClient.LLMMeshTraceObservation)trace, "LangGraph");
        if (langGraph == null) {
            return List.of();
        }
        List<AgentToolIteration> agentToolIterations = RawAgentTrajectoryExtractor.groupVisualAgentV1ToolIterations(langGraph);
        return agentToolIterations.stream().map(RawAgentTrajectoryExtractor::getVisualAgentV1IterationSubTrajectory).flatMap(Collection::stream).toList();
    }

    private static List<AgentToolIteration> groupVisualAgentV1ToolIterations(LLMClient.LLMMeshTraceSpan langGraph) {
        ArrayList<AgentToolIteration> iterations = new ArrayList<AgentToolIteration>();
        LLMClient.LLMMeshTraceSpan currentAgentSpan = null;
        ArrayList<LLMClient.LLMMeshTraceSpan> currentTools = new ArrayList<LLMClient.LLMMeshTraceSpan>();
        for (LLMClient.LLMMeshTraceObservation span : langGraph.children) {
            if ("agent".equals(span.name)) {
                if (currentAgentSpan != null) {
                    iterations.add(new AgentToolIteration(currentAgentSpan, currentTools));
                }
                currentAgentSpan = (LLMClient.LLMMeshTraceSpan)span;
                currentTools = new ArrayList();
                continue;
            }
            if (!"tools".equals(span.name)) continue;
            if (currentAgentSpan == null) {
                logger.warnV("Found tool span without preceding agent span: %s", new Object[]{span});
                continue;
            }
            currentTools.addAll(RawAgentTrajectoryExtractor.getChildrenAsLLMMeshTraceSpans(span));
        }
        if (currentAgentSpan != null) {
            iterations.add(new AgentToolIteration(currentAgentSpan, currentTools));
        }
        return iterations;
    }

    private static List<TrajectoryElement> getVisualAgentV1IterationSubTrajectory(AgentToolIteration iteration) {
        LLMClient.LLMMeshTraceSpan runnableSequence = RawAgentTrajectoryExtractor.getFirstChildWithName(iteration.agentSpan(), "RunnableSequence");
        if (runnableSequence == null) {
            return List.of();
        }
        LLMClient.LLMMeshTraceSpan dkuChatModel = RawAgentTrajectoryExtractor.getFirstChildWithName((LLMClient.LLMMeshTraceObservation)runnableSequence, "DKUChatModel");
        if (dkuChatModel == null) {
            return List.of();
        }
        List<String> requestedToolNames = RawAgentTrajectoryExtractor.getVisualAgentV1RequestedToolNames(runnableSequence);
        List<ToolCallTrajectoryElement> toolCalls = RawAgentTrajectoryExtractor.getVisualAgentV1IterationToolCallElements(iteration.toolSpans(), new ArrayList<String>(requestedToolNames));
        LLMClient.LLMMeshTraceSpan completionQuery = RawAgentTrajectoryExtractor.getFirstChildWithName((LLMClient.LLMMeshTraceObservation)dkuChatModel, COMPLETION_QUERY_SPAN_NAMES);
        TriggeredGuardrails triggeredGuardrails = RawAgentTrajectoryExtractor.extractGuardrails(completionQuery, TrajectoryLevel.ORCHESTRATOR);
        return RawAgentTrajectoryExtractor.concatenate(triggeredGuardrails.queryGuardrails(), triggeredGuardrails.responseGuardrails(), toolCalls);
    }

    private static List<ToolCallTrajectoryElement> getVisualAgentV1IterationToolCallElements(List<LLMClient.LLMMeshTraceSpan> toolSpans, ArrayList<String> requestedToolNames) {
        ArrayList<ToolCallTrajectoryElement> toolCalls = new ArrayList<ToolCallTrajectoryElement>();
        for (LLMClient.LLMMeshTraceSpan toolSpan : toolSpans) {
            LLMClient.LLMMeshTraceSpan dkuManagedToolCall;
            if (!requestedToolNames.contains(toolSpan.name)) continue;
            requestedToolNames.remove(toolSpan.name);
            LLMClient.LLMMeshTraceSpan dkuStructuredTool = RawAgentTrajectoryExtractor.getFirstChildWithName((LLMClient.LLMMeshTraceObservation)toolSpan, "DKUStructuredTool");
            if (dkuStructuredTool == null || (dkuManagedToolCall = RawAgentTrajectoryExtractor.getFirstChildWithName((LLMClient.LLMMeshTraceObservation)dkuStructuredTool, "DKU_MANAGED_TOOL_CALL")) == null) continue;
            ToolCallTrajectoryElement toolCall = new ToolCallTrajectoryElement(toolSpan.name, toolSpan.begin, toolSpan.end, toolSpan.duration, toolSpan.inputs, toolSpan.outputs, dkuManagedToolCall.attributes);
            toolCalls.add(toolCall);
        }
        return toolCalls;
    }

    private static List<String> getVisualAgentV1RequestedToolNames(LLMClient.LLMMeshTraceObservation runnableSequence) {
        JsonObject sequenceOutputs = runnableSequence.outputs == null ? new JsonObject() : runnableSequence.outputs;
        JsonObject output = JsonUtils.getOrEmptyObj(sequenceOutputs, "output");
        if (output.has("tool_calls")) {
            JsonArray requestedTools = JsonUtils.getOrEmptyArr(output, "tool_calls");
            return StreamSupport.stream(requestedTools.spliterator(), false).map(tool -> {
                if (!tool.isJsonObject()) {
                    return null;
                }
                return JsonUtils.getOrNullStr(tool.getAsJsonObject(), "name");
            }).filter(Objects::nonNull).toList();
        }
        JsonArray requestedTools = JsonUtils.getOrEmptyArr(output, "additional_kwargs", "tool_calls");
        return StreamSupport.stream(requestedTools.spliterator(), false).map(tool -> {
            if (!tool.isJsonObject()) {
                return null;
            }
            return JsonUtils.getOrNullStr(tool.getAsJsonObject(), "function", "name");
        }).filter(Objects::nonNull).toList();
    }

    @Nonnull
    private static List<TrajectoryElement> extractVisualAgentV2Trajectory(LLMClient.LLMMeshTraceSpan dkuAgentCall) {
        List<LLMClient.LLMMeshTraceSpan> agentIterations = RawAgentTrajectoryExtractor.getChildrenAsLLMMeshTraceSpans(dkuAgentCall).stream().filter(child -> Objects.equals(child.name, "DKU_AGENT_ITERATION")).toList();
        return agentIterations.stream().map(RawAgentTrajectoryExtractor::getVisualAgentV2IterationSubTrajectory).flatMap(Collection::stream).toList();
    }

    private static List<TrajectoryElement> getVisualAgentV2IterationSubTrajectory(@Nonnull LLMClient.LLMMeshTraceSpan agentIteration) {
        TriggeredGuardrails triggeredGuardrails;
        LLMClient.LLMMeshTraceSpan dkuAgentLlmCall = RawAgentTrajectoryExtractor.getFirstChildWithName((LLMClient.LLMMeshTraceObservation)agentIteration, "DKU_AGENT_LLM_CALL");
        if (dkuAgentLlmCall != null) {
            LLMClient.LLMMeshTraceSpan completionQuery = RawAgentTrajectoryExtractor.getFirstChildWithName((LLMClient.LLMMeshTraceObservation)dkuAgentLlmCall, COMPLETION_QUERY_SPAN_NAMES);
            triggeredGuardrails = RawAgentTrajectoryExtractor.extractGuardrails(completionQuery, TrajectoryLevel.ORCHESTRATOR);
        } else {
            triggeredGuardrails = new TriggeredGuardrails(List.of(), List.of());
        }
        LLMClient.LLMMeshTraceSpan agentToolCallsSpan = RawAgentTrajectoryExtractor.getFirstChildWithName((LLMClient.LLMMeshTraceObservation)agentIteration, "DKU_AGENT_TOOL_CALLS");
        if (agentToolCallsSpan == null) {
            return RawAgentTrajectoryExtractor.concatenate(triggeredGuardrails.queryGuardrails(), triggeredGuardrails.responseGuardrails());
        }
        List<ToolCallTrajectoryElement> toolCalls = RawAgentTrajectoryExtractor.getChildrenAsLLMMeshTraceSpans(agentToolCallsSpan).stream().filter(child -> Objects.equals(child.name, "DKU_MANAGED_TOOL_CALL")).map(toolCallSpan -> {
            String projectKey = JsonUtils.getOrNullStr(toolCallSpan.attributes, "toolProjectKey");
            String toolId = JsonUtils.getOrNullStr(toolCallSpan.attributes, "toolId");
            Object name = "";
            if (StringUtils.isNotBlank((String)projectKey)) {
                name = (String)name + projectKey + ".";
            }
            name = StringUtils.isNotBlank((String)toolId) ? (String)name + toolId : (String)name + "unknown";
            return new ToolCallTrajectoryElement((String)name, toolCallSpan.begin, toolCallSpan.end, toolCallSpan.duration, toolCallSpan.inputs, toolCallSpan.outputs, toolCallSpan.attributes);
        }).toList();
        return RawAgentTrajectoryExtractor.concatenate(triggeredGuardrails.queryGuardrails(), triggeredGuardrails.responseGuardrails(), toolCalls);
    }

    @Nonnull
    private static List<TrajectoryElement> extractCodeAgentTrajectory(LLMClient.LLMMeshTraceSpan trace) {
        LLMClient.LLMMeshTraceSpan agentExecutor = RawAgentTrajectoryExtractor.getFirstChildWithName((LLMClient.LLMMeshTraceObservation)trace, "AgentExecutor");
        if (agentExecutor == null) {
            logger.warnV("No AgentExecutor span found in code agent trace: %s", new Object[]{trace});
            return List.of();
        }
        List<AgentToolIteration> agentToolIterations = RawAgentTrajectoryExtractor.groupCodeAgentToolIterations(agentExecutor);
        return agentToolIterations.stream().map(RawAgentTrajectoryExtractor::getCodeAgentIterationSubTrajectory).flatMap(Collection::stream).toList();
    }

    private static List<AgentToolIteration> groupCodeAgentToolIterations(LLMClient.LLMMeshTraceObservation agentExecutor) {
        ArrayList<AgentToolIteration> iteration = new ArrayList<AgentToolIteration>();
        LLMClient.LLMMeshTraceSpan agentSpan = null;
        ArrayList<LLMClient.LLMMeshTraceSpan> toolSpans = new ArrayList<LLMClient.LLMMeshTraceSpan>();
        for (LLMClient.LLMMeshTraceSpan span : RawAgentTrajectoryExtractor.getChildrenAsLLMMeshTraceSpans(agentExecutor)) {
            if ("RunnableSequence".equals(span.name)) {
                if (agentSpan != null) {
                    iteration.add(new AgentToolIteration(agentSpan, toolSpans));
                }
                agentSpan = span;
                toolSpans = new ArrayList();
                continue;
            }
            if (agentSpan == null) {
                logger.warnV("Found tool span without preceding RunnableSequence span: %s", new Object[]{span});
                continue;
            }
            toolSpans.add(span);
        }
        if (agentSpan != null) {
            iteration.add(new AgentToolIteration(agentSpan, toolSpans));
        }
        return iteration;
    }

    private static List<TrajectoryElement> getCodeAgentIterationSubTrajectory(AgentToolIteration agentToolIteration) {
        LLMClient.LLMMeshTraceSpan openAIToolsAgentOutputParser = RawAgentTrajectoryExtractor.getFirstChildWithName(agentToolIteration.agentSpan(), "OpenAIToolsAgentOutputParser");
        if (openAIToolsAgentOutputParser == null) {
            logger.warn((Object)"No OpenAIToolsAgentOutputParser span found in agent iteration");
            return List.of();
        }
        JsonObject inputs = openAIToolsAgentOutputParser.inputs == null ? new JsonObject() : openAIToolsAgentOutputParser.inputs;
        JsonArray requestedToolCalls = JsonUtils.getOrEmptyArr(inputs, "input", "additional_kwargs", "tool_calls");
        List<String> requestedToolNames = RawAgentTrajectoryExtractor.getCodeAgentRequestedToolNames(requestedToolCalls);
        LLMClient.LLMMeshTraceSpan dkuChatModel = RawAgentTrajectoryExtractor.getFirstChildWithName(agentToolIteration.agentSpan(), "DKUChatModel");
        TriggeredGuardrails triggeredGuardrails = new TriggeredGuardrails(List.of(), List.of());
        if (dkuChatModel != null) {
            LLMClient.LLMMeshTraceSpan completionQuery = RawAgentTrajectoryExtractor.getFirstChildWithName((LLMClient.LLMMeshTraceObservation)dkuChatModel, COMPLETION_QUERY_SPAN_NAMES);
            triggeredGuardrails = RawAgentTrajectoryExtractor.extractGuardrails(completionQuery, TrajectoryLevel.ORCHESTRATOR);
        }
        List<ToolCallTrajectoryElement> toolCalls = agentToolIteration.toolSpans().stream().filter(toolSpan -> {
            String toolName = toolSpan.name;
            return toolName != null && requestedToolNames.contains(toolName);
        }).map(toolSpan -> new ToolCallTrajectoryElement(toolSpan.name, toolSpan.begin, toolSpan.end, toolSpan.duration, toolSpan.inputs, toolSpan.outputs, toolSpan.attributes)).toList();
        return RawAgentTrajectoryExtractor.concatenate(triggeredGuardrails.queryGuardrails(), toolCalls, triggeredGuardrails.responseGuardrails());
    }

    private static List<String> getCodeAgentRequestedToolNames(JsonArray requestedToolCalls) {
        ArrayList<String> requestedToolNames = new ArrayList<String>();
        for (JsonElement toolElement : requestedToolCalls) {
            String functionName;
            JsonObject tool;
            if (!toolElement.isJsonObject() || !"function".equals(JsonUtils.getStringMemberOrEmpty(tool = toolElement.getAsJsonObject(), "type")) || !tool.has("function") || (functionName = JsonUtils.getOrNullStr(tool, "function", "name")) == null) continue;
            requestedToolNames.add(functionName);
        }
        return requestedToolNames;
    }

    private static LLMClient.LLMMeshTraceSpan getFirstChildWithName(LLMClient.LLMMeshTraceObservation span, String childName) {
        return RawAgentTrajectoryExtractor.getFirstChildWithName(span, Set.of(childName));
    }

    private static LLMClient.LLMMeshTraceSpan getFirstChildWithName(LLMClient.LLMMeshTraceObservation span, Collection<String> childNames) {
        return span.children.stream().filter(child -> childNames.contains(child.name)).findFirst().orElse(null);
    }

    @SafeVarargs
    private static List<TrajectoryElement> concatenate(List<? extends TrajectoryElement> ... lists) {
        ArrayList<TrajectoryElement> result = new ArrayList<TrajectoryElement>();
        for (List<? extends TrajectoryElement> list : lists) {
            result.addAll(list);
        }
        return result;
    }

    private static List<LLMClient.LLMMeshTraceSpan> getChildrenAsLLMMeshTraceSpans(LLMClient.LLMMeshTraceObservation span) {
        return span.children.stream().filter(child -> child instanceof LLMClient.LLMMeshTraceSpan).map(child -> (LLMClient.LLMMeshTraceSpan)child).toList();
    }

    private record InputsAndOutputs(@Nonnull JsonObject inputs, @Nullable JsonObject outputs) {
    }

    public static enum TrajectoryLevel {
        AGENT,
        ORCHESTRATOR;

    }

    private record TriggeredGuardrails(@Nonnull List<GuardrailTrajectoryElement> queryGuardrails, @Nonnull List<GuardrailTrajectoryElement> responseGuardrails) {
    }

    public record AgentSubtrajectoryAndType(@Nonnull TraceType traceType, @Nonnull List<TrajectoryElement> subtrajectory) {
    }

    public static enum TraceType {
        VISUAL_AGENT_V1,
        VISUAL_AGENT_V2,
        CODE_AGENT,
        UNKNOWN;

    }

    public static class TrajectoryError {
        public String errorType;
        public String errorMessage;
        public TrajectoryLevel errorLevel;

        public TrajectoryError() {
        }

        public TrajectoryError(String errorType, String errorMessage, TrajectoryLevel errorLevel) {
            this.errorType = errorType;
            this.errorMessage = errorMessage;
            this.errorLevel = errorLevel;
        }
    }

    public record RawAgentTrajectory(@Nonnull TraceType traceType, @Nonnull String begin, @Nonnull String end, @Nonnull Long duration, @Nonnull JsonObject inputs, @Nullable JsonObject outputs, @Nullable TrajectoryError error, @Nonnull List<TrajectoryElement> agentLoop) {
    }

    public static enum GuardrailEnforcementType {
        QUERY,
        RESPONSE;

    }

    private record AgentToolIteration(@Nonnull LLMClient.LLMMeshTraceObservation agentSpan, @Nonnull List<LLMClient.LLMMeshTraceSpan> toolSpans) {
    }

    public static class ToolCallTrajectoryElement
    extends TrajectoryElement {
        public JsonObject attributes;

        public ToolCallTrajectoryElement() {
        }

        public ToolCallTrajectoryElement(String name, String begin, String end, Long duration, JsonObject inputs, JsonObject outputs, JsonObject attributes) {
            super(name, begin, end, duration, inputs, outputs);
            this.attributes = attributes;
        }
    }

    public static final class GuardrailTrajectoryElement
    extends TrajectoryElement {
        public String llmId;
        @Nonnull
        public GuardrailEnforcementType guardrailEnforcementType;
        @Nonnull
        public TrajectoryLevel guardrailLevel;

        public GuardrailTrajectoryElement() {
        }

        public GuardrailTrajectoryElement(String name, String begin, String end, Long duration, JsonObject inputs, JsonObject outputs, String llmId, @Nonnull GuardrailEnforcementType guardrailEnforcementType, @Nonnull TrajectoryLevel guardrailLevel) {
            super(name, begin, end, duration, inputs, outputs);
            this.llmId = llmId;
            this.guardrailLevel = guardrailLevel;
            this.guardrailEnforcementType = guardrailEnforcementType;
        }
    }

    @PolyJSON(value={@Mapping(value=ToolCallTrajectoryElement.class, type="toolCall"), @Mapping(value=GuardrailTrajectoryElement.class, type="guardrail")})
    public static abstract class TrajectoryElement {
        public String name;
        public String begin;
        public String end;
        public Long duration;
        public JsonObject inputs;
        public JsonObject outputs;

        public TrajectoryElement() {
        }

        public TrajectoryElement(String name, String begin, String end, Long duration, JsonObject inputs, JsonObject outputs) {
            this.name = name;
            this.begin = begin;
            this.end = end;
            this.duration = duration;
            this.inputs = inputs;
            this.outputs = outputs;
        }
    }
}

