/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online;

import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.governance.GuardrailsPipelineSettings;
import com.dataiku.dip.llm.governance.GuardrailsPipelineUtils;
import com.dataiku.dip.llm.online.LLMMeshClient;
import com.dataiku.dip.llm.online.NonParallelLLMClient;
import com.dataiku.dip.llm.online.ParallelLLMClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import javax.annotation.Nullable;

public class LLMMeshClientFactory {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.llm");

    public static LLMMeshClient get(AuthCtx authCtx, String projectKey, LLMStructuredRef llmId, GuardrailsPipelineSettings guardrailsPipelineSettings, @Nullable AnyLoc usedDataset, int estimatedNbQueries) throws Exception {
        if (estimatedNbQueries <= 1) {
            return new NonParallelLLMClient(authCtx, llmId, guardrailsPipelineSettings, projectKey, usedDataset);
        }
        if (GuardrailsPipelineUtils.needsNonParallelProcessing(guardrailsPipelineSettings)) {
            logger.info((Object)"Multiple queries, but guardrails don't support parallel, using non-parallel");
            return new NonParallelLLMClient(authCtx, llmId, guardrailsPipelineSettings, projectKey, usedDataset);
        }
        return new ParallelLLMClient(authCtx, llmId, guardrailsPipelineSettings, projectKey, usedDataset, estimatedNbQueries);
    }
}

