/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.vertex;

import com.dataiku.dip.connections.VertexAILLMConnection;
import org.apache.commons.lang.StringUtils;

public class VertexPricing {
    private VertexPricing() {
    }

    public static Double getVertexPromptCostPer1kTokens(String model) {
        if (StringUtils.isBlank((String)model)) {
            return 0.0;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.GEMINI_FLASH_20.id)) {
            return 1.5E-4;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.GEMINI_FLASH_LITE_20.id)) {
            return 7.5E-5;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.GEMINI_FLASH_LITE_25.id)) {
            return 1.0E-4;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.GEMINI_FLASH_25.id)) {
            return 3.0E-4;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.GEMINI_PRO_25.id)) {
            return 0.00125;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.GEMINI_FLASH_20_EXP.id)) {
            return 0.0;
        }
        return 0.0;
    }

    public static Double getVertexAICompletionCostPer1kTokens(String model) {
        if (StringUtils.isBlank((String)model)) {
            return 0.0;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.GEMINI_FLASH_20.id)) {
            return 6.0E-4;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.GEMINI_FLASH_LITE_20.id)) {
            return 3.0E-4;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.GEMINI_FLASH_25.id)) {
            return 0.0025;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.GEMINI_FLASH_LITE_25.id)) {
            return 4.0E-4;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.GEMINI_PRO_25.id)) {
            return 0.01;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.GEMINI_FLASH_20_EXP.id)) {
            return 0.0;
        }
        return 0.0;
    }

    public static double getVertexAIEmbeddingCostPer1KChars(String model) {
        if (StringUtils.isBlank((String)model)) {
            return 0.0;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.GEMINI_EMBEDDING.id)) {
            return 1.5E-4;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.TEXT_EMBEDDING.id)) {
            return 2.5E-5;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.TEXT_EMBEDDING_005.id)) {
            return 2.5E-5;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.TEXT_MULTILANG_EMBEDDING.id)) {
            return 2.5E-5;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.MULTIMODAL_EMBEDDING.id)) {
            return 2.0E-4;
        }
        return 0.0;
    }

    public static double getVertexAIEmbeddingCostPerImage(String model) {
        if (StringUtils.isBlank((String)model)) {
            return 0.0;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.MULTIMODAL_EMBEDDING.id)) {
            return 1.0E-4;
        }
        return 0.0;
    }

    public static double getVertexAIImageGenerationCostPerImage(String model) {
        if (StringUtils.isBlank((String)model)) {
            return 0.0;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.IMAGEN_4_001.id)) {
            return 0.02;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.IMAGEN_4_FAST_001.id)) {
            return 0.04;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.IMAGEN_4_ULTRA_001.id)) {
            return 0.06;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.IMAGEN_3_001.id)) {
            return 0.04;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.IMAGEN_3_FAST_001.id)) {
            return 0.02;
        }
        return 0.0;
    }
}

