/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.nodeclients;

import com.dataiku.dip.apideployer.datamodel.actual.APIServiceDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.actual.APIServiceEndpointMonitoring;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentLightStatus;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractInfraBasicInfo;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractPublishedItemLightStatus;
import com.dataiku.dip.apideployer.datamodel.actual.PublishedPackageInfo;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.CheckInfraReadPermissionResponse;
import com.dataiku.dip.apideployer.deployments.AbstractAPIServiceDockerDeploymentManager;
import com.dataiku.dip.apideployer.deployments.QueryableEndpoint;
import com.dataiku.dip.apideployer.deployments.SingleStaticDeploymentManager;
import com.dataiku.dip.apideployer.engine.DeploymentReport;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.nodeclients.AbstractDeployerClientProxyUser;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.entity.ContentType;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.HttpMultipartMode;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.MultipartEntityBuilder;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.content.ContentBody;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.content.FileBody;
import com.dataiku.lambda.client.BaseLambdaAPIClient;
import com.dataiku.lambda.model.studioconfig.ApiEndpointQuery;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class APIDeployerClientProxyUser
extends AbstractDeployerClientProxyUser {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.nodeclients.apideployer.proxyuser");

    @Override
    protected String getPublicBaseUrl() {
        return "public/api/api-deployer/";
    }

    @Override
    protected String getPublicPublishedItemUrl(String publishedServiceId) {
        return this.getPublicBaseUrl() + "services/" + publishedServiceId;
    }

    private String getServiceEndpointMonitoringUrl(String apiServiceId, String endpointId) {
        return this.getPublicBaseUrl() + "api-services/" + apiServiceId + "/monitoring/" + endpointId;
    }

    @Override
    AbstractPublishedItemLightStatus.PublishedAPIServiceLightStatus getPublishedItemLightStatus(AbstractDeployment deployment) throws IOException {
        String getLightStatusPath = this.getPublicPublishedItemUrl(deployment.getPublishedItemId());
        return (AbstractPublishedItemLightStatus.PublishedAPIServiceLightStatus)this.getForm(getLightStatusPath, AbstractPublishedItemLightStatus.PublishedAPIServiceLightStatus.class, new Object[0]);
    }

    public APIDeployerClientProxyUser(GeneralSettingsDAO.DeployerRef ref, AuthCtx authCtx) {
        super(ref, authCtx);
    }

    public AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus getDeploymentLightStatus(String deploymentId) throws IOException {
        String path = this.getPublicBaseUrl() + "deployments/" + deploymentId;
        return (AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus)this.getForm(path, AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus.class, new Object[0]);
    }

    public List<AbstractPublishedItemLightStatus.PublishedAPIServiceLightStatus> listPublishedServiceLightStatus() throws IOException {
        JsonArray unparsedLightStatusList = (JsonArray)this.getForm(this.getPublicBaseUrl() + "services", JsonArray.class, new Object[0]);
        return (List)JSON.parse((JsonElement)unparsedLightStatusList, (TypeToken)new TypeToken<List<AbstractPublishedItemLightStatus.PublishedAPIServiceLightStatus>>(){});
    }

    public List<AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus> listDeploymentLightStatus() throws IOException {
        JsonArray unparsedLightStatusList = (JsonArray)this.getForm(this.getPublicBaseUrl() + "deployments", JsonArray.class, new Object[0]);
        return (List)JSON.parse((JsonElement)unparsedLightStatusList, (TypeToken)new TypeToken<List<AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus>>(){});
    }

    public APIServiceEndpointMonitoring getServiceEndpointMonitoring(String apiServiceId, String endpointId) throws IOException {
        JsonObject unparsedServiceEndpointMonitoring = (JsonObject)this.getForm(this.getServiceEndpointMonitoringUrl(apiServiceId, endpointId), JsonObject.class, new Object[0]);
        return (APIServiceEndpointMonitoring)JSON.parse((JsonElement)unparsedServiceEndpointMonitoring, (TypeToken)new TypeToken<APIServiceEndpointMonitoring>(){});
    }

    public AbstractDeployment getDeploymentSettings(String deploymentId) throws IOException {
        JsonObject unparsedDeploymentSettings = (JsonObject)this.getForm(this.getPublicBaseUrl() + "deployments/" + deploymentId + "/settings", JsonObject.class, new Object[0]);
        return (AbstractDeployment)JSON.parse((JsonElement)unparsedDeploymentSettings, (TypeToken)new TypeToken<AbstractDeployment>(){});
    }

    public AbstractDeploymentInfra getDeploymentInfraSettings(String infraId) throws IOException {
        JsonObject unparsedDeploymentInfraSettings = (JsonObject)this.getForm(this.getPublicBaseUrl() + "infras/" + infraId + "/settings", JsonObject.class, new Object[0]);
        return (AbstractDeploymentInfra)JSON.parse((JsonElement)unparsedDeploymentInfraSettings, (TypeToken)new TypeToken<AbstractDeploymentInfra>(){});
    }

    public boolean checkInfraReadAccessPermission(String infraId) throws IOException {
        CheckInfraReadPermissionResponse readPermissionResponse = (CheckInfraReadPermissionResponse)this.getForm(this.getPublicBaseUrl() + "infras/" + infraId + "/check-read-permission", CheckInfraReadPermissionResponse.class, new Object[0]);
        return readPermissionResponse.canRead;
    }

    public APIServiceDeploymentHeavyStatus getDeploymentHeavyStatus(String deploymentId) throws IOException {
        return (APIServiceDeploymentHeavyStatus)this.getForm(this.getPublicBaseUrl() + "deployments/" + deploymentId + "/status", APIServiceDeploymentHeavyStatus.class, new Object[0]);
    }

    public void publishVersion(String serviceId, String versionId, File versionFile) throws IOException {
        logger.infoV("Publish service %s (version: %s) to API deployer", new Object[]{serviceId, versionId});
        FileBody fileBody = new FileBody(versionFile, ContentType.DEFAULT_BINARY);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.addPart("file", (ContentBody)fileBody);
        HttpEntity entity = builder.build();
        this.postAnyToJSON(String.format("%sservices/%s/versions/", this.getPublicBaseUrl(), serviceId), PublishedPackageInfo.class, entity);
    }

    public FutureResponse<? extends DeploymentReport> updateDeployment(String deploymentId, boolean isFullUpdate) throws IOException {
        AbstractInfraBasicInfo infraBasicInfo;
        DeploymentUpdateRequest dur = new DeploymentUpdateRequest();
        if (isFullUpdate) {
            dur.updateMode = SingleStaticDeploymentManager.StaticDeploymentUpdateMode.FULL;
        }
        if ((infraBasicInfo = this.getDeploymentLightStatus((String)deploymentId).infraBasicInfo) instanceof AbstractInfraBasicInfo.StaticAPIDeploymentInfraBasicInfo) {
            return super.updateDeployment(deploymentId, dur, new TypeToken<FutureResponse<SingleStaticDeploymentManager.PrepareAndSyncReport>>(){});
        }
        if (infraBasicInfo instanceof AbstractInfraBasicInfo.AbstractAPIDockerDeploymentInfraBasicInfo) {
            return super.updateDeployment(deploymentId, dur, new TypeToken<FutureResponse<AbstractAPIServiceDockerDeploymentManager.DockerBasedDeploymentReport>>(){});
        }
        throw new IllegalArgumentException("Invalid infra type: " + JSON.getType((Object)infraBasicInfo));
    }

    public BaseLambdaAPIClient.ApiEndpointResponses runQueries(String deploymentId, String endpointId, List<ApiEndpointQuery> queries) throws IOException {
        String url = this.getPublicBaseUrl() + "deployments/" + deploymentId + "/actions/run-queries";
        return (BaseLambdaAPIClient.ApiEndpointResponses)this.postFormToJSON(url, BaseLambdaAPIClient.ApiEndpointResponses.class, new Object[]{"endpointId", endpointId, "queries", JSON.toJsonElement(queries).toString()});
    }

    public List<QueryableEndpoint> listEndpointsQueryableThroughDeployer() throws IOException {
        String url = this.getPublicBaseUrl() + "endpoints-queryable-through-deployer";
        return (List)this.getForm(url, (TypeToken)new TypeToken<List<QueryableEndpoint>>(){}, new Object[0]);
    }

    public QueryableEndpoint getEndpointQueryableThroughDeployer(String deploymentId, String endpointId) throws IOException {
        String url = this.getPublicBaseUrl() + "endpoint-queryable-through-deployer";
        return (QueryableEndpoint)this.getForm(url, (TypeToken)new TypeToken<QueryableEndpoint>(){}, new Object[]{"deploymentId", deploymentId, "endpointId", endpointId});
    }

    @Override
    public String packageIdParameterName() {
        return "version";
    }

    public static class DeploymentUpdateRequest
    extends AbstractDeployerClientProxyUser.DeploymentUpdateRequest {
        public SingleStaticDeploymentManager.StaticDeploymentUpdateMode updateMode = SingleStaticDeploymentManager.StaticDeploymentUpdateMode.LIGHT;
    }
}

