/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.notifications;

import com.dataiku.dip.dataflow.jobrunner.status.EnhancedSerializedJobStatus;
import com.dataiku.dip.export.ExportStatus;
import com.dataiku.dip.notifications.NotificationsRouter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.AuthCtxCreationService;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.notifications.backend.CommitMentionEvent;
import com.dataiku.dip.server.notifications.backend.DiscussionMentionEvent;
import com.dataiku.dip.server.notifications.backend.ExportStateChangedEvent;
import com.dataiku.dip.server.notifications.backend.JobStateChangedEvent;
import com.dataiku.dip.server.notifications.backend.LoginEvent;
import com.dataiku.dip.server.notifications.backend.MLTaskStateChangedEvent;
import com.dataiku.dip.server.notifications.backend.TimelineItemEvent;
import com.dataiku.dip.server.notifications.backend.UserChangedEvent;
import com.dataiku.dip.server.notifications.backend.UserSettingsChangedEvent;
import com.dataiku.dip.server.notifications.offlinequeues.UserOfflineQueueService;
import com.dataiku.dip.server.services.FlowExecutionService2;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TrackingService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserOfflineQueueNotificationsRouter
implements NotificationsRouter {
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private FlowExecutionService2 statusService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private TrackingService trackingService;
    @Autowired
    private UserOfflineQueueService service;
    @Autowired
    private AuthCtxCreationService authCtxCreationService;
    @Autowired
    private UserSettingsService userSettingsService;
    private Map<String, UserSettingsService.UserSettings> userSettings;
    private static Logger logger = Logger.getLogger((String)"dku.notifications.offline");

    private void readUserSettings() {
        try (Transaction t = this.transactionService.beginRead();){
            this.userSettings = this.userSettingsService.getForAllUsers();
        }
        catch (IOException e1) {
            logger.error((Object)"Failed to read user settings", (Throwable)e1);
            this.userSettings = new HashMap<String, UserSettingsService.UserSettings>();
        }
    }

    private UserSettingsService.EmailNotificationsSettings getUserSettings(String user) {
        if (this.userSettings.get(user) != null) {
            return this.userSettings.get((Object)user).offlineQueue;
        }
        return new UserSettingsService.EmailNotificationsSettings();
    }

    @Override
    @PostConstruct
    public void init() {
        logger.debug((Object)"Init offline queues router");
        this.readUserSettings();
        this.pubSub.subscribe("user-settings-changed", (DSSEventListener)new DSSEventListener<UserSettingsChangedEvent>(){

            public void on(UserSettingsChangedEvent evt) {
                UserOfflineQueueNotificationsRouter.this.readUserSettings();
            }
        });
        this.pubSub.subscribe("user-edited", (DSSEventListener)new DSSEventListener<UserChangedEvent>(){

            public void on(UserChangedEvent evt) {
                if (evt.action == UserChangedEvent.ActionType.DELETED) {
                    UserOfflineQueueNotificationsRouter.this.service.deleteForUser(evt.getUserLogin());
                }
                UserOfflineQueueNotificationsRouter.this.readUserSettings();
            }
        });
        this.pubSub.subscribe("login", (DSSEventListener)new DSSEventListener<LoginEvent>(){

            public void on(LoginEvent evt) {
                UserOfflineQueueNotificationsRouter.this.service.flush(evt.getUserLogin());
            }
        });
        DSSEventListener<TimelineItemEvent> timelineEventListener = new DSSEventListener<TimelineItemEvent>(){

            public void on(TimelineItemEvent evt) {
                String initiator = evt.getUserLogin();
                if (!UserOfflineQueueNotificationsRouter.this.getUserSettings((String)initiator).enabled) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("UOQ disabled, ignoring TimelineItemEvent for " + initiator));
                    }
                    return;
                }
                Set connectedUsers = UserOfflineQueueNotificationsRouter.this.trackingService.getConnectedUsers().stream().map(u -> u.login).collect(Collectors.toSet());
                Set<String> interestedUsers = UserOfflineQueueNotificationsRouter.this.interestsService.getEffectiveWatchingUsers_NT(evt.item.objectType, evt.item.projectKey, evt.item.objectId, initiator, evt.item.workspaceKey);
                for (String user : interestedUsers) {
                    if (connectedUsers.contains(user)) continue;
                    UserOfflineQueueNotificationsRouter.this.service.push(user, evt);
                }
            }
        };
        this.pubSub.subscribe("timeline-item", (DSSEventListener)timelineEventListener);
        this.pubSub.subscribe("discussion-mention", (DSSEventListener)new DSSEventListener<DiscussionMentionEvent>(){

            public void on(DiscussionMentionEvent evt) {
                UserOfflineQueueNotificationsRouter.this.service.push(evt.mentionedUser, evt);
            }
        });
        this.pubSub.subscribe("commit-mention", (DSSEventListener)new DSSEventListener<CommitMentionEvent>(){

            public void on(CommitMentionEvent evt) {
                UserOfflineQueueNotificationsRouter.this.service.push(evt.mentionedUser, evt);
            }
        });
        this.pubSub.subscribe("job-state-change", (DSSEventListener)new DSSEventListener<JobStateChangedEvent>(){

            public void on(JobStateChangedEvent evt) {
                String initiator = evt.getUserLogin();
                if (!UserOfflineQueueNotificationsRouter.this.getUserSettings((String)initiator).enabled) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("UOQ disabled, ignoring JobStateChangedEvent for " + initiator));
                    }
                    return;
                }
                try {
                    EnhancedSerializedJobStatus status = UserOfflineQueueNotificationsRouter.this.statusService.getStatus_NT(evt.projectKey, evt.jobId);
                    try (Transaction t = UserOfflineQueueNotificationsRouter.this.transactionService.beginRead();){
                        UserOfflineQueueNotificationsRouter.this.statusService.addInitiator(status);
                        String initiatorLogin = status.baseStatus.def.initiator;
                        switch (evt.state) {
                            case PAUSED: 
                            case COMPUTING_DEPS: 
                            case PENDING: 
                            case NOT_STARTED: 
                            case STARTING: 
                            case RUNNING: 
                            case WAITING_CONFIRMATION: {
                                return;
                            }
                        }
                        AuthCtx u = UserOfflineQueueNotificationsRouter.this.authCtxCreationService.createOrNull(initiatorLogin);
                        if (u == null || u.getAssociatedDSSUser() == null) {
                            return;
                        }
                        UserOfflineQueueNotificationsRouter.this.service.push(initiatorLogin, evt);
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)"Failed to store job notifications", (Throwable)e);
                }
            }
        });
        this.pubSub.subscribe("export-state-change", (DSSEventListener)new DSSEventListener<ExportStateChangedEvent>(){

            public void on(ExportStateChangedEvent evt) {
                String initiator = evt.getUserLogin();
                if (!UserOfflineQueueNotificationsRouter.this.getUserSettings((String)initiator).enabled) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("UOQ disabled, ignoring ExportStateChangedEvent for " + initiator));
                    }
                    return;
                }
                ExportStatus status = evt.status;
                try (Transaction t = UserOfflineQueueNotificationsRouter.this.transactionService.beginRead();){
                    AuthCtx u = UserOfflineQueueNotificationsRouter.this.authCtxCreationService.createOrNull(initiator);
                    if (u == null || u.getAssociatedDSSUser() == null) {
                        return;
                    }
                }
                switch (status.state) {
                    case PAUSED: 
                    case RUNNING: 
                    case ABORTED: {
                        return;
                    }
                }
                UserOfflineQueueNotificationsRouter.this.service.push(initiator, evt);
            }
        });
        this.pubSub.subscribe("mltask-state-change", (DSSEventListener)new DSSEventListener<MLTaskStateChangedEvent>(){

            public void on(MLTaskStateChangedEvent evt) {
                String initiator = evt.getUserLogin();
                if (!UserOfflineQueueNotificationsRouter.this.getUserSettings((String)initiator).enabled) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("UOQ disabled, ignoring MLTaskStateChangedEvent for " + initiator));
                    }
                    return;
                }
                try (Transaction t = UserOfflineQueueNotificationsRouter.this.transactionService.beginRead();){
                    AuthCtx u = UserOfflineQueueNotificationsRouter.this.authCtxCreationService.createOrNull(initiator);
                    if (u == null || u.getAssociatedDSSUser() == null) {
                        return;
                    }
                    if (evt.isRunning) {
                        return;
                    }
                    UserOfflineQueueNotificationsRouter.this.service.push(initiator, evt);
                }
                catch (Exception e) {
                    logger.warn((Object)"Failed to store mlTask event notification", (Throwable)e);
                }
            }
        });
        logger.debug((Object)"Done init offline queues router");
    }
}

