/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.frontend.excel.xssf;

import com.dataiku.dip.pivot.backend.dss.DataTensor;
import com.dataiku.dip.pivot.backend.model.AxisElt;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorResponse;
import com.dataiku.dip.pivot.backend.model.SideResponseKey;
import com.dataiku.dip.pivot.frontend.color.Color;
import com.dataiku.dip.pivot.frontend.excel.CellStyler;
import com.dataiku.dip.pivot.frontend.excel.xssf.ChartSources;
import com.dataiku.dip.pivot.frontend.excel.xssf.ChartTextSource;
import com.dataiku.dip.pivot.frontend.excel.xssf.SheetUtils;
import com.dataiku.dip.pivot.frontend.model.ChartDef;
import com.dataiku.dip.pivot.frontend.model.DimensionDef;
import com.dataiku.dip.pivot.frontend.model.DisplayAxis;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.CellStyle;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Workbook;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.util.CellRangeAddress;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.PresetLineDash;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.XDDFColor;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.XDDFFillProperties;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.XDDFLineProperties;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.XDDFPresetLineDash;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.XDDFShapeProperties;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.XDDFSolidFillProperties;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.AxisPosition;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.ChartTypes;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.MarkerStyle;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFCategoryAxis;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFCategoryDataSource;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFChart;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFChartAxis;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFChartLegend;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFLegendEntry;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFLineChartData;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFValueAxis;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFChart;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFSheet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBoolean;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTChartSpace;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumData;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumRef;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumVal;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTSerTx;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTStrData;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTStrRef;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTStrVal;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTStyle;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTTitle;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTTx;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;

public class ChartUtils {
    private static byte[] WHITE = new byte[]{-1, -1, -1};
    private static final Logger logger = Logger.getLogger((String)"dku.charts.utils");

    public static void crossAxes(XDDFChartAxis ax1, XDDFChartAxis ax2) {
        ax1.crossAxis(ax2);
        ax2.crossAxis(ax1);
    }

    public static void buildAxDataSource(CTAxDataSource ctAxDataSource, XDDFDataSource<?> dataSource) {
        if (dataSource.isNumeric()) {
            if (dataSource.isReference()) {
                ChartUtils.buildNumRef(ctAxDataSource.addNewNumRef(), dataSource);
            } else {
                ChartUtils.buildNumLit(ctAxDataSource.addNewNumLit(), dataSource);
            }
        } else if (dataSource.isReference()) {
            ChartUtils.buildStrRef(ctAxDataSource.addNewStrRef(), dataSource);
        } else {
            ChartUtils.buildStrLit(ctAxDataSource.addNewStrLit(), dataSource);
        }
    }

    private static void buildNumRef(CTNumRef ctNumRef, XDDFDataSource<?> dataSource) {
        ctNumRef.setF(dataSource.getFormula());
        CTNumData cache = ctNumRef.addNewNumCache();
        ChartUtils.fillNumCache(cache, dataSource);
    }

    private static void buildNumLit(CTNumData ctNumData, XDDFDataSource<?> dataSource) {
        ChartUtils.fillNumCache(ctNumData, dataSource);
    }

    private static void buildStrRef(CTStrRef ctStrRef, XDDFDataSource<?> dataSource) {
        ctStrRef.setF(dataSource.getFormula());
        CTStrData cache = ctStrRef.addNewStrCache();
        ChartUtils.fillStringCache(cache, dataSource);
    }

    private static void buildStrLit(CTStrData ctStrData, XDDFDataSource<?> dataSource) {
        ChartUtils.fillStringCache(ctStrData, dataSource);
    }

    private static void fillNumCache(CTNumData cache, XDDFDataSource<?> dataSource) {
        int numOfPoints = dataSource.getPointCount();
        cache.addNewPtCount().setVal((long)numOfPoints);
        for (int i = 0; i < numOfPoints; ++i) {
            Number value = (Number)dataSource.getPointAt(i);
            if (value == null) continue;
            CTNumVal ctNumVal = cache.addNewPt();
            ctNumVal.setIdx((long)i);
            ctNumVal.setV(value.toString());
        }
    }

    private static void fillStringCache(CTStrData cache, XDDFDataSource<?> dataSource) {
        int numOfPoints = dataSource.getPointCount();
        cache.addNewPtCount().setVal((long)numOfPoints);
        for (int i = 0; i < numOfPoints; ++i) {
            Object value = dataSource.getPointAt(i);
            if (value == null) continue;
            CTStrVal ctStrVal = cache.addNewPt();
            ctStrVal.setIdx((long)i);
            ctStrVal.setV(value.toString());
        }
    }

    public static void buildNumDataSource(CTNumDataSource ctNumDataSource, XDDFDataSource<? extends Number> dataSource) {
        if (dataSource.isReference()) {
            ChartUtils.buildNumRef(ctNumDataSource.addNewNumRef(), dataSource);
        } else {
            ChartUtils.buildNumLit(ctNumDataSource.addNewNumLit(), dataSource);
        }
    }

    public static void buildSerTx(CTSerTx ctSerTx, ChartTextSource textSource) {
        if (textSource.isReference()) {
            ChartUtils.buildStrRef(ctSerTx.addNewStrRef(), textSource);
        } else {
            ctSerTx.setV(textSource.getTextString());
        }
    }

    public static void buildStrRef(CTStrRef ctStrRef, String text) {
        ChartUtils.buildStrRef(ctStrRef, text, text);
    }

    public static void buildStrRef(CTStrRef ctStrRef, ChartTextSource textSource) {
        ChartUtils.buildStrRef(ctStrRef, textSource.getFormulaString(), textSource.getTextString());
    }

    private static void buildStrRef(CTStrRef ctStrRef, String text, String cacheText) {
        ctStrRef.setF(text);
        CTStrData cache = ctStrRef.addNewStrCache();
        ChartUtils.fillStringCache(cache, cacheText);
    }

    private static void fillStringCache(CTStrData cache, String text) {
        cache.addNewPtCount().setVal(1L);
        CTStrVal ctStrVal = cache.addNewPt();
        ctStrVal.setIdx(0L);
        ctStrVal.setV(text);
    }

    public static XSSFChart createChart(XSSFSheet sheet) {
        XSSFClientAnchor anchor = new XSSFClientAnchor(0, 0, 100, 100, 0, 0, 14, 26);
        XSSFChart chart = sheet.createDrawingPatriarch().createChart(anchor);
        CTChartSpace chartSpace = chart.getCTChartSpace();
        CTBoolean roundedCorner = chartSpace.isSetRoundedCorners() ? chartSpace.getRoundedCorners() : chartSpace.addNewRoundedCorners();
        roundedCorner.setVal(false);
        CTStyle style = chartSpace.isSetStyle() ? chartSpace.getStyle() : chartSpace.addNewStyle();
        style.setVal((short)2);
        CTShapeProperties spPr = chartSpace.isSetSpPr() ? chartSpace.getSpPr() : chartSpace.addNewSpPr();
        CTSolidColorFillProperties solidFill = spPr.addNewSolidFill();
        solidFill.addNewSrgbClr().setVal(WHITE);
        return chart;
    }

    public static void setChartTitle(XSSFChart chart, ChartTextSource titleSource) {
        CTChart ctChart = chart.getCTChart();
        if (ctChart.isSetTitle()) {
            ctChart.unsetTitle();
        }
        CTTitle ctTitle = ctChart.addNewTitle();
        CTTx ctTx = ctTitle.addNewTx();
        if (!titleSource.isReference()) {
            throw new NotImplementedException();
        }
        CTStrRef ctStrRef = ctTx.addNewStrRef();
        ctStrRef.setF(titleSource.getFormulaString());
        ChartUtils.buildStrRef(ctStrRef, titleSource);
    }

    public static void dropLegendEntry(XDDFChartLegend legend, long entryIndex) {
        XDDFLegendEntry entry = legend.addEntry();
        entry.setDelete(Boolean.valueOf(true));
        entry.setIndex(entryIndex);
    }

    public static byte[] computeDualColor(byte[] col) {
        return new byte[]{ChartUtils.computeDualComp(col[0]), ChartUtils.computeDualComp(col[1]), ChartUtils.computeDualComp(col[2])};
    }

    private static byte computeDualComp(int b) {
        return (byte)(b + 127);
    }

    public static byte[] computeDarkenColor(byte[] col) {
        return new byte[]{ChartUtils.computeDarkenComp(col[0]), ChartUtils.computeDarkenComp(col[1]), ChartUtils.computeDarkenComp(col[2])};
    }

    private static byte computeDarkenComp(byte b) {
        return (byte)((b + 256) % 256 / 2);
    }

    public static void setOverlay(XDDFChartLegend legend, boolean val) {
        legend.setOverlay(val);
    }

    public static String labelify(String label) {
        if (StringUtils.equals((String)label, (String)"___dku_no_value___")) {
            return "No value";
        }
        if (StringUtils.equals((String)label, (String)"___dku_others_value___")) {
            label = "Others";
        }
        return label;
    }

    private static void appendReferenceLines(PivotTableTensorResponse response, XSSFSheet sheet, ChartDef.ReferenceLine[] referenceLines, Map<ChartDef.ReferenceLineAxis, Boolean> availableAxes) {
        CellStyler styler = new CellStyler((Workbook)sheet.getWorkbook());
        CellStyle titleStyle = styler.getTitleStyle();
        CellStyle subTitleStyle = styler.getSubtitleStyle();
        CellStyle headerStyle = styler.getHeaderStyle();
        int rowIdx = sheet.getLastRowNum() + 2;
        int referenceLinePos = 1;
        int sideResponseIndex = 0;
        for (ChartDef.ReferenceLine referenceLine : referenceLines) {
            double value;
            boolean isAxisAvailable = availableAxes.getOrDefault((Object)referenceLine.axis.type, false);
            if (!isAxisAvailable) continue;
            if (referenceLine.sourceType == ChartDef.ValueType.Constant) {
                value = referenceLine.constantValue;
            } else {
                if (referenceLine.sourceType == ChartDef.ValueType.AggregatedColumn) {
                    throw new NotImplementedException("Cannot export a chart with a \"Displayed Aggregation\" reference line.");
                }
                List sideResponses = (List)response.sideResponses.get((Object)SideResponseKey.REFERENCE_LINES);
                if (sideResponses != null && sideResponses.size() >= 1) {
                    value = ((DataTensor)((PivotTableTensorResponse)((List)response.sideResponses.get((Object)((Object)SideResponseKey.REFERENCE_LINES))).get((int)0)).aggregations.get(sideResponseIndex++)).getAsDouble(0);
                } else {
                    logger.warn((Object)"Skipping the reference line drawing, something is missing in the request");
                    continue;
                }
            }
            SheetUtils.writeCell(sheet, rowIdx, referenceLinePos, "Reference line " + referenceLinePos).setCellStyle(subTitleStyle);
            for (int j = 0; j < response.axisLabels[0].size(); ++j) {
                SheetUtils.writeCell(sheet, rowIdx + j + 1, referenceLinePos, value);
            }
            ++referenceLinePos;
        }
        if (referenceLinePos > 1) {
            SheetUtils.writeCell(sheet, rowIdx, 0, "Reference lines").setCellStyle(titleStyle);
            for (int j = 0; j < response.axisLabels[0].size(); ++j) {
                AxisElt xLabel = response.axisLabels[0].get(j);
                String label = ChartUtils.labelify(xLabel.label);
                SheetUtils.writeCell(sheet, rowIdx + j + 1, 0, label).setCellStyle(headerStyle);
            }
        }
    }

    private static void drawGridLine(XDDFShapeProperties gridProperties, ChartDef.GridlinesOption gridlinesOption) {
        String color = StringUtils.isNotBlank((String)gridlinesOption.lineFormatting.color) ? gridlinesOption.lineFormatting.color : "D9D9D9";
        XDDFLineProperties lineProperties = new XDDFLineProperties();
        lineProperties.setWidth(Double.valueOf(gridlinesOption.lineFormatting.size));
        if (ChartDef.ChartLineType.DASHED.equals((Object)gridlinesOption.lineFormatting.type)) {
            lineProperties.setPresetDash(new XDDFPresetLineDash(PresetLineDash.DASH));
        }
        lineProperties.setFillProperties((XDDFFillProperties)new XDDFSolidFillProperties(XDDFColor.from((byte[])Color.fromHTML(color).asByteArray())));
        gridProperties.setLineProperties(lineProperties);
    }

    public static void drawGridLines(XDDFChart poiChart, ChartDef chartDef) {
        XDDFShapeProperties gridProperties;
        XDDFCategoryAxis bottomAxis = null;
        XDDFValueAxis leftAxis = null;
        XDDFValueAxis rightAxis = null;
        XDDFCategoryAxis rightBottomAxis = null;
        List axes = poiChart.getAxes();
        for (XDDFChartAxis axis : axes) {
            if (bottomAxis == null && AxisPosition.BOTTOM.equals((Object)axis.getPosition()) && axis.isVisible()) {
                bottomAxis = (XDDFCategoryAxis)axis;
            }
            if (rightBottomAxis == null && AxisPosition.BOTTOM.equals((Object)axis.getPosition()) && !axis.isVisible()) {
                rightBottomAxis = (XDDFCategoryAxis)axis;
            }
            if (leftAxis == null && AxisPosition.LEFT.equals((Object)axis.getPosition())) {
                leftAxis = (XDDFValueAxis)axis;
            }
            if (rightAxis != null || !AxisPosition.RIGHT.equals((Object)axis.getPosition())) continue;
            rightAxis = (XDDFValueAxis)axis;
        }
        if (chartDef.gridlinesOptions != null && chartDef.gridlinesOptions.horizontal != null && chartDef.gridlinesOptions.horizontal.show && chartDef.gridlinesOptions.horizontal.lineFormatting != null && chartDef.gridlinesOptions.horizontal.displayAxis != null) {
            if ((chartDef.gridlinesOptions.horizontal.displayAxis.type == ChartDef.GridlinesAxisType.LEFT_Y_AXIS || chartDef.gridlinesOptions.horizontal.displayAxis.type == ChartDef.GridlinesAxisType.LEFT_AND_RIGHT_Y_AXIS) && leftAxis != null) {
                gridProperties = leftAxis.getOrAddMajorGridProperties();
                ChartUtils.drawGridLine(gridProperties, chartDef.gridlinesOptions.horizontal);
            }
            if ((chartDef.gridlinesOptions.horizontal.displayAxis.type == ChartDef.GridlinesAxisType.RIGHT_Y_AXIS || chartDef.gridlinesOptions.horizontal.displayAxis.type == ChartDef.GridlinesAxisType.LEFT_AND_RIGHT_Y_AXIS) && rightAxis != null) {
                gridProperties = rightAxis.getOrAddMajorGridProperties();
                ChartUtils.drawGridLine(gridProperties, chartDef.gridlinesOptions.horizontal);
            }
        }
        if (chartDef.gridlinesOptions != null && chartDef.gridlinesOptions.vertical != null && chartDef.gridlinesOptions.vertical.show && chartDef.gridlinesOptions.vertical.lineFormatting != null && (bottomAxis != null || rightBottomAxis != null)) {
            gridProperties = (bottomAxis != null ? bottomAxis : rightBottomAxis).getOrAddMajorGridProperties();
            ChartUtils.drawGridLine(gridProperties, chartDef.gridlinesOptions.vertical);
        }
    }

    public static int drawReferenceLines(PivotTableTensorResponse response, XSSFSheet dataSheet, XDDFChart poiChart, ChartDef chartDef) {
        int drawnReferenceLines = 0;
        ChartDef.ReferenceLine[] referenceLines = chartDef.referenceLines;
        if (referenceLines == null || referenceLines.length == 0) {
            return 0;
        }
        HashMap<ChartDef.ReferenceLineAxis, Boolean> availableAxes = new HashMap<ChartDef.ReferenceLineAxis, Boolean>();
        availableAxes.put(ChartDef.ReferenceLineAxis.LEFT_Y_AXIS, false);
        availableAxes.put(ChartDef.ReferenceLineAxis.RIGHT_Y_AXIS, false);
        chartDef.genericMeasures.forEach(genericMeasure -> {
            if (genericMeasure.displayAxis == DisplayAxis.axis1) {
                availableAxes.put(ChartDef.ReferenceLineAxis.LEFT_Y_AXIS, true);
            }
            if (genericMeasure.displayAxis == DisplayAxis.axis2) {
                availableAxes.put(ChartDef.ReferenceLineAxis.RIGHT_Y_AXIS, true);
            }
        });
        ChartUtils.appendReferenceLines(response, dataSheet, referenceLines, availableAxes);
        XDDFCategoryAxis bottomAxis = null;
        XDDFValueAxis leftAxis = null;
        XDDFValueAxis rightAxis = null;
        XDDFCategoryAxis rightBottomAxis = null;
        List axes = poiChart.getAxes();
        for (XDDFChartAxis axis : axes) {
            if (bottomAxis == null && AxisPosition.BOTTOM.equals((Object)axis.getPosition()) && axis.isVisible()) {
                bottomAxis = (XDDFCategoryAxis)axis;
            }
            if (rightBottomAxis == null && AxisPosition.BOTTOM.equals((Object)axis.getPosition()) && !axis.isVisible()) {
                rightBottomAxis = (XDDFCategoryAxis)axis;
            }
            if (leftAxis == null && AxisPosition.LEFT.equals((Object)axis.getPosition())) {
                leftAxis = (XDDFValueAxis)axis;
            }
            if (rightAxis != null || !AxisPosition.RIGHT.equals((Object)axis.getPosition())) continue;
            rightAxis = (XDDFValueAxis)axis;
        }
        XDDFLineChartData lineChartData = null;
        if (((Boolean)availableAxes.get((Object)ChartDef.ReferenceLineAxis.LEFT_Y_AXIS)).booleanValue()) {
            lineChartData = (XDDFLineChartData)poiChart.createData(ChartTypes.LINE, bottomAxis, leftAxis);
        }
        XDDFLineChartData secondlineChartData = null;
        if (((Boolean)availableAxes.get((Object)ChartDef.ReferenceLineAxis.RIGHT_Y_AXIS)).booleanValue()) {
            secondlineChartData = (XDDFLineChartData)poiChart.createData(ChartTypes.LINE, (XDDFChartAxis)rightBottomAxis, rightAxis);
        }
        int referenceLinesRowStartIdx = dataSheet.getLastRowNum() - response.axisLabels[0].size();
        int referenceLinePos = 1;
        for (ChartDef.ReferenceLine referenceLine : referenceLines) {
            boolean isAxisAvailable = availableAxes.getOrDefault((Object)referenceLine.axis.type, false);
            if (!isAxisAvailable) continue;
            ChartTextSource title = ChartSources.fromCellRange(dataSheet, new CellRangeAddress(referenceLinesRowStartIdx, referenceLinesRowStartIdx, referenceLinePos, referenceLinePos));
            XDDFNumericalDataSource value = XDDFDataSourcesFactory.fromNumericCellRange((XSSFSheet)dataSheet, (CellRangeAddress)new CellRangeAddress(referenceLinesRowStartIdx + 1, referenceLinesRowStartIdx + response.axisLabels[0].size(), referenceLinePos, referenceLinePos));
            XDDFCategoryDataSource labels = XDDFDataSourcesFactory.fromStringCellRange((XSSFSheet)dataSheet, (CellRangeAddress)new CellRangeAddress(referenceLinesRowStartIdx + 1, referenceLinesRowStartIdx + response.axisLabels[0].size(), 0, 0));
            XDDFLineChartData.Series series = (XDDFLineChartData.Series)(referenceLine.axis.type == ChartDef.ReferenceLineAxis.RIGHT_Y_AXIS ? secondlineChartData : lineChartData).addSeries((XDDFDataSource)labels, value);
            series.setTitle(title.getTextString(), null);
            series.setMarkerStyle(MarkerStyle.NONE);
            series.setSmooth(Boolean.valueOf(true));
            int lineSize = referenceLine.lineFormatting != null ? referenceLine.lineFormatting.size : 1;
            String lineColor = referenceLine.lineFormatting != null && referenceLine.lineFormatting.color != null ? referenceLine.lineFormatting.color : "#000";
            ChartDef.ChartLineType lineType = referenceLine.lineFormatting != null && referenceLine.lineFormatting.type != null ? referenceLine.lineFormatting.type : ChartDef.ChartLineType.FILLED;
            XDDFShapeProperties shapeProperties = new XDDFShapeProperties();
            XDDFLineProperties lineProperties = new XDDFLineProperties();
            XDDFSolidFillProperties fillProperties = new XDDFSolidFillProperties();
            fillProperties.setColor(XDDFColor.from((byte[])Color.fromHTML(lineColor).asByteArray()));
            lineProperties.setFillProperties((XDDFFillProperties)fillProperties);
            if (lineType.equals((Object)ChartDef.ChartLineType.DASHED)) {
                lineProperties.setPresetDash(new XDDFPresetLineDash(PresetLineDash.DASH));
            }
            lineProperties.setWidth(Double.valueOf(lineSize));
            shapeProperties.setLineProperties(lineProperties);
            series.setShapeProperties(shapeProperties);
            ++referenceLinePos;
            ++drawnReferenceLines;
        }
        if (lineChartData != null) {
            poiChart.plot((XDDFChartData)lineChartData);
        }
        if (secondlineChartData != null) {
            poiChart.plot((XDDFChartData)secondlineChartData);
        }
        return drawnReferenceLines;
    }

    public static DimensionDef getGenericDimension(ChartDef chartDef) {
        if (!chartDef.genericHierarchyDimension.isEmpty()) {
            return chartDef.genericHierarchyDimension.get(0).getCurrentDimension();
        }
        return chartDef.genericDimension0.get(0);
    }

    public static List<DimensionDef> getXDimensions(ChartDef chartDef) {
        if (!chartDef.xHierarchyDimension.isEmpty()) {
            return List.of(chartDef.xHierarchyDimension.get(0).getCurrentDimension());
        }
        return chartDef.xDimension;
    }

    public static List<DimensionDef> getYDimensions(ChartDef chartDef) {
        if (!chartDef.yHierarchyDimension.isEmpty()) {
            return List.of(chartDef.yHierarchyDimension.get(0).getCurrentDimension());
        }
        return chartDef.yDimension;
    }

    public static DimensionDef getGroupDimension(ChartDef chartDef) {
        if (!chartDef.groupHierarchyDimension.isEmpty()) {
            return chartDef.groupHierarchyDimension.get(0).getCurrentDimension();
        }
        return chartDef.groupDimension.get(0);
    }
}

