/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projects.importexport;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.code.AutomationNodeCodeEnvsService;
import com.dataiku.dip.code.AutomationNodeManagedEnvUtils;
import com.dataiku.dip.code.CodeEnvCodes;
import com.dataiku.dip.code.CodeEnvImportUtils;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvUtilsBase;
import com.dataiku.dip.code.DSSInternalCodeEnvsService;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.projects.importexport.BundleCodes;
import com.dataiku.dip.projects.importexport.ExportedProject;
import com.dataiku.dip.projects.importexport.model.BundleContainerSettings;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class BundlePreloader {
    @Autowired
    private AutomationNodeCodeEnvsService codeEnvsService;
    @Autowired
    protected TransactionService transactionService;
    @Autowired
    protected IPermissionsService permissionsService;
    private final AuthCtx authCtx;
    private final String projectKey;
    private final File bundlePath;
    private final DKUtils.SmartLogTailBuilder logTailBuilder;
    private final BundleContainerSettings containerSettings;
    private ExportedProject ep;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.projects.bundleimport.preload");

    public BundlePreloader(AuthCtx authCtx, BundleContainerSettings containerSettings, File bundlePath, String projectKey, DKUtils.SmartLogTailBuilder logTailBuilder) {
        this.authCtx = authCtx;
        this.containerSettings = containerSettings;
        this.projectKey = projectKey;
        this.bundlePath = bundlePath;
        this.logTailBuilder = logTailBuilder;
        SpringUtils.getInstance().autowire((Object)this);
    }

    private File bundleFile(String ... pathChunks) {
        return new File(this.bundlePath, StringUtils.join((Object[])pathChunks, (String)"/"));
    }

    public BundlePreloadingReport run() throws Exception {
        BundlePreloadingReport ret = new BundlePreloadingReport();
        this.ep = (ExportedProject)JSON.parseFile((File)this.bundleFile("export-manifest.json"), ExportedProject.class);
        for (CodeEnvModel.UsedCodeEnvRef envRef : this.ep.usedCodeEnvRefs) {
            this.handleCodeEnv(envRef.envLang, envRef.envName, ret);
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleCodeEnv(CodeEnvModel.EnvLang envLang, String envName, BundlePreloadingReport ret) throws Exception {
        try (ErrorContext.ACNDC acndc = ErrorContext.pushWithNDC((String)("preload-env-" + String.valueOf((Object)envLang) + "-" + envName));){
            CodeEnvModel.AbstractEnvDesc exportedDesc;
            logger.infoV("Preloading code env: %s %s", new Object[]{envLang, envName});
            File exportedEnvDir = envLang == CodeEnvModel.EnvLang.PYTHON ? this.bundleFile("python-envs", envName) : this.bundleFile("r-envs", envName);
            File exportedDescFile = new File(exportedEnvDir, "desc.json");
            if (!exportedDescFile.exists()) {
                logger.warn((Object)"Exported env has no description, using empty");
                exportedDesc = envLang == CodeEnvModel.EnvLang.PYTHON ? new CodeEnvModel.PythonEnvDesc() : new CodeEnvModel.REnvDesc();
            } else {
                exportedDesc = envLang == CodeEnvModel.EnvLang.PYTHON ? (CodeEnvModel.AbstractEnvDesc)JSON.parseFile((File)exportedDescFile, CodeEnvModel.PythonEnvDesc.class) : (CodeEnvModel.AbstractEnvDesc)JSON.parseFile((File)exportedDescFile, CodeEnvModel.REnvDesc.class);
            }
            boolean hasActualSpec = new File(exportedEnvDir, "actual").exists();
            boolean hasSpecifiedSpec = new File(exportedEnvDir, "spec").exists();
            CodeEnvModel.AutomationEnvRootDef envRootDef = this.codeEnvsService.getEnvRootDefOrNull(envLang, envName);
            File log = ApplicationConfigurator.getFile((File)this.codeEnvsService.getEnvLogsDir(envLang, envName), (String[])new String[]{"handleCodeEnv.log"});
            DKUFileUtils.mkdirsParent((File)log);
            if (envRootDef != null && envRootDef.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_VERSIONED) {
                logger.info((Object)"Env already exists in AUTOMATION_VERSIONED mode, checking for bundle link");
                CodeEnvModel.EnvVersionRef evr = AutomationNodeManagedEnvUtils.getNamedBundleLink(envLang, envName, this.projectKey, this.ep.bundleId);
                if (evr != null) {
                    logger.infoV("Found existing link " + JSON.json((Object)evr), new Object[0]);
                    return;
                }
            }
            if (this.containerSettings == null) return;
            if (this.containerSettings.codeEnvsBehavior == null) return;
            if (this.containerSettings.codeEnvsBehavior.importTimeMode == null) {
                return;
            }
            switch (this.containerSettings.codeEnvsBehavior.importTimeMode) {
                case DO_NOTHING: {
                    logger.infoV("Do nothing mode, doing nothing", new Object[]{envName});
                    return;
                }
                case FAIL_IF_MISS: {
                    if (envRootDef == null) {
                        logger.infoV("Env does not exist at all, failing", new Object[0]);
                        ret.withFatalV(BundleCodes.ERR_BUNDLE_PRELOAD_NO_MATCHING_PYENV, "No matching environment for code env " + envName, new Object[0]);
                        return;
                    }
                    this.handleCodeEnvFailIfDifferent(envLang, envName, ret, exportedEnvDir, envRootDef, log);
                    return;
                }
                case INSTALL_IF_MISS: {
                    if (envRootDef == null) {
                        envRootDef = this.createMissingCodeEnv(envLang, envName, ret, exportedDesc, hasActualSpec, hasSpecifiedSpec, log);
                    }
                    this.handleCodeEnvUpdateIfDifferent(envLang, envName, exportedEnvDir, envRootDef, log, ret);
                    return;
                }
            }
            return;
        }
    }

    private CodeEnvModel.AutomationEnvRootDef createMissingCodeEnv(CodeEnvModel.EnvLang envLang, String envName, BundlePreloadingReport ret, CodeEnvModel.AbstractEnvDesc exportedDesc, boolean hasActualSpec, boolean hasSpecifiedSpec, File log) throws Exception {
        if (!((DSSAuthCtx)this.authCtx).getPermissions().mayCreateCodeEnvs()) {
            throw new SecurityException("You may not create new code envs");
        }
        CodeEnvModel.CodeEnvDeploymentMode creationMode = exportedDesc.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.DSS_INTERNAL ? CodeEnvModel.CodeEnvDeploymentMode.DSS_INTERNAL : (exportedDesc.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.DESIGN_NON_MANAGED ? CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_NON_MANAGED_PATH : (exportedDesc.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.EXTERNAL_CONDA_NAMED ? CodeEnvModel.CodeEnvDeploymentMode.EXTERNAL_CONDA_NAMED : (!hasActualSpec && !hasSpecifiedSpec ? CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_NON_MANAGED_PATH : CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_VERSIONED)));
        logger.infoV("Env does not exist at all, will create it in " + String.valueOf((Object)creationMode) + " mode", new Object[0]);
        CodeEnvModel.AutomationEnvRootDef envRootDef = new CodeEnvModel.AutomationEnvRootDef();
        envRootDef.deploymentMode = creationMode;
        envRootDef.owner = this.authCtx.getAssociatedDSSUserOrIdentifier();
        envRootDef.usableByAll = true;
        CodeEnvModel.AutomationNewEnvSpec anpes = new CodeEnvModel.AutomationNewEnvSpec();
        anpes.deploymentMode = creationMode;
        anpes.envLang = envLang;
        anpes.envName = envName;
        anpes.owner = this.authCtx.getIdentifier();
        if (envLang == CodeEnvModel.EnvLang.PYTHON && ((CodeEnvModel.PythonEnvDesc)exportedDesc).installJupyterSupport) {
            anpes.installJupyterSupport = true;
        } else if (envLang == CodeEnvModel.EnvLang.R && ((CodeEnvModel.REnvDesc)exportedDesc).installJupyterSupport) {
            anpes.installJupyterSupport = true;
        }
        this.codeEnvsService.createEnv(this.authCtx, anpes, exportedDesc.externalCondaEnvName, this.logTailBuilder, log, ret);
        return envRootDef;
    }

    private void checkEnvUpdatePrivilege(CodeEnvModel.EnvLang envLang, String envName) throws DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            this.permissionsService.checkCodeEnvPrivileges(this.authCtx, envLang, envName, Privileges.CodeEnvLevelPrivilegeType.UPDATE);
        }
    }

    private CodeEnvModel.EnvVersionRef handleCodeEnvUpdateIfDifferent(CodeEnvModel.EnvLang envLang, String envName, File exportedEnvDir, CodeEnvModel.AutomationEnvRootDef envRootDef, File log, BundlePreloadingReport ret) throws Exception {
        switch (envRootDef.deploymentMode) {
            case AUTOMATION_NON_MANAGED_PATH: 
            case EXTERNAL_CONDA_NAMED: 
            case PLUGIN_NON_MANAGED: 
            case PLUGIN_MANAGED: {
                logger.infoV("Env is not managed, assuming everything ok", new Object[0]);
                break;
            }
            case DSS_INTERNAL: {
                boolean useReferenceSpec = false;
                if (this.containerSettings.codeEnvsBehavior.envImportSpecificationMode == CodeEnvModel.EnvImportSpecificationMode.SPECIFIED && envLang == CodeEnvModel.EnvLang.PYTHON) {
                    CodeEnvModel.PythonEnvDesc exportedEnvDesc = (CodeEnvModel.PythonEnvDesc)JSON.parseFile((File)new File(exportedEnvDir, "desc.json"), CodeEnvModel.PythonEnvDesc.class);
                    useReferenceSpec = exportedEnvDesc.useReferenceSpec();
                }
                try (AutoDelete fixedExportedEnvDir = CodeEnvImportUtils.getTempImportFolder("import-from-bundle-dss-internal-" + exportedEnvDir.getName());){
                    File envRootDir;
                    File readyFile;
                    boolean existingCodeEnvReady;
                    DKUFileUtils.copyDirectory((File)exportedEnvDir, (File)fixedExportedEnvDir);
                    if (useReferenceSpec) {
                        this.logTailBuilder.appendLine("Fixing exported internal code environment spec from DSS internal resources ...");
                        CodeEnvUtilsBase.addLogHeader(this.authCtx, log, "fix exported internal code env spec", "");
                        File referenceSpecFolder = DSSInternalCodeEnvsService.DSSInternalCodeEnv.fromName(envName).getResourceSpecFolder();
                        this.codeEnvsService.importSpecToDirectory(CodeEnvModel.EnvLang.PYTHON, (File)fixedExportedEnvDir, referenceSpecFolder, true);
                    }
                    if (existingCodeEnvReady = (readyFile = new File(envRootDir = AutomationNodeManagedEnvUtils.getEnvDir(envLang, envName), "ready.txt")).isFile()) {
                        logger.infoV("Internal code env %s (%s) already exists and is ready ; will only check consistency.", new Object[]{envName, envLang});
                        if (this.containerSettings.codeEnvsBehavior.envImportSpecificationMode != CodeEnvModel.EnvImportSpecificationMode.SPECIFIED || envLang != CodeEnvModel.EnvLang.PYTHON) break;
                        CodeEnvModel.PythonEnvDesc envDesc = AutomationNodeManagedEnvUtils.getEnvDesc(envRootDir, CodeEnvModel.PythonEnvDesc.class);
                        CodeEnvModel.PythonEnvDesc exportedEnvDesc = (CodeEnvModel.PythonEnvDesc)JSON.parseFile((File)new File(exportedEnvDir, "desc.json"), CodeEnvModel.PythonEnvDesc.class);
                        if (exportedEnvDesc.useReferenceSpec() && envDesc.useReferenceSpec()) {
                            logger.infoV("Exported internal code env and existing internal code env both use reference spec. Nothing to do.", new Object[0]);
                            break;
                        }
                        boolean codeEnvMatch = this.codeEnvsService.checkIfNonVersionedCodeEnvMatches(envLang, envName, (File)fixedExportedEnvDir, this.containerSettings.codeEnvsBehavior.envImportSpecificationMode);
                        if (codeEnvMatch) {
                            logger.infoV("Exported internal code env and existing internal code env have matching specs. Nothing to do.", new Object[0]);
                            break;
                        }
                        logger.warnV("Exported internal code env and existing internal code env have different definitions. Exported uses reference spec: %b. Existing uses reference spec: %b.", new Object[]{exportedEnvDesc.useReferenceSpec(), envDesc.useReferenceSpec()});
                        ret.withWarningV(CodeEnvCodes.WARN_CODEENV_INTERNAL_SPEC_MISMATCH, "Specs of exported internal code env %s differs from existing internal code env", new Object[]{envName});
                        break;
                    }
                    logger.infoV("Internal code env %s (%s) is not ready. Updating its spec and building it", new Object[]{envName, envLang});
                    this.checkEnvUpdatePrivilege(envLang, envName);
                    try {
                        logger.infoV("Updating internal code env", new Object[0]);
                        CodeEnvModel.AbstractEnvDesc desc = this.codeEnvsService.importToNonVersionedEnv(this.authCtx, envLang, envName, (File)fixedExportedEnvDir, envRootDef.deploymentMode, this.containerSettings.codeEnvsBehavior.envImportSpecificationMode, true, this.logTailBuilder);
                        File envDescFolder = DKUFileUtils.getWithin((File)envRootDir, (String[])new String[]{"desc"});
                        this.codeEnvsService.buildEnvDockerImages(envDescFolder, desc, envLang, this.logTailBuilder, log, envName, null, ret);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Env update failed", (Throwable)e);
                        ret.withFatal(CodeEnvCodes.ERR_CODEENV_UPDATE_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                    }
                    break;
                }
            }
            case AUTOMATION_SINGLE: {
                logger.infoV("Env in SINGLE mode, checking if version matches", new Object[0]);
                if (this.codeEnvsService.checkIfNonVersionedCodeEnvMatches(envLang, envName, exportedEnvDir, this.containerSettings.codeEnvsBehavior.envImportSpecificationMode)) {
                    logger.infoV("Env in SINGLE mode, version matches", new Object[0]);
                    break;
                }
                this.checkEnvUpdatePrivilege(envLang, envName);
                try {
                    this.codeEnvsService.importToNonVersionedEnv(this.authCtx, envLang, envName, exportedEnvDir, envRootDef.deploymentMode, this.containerSettings.codeEnvsBehavior.envImportSpecificationMode, true, this.logTailBuilder);
                    AutomationNodeManagedEnvUtils.installJupyterSupportForNonVersionedEnv(this.authCtx, envLang, envName, this.logTailBuilder, log, true);
                    if (envLang == CodeEnvModel.EnvLang.PYTHON) {
                        AutomationNodeManagedEnvUtils.addResourcesEnvVariablesToJupyterKernelForNonVersionedEnv(envLang, envName, this.logTailBuilder, log, false);
                    }
                    File envRootDir = AutomationNodeManagedEnvUtils.getEnvDir(envLang, envName);
                    CodeEnvModel.AbstractEnvDesc desc = AutomationNodeManagedEnvUtils.getEnvDesc(envRootDir, envLang.getDescClazz());
                    this.codeEnvsService.buildEnvDockerImages(DKUFileUtils.getWithin((File)envRootDir, (String[])new String[]{"desc"}), desc, envLang, this.logTailBuilder, log, envName, null, ret);
                }
                catch (Exception e) {
                    logger.warn((Object)"Env update failed", (Throwable)e);
                    ret.withFatal(CodeEnvCodes.ERR_CODEENV_UPDATE_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                break;
            }
            case AUTOMATION_VERSIONED: {
                logger.infoV("Env in VERSIONED mode, checking if a version matches", new Object[0]);
                CodeEnvModel.EnvVersionRef versionRef = this.codeEnvsService.findMatchingEnvVersion(envLang, envName, exportedEnvDir, this.containerSettings.codeEnvsBehavior.envImportSpecificationMode);
                if (versionRef != null) {
                    logger.infoV("Env in VERSIONED mode, version %s matches", new Object[]{versionRef.envVersion});
                    AutomationNodeManagedEnvUtils.linkBundle(envLang, envName, this.projectKey, this.ep.bundleId, versionRef.envVersion);
                    AutomationNodeManagedEnvUtils.installJupyterSupportForVersionedEnv(this.authCtx, envLang, envName, versionRef.envVersion, this.projectKey, this.ep.bundleId, this.logTailBuilder, log, true);
                    if (envLang == CodeEnvModel.EnvLang.PYTHON) {
                        AutomationNodeManagedEnvUtils.addResourcesEnvVariablesToJupyterKernelForVersionedEnv(envLang, envName, versionRef.envVersion, this.projectKey, this.ep.bundleId, this.logTailBuilder, log, false);
                    }
                } else {
                    logger.infoV("Env in VERSIONED mode, no version matches, installing one", new Object[0]);
                    this.checkEnvUpdatePrivilege(envLang, envName);
                    try {
                        versionRef = this.codeEnvsService.importNewCodeEnvVersion(this.authCtx, envLang, envName, exportedEnvDir, envRootDef.deploymentMode, this.containerSettings.codeEnvsBehavior.envImportSpecificationMode, envRootDef.envSettings.overrideImportedEnvSettings ? envRootDef.envSettings : null, true, this.logTailBuilder);
                        logger.infoV("Env in VERSIONED mode, just installed version: %s, linking it", new Object[]{versionRef.envVersion});
                        AutomationNodeManagedEnvUtils.linkBundle(envLang, envName, this.projectKey, this.ep.bundleId, versionRef.envVersion);
                        AutomationNodeManagedEnvUtils.installJupyterSupportForVersionedEnv(this.authCtx, envLang, envName, versionRef.envVersion, this.projectKey, this.ep.bundleId, this.logTailBuilder, log, true);
                        if (envLang == CodeEnvModel.EnvLang.PYTHON) {
                            AutomationNodeManagedEnvUtils.addResourcesEnvVariablesToJupyterKernelForVersionedEnv(envLang, envName, versionRef.envVersion, this.projectKey, this.ep.bundleId, this.logTailBuilder, log, false);
                        }
                        File envRootDir = AutomationNodeManagedEnvUtils.getEnvVersionDir(envLang, envName, versionRef.envVersion);
                        CodeEnvModel.AbstractEnvDesc desc = AutomationNodeManagedEnvUtils.getEnvDesc(envRootDir, envLang.getDescClazz());
                        this.codeEnvsService.buildEnvDockerImages(DKUFileUtils.getWithin((File)envRootDir, (String[])new String[]{"desc"}), desc, envLang, this.logTailBuilder, log, envName, versionRef.envVersion, ret);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Env update failed", (Throwable)e);
                        ret.withFatal(CodeEnvCodes.ERR_CODEENV_UPDATE_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                    }
                }
                return versionRef;
            }
            case DESIGN_MANAGED: 
            case DESIGN_NON_MANAGED: {
                throw new Error("illegal env deployment mode");
            }
        }
        return null;
    }

    private CodeEnvModel.EnvVersionRef handleCodeEnvFailIfDifferent(CodeEnvModel.EnvLang envLang, String envName, BundlePreloadingReport ret, File exportedEnvDir, CodeEnvModel.AutomationEnvRootDef envRootDef, File log) throws Exception {
        switch (envRootDef.deploymentMode) {
            case AUTOMATION_NON_MANAGED_PATH: 
            case EXTERNAL_CONDA_NAMED: 
            case PLUGIN_NON_MANAGED: 
            case PLUGIN_MANAGED: 
            case DSS_INTERNAL: {
                logger.infoV("Env is not managed, not doing anything", new Object[0]);
                break;
            }
            case AUTOMATION_SINGLE: {
                logger.info((Object)"Env is in SINGLE mode: checking if single version matches");
                if (this.codeEnvsService.checkIfNonVersionedCodeEnvMatches(envLang, envName, exportedEnvDir, this.containerSettings.codeEnvsBehavior.envImportSpecificationMode)) {
                    logger.info((Object)"Env is in SINGLE mode: single version matches");
                    break;
                }
                logger.info((Object)"Env is in SINGLE mode: single version does not match");
                ret.withFatalV(BundleCodes.ERR_BUNDLE_PRELOAD_NO_MATCHING_PYENV, "No matching environment for code env " + envName, new Object[0]);
                break;
            }
            case AUTOMATION_VERSIONED: {
                logger.info((Object)"Env is in VERSIONED mode: checking if a version matches");
                CodeEnvModel.EnvVersionRef versionRef = this.codeEnvsService.findMatchingEnvVersion(envLang, envName, exportedEnvDir, this.containerSettings.codeEnvsBehavior.envImportSpecificationMode);
                if (versionRef != null) {
                    logger.infoV("Env is in VERSIONED mode: found matching version: %s", new Object[]{versionRef.envVersion});
                    AutomationNodeManagedEnvUtils.linkBundle(envLang, envName, this.projectKey, this.ep.bundleId, versionRef.envVersion);
                    AutomationNodeManagedEnvUtils.installJupyterSupportForVersionedEnv(this.authCtx, envLang, envName, versionRef.envVersion, this.projectKey, this.ep.bundleId, this.logTailBuilder, log, true);
                    if (envLang == CodeEnvModel.EnvLang.PYTHON) {
                        AutomationNodeManagedEnvUtils.addResourcesEnvVariablesToJupyterKernelForVersionedEnv(envLang, envName, versionRef.envVersion, this.projectKey, this.ep.bundleId, this.logTailBuilder, log, false);
                    }
                } else {
                    logger.infoV("Env is in VERSIONED mode: found nomatching version", new Object[0]);
                    ret.withFatalV(BundleCodes.ERR_BUNDLE_PRELOAD_NO_MATCHING_PYENV, "No matching environment for py env " + envName, new Object[0]);
                }
                return versionRef;
            }
            case DESIGN_MANAGED: 
            case DESIGN_NON_MANAGED: {
                throw new Error("illegal env deployment mode");
            }
        }
        return null;
    }

    public static class BundlePreloadingReport
    extends InfoMessage.InfoMessages {
    }
}

