/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projects.importexport;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolsDAO;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.badges.ApiServiceTypeBadgesService;
import com.dataiku.dip.badges.ProjectTypeBadgesService;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.DesignNodeCodeEnvsService;
import com.dataiku.dip.code.ProjectLibrariesEditionService;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.UsedContainerExec;
import com.dataiku.dip.coremodel.AppManifest;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.datasets.DatasetConnectionUtils;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.twitter.TwitterDatasetConfig;
import com.dataiku.dip.discussions.Discussion;
import com.dataiku.dip.discussions.DiscussionList;
import com.dataiku.dip.discussions.DiscussionsService;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.experimenttracking.ExperimentTrackingExportData;
import com.dataiku.dip.experimenttracking.ExperimentTrackingService;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.lambda.mgmt.LambdaServicesDAO;
import com.dataiku.dip.llm.promptstudio.PromptStudio;
import com.dataiku.dip.llm.promptstudio.PromptStudioDAO;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.projects.ProjectCodes;
import com.dataiku.dip.projects.apps.AppsService;
import com.dataiku.dip.projects.importexport.AbstractCodeEnvRemapper;
import com.dataiku.dip.projects.importexport.AutoMigrator;
import com.dataiku.dip.projects.importexport.AutomationNodeCodeEnvRemapper;
import com.dataiku.dip.projects.importexport.ConnectionRemapper;
import com.dataiku.dip.projects.importexport.ContainerExecRemapper;
import com.dataiku.dip.projects.importexport.ExportedProject;
import com.dataiku.dip.projects.importexport.ProjectImportExportUtils;
import com.dataiku.dip.projects.importexport.ProjectImporterBase;
import com.dataiku.dip.projects.importexport.model.BundleContentSummary;
import com.dataiku.dip.projects.importexport.model.ProjectRemappingSettings;
import com.dataiku.dip.reports.Report;
import com.dataiku.dip.reports.ReportsDAO;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.searchnotebooks.SearchNotebook;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.recipes.RecipesCRUDController;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.JupyterService;
import com.dataiku.dip.server.services.JupyterUtils;
import com.dataiku.dip.server.services.NeverBuiltComputablesCacheService;
import com.dataiku.dip.server.services.ProjectFoldersService;
import com.dataiku.dip.server.services.ScenariosService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TaggingService;
import com.dataiku.dip.sqlnotebooks.SQLNotebook;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.NativeFS;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.git.DSSGitModel;
import com.dataiku.dip.transactions.git.jgit.ProjectsJGitService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppsDAO;
import com.dataiku.dip.webapps.backend.WebAppBackendRestartThread;
import com.dataiku.dip.wikis.Article;
import com.dataiku.dip.wikis.ArticlesCacheService;
import com.dataiku.dip.wikis.ArticlesDAO;
import com.dataiku.dip.wikis.WikisService;
import com.dataiku.lambda.model.studioconfig.LambdaService;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ProjectImporter
extends ProjectImporterBase {
    private boolean isFromTrustedSource;
    private File archiveFile;
    private ProjectImportSettings importSettings;
    private Integer confVersion = null;
    @Autowired
    private ScenariosService scenariosService;
    @Autowired
    private TaggingService taggingService;
    @Autowired
    private DesignNodeCodeEnvsService codeEnvsService;
    @Autowired
    private JupyterService jupyterService;
    @Autowired
    private DiscussionsService discussionsService;
    @Autowired
    private WikisService wikisService;
    @Autowired
    protected WebAppsDAO webAppsDAO;
    @Autowired
    protected ReportsDAO reportsDAO;
    @Autowired
    protected LambdaServicesDAO lambdaServicesDAO;
    @Autowired
    protected SavedModelsDAO savedModelsDAO;
    @Autowired
    protected ArticlesDAO articlesDAO;
    @Autowired
    private NeverBuiltComputablesCacheService neverBuiltComputablesCacheService;
    @Autowired
    private ProjectFoldersService projectFoldersService;
    @Autowired
    private ProjectLibrariesEditionService projectLibrariesEditionService;
    @Autowired
    private ArticlesCacheService articlesCacheService;
    @Autowired
    private AppsService appsService;
    @Autowired
    private ExperimentTrackingService experimentTrackingService;
    @Autowired
    private PromptStudioDAO promptStudioDAO;
    @Autowired
    private AgentToolsDAO agentToolsDAO;
    @Autowired
    private ProjectsJGitService projectsGitService;
    @Autowired
    private ProjectTypeBadgesService projectTypeBadgesService;
    @Autowired
    private ApiServiceTypeBadgesService apiServiceTypeBadgesService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.projects.import");

    public ProjectImporter(AuthCtx authCtx, File archiveFile, ProjectImportSettings importSettings, boolean isFromTrustedSource) {
        super(authCtx);
        this.importSettings = importSettings;
        this.targetProjectKey = importSettings.targetProjectKey;
        this.archiveFile = archiveFile;
        this.isFromTrustedSource = isFromTrustedSource;
        SpringUtils.getInstance().autowire((Object)this);
    }

    public ProjectImporter(AuthCtx authCtx, File archiveFile, ProjectImportSettings importSettings) {
        this(authCtx, archiveFile, importSettings, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectImportResult importProject(AuthCtx user) throws Exception {
        ProjectImportResult ret = new ProjectImportResult();
        try {
            try (FutureProgress.AutocloseableFutureProgressState zipping = FutureProgress.pushAutoCloseableState((String)"Unzipping");){
                if (this.archiveFile.isFile()) {
                    this.importSourceDirectory = DSSTempUtils.getTempFolder((String)"project-import", (String)this.archiveFile.getName());
                    this.deleteImportSourceDirectory = true;
                    logger.info((Object)("Unarchiving to " + String.valueOf(this.importSourceDirectory)));
                    ZipUnzipDir.extractFolder(this.archiveFile, this.importSourceDirectory, false);
                } else if (this.archiveFile.isDirectory()) {
                    this.importSourceDirectory = this.archiveFile;
                } else {
                    throw new IOException("Import source `" + String.valueOf(this.archiveFile) + "` does not exist");
                }
                if (!this.importFile("export-manifest.json").isFile()) {
                    throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "This does not look like a DSS project archive");
                }
            }
            this.fixupUnzippedProject(this.importSourceDirectory);
            try (FutureProgress.AutocloseableFutureProgressState importing = FutureProgress.pushAutoCloseableState((String)"Importing");){
                SerializedProject.ProjectAppType projectAppType;
                ExportedProject ep = (ExportedProject)JSON.parseFile((File)this.importFile("export-manifest.json"), ExportedProject.class);
                boolean needToRegenerateAPIKeys = false;
                if (!this.importSettings.createBranch) {
                    try {
                        this.confVersion = Integer.parseInt(ep.generatedWithDSSConfVersion);
                        if (this.confVersion >= 17) {
                            logger.info((Object)"Exported from conf version >= 17, regenerating local project keys");
                            needToRegenerateAPIKeys = true;
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Failed to check if should regenerate project keys", (Throwable)e);
                    }
                }
                if (this.targetProjectKey == null) {
                    this.targetProjectKey = ep.originalProjectKey;
                }
                logger.info((Object)("Importing to project key " + this.targetProjectKey));
                ret.usedProjectKey = this.targetProjectKey;
                if (this.targetProjectKey != null && !this.targetProjectKey.isEmpty() && !Pattern.matches("^[A-Za-z_0-9]+$", this.targetProjectKey)) {
                    throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_PROJECT_KEY, "Invalid project key '" + this.targetProjectKey + "'. Project key should only contains letters and digits.");
                }
                try (Transaction t = this.transactionService.beginRead();){
                    if (t.exists(new RelFile(new String[]{"projects", this.targetProjectKey}))) {
                        throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_PROJECT_KEY, "Project key " + this.targetProjectKey + " is already used. Please check that you have not already imported this project.");
                    }
                }
                AutoMigrator migrator = new AutoMigrator(this.importSourceDirectory, ep);
                ret.neededAMigration = migrator.migrateIfNeeded();
                this.readAdditionalExportManifest(ep, this.importSourceDirectory);
                try (RWTransaction rwt = this.transactionService.beginNonCommittableWriteAsLoggedInUser(this.authCtx);){
                    logger.info((Object)"Doing test config import");
                    this.importWholeConfig();
                    logger.info((Object)"Checking remapping");
                    ConnectionRemapper connectionRemapper = new ConnectionRemapper(this.authCtx, null, this.importSettings.remapping, ep);
                    for (SerializedDataset serializedDataset : this.datasetsDAO.list(this.targetProjectKey)) {
                        ret.messages.addAll(connectionRemapper.checkRemapDataset(serializedDataset));
                        Dataset ds = Dataset.fromSerializedUnsafe(serializedDataset);
                        if (!this.neverBuiltComputablesCacheService.canBeAdded(ds)) continue;
                        this.neverBuiltComputablesCacheService.add(new TaggableObjectsService.TaggableObjectRef(serializedDataset));
                    }
                    for (StreamingEndpoint streamingEndpoint : this.streamingEndpointsDAO.list(this.targetProjectKey)) {
                        try {
                            ret.messages.addAll(connectionRemapper.checkRemapStreamingEndpoint(streamingEndpoint));
                        }
                        catch (Exception e) {
                            throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid Streaming endpoint: " + streamingEndpoint.id, (Throwable)e);
                        }
                    }
                    for (AnalysisCoreParams analysisCoreParams : this.analysisCRUDService.listCoreUnsafe(this.targetProjectKey, null)) {
                        for (MLTask mlTask : this.analysisCRUDService.listRawMLTasks(analysisCoreParams.projectKey, analysisCoreParams.id)) {
                            try {
                                ret.messages.addAll(connectionRemapper.checkRemapMLTask(mlTask));
                            }
                            catch (Exception e) {
                                throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid Analysis: " + analysisCoreParams.name, (Throwable)e);
                            }
                        }
                    }
                    for (SavedModel savedModel : this.savedModelsDAO.list(this.targetProjectKey)) {
                        try {
                            ret.messages.addAll(connectionRemapper.checkRemapSavedModel(this.importSourceDirectory, savedModel));
                        }
                        catch (Exception e) {
                            throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid Saved model: " + savedModel.id, (Throwable)e);
                        }
                    }
                    for (SQLNotebook sQLNotebook : this.sqlNotebooksDAO.list(this.targetProjectKey)) {
                        try {
                            ret.messages.addAll(connectionRemapper.checkRemapNotebook(sQLNotebook));
                        }
                        catch (Exception e) {
                            throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid SQL notebook: " + sQLNotebook.name, (Throwable)e);
                        }
                    }
                    for (SearchNotebook searchNotebook : this.searchNotebooksDAO.list(this.targetProjectKey)) {
                        try {
                            ret.messages.addAll(connectionRemapper.checkRemapNotebook(searchNotebook));
                        }
                        catch (Exception e) {
                            throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid Search notebook: " + searchNotebook.name, (Throwable)e);
                        }
                    }
                    for (ManagedFolder managedFolder : this.managedFolderDAO.list(this.targetProjectKey)) {
                        try {
                            ret.messages.addAll(connectionRemapper.checkRemapManagedFolder(managedFolder));
                        }
                        catch (Exception e) {
                            throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid Managed Folder: " + managedFolder.name, (Throwable)e);
                        }
                    }
                    for (SerializedRecipe serializedRecipe : this.recipesDAO.list(this.targetProjectKey)) {
                        try {
                            ret.messages.addAll(connectionRemapper.checkRemapRecipe(serializedRecipe));
                        }
                        catch (Exception e) {
                            throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid Recipe: " + serializedRecipe.name, (Throwable)e);
                        }
                    }
                    for (Scenario scenario : this.scenariosDAO.list(this.targetProjectKey)) {
                        try {
                            ret.messages.addAll(connectionRemapper.checkRemapScenario(scenario));
                        }
                        catch (Exception e) {
                            throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid Scenario: " + scenario.name, (Throwable)e);
                        }
                    }
                    for (LambdaService lambdaService : this.lambdaServicesDAO.list(this.targetProjectKey)) {
                        try {
                            ret.messages.addAll(connectionRemapper.checkRemapLambdaService(lambdaService));
                        }
                        catch (Exception e) {
                            throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid API service: " + lambdaService.name, (Throwable)e);
                        }
                    }
                    for (RetrievableKnowledge retrievableKnowledge : this.retrievableKnowledgeDAO.list(this.targetProjectKey)) {
                        try {
                            ret.messages.addAll(connectionRemapper.checkRetrievableKnowledge(retrievableKnowledge));
                        }
                        catch (Exception e) {
                            throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid knowledge bank: " + retrievableKnowledge.name, (Throwable)e);
                        }
                    }
                    for (PromptStudio promptStudio : this.promptStudioDAO.list(this.targetProjectKey)) {
                        try {
                            ret.messages.addAll(connectionRemapper.checkPromptStudio(promptStudio));
                        }
                        catch (Exception e) {
                            throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid prompt studio: " + promptStudio.name, (Throwable)e);
                        }
                    }
                    for (AgentTool agentTool : this.agentToolsDAO.list(this.targetProjectKey)) {
                        try {
                            ret.messages.addAll(connectionRemapper.checkAgentTool(agentTool));
                        }
                        catch (Exception e) {
                            throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid agent tool: " + agentTool.getDisplayName(), (Throwable)e);
                        }
                    }
                    AbstractCodeEnvRemapper codeEnvRemapper = this.buildCodeEnvRemapper(ep);
                    if (codeEnvRemapper instanceof AutomationNodeCodeEnvRemapper) {
                        ((AutomationNodeCodeEnvRemapper)codeEnvRemapper).prepareVersionedEnvs(ep.originalProjectKey, this.targetProjectKey);
                    }
                    ret.messages.addAll(codeEnvRemapper.checkRemap(this.projectsDAO.getMandatoryUnsafe(this.targetProjectKey)));
                    for (SerializedRecipe sr : this.recipesDAO.list(this.targetProjectKey)) {
                        try {
                            ret.messages.addAll(codeEnvRemapper.checkRemap(sr));
                        }
                        catch (Exception e) {
                            throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid Recipe: " + sr.name, (Throwable)e);
                        }
                    }
                    for (SerializedDataset sd : this.datasetsDAO.list(this.targetProjectKey)) {
                        try {
                            ret.messages.addAll(codeEnvRemapper.checkRemap(sd));
                        }
                        catch (Exception e) {
                            throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid Dataset: " + sd.name, (Throwable)e);
                        }
                    }
                    for (JupyterUtils.JupyterNotebookListEntry nbk : this.jupyterService.listUnsafe(user, this.targetProjectKey)) {
                        try {
                            ret.messages.addAll(codeEnvRemapper.checkRemap(nbk));
                        }
                        catch (Exception e) {
                            throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid Notebook: " + nbk.name, (Throwable)e);
                        }
                    }
                    for (Scenario scenario : this.scenariosService.list(this.targetProjectKey)) {
                        try {
                            ret.messages.addAll(codeEnvRemapper.checkRemap(scenario));
                        }
                        catch (Exception e) {
                            throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid Scenario: " + scenario.name, (Throwable)e);
                        }
                    }
                    for (WebApp webApp : this.webAppsDAO.list(this.targetProjectKey)) {
                        try {
                            ret.messages.addAll(codeEnvRemapper.checkRemap(webApp));
                        }
                        catch (Exception e) {
                            throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid WebApp: " + webApp.name, (Throwable)e);
                        }
                    }
                    for (Report report : this.reportsDAO.list(this.targetProjectKey)) {
                        try {
                            ret.messages.addAll(codeEnvRemapper.checkRemap(report));
                        }
                        catch (Exception e) {
                            throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid Report: " + report.name, (Throwable)e);
                        }
                    }
                    for (LambdaService service : this.lambdaServicesDAO.list(this.targetProjectKey)) {
                        try {
                            ret.messages.addAll(codeEnvRemapper.checkRemap(service));
                        }
                        catch (Exception e) {
                            throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid API Service: " + service.name, (Throwable)e);
                        }
                    }
                    for (AnalysisCoreParams acp : this.analysisCRUDService.listCoreUnsafe(this.targetProjectKey, null)) {
                        try {
                            ret.messages.addAll(codeEnvRemapper.checkRemap(acp));
                        }
                        catch (Exception e) {
                            throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid Analysis: " + acp.name, (Throwable)e);
                        }
                    }
                    for (SavedModel sm : this.savedModelsDAO.list(this.targetProjectKey)) {
                        try {
                            ret.messages.addAll(codeEnvRemapper.checkRemap(sm));
                        }
                        catch (Exception e) {
                            throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid Saved Model: " + sm.id, (Throwable)e);
                        }
                    }
                    for (RetrievableKnowledge rk : this.retrievableKnowledgeDAO.list(this.targetProjectKey)) {
                        try {
                            ret.messages.addAll(codeEnvRemapper.checkRemap(rk));
                        }
                        catch (Exception e) {
                            throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid knowledge bank: " + rk.name, (Throwable)e);
                        }
                    }
                    for (Iterator<TaggableObjectsService.TaggableObject> agentTool : this.agentToolsDAO.list(this.targetProjectKey)) {
                        try {
                            ret.messages.addAll(codeEnvRemapper.checkRemap((TaggableObjectsService.TaggableObject)((Object)agentTool)));
                        }
                        catch (Exception e) {
                            throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid agent tool: " + ((AgentTool)((Object)agentTool)).getDisplayName(), (Throwable)e);
                        }
                    }
                    if (this.importSettings.remapping.enableContainerExecRemapping) {
                        ContainerExecRemapper containerExecRemapper = new ContainerExecRemapper(this.authCtx, this.importSettings.remapping, ep);
                        ret.messages.addAll(containerExecRemapper.checkRemapProject(this.projectsDAO.getMandatoryUnsafe(this.targetProjectKey)));
                        for (SerializedRecipe sr : this.recipesDAO.listUnsafe(this.targetProjectKey)) {
                            try {
                                ret.messages.addAll(containerExecRemapper.checkRemapRecipe(sr));
                                ret.messages.addAll(containerExecRemapper.checkRemapPayloadRecipe(sr));
                            }
                            catch (Exception e) {
                                throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid Recipe: " + sr.name, (Throwable)e);
                            }
                        }
                        for (JupyterUtils.JupyterNotebookListEntry listEntry : this.jupyterService.listUnsafe(null, this.targetProjectKey)) {
                            try {
                                ret.messages.addAll(containerExecRemapper.checkRemapNotebooks(listEntry, this.targetProjectKey));
                            }
                            catch (Exception e) {
                                throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid Notebook: " + listEntry.name, (Throwable)e);
                            }
                        }
                        for (WebApp webApp : this.webAppsDAO.listUnsafe(this.targetProjectKey)) {
                            try {
                                ret.messages.addAll(containerExecRemapper.checkRemapWebApp(webApp));
                            }
                            catch (Exception e) {
                                throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid WebApp: " + webApp.name, (Throwable)e);
                            }
                        }
                        for (RetrievableKnowledge rk : this.retrievableKnowledgeDAO.listUnsafe(this.targetProjectKey)) {
                            try {
                                ret.messages.addAll(containerExecRemapper.checkRetrievableKnowledge(rk));
                            }
                            catch (Exception e) {
                                throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid knowledge bank: " + rk.name, (Throwable)e);
                            }
                        }
                        for (AnalysisCoreParams acp : this.analysisCRUDService.listCoreUnsafe(this.targetProjectKey, null)) {
                            try {
                                ret.messages.addAll(containerExecRemapper.checkRemapAnalysis(acp));
                            }
                            catch (Exception e) {
                                throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid Analysis: " + acp.name, (Throwable)e);
                            }
                        }
                        for (SavedModel sm : this.savedModelsDAO.listUnsafe(this.targetProjectKey)) {
                            try {
                                ret.messages.addAll(containerExecRemapper.checkRemapSavedModels(sm));
                            }
                            catch (Exception e) {
                                throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid Saved Model: " + sm.id, (Throwable)e);
                            }
                        }
                        for (AgentTool agentTool : this.agentToolsDAO.list(this.targetProjectKey)) {
                            try {
                                ret.messages.addAll(containerExecRemapper.checkRemapAgentTool(agentTool));
                            }
                            catch (Exception e) {
                                throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid agent tool: " + agentTool.getDisplayName(), (Throwable)e);
                            }
                        }
                    } else {
                        logger.info((Object)"Skipping check of container exec remapping.");
                    }
                    if (ret.messages.size() == 0) {
                        this.executeConnectionRemapping(ep, ret);
                        if (ep.manifestVersion == 3) {
                            this.v3CheckConnectionsWritability(ep, ret);
                        }
                    }
                    this.checkPlugins(ep.exportedWithPlugins, this.targetProjectKey, ret);
                    this.checkCodeStudioTemplates(ep, ret);
                    for (Article article : this.articlesDAO.listUnsafe(this.targetProjectKey)) {
                        try {
                            ret.messages.addAll(this.wikisService.listForbiddenUploadedAttachments(article, null).stream().map(att -> InfoMessage.warning((String)("Forbidden wiki attachment removed: " + att.getDetails().get("objectDisplayName").getAsString() + " in " + article.getDisplayName()))).collect(Collectors.toList()));
                        }
                        catch (Exception e) {
                            throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "Invalid wiki article: " + article.name, (Throwable)e);
                        }
                    }
                    ret.summarize();
                    if (ret.anyFatal()) {
                        ProjectImportResult projectImportResult = ret;
                        return projectImportResult;
                    }
                }
                try (RWTransaction rwt = this.transactionService.beginWriteAsLoggedInUser(user);){
                    RelFile relFile;
                    NativeFS projectConfigFS = NativeFS.from((File)new File(this.importSourceDirectory, "project_config")).build();
                    if (needToRegenerateAPIKeys) {
                        ProjectImportExportUtils.regenerateAPIKeys((ReadWriteFS)projectConfigFS, false);
                    }
                    ProjectImportExportUtils.encryptApiServiceApiKeys((ReadWriteFS)projectConfigFS);
                    logger.info((Object)"Importing config");
                    this.importWholeConfig();
                    if (ApplicationConfigurator.getGitMode() == DSSGitModel.GitMode.GLOBAL && rwt.isDirectory(relFile = new RelFile(new String[]{"projects", this.targetProjectKey, ".git"}))) {
                        logger.info((Object)"Removing imported Git repository (global Git mode)");
                        rwt.deleteDirectory(relFile);
                    }
                    if (ep.manifestVersion == 2) {
                        logger.info((Object)"Importing a DSS-v2 project");
                        this.v2FixupAllManagedFSDataPaths();
                    } else if (ep.manifestVersion == 3) {
                        logger.info((Object)"Importing a DSS-v3 project");
                    }
                    this.executeConnectionRemapping(ep, ret);
                    this.executeCodeEnvRemapping(user, ep);
                    this.executeContainerExecRemapping(user, ep);
                    this.shareForeignObjects(user, ep, ret);
                    this.unsetDatasetsAsFeatureGroups(ep);
                    this.updateFolderIdForKB(ep);
                    if (ep.manifestVersion == 3) {
                        this.v3CheckConnectionsWritabilityWithFail(ep);
                        this.v3ForceReloadedDatasetsPath(ep);
                    }
                    for (JupyterUtils.JupyterNotebookListEntry nb : this.jupyterService.listUnsafe(this.authCtx, this.targetProjectKey)) {
                        this.jupyterService.rewriteNotebook(nb.projectKey, nb.name);
                    }
                    SerializedProject serializedProject = this.projectsDAO.getMandatory(this.targetProjectKey);
                    boolean duplicateProject = "DUPLICATED".equals(this.importSettings.importType);
                    if (!this.importSettings.createBranch) {
                        if (!duplicateProject) {
                            serializedProject.permissions = new ArrayList<SerializedProject.PermissionItem>();
                        }
                        if (rwt.getUser().getIdentifier() != null) {
                            serializedProject.owner = rwt.getUser().getIdentifier();
                        }
                    }
                    if (TaggingService.DEFAULT_TAG.APP_INSTANTIATION.name.equals(this.importSettings.importType)) {
                        serializedProject.settings.limitedVisibilityEnabled = GeneralSettingsDAO.InheritableEnabledSetting.LocalValue.DISABLED;
                        serializedProject.settings.accessRequestsEnabled = GeneralSettingsDAO.InheritableEnabledSetting.LocalValue.DISABLED;
                        serializedProject.settings.sharingRequestsEnabled = GeneralSettingsDAO.InheritableEnabledSetting.LocalValue.DISABLED;
                    } else if (!duplicateProject) {
                        serializedProject.settings.limitedVisibilityEnabled = GeneralSettingsDAO.InheritableEnabledSetting.LocalValue.INHERIT;
                        serializedProject.settings.accessRequestsEnabled = GeneralSettingsDAO.InheritableEnabledSetting.LocalValue.INHERIT;
                        serializedProject.settings.sharingRequestsEnabled = GeneralSettingsDAO.InheritableEnabledSetting.LocalValue.INHERIT;
                        if (SerializedProject.ProjectAppType.APP_TEMPLATE.equals((Object)serializedProject.projectAppType)) {
                            AppManifest manifest = this.appsService.getAppTemplateManifestForProject_T(this.targetProjectKey);
                            manifest.limitedVisibilityEnabled = GeneralSettingsDAO.InheritableEnabledSetting.LocalValue.INHERIT;
                            manifest.accessRequestsEnabled = GeneralSettingsDAO.InheritableEnabledSetting.LocalValue.INHERIT;
                            this.appsService.saveAppTemplateManifestForProject(this.targetProjectKey, manifest, this.isFromTrustedSource);
                        }
                    }
                    if (TaggingService.DEFAULT_TAG.APP_INSTANTIATION.name.equalsIgnoreCase(this.importSettings.importType) || TaggingService.DEFAULT_TAG.DUPLICATED.name.equalsIgnoreCase(this.importSettings.importType) && !this.importSettings.createBranch) {
                        serializedProject.exposedObjects.objects = serializedProject.exposedObjects.objects.stream().filter(eo -> eo.quickSharingEnabled).peek(eo -> eo.rules.clear()).collect(Collectors.toList());
                    }
                    if (!this.importSettings.createBranch) {
                        TaggingService.DEFAULT_TAG importTag;
                        TaggingService.DEFAULT_TAG tag = TaggingService.DEFAULT_TAG.IMPORTED;
                        if (this.importSettings.importType != null && (importTag = TaggingService.DEFAULT_TAG.getByName(this.importSettings.importType)) != null) {
                            tag = importTag;
                        }
                        if (serializedProject.tags == null) {
                            serializedProject.tags = new ArrayList();
                        }
                        if (!serializedProject.tags.contains(tag.name)) {
                            serializedProject.tags.add(tag.name);
                        }
                        TaggingService.TagsFile tagsFile = this.taggingService.listTags(this.targetProjectKey);
                        if (tagsFile.tags.get(tag.name) == null) {
                            tagsFile.tags.put(tag.name, tag.tagInfo);
                        }
                        this.taggingService.setTags(this.targetProjectKey, tagsFile, null);
                    }
                    if (!duplicateProject) {
                        RelFile gitInfo;
                        RelFile importedGit2 = new RelFile(new String[]{"projects", this.targetProjectKey, ".git"});
                        if (!rwt.isDirectory(importedGit2)) {
                            serializedProject.settings.useRemoteGit = null;
                        }
                        if (rwt.exists(gitInfo = new RelFile(new String[]{"projects", this.targetProjectKey, ".dss-meta", "git-info.json"}))) {
                            logger.info((Object)"Removing git-info.json");
                            rwt.deleteFile(gitInfo);
                        }
                    }
                    TaggableObjectChangedEvent.ProjectEditSubtype editSubtype = duplicateProject ? TaggableObjectChangedEvent.ProjectEditSubtype.DUPLICATION : TaggableObjectChangedEvent.ProjectEditSubtype.UNKNOWN;
                    this.preSaveHook(serializedProject);
                    this.projectsService.save(serializedProject, editSubtype);
                    this.postSaveHook();
                    projectAppType = this.projectsDAO.getMandatory((String)this.targetProjectKey).projectAppType;
                    for (Scenario s : this.scenariosService.list(this.targetProjectKey)) {
                        if (!s.active) continue;
                        logger.infoV("Disabling scenario %s", new Object[]{s.id});
                        s.active = false;
                        this.scenariosService.save(this.targetProjectKey, s);
                    }
                    this.projectFoldersService.addProject_Check(this.authCtx, this.importSettings.targetProjectFolderId, this.targetProjectKey);
                    this.projectLibrariesEditionService.generateProjectLibrariesContent((RWTransactionRef)rwt, this.targetProjectKey);
                    this.adjustRunAsUsers();
                    List<String> datasets = this.datasetAccessService.list(this.targetProjectKey).stream().map(Dataset::getName).collect(Collectors.toList());
                    this.projectsGitService.removeDiffNoiseFromSerialization(this.targetProjectKey, datasets);
                    if (duplicateProject) {
                        rwt.commit("Duplicated project " + ep.originalProjectKey + " into " + this.importSettings.targetProjectKey);
                    } else {
                        rwt.commit("Imported project " + this.targetProjectKey);
                    }
                }
                ret.success = true;
                this.projectsGitService.addProjectTagOnProjectImport_NT(this.authCtx, ret.usedProjectKey);
                Set<InfoMessage> badgesSyncMessages = this.synchronizeTypeBadges();
                ret.messages.addAll(badgesSyncMessages);
                logger.info((Object)"Config import done, continuing with data");
                if (ep.manifestVersion == 2) {
                    logger.info((Object)"Importing a DSS-v2 project");
                    if (ep.exportedWithOptions.exportAnalysisModels) {
                        logger.info((Object)"Importing ALL Analysis ML data");
                        this.importAllAnalysisData();
                    }
                    if (ep.exportedWithOptions.exportSavedModels) {
                        logger.info((Object)"Importing ALL saved models");
                        this.importAllSavedModels();
                    }
                    logger.info((Object)"Importing ALL managed FS datasets");
                    this.v2ImportManagedFSData();
                    if (ep.exportedWithOptions.exportUploads) {
                        logger.info((Object)"Importing ALL uploaded datasets");
                        this.v2ImportUploadData();
                    }
                } else if (ep.manifestVersion == 3) {
                    logger.info((Object)"Importing a DSS-v3 project");
                    assert (ep.actualContent != null);
                    if (ep.actualContent.allAnalysisData) {
                        logger.info((Object)"Importing ALL Analysis ML data");
                        this.importAllAnalysisData();
                        this.executeAnalysisDataConnectionRemappingNoFail(ep);
                        this.executeAnalysisDataCodeEnvRemappingNoFail(ep);
                        this.executeAnalysisDataContainerExecRemappingNoFail(ep);
                    }
                    if (ep.actualContent.insightsData) {
                        logger.info((Object)"Importing static insights data");
                        this.importInsightsData();
                    }
                    this.importReportsData();
                    this.importReportsExportsData();
                    this.importWikiData();
                    this.importDiscussionsData();
                    this.importExperimentTrackingData();
                    this.importProjectResources();
                    this.importNotebooksOutputs();
                    this.importKnowledgeBanksData();
                    this.importPromptStudioHistories();
                    if (TaggingService.DEFAULT_TAG.APP_INSTANTIATION.name.equals(this.importSettings.importType)) {
                        this.v3ReloadAllDataExceptTimeline(ep, ret.messages);
                    } else {
                        this.v3ReloadAllData(ep, ret.messages);
                    }
                    this.executeSavedModelDataCodeEnvRemappingNoFail(ep);
                    this.executeSavedModelContainerExecRemappingNoFail(ep);
                    this.executeSavedModelConnectionRemappingNoFail(ep);
                    this.executeModelEvaluationConnectionRemappingNoFail(ep);
                    this.executeKnowledgeBankDataImagesFolderRemappingNoFail(ep);
                    this.executeKnowledgeBankDataConnectionRemappingNoFail(ep);
                    this.executeKnowledgeBankDataCodeEnvRemappingNoFail(ep);
                    this.executeKnowledgeBankDataContainerExecRemappingNoFail(ep);
                }
                WebAppBackendRestartThread.restartAll(this.targetProjectKey, user);
                if (projectAppType == SerializedProject.ProjectAppType.APP_TEMPLATE) {
                    this.appsService.handleProjectImported_NT(this.targetProjectKey);
                }
            }
        }
        finally {
            if (this.deleteImportSourceDirectory) {
                DKUFileUtils.deleteDirectory((File)this.importSourceDirectory);
            }
        }
        return ret;
    }

    private Set<InfoMessage> synchronizeTypeBadges() throws IOException {
        String message;
        HashSet<InfoMessage> messages = new HashSet<InfoMessage>();
        if (!this.projectTypeBadgesService.hasBadgesFile(this.targetProjectKey)) {
            try {
                this.projectTypeBadgesService.synchronizeBadges_NT(this.targetProjectKey);
            }
            catch (Exception e) {
                message = String.format("Failed to synchronize badges for project %s, you may synchronize them manually in the project settings", this.targetProjectKey);
                messages.add(InfoMessage.warning((String)message));
                logger.warn((Object)message, (Throwable)e);
            }
        } else {
            logger.debugV("Badges file already exists in project %s, skipping synchronization of project type badges", new Object[]{this.targetProjectKey});
        }
        try {
            this.apiServiceTypeBadgesService.synchronizeBadges_NT(this.targetProjectKey);
        }
        catch (Exception e) {
            message = String.format("Failed to synchronize badges for the API services of project %s, you may synchronize them manually in the project settings", this.targetProjectKey);
            messages.add(InfoMessage.warning((String)message));
            logger.warn((Object)message, (Throwable)e);
        }
        return messages;
    }

    private void unsetDatasetsAsFeatureGroups(ExportedProject ep) throws Exception {
        for (BundleContentSummary.IncludedDataset id : ep.actualContent.includedDatasets) {
            SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getMandatory(this.targetProjectKey, id.name);
            if (!sd.featureGroup) continue;
            sd.featureGroup = false;
            this.datasetsDAO.save(sd);
        }
    }

    private void updateFolderIdForKB(ExportedProject ep) {
        if (ep.actualContent == null || ep.actualContent.includedKnowledgeBanks == null) {
            return;
        }
        for (BundleContentSummary.IncludedKnowledgeBank ikb : ep.actualContent.includedKnowledgeBanks) {
            try {
                RetrievableKnowledge rk = (RetrievableKnowledge)this.retrievableKnowledgeDAO.getMandatory(this.targetProjectKey, ikb.id);
                boolean remapped = this.remapKnowledgeBankImagesFolder(rk, ep.originalProjectKey);
                if (!remapped) continue;
                this.retrievableKnowledgeDAO.save(rk);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to update the folder id on knowledge bank " + ikb.id), (Throwable)e);
            }
        }
    }

    protected void preSaveHook(SerializedProject project) throws IOException {
    }

    protected void postSaveHook() throws IOException {
    }

    protected void adjustRunAsUsers() throws IOException {
        boolean adjustRunAsInScenarios = ApplicationConfigurator.getParams().getBoolParam("dku.security.projectImport.adjustRunAsUserInScenarios", true);
        boolean adjustRunAsInWebapps = ApplicationConfigurator.getParams().getBoolParam("dku.security.projectImport.adjustRunAsUserInWebapps", true);
        boolean adjustRunAsInInsights = ApplicationConfigurator.getParams().getBoolParam("dku.security.projectImport.adjustRunAsUserInInsights", true);
        super.adjustRunAsUsers(new ProjectImporterBase.StashedLocalConfig(), adjustRunAsInScenarios, adjustRunAsInWebapps, adjustRunAsInInsights);
    }

    protected void fixupUnzippedProject(File importSourceDirectory) throws IOException {
    }

    public PrepareImportResponse prepareImport(AuthCtx liu) throws Exception {
        PrepareImportResponse ret = new PrepareImportResponse();
        for (DSSConnection dSSConnection : this.connectionsDAO.listUnsafe().values()) {
            if (!dSSConnection.isFreelyUsableBy(liu)) continue;
            RecipesCRUDController.ManagedDatasetConnection mdc = new RecipesCRUDController.ManagedDatasetConnection();
            mdc.name = dSSConnection.name;
            mdc.description = dSSConnection.description;
            mdc.type = dSSConnection.getType();
            mdc.sql = dSSConnection.isProperSQL();
            ret.availableConnections.add(mdc);
        }
        for (CodeEnvModel.CodeEnvListItem codeEnvListItem : this.codeEnvsService.listCodeEnvs()) {
            if (codeEnvListItem.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED || codeEnvListItem.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_NON_MANAGED) continue;
            ret.availableCodeEnvs.add(codeEnvListItem);
        }
        for (ContainerExecRuntimeConfig containerExecRuntimeConfig : new ClusterSelector().selectGlobal().getContainerSettings().executionConfigs) {
            if (!containerExecRuntimeConfig.isFreelyUsableBy(liu)) continue;
            ret.availableContainerExecConfs.add(containerExecRuntimeConfig);
        }
        if (this.archiveFile != null) {
            File exportManifestFile = new File(this.archiveFile, "export-manifest.json");
            if (!exportManifestFile.isFile()) {
                throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_INVALID_ARCHIVE, "This does not look like a DSS project archive");
            }
            ExportedProject exportedProject = (ExportedProject)JSON.parseFile((File)exportManifestFile, ExportedProject.class);
            this.readAdditionalExportManifest(exportedProject, this.archiveFile);
            ret.originalProjectKey = exportedProject.originalProjectKey;
            ret.usedConnections = Lists.newArrayList();
            for (DatasetConnectionUtils.UsedConnection requiredConnection : exportedProject.requiredConnections.values()) {
                if (ConnectionsDAO.parseVirtualConnection(requiredConnection.name) != null) continue;
                ret.usedConnections.add(requiredConnection);
            }
            ret.usedCodeEnvs = exportedProject.usedCodeEnvRefs;
            ret.usedContainerExecConfs = exportedProject.usedContainerExecConfs;
        }
        return ret;
    }

    protected void v2FixupAllManagedFSDataPaths() throws IOException {
        for (SerializedDataset sd : this.datasetsDAO.list(this.targetProjectKey)) {
            String newPath;
            Dataset ds;
            if (sd.type.equals("Filesystem")) {
                ds = Dataset.fromSerialized("X.X", sd);
                if (!ds.getParamsAs(AbstractFSDatasetHandler.AbstractFSConfig.class).connection.equals("filesystem_managed")) continue;
                newPath = "/" + this.targetProjectKey + "." + sd.name;
                ds.getParamsAs(AbstractFSDatasetHandler.AbstractFSConfig.class).path = newPath;
                this.datasetsDAO.save(ds.serialize());
                continue;
            }
            if (!sd.type.equals("Twitter")) continue;
            ds = Dataset.fromSerialized("X.X", sd);
            if (!ds.getParamsAs(TwitterDatasetConfig.class).connection.equals("filesystem_managed")) continue;
            newPath = "/" + this.targetProjectKey + "." + sd.name;
            ds.getParamsAs(TwitterDatasetConfig.class).path = newPath;
            this.datasetsDAO.save(ds.serialize());
        }
    }

    protected void v2ImportManagedFSData() throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            for (SerializedDataset sd : this.datasetsDAO.list(this.targetProjectKey)) {
                String newPath;
                Dataset ds;
                if (sd.type.equals("Filesystem")) {
                    ds = Dataset.fromSerialized("X.X", sd);
                    if (!ds.getParamsAs(AbstractFSDatasetHandler.AbstractFSConfig.class).connection.equals("filesystem_managed")) continue;
                    newPath = "/" + this.targetProjectKey + "." + sd.name;
                    if (!this.importFile("managed_datasets", sd.name).isDirectory()) continue;
                    logger.info((Object)("Copying managed FS dataset " + sd.name));
                    DKUFileUtils.copyDirectory((File)this.importFile("managed_datasets", sd.name), (File)ApplicationConfigurator.getFile((String[])new String[]{"managed_datasets", newPath}));
                    continue;
                }
                if (!sd.type.equals("Twitter")) continue;
                ds = Dataset.fromSerialized("X.X", sd);
                if (!ds.getParamsAs(TwitterDatasetConfig.class).connection.equals("filesystem_managed")) continue;
                newPath = "/" + this.targetProjectKey + "." + sd.name;
                if (!this.importFile("managed_datasets", sd.name).isDirectory()) continue;
                logger.info((Object)("Copying managed Twitter dataset " + sd.name));
                DKUFileUtils.copyDirectory((File)this.importFile("managed_datasets", sd.name), (File)ApplicationConfigurator.getFile((String[])new String[]{"managed_datasets", newPath}));
            }
        }
    }

    protected void v2ImportUploadData() throws IOException, DKUSecurityException, CodedException {
        try (Transaction t = this.transactionService.beginRead();){
            for (SerializedDataset sd : this.datasetsDAO.listUnsafe(this.targetProjectKey)) {
                if (!sd.type.equals("UploadedFiles")) continue;
                AbstractFSDatasetHandler fsdh = (AbstractFSDatasetHandler)DatasetHandlerFactory.build(this.authCtx, Dataset.fromSerialized(sd));
                try {
                    fsdh.transferFrom(this.importFile("uploads", sd.name));
                }
                finally {
                    if (fsdh == null) continue;
                    fsdh.close();
                }
            }
        }
    }

    protected void importAllAnalysisData() throws IOException, InterruptedException {
        if (this.importFile("analysis-data").isDirectory()) {
            File projectAnalysisData = ApplicationConfigurator.getFile((String[])new String[]{"analysis-data", this.targetProjectKey});
            DKUFileUtils.copyDirectory((File)this.importFile("analysis-data"), (File)projectAnalysisData);
            if (projectAnalysisData.isDirectory()) {
                for (File analysisFolder : projectAnalysisData.listFiles()) {
                    MLPaths.restrictPermissionsAnalysisFolder(analysisFolder);
                }
            }
        }
    }

    protected void importDiscussionsData() throws IOException, SQLException {
        HashSet<String> affectedUsers = new HashSet<String>();
        HashSet<TaggableObjectsService.TaggableObjectRef> affectedTors = new HashSet<TaggableObjectsService.TaggableObjectRef>();
        File dir = this.importFile("discussions");
        if (dir.isDirectory()) {
            List<Discussion> discussions = ((DiscussionList)JSON.parseFile((File)new File((File)dir, (String)"discussions.json"), DiscussionList.class)).discussions;
            for (Discussion discussion : discussions) {
                discussion.projectKey = this.targetProjectKey;
                if (discussion.objectType == ITaggingService.TaggableType.PROJECT) {
                    discussion.objectId = this.targetProjectKey;
                } else if (discussion.objectType == ITaggingService.TaggableType.ARTICLE && this.confVersion != null && this.confVersion < 6000) {
                    String id;
                    try (Transaction t = this.transactionService.beginRead();){
                        id = this.articlesCacheService.getIdFromName(discussion.projectKey, discussion.objectId);
                    }
                    if (StringUtils.isNotBlank((CharSequence)id)) {
                        discussion.objectId = id;
                    } else {
                        logger.warn((Object)("Unable to find new ID for article: " + discussion.projectKey + "." + discussion.objectId));
                    }
                }
                affectedTors.add(new TaggableObjectsService.TaggableObjectRef(discussion.projectKey, discussion.objectType, discussion.objectId));
                affectedUsers.addAll(this.discussionsService.importWholeDiscussion(discussion));
            }
        }
        this.discussionsService.massActionSendEvents(affectedTors, affectedUsers);
    }

    protected void importExperimentTrackingData() throws IOException, SQLException {
        File dir = this.importFile("experiment-tracking");
        if (dir.isDirectory()) {
            ExperimentTrackingExportData experimentTrackingExportData = (ExperimentTrackingExportData)JSON.parseFile((File)new File(dir, "experiment-tracking.json"), ExperimentTrackingExportData.class);
            this.experimentTrackingService.insertExportData(this.targetProjectKey, experimentTrackingExportData);
        }
    }

    protected void importReportsData() throws IOException {
        File reports = this.importFile("code-reports");
        if (reports.isDirectory()) {
            DKUFileUtils.copyDirectory((File)reports, (File)ApplicationConfigurator.getFile((String[])new String[]{"code-reports", this.targetProjectKey}));
        }
    }

    protected void importReportsExportsData() throws IOException {
        File exports = this.importFile("reports_exports");
        if (exports.isDirectory()) {
            DKUFileUtils.copyDirectory((File)exports, (File)ApplicationConfigurator.getFile((String[])new String[]{"reports_exports", this.targetProjectKey}));
        }
    }

    protected void importAllSavedModels() throws IOException, InterruptedException {
        if (this.importFile("saved_models").isDirectory()) {
            File projectSavedModels = ApplicationConfigurator.getFile((String[])new String[]{"saved_models", this.targetProjectKey});
            DKUFileUtils.copyDirectory((File)this.importFile("saved_models"), (File)projectSavedModels);
            if (projectSavedModels.isDirectory()) {
                for (File smFolder : projectSavedModels.listFiles()) {
                    if (!smFolder.isDirectory()) continue;
                    FilesystemACLUtils.restrictRwxToDSSIfImpersonationEnabled(smFolder);
                }
            }
        }
    }

    private void executeConnectionRemapping(ExportedProject ep, InfoMessage.InfoMessages ret) throws IOException, DKUSecurityException {
        boolean wasRemapped;
        ConnectionRemapper connectionRemapper = new ConnectionRemapper(this.authCtx, null, this.importSettings.remapping, ep);
        for (SerializedDataset serializedDataset : this.datasetsDAO.list(this.targetProjectKey)) {
            wasRemapped = connectionRemapper.remapDataset(serializedDataset);
            if (!wasRemapped) continue;
            logger.infoV("Saving remapped dataset %s", new Object[]{serializedDataset.name});
            serializedDataset.projectKey = this.targetProjectKey;
            this.datasetsDAO.save(serializedDataset);
        }
        for (StreamingEndpoint streamingEndpoint : this.streamingEndpointsDAO.list(this.targetProjectKey)) {
            wasRemapped = connectionRemapper.remapStreamingEndpoint(streamingEndpoint);
            if (!wasRemapped) continue;
            logger.infoV("Saving remapped streaming endpoint %s", new Object[]{streamingEndpoint.id});
            streamingEndpoint.projectKey = this.targetProjectKey;
            this.streamingEndpointsDAO.save(streamingEndpoint);
        }
        for (SQLNotebook sQLNotebook : this.sqlNotebooksDAO.list(this.targetProjectKey)) {
            wasRemapped = connectionRemapper.remapNotebook(sQLNotebook);
            if (!wasRemapped) continue;
            logger.infoV("Saving remapped sql notebook %s", new Object[]{sQLNotebook.name});
            this.sqlNotebooksDAO.save(sQLNotebook);
        }
        for (SearchNotebook searchNotebook : this.searchNotebooksDAO.list(this.targetProjectKey)) {
            wasRemapped = connectionRemapper.remapNotebook(searchNotebook);
            if (!wasRemapped) continue;
            logger.infoV("Saving remapped search notebook %s", new Object[]{searchNotebook.name});
            this.searchNotebooksDAO.save(searchNotebook);
        }
        for (ManagedFolder managedFolder : this.managedFolderDAO.list(this.targetProjectKey)) {
            wasRemapped = connectionRemapper.remapManagedFolder(managedFolder);
            if (wasRemapped) {
                logger.infoV("Saving remapped folder %s", new Object[]{managedFolder.name});
                this.managedFolderDAO.save(managedFolder);
            }
            this.fixFolderType(ret, managedFolder);
        }
        for (SerializedRecipe serializedRecipe : this.recipesDAO.list(this.targetProjectKey)) {
            ConnectionRemapper.RecipeRemappingResult remappingResult = connectionRemapper.remapRecipe(serializedRecipe);
            if (!remappingResult.wasRemapped) continue;
            logger.infoV("Saving remapped recipe %s", new Object[]{serializedRecipe.name});
            this.recipesDAO.save(this.targetProjectKey, serializedRecipe.name, serializedRecipe, JSON.json((Object)remappingResult.payloadParams));
        }
        for (Scenario scenario : this.scenariosDAO.list(this.targetProjectKey)) {
            boolean wasRemapped2 = connectionRemapper.remapScenario(scenario);
            if (!wasRemapped2) continue;
            logger.infoV("Saving remapped scenario %s", new Object[]{scenario.id});
            this.scenariosDAO.save(this.targetProjectKey, scenario.id, scenario);
        }
        for (RetrievableKnowledge retrievableKnowledge : this.retrievableKnowledgeDAO.list(this.targetProjectKey)) {
            boolean wasRemapped3 = connectionRemapper.remapRetrievableKnowledge(retrievableKnowledge);
            if (!wasRemapped3) continue;
            logger.infoV("Saving remapped retrievable knowledge %s", new Object[]{retrievableKnowledge.id});
            this.retrievableKnowledgeDAO.save(retrievableKnowledge);
        }
        for (PromptStudio promptStudio : this.promptStudioDAO.list(this.targetProjectKey)) {
            boolean wasRemapped4 = connectionRemapper.remapPromptStudio(promptStudio);
            if (!wasRemapped4) continue;
            logger.infoV("Saving remapped prompt studio %s", new Object[]{promptStudio.id});
            this.promptStudioDAO.save(promptStudio);
        }
        for (AgentTool agentTool : this.agentToolsDAO.list(this.targetProjectKey)) {
            boolean wasRemapped5 = connectionRemapper.remapAgentTool(agentTool);
            if (!wasRemapped5) continue;
            logger.infoV("Saving remapped agent tool %s", new Object[]{agentTool.id});
            this.agentToolsDAO.save(agentTool);
        }
        for (LambdaService lambdaService : this.lambdaServicesDAO.list(this.targetProjectKey)) {
            LambdaService lambdaService2 = (LambdaService)this.lambdaServicesDAO.getOrNull(lambdaService.projectKey, lambdaService.id);
            boolean wasRemapped6 = connectionRemapper.remapLambdaService(lambdaService2);
            if (!wasRemapped6) continue;
            logger.infoV("Saving remapped API service %s", new Object[]{lambdaService2.id});
            this.lambdaServicesDAO.save(lambdaService2);
        }
        for (AnalysisCoreParams analysisCoreParams : this.analysisCRUDService.listCoreUnsafe(this.targetProjectKey, null)) {
            for (MLTask mlTask : this.analysisCRUDService.listRawMLTasks(this.targetProjectKey, analysisCoreParams.id)) {
                boolean wasRemapped7 = connectionRemapper.remapMLTask(mlTask);
                if (!wasRemapped7) continue;
                logger.infoV("Saving remapped ML task %s.%s", new Object[]{analysisCoreParams.id, mlTask.id});
                this.analysisCRUDService.saveMLTask(new MLTaskLoc(this.targetProjectKey, analysisCoreParams.id, mlTask.id), mlTask, true);
            }
        }
    }

    private AbstractCodeEnvRemapper buildCodeEnvRemapper(ExportedProject ep) {
        return this.buildCodeEnvRemapper(ep, this.importSettings.remapping);
    }

    private void executeCodeEnvRemapping(AuthCtx user, ExportedProject ep) throws Exception {
        SerializedProject sp;
        AbstractCodeEnvRemapper codeEnvRemapper = this.buildCodeEnvRemapper(ep);
        if (codeEnvRemapper.remapProject(sp = this.projectsDAO.getMandatoryUnsafe(this.targetProjectKey))) {
            logger.infoV("Saving remapped project %s", new Object[]{sp.name});
            this.projectsDAO.save(sp);
        }
        for (SerializedRecipe sr : this.recipesDAO.list(this.targetProjectKey)) {
            Object newPayload;
            if (codeEnvRemapper.remap(sr)) {
                logger.infoV("Saving remapped recipe %s", new Object[]{sr.name});
                this.recipesDAO.save(this.targetProjectKey, sr.name, sr, null);
            }
            if ((newPayload = codeEnvRemapper.remapPayload(sr)) == null) continue;
            logger.infoV("Saving remapped recipe payload %s", new Object[]{sr.name});
            this.recipesDAO.save(this.targetProjectKey, sr.name, sr, JSON.pretty((Object)newPayload));
        }
        for (SerializedDataset sd : this.datasetsDAO.list(this.targetProjectKey)) {
            if (!codeEnvRemapper.remap(sd)) continue;
            logger.infoV("Saving remapped dataset %s", new Object[]{sd.name});
            this.datasetsDAO.save(sd);
        }
        for (JupyterUtils.JupyterNotebookListEntry nbk : this.jupyterService.listUnsafe(user, this.targetProjectKey)) {
            RelFile rf = this.jupyterService.getNotebookFile(this.targetProjectKey, nbk.name);
            RWTransactionRef t = TransactionContext.retrieveWrite();
            JsonObject notebook = (JsonObject)t.readObjectUnsafe(rf, JsonObject.class);
            if (!codeEnvRemapper.remapNotebook(nbk.name, notebook)) continue;
            logger.infoV("Saving remapped notebook %s", new Object[]{nbk.name});
            t.writeObject(rf, (Object)notebook);
        }
        for (Scenario scenario : this.scenariosService.list(this.targetProjectKey)) {
            if (!codeEnvRemapper.remap(scenario)) continue;
            logger.infoV("Saving remapped scenario %s", new Object[]{scenario.name});
            this.scenariosService.save(this.targetProjectKey, scenario);
        }
        for (WebApp webApp : this.webAppsDAO.list(this.targetProjectKey)) {
            if (!codeEnvRemapper.remap(webApp)) continue;
            logger.infoV("Saving remapped webApp %s", new Object[]{webApp.name});
            this.webAppsDAO.save(webApp);
        }
        for (Report report : this.reportsDAO.list(this.targetProjectKey)) {
            if (!codeEnvRemapper.remap(report)) continue;
            logger.infoV("Saving remapped report %s", new Object[]{report.name});
            this.reportsDAO.save(report, null);
        }
        for (LambdaService service : this.lambdaServicesDAO.list(this.targetProjectKey)) {
            service = (LambdaService)this.lambdaServicesDAO.getOrNull(service.projectKey, service.id);
            if (!codeEnvRemapper.remap(service)) continue;
            logger.infoV("Saving remapped API service %s", new Object[]{service.id});
            this.lambdaServicesDAO.save(service);
        }
        for (AnalysisCoreParams acp : this.analysisCRUDService.listCoreUnsafe(this.targetProjectKey, null)) {
            for (MLTask task : this.analysisCRUDService.listRawMLTasks(this.targetProjectKey, acp.id)) {
                if (!codeEnvRemapper.remap(acp, task)) continue;
                logger.infoV("Saving remapped ML task %s.%s", new Object[]{acp.id, task.id});
                this.analysisCRUDService.saveMLTask(new MLTaskLoc(this.targetProjectKey, acp.id, task.id), task, true);
            }
        }
        for (RetrievableKnowledge rk : this.retrievableKnowledgeDAO.list(this.targetProjectKey)) {
            if (!codeEnvRemapper.remap(rk)) continue;
            logger.infoV("Saving remapped Retrievable Knowledge %s", new Object[]{rk.id});
            this.retrievableKnowledgeDAO.save(rk);
        }
        for (AgentTool at : this.agentToolsDAO.list(this.targetProjectKey)) {
            if (!codeEnvRemapper.remap(at)) continue;
            logger.infoV("Saving remapped Agent Tool %s", new Object[]{at.id});
            this.agentToolsDAO.save(at);
        }
    }

    private void executeContainerExecRemapping(AuthCtx user, ExportedProject ep) throws Exception {
        if (!this.importSettings.remapping.enableContainerExecRemapping) {
            logger.info((Object)"Skipping container exec remapping.");
            return;
        }
        ContainerExecRemapper containerExecRemapper = new ContainerExecRemapper(this.authCtx, this.importSettings.remapping, ep);
        SerializedProject sp = this.projectsDAO.getMandatory(this.targetProjectKey);
        if (containerExecRemapper.remapProject(sp)) {
            logger.infoV("Saving remapped project %s", new Object[]{sp.name});
            this.projectsDAO.save(sp);
        }
        for (SerializedRecipe sr : this.recipesDAO.list(this.targetProjectKey)) {
            Object newPayload;
            if (containerExecRemapper.remapRecipe(sr)) {
                logger.infoV("Saving remapped recipe %s", new Object[]{sr.name});
                this.recipesDAO.save(this.targetProjectKey, sr.name, sr, null);
            }
            if ((newPayload = containerExecRemapper.remapRecipePayload(sr)) == null) continue;
            logger.infoV("Saving remapped recipe payload %s", new Object[]{sr.name});
            this.recipesDAO.save(this.targetProjectKey, sr.name, sr, JSON.pretty((Object)newPayload));
        }
        for (JupyterUtils.JupyterNotebookListEntry nbk : this.jupyterService.listUnsafe(user, this.targetProjectKey)) {
            RelFile rf = this.jupyterService.getNotebookFile(this.targetProjectKey, nbk.name);
            RWTransactionRef t = TransactionContext.retrieveWrite();
            JsonObject notebook = (JsonObject)t.readObject(rf, JsonObject.class);
            if (!containerExecRemapper.remapNotebook(nbk.name, notebook)) continue;
            logger.infoV("Saving remapped notebook %s", new Object[]{nbk.name});
            t.writeObject(rf, (Object)notebook);
        }
        for (WebApp webApp : this.webAppsDAO.list(this.targetProjectKey)) {
            if (!containerExecRemapper.remapWebApp(webApp)) continue;
            logger.infoV("Saving remapped webApp %s", new Object[]{webApp.name});
            this.webAppsDAO.save(webApp);
        }
        for (AnalysisCoreParams acp : this.analysisCRUDService.listCoreUnsafe(this.targetProjectKey, null)) {
            for (MLTask task : this.analysisCRUDService.listRawMLTasks(this.targetProjectKey, acp.id)) {
                if (!containerExecRemapper.remapAnalysis(acp, task)) continue;
                logger.infoV("Saving remapped ML task %s.%s", new Object[]{acp.id, task.id});
                this.analysisCRUDService.saveMLTask(new MLTaskLoc(this.targetProjectKey, acp.id, task.id), task, true);
            }
        }
        for (RetrievableKnowledge rk : this.retrievableKnowledgeDAO.list(this.targetProjectKey)) {
            if (!containerExecRemapper.remapRetrievableKnowledge(rk)) continue;
            logger.infoV("Saving remapped Retrievable Knowledge %s", new Object[]{rk.id});
            this.retrievableKnowledgeDAO.save(rk);
        }
        for (AgentTool agentTool : this.agentToolsDAO.list(this.targetProjectKey)) {
            if (!containerExecRemapper.remapAgentTool(agentTool)) continue;
            logger.infoV("Saving remapped Agent Tool %s", new Object[]{agentTool.getDisplayName()});
            this.agentToolsDAO.save(agentTool);
        }
    }

    private void executeAnalysisDataCodeEnvRemappingNoFail(ExportedProject ep) {
        AbstractCodeEnvRemapper codeEnvRemapper = this.buildCodeEnvRemapper(ep);
        try {
            HashMap<AnalysisCoreParams, List<MLTask>> acps = new HashMap<AnalysisCoreParams, List<MLTask>>();
            try (Transaction t = this.transactionService.beginRead();){
                for (AnalysisCoreParams acp : this.analysisCRUDService.listCoreUnsafe(this.targetProjectKey, null)) {
                    acps.put(acp, this.analysisCRUDService.listRawMLTasks(this.targetProjectKey, acp.id));
                }
            }
            for (Map.Entry entry : acps.entrySet()) {
                for (MLTask mlTask : (List)entry.getValue()) {
                    if (!codeEnvRemapper.remapTrainedModels((AnalysisCoreParams)entry.getKey(), mlTask)) continue;
                    logger.infoV("Remapped code-env of MlTask %s", new Object[]{mlTask.id});
                }
            }
        }
        catch (Exception e) {
            logger.info((Object)("Failed to remap code-env for imported analysis data of '" + this.targetProjectKey + "'"), (Throwable)e);
        }
    }

    protected void executeAnalysisDataContainerExecRemappingNoFail(ExportedProject ep) {
        if (!this.importSettings.remapping.enableContainerExecRemapping) {
            logger.info((Object)"Skipping container exec remapping in analysis data.");
            return;
        }
        try {
            this.executeAnalysisDataContainerExecRemapping(ep, this.importSettings.remapping);
        }
        catch (Exception e) {
            logger.info((Object)("Failed to remap container exec for imported analysis data of '" + this.targetProjectKey + "'"), (Throwable)e);
        }
    }

    private void executeAnalysisDataConnectionRemappingNoFail(ExportedProject ep) {
        try {
            this.executeCompletedAnalysisRemapping(ep, this.importSettings.remapping);
        }
        catch (Exception e) {
            logger.info((Object)("Failed to remap connection for imported analysis data of '" + this.targetProjectKey + "'"), (Throwable)e);
        }
    }

    private void executeSavedModelDataCodeEnvRemappingNoFail(ExportedProject ep) {
        AbstractCodeEnvRemapper codeEnvRemapper = this.buildCodeEnvRemapper(ep);
        try {
            List sms;
            try (Transaction t = this.transactionService.beginRead();){
                sms = this.savedModelsDAO.listUnsafe(this.targetProjectKey);
            }
            for (SavedModel sm : sms) {
                if (!codeEnvRemapper.remapSavedModels(sm)) continue;
                String message = "Remapped code-env of saved model " + sm.id;
                if (sm.savedModelType == SavedModel.SavedModelType.PYTHON_AGENT) {
                    try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(this.authCtx);){
                        this.savedModelsDAO.save(sm);
                        t.commit(message);
                    }
                }
                logger.info((Object)message);
            }
        }
        catch (Exception e) {
            logger.info((Object)("Failed to remap code-env for imported saved model data of '" + this.targetProjectKey + "'"), (Throwable)e);
        }
    }

    protected void executeSavedModelContainerExecRemappingNoFail(ExportedProject ep) {
        if (!this.importSettings.remapping.enableContainerExecRemapping) {
            logger.info((Object)"Skipping container exec remapping in saved model data.");
            return;
        }
        try {
            this.executeSavedModelContainerExecRemapping(ep, this.importSettings.remapping);
        }
        catch (Exception e) {
            logger.info((Object)("Failed to remap container exec for imported saved model data of '" + this.targetProjectKey + "'"), (Throwable)e);
        }
    }

    private void executeSavedModelConnectionRemappingNoFail(ExportedProject ep) {
        try {
            this.executeSavedModelConnectionRemapping(ep, this.importSettings.remapping);
        }
        catch (Exception e) {
            logger.info((Object)("Failed to remap connection for imported saved model data of '" + this.targetProjectKey + "'"), (Throwable)e);
        }
    }

    private void executeModelEvaluationConnectionRemappingNoFail(ExportedProject ep) {
        try {
            this.executeModelEvaluationConnectionRemapping(ep, this.importSettings.remapping);
        }
        catch (Exception e) {
            logger.info((Object)("Failed to remap connection for imported evaluation store of '" + this.targetProjectKey + "'"), (Throwable)e);
        }
    }

    private void executeKnowledgeBankDataImagesFolderRemappingNoFail(ExportedProject ep) {
        try {
            this.executeKnowledgeBankDataImagesFolderRemapping(ep);
        }
        catch (Exception e) {
            logger.info((Object)"Failed to remap images folder id for imported knowledge bank of '%s'".formatted(this.targetProjectKey), (Throwable)e);
        }
    }

    private void executeKnowledgeBankDataConnectionRemappingNoFail(ExportedProject ep) {
        try {
            this.executeKnowledgeBankDataConnectionRemapping(ep, this.importSettings.remapping);
        }
        catch (Exception e) {
            logger.info((Object)"Failed to remap connection for imported knowledge bank of '%s'".formatted(this.targetProjectKey), (Throwable)e);
        }
    }

    private void executeKnowledgeBankDataCodeEnvRemappingNoFail(ExportedProject ep) {
        try {
            this.executeKnowledgeBankDataCodeEnvRemapping(ep, this.importSettings.remapping);
        }
        catch (Exception e) {
            logger.info((Object)"Failed to remap code env for imported knowledge bank of '%s'".formatted(this.targetProjectKey), (Throwable)e);
        }
    }

    private void executeKnowledgeBankDataContainerExecRemappingNoFail(ExportedProject ep) {
        if (!this.importSettings.remapping.enableContainerExecRemapping) {
            logger.info((Object)"Skipping container exec remapping in knowledge banks data.");
            return;
        }
        try {
            this.executeKnowledgeBankDataContainerExecRemapping(ep, this.importSettings.remapping);
        }
        catch (Exception e) {
            logger.info((Object)"Failed to remap container exec for imported knowledge bank of '%s'".formatted(this.targetProjectKey), (Throwable)e);
        }
    }

    public static class ProjectImportSettings {
        public String targetProjectKey;
        public String importType;
        public ProjectRemappingSettings remapping = new ProjectRemappingSettings();
        public String targetProjectFolderId;
        public boolean createBranch = false;
    }

    public static class ProjectImportResult
    extends InfoMessage.InfoMessages {
        public String usedProjectKey;
        public boolean neededAMigration;
        public List<DatasetConnectionUtils.UsedConnection> usedConnections = new ArrayList<DatasetConnectionUtils.UsedConnection>();
    }

    public class PrepareImportResponse {
        public String originalProjectKey;
        public List<DatasetConnectionUtils.UsedConnection> usedConnections = new ArrayList<DatasetConnectionUtils.UsedConnection>();
        public List<RecipesCRUDController.ManagedDatasetConnection> availableConnections = new ArrayList<RecipesCRUDController.ManagedDatasetConnection>();
        public List<CodeEnvModel.UsedCodeEnvRef> usedCodeEnvs = new ArrayList<CodeEnvModel.UsedCodeEnvRef>();
        public List<CodeEnvModel.CodeEnvListItem> availableCodeEnvs = new ArrayList<CodeEnvModel.CodeEnvListItem>();
        public List<UsedContainerExec> usedContainerExecConfs = new ArrayList<UsedContainerExec>();
        public List<ContainerExecRuntimeConfig> availableContainerExecConfs = new ArrayList<ContainerExecRuntimeConfig>();
    }
}

