/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scoring.exports.snowflake;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.scoring.exports.JarScoring;
import com.dataiku.dip.scoring.exports.ScoringExporter;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import com.dataiku.scoring.builders.Build;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.annotation.Nullable;

public class JarsBuilder {
    private final File workDir;
    private final FullModelId fmi;
    private final String modelSuffixIdentifier;
    private File scoringJarFile;
    private File wrapperJarFile;
    private String finalClassName;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku");

    public JarsBuilder(File workDir, FullModelId fmi, String modelSuffixIdentifier) {
        this.workDir = workDir;
        this.fmi = fmi;
        this.modelSuffixIdentifier = modelSuffixIdentifier;
    }

    public List<File> getFilesToUploadToSnowflake() throws IOException {
        return Lists.newArrayList((Object[])new File[]{this.scoringJarFile, this.wrapperJarFile, DKUApp.getDataikuApplicationStringF()});
    }

    public String getClassFullyQualifiedName() {
        return "dsssnowflake." + this.finalClassName;
    }

    public void compileAndPackageJar(Build.DssPipelineMeta meta) throws Exception {
        this.compileAndPackageJar(meta, null);
    }

    public void compileAndPackageJar(Build.DssPipelineMeta meta, @Nullable Double forcedClassifierThreshold) throws Exception {
        String baseClassName = "BaseGeneratedModel" + this.modelSuffixIdentifier;
        this.finalClassName = "SnowflakeGeneratedModel" + this.modelSuffixIdentifier;
        this.scoringJarFile = new File(this.workDir, "snowflake-generated-base-model.jar");
        try (FileOutputStream fos = new FileOutputStream(this.scoringJarFile);){
            ScoringExporter exporter = new ScoringExporter(new JarScoring(true, this.fmi, "dsssnowflake." + baseClassName));
            exporter.exportToStream(fos);
        }
        Object source = "package dsssnowflake;\n";
        switch (meta.type) {
            case REGRESSION: {
                source = (String)source + "public class " + this.finalClassName + " extends com.dataiku.scoring.generated.snowflake.SnowflakeRegressionBaseModel {\n";
                source = (String)source + "static { model = new dsssnowflake." + baseClassName + "(); } }\n";
                break;
            }
            case CLASSIFICATION_ONLY: {
                throw new Error("unsupported classif only");
            }
            case BINARY_PROBABILISTIC: {
                source = (String)source + "public class " + this.finalClassName + " extends com.dataiku.scoring.generated.snowflake.SnowflakeBinaryClassificationBaseModel {\n";
                source = (String)source + "static { model = new dsssnowflake." + baseClassName + "(" + forcedClassifierThreshold + "); } }\n";
                break;
            }
            case MULTICLASS_PROBABILISTIC: {
                source = (String)source + "public class " + this.finalClassName + " extends com.dataiku.scoring.generated.snowflake.SnowflakeMulticlassBaseModel {\n";
                source = (String)source + "static { model = new dsssnowflake." + baseClassName + "(); } }\n";
            }
        }
        File sourceFile = new File(this.workDir, "dsssnowflake/" + this.finalClassName + ".java");
        DKUFileUtils.mkdirsParent((File)sourceFile);
        DKUFileUtils.writeFileUTF8((File)sourceFile, (String)source);
        String javaHome = System.getProperty("java.home");
        File javaCompiler = new File(javaHome + "/bin/javac");
        if (!javaCompiler.exists()) {
            throw new IllegalArgumentException("No suitable java compiler found in JAVA_HOME: " + javaHome);
        }
        String jarName = "snowflake-generated-model-wrapper.jar";
        logger.info((Object)("Will use " + javaCompiler.getAbsolutePath() + " to compile " + jarName));
        ProcessBuilder pb = new ProcessBuilder(javaCompiler.getAbsolutePath(), "--release", "17", "-cp", this.scoringJarFile.getAbsolutePath() + ":" + String.valueOf(DKUApp.getInstallFile((String[])new String[]{"dist", "dataiku-scoring.jar"})), sourceFile.getPath());
        DKUtils.execAndLogThrows((ProcessBuilder)pb);
        File classFile = new File(this.workDir, "dsssnowflake/" + this.finalClassName + ".class");
        this.wrapperJarFile = new File(this.workDir, jarName);
        try (FileOutputStream fos = new FileOutputStream(this.wrapperJarFile);){
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            try (JarOutputStream jar = new JarOutputStream((OutputStream)fos, manifest);){
                JarEntry clazzEntry = new JarEntry("dsssnowflake/" + this.finalClassName + ".class");
                jar.putNextEntry(clazzEntry);
                jar.write(Files.toByteArray((File)classFile));
                jar.flush();
                jar.closeEntry();
            }
        }
        logger.info((Object)("Jar compiled successfully to " + this.wrapperJarFile.getAbsolutePath()));
    }
}

