/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.dao.InterestsInternalDB;
import com.dataiku.dip.discussions.DiscussionsCacheService;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public class InterestsController
extends DIPInternalControllerBase {
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private DiscussionsCacheService discussionsCacheService;

    @AuditedCall(value={"msgType", "interests-get", "user", "${user}"})
    @RequestMapping(value={"/api/interests/get-user-interests"})
    @ResponseBody
    public InterestsService.InterestsResponse getUserInterests(HttpServletRequest req, @RequestParam String user, @RequestParam String offset, @RequestParam String maxItems, @RequestParam(required=false) TaggableObjectsService.TaggableObjectFilter filters, @RequestParam(required=false) boolean starsOnly) throws IOException, UnauthorizedException {
        int limit = Integer.parseInt(maxItems);
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx ctx = this.authService.getMandatoryUser(req);
            if (!user.equals(ctx.getAssociatedDSSUser())) {
                throw new SecurityException("You are not allowed to see other users settings");
            }
        }
        return this.interestsService.getUserInterests_NT(user, Integer.parseInt(offset), filters, limit, starsOnly);
    }

    @AuditedCall(value={"msgType", "interests-get", "objectId", "${objectId}", "projectKey", "${projectKey}", "workspaceKey", "${workspaceKey}"})
    @RequestMapping(value={"/api/interests/get-interest-for-object"})
    public void getForObject(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String objectType, @RequestParam String objectId, @RequestParam(required=false) String workspaceKey) throws Exception {
        AuthCtx authCtx;
        ITaggingService.TaggableType objType = ITaggingService.TaggableType.valueOf(objectType);
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkReadDashboardPerm(authCtx, projectKey, objType, objectId);
        }
        InterestsInternalDB.Interest out = this.interestsService.getObjectAndUserInterest_NT(authCtx, objType, projectKey, objectId, workspaceKey);
        InterestsController.writeJSON((HttpServletResponse)resp, (Object)out);
    }

    @AuditedCall(value={"msgType", "get-project-folders-interests"})
    @RequestMapping(value={"/api/interests/get-project-folders-interests"})
    @ResponseBody
    public InterestsService.ProjectFoldersInterestsResponse getProjectFoldersInterests(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.interestsService.getProjectFoldersUserInterests(authCtx);
    }

    @AuditedCall(value={"msgType", "interests-watch", "objecs", "${objects}", "watch", "${watch}"})
    @RequestMapping(value={"/api/interests/watch"})
    @ResponseStatus(value=HttpStatus.OK)
    public void watch(HttpServletRequest req, @RequestParam List<TaggableObjectsService.TaggableObjectRef> items, @RequestParam InterestsInternalDB.Watching watch) throws Exception {
        AuthCtx authCtx = this.checkReadDashboardPermission(req, items);
        for (TaggableObjectsService.TaggableObjectRef ref : items) {
            AnyLoc loc = ref.getLoc().resolved();
            this.interestsService.setWatch_NT(authCtx, ref.type, loc.getProjectKey(), loc.getId(), ref.workspaceKey, watch);
        }
        for (String pkey : this.listImpactedProjects(items)) {
            this.discussionsCacheService.watchChanged(authCtx.getIdentifier(), pkey, null);
        }
        for (String wkey : this.listImpactedWorkspaces(items)) {
            this.discussionsCacheService.watchChanged(authCtx.getIdentifier(), null, wkey);
        }
    }

    @AuditedCall(value={"msgType", "interests-star", "objectId", "${objectId}", "projectKey", "${projectKey}", "star", "${star}"})
    @RequestMapping(value={"/api/interests/star"})
    @ResponseStatus(value=HttpStatus.OK)
    public void star(HttpServletRequest req, @RequestParam List<TaggableObjectsService.TaggableObjectRef> items, @RequestParam String star) throws Exception {
        AuthCtx authCtx = this.checkReadDashboardPermission(req, items);
        for (TaggableObjectsService.TaggableObjectRef ref : items) {
            AnyLoc loc = ref.getLoc().resolved();
            this.interestsService.setStar_NT(authCtx, ref.type, loc.getProjectKey(), loc.getId(), ref.workspaceKey, "true".equals(star));
        }
    }

    @AuditedCall(value={"msgType", "interests-star", "projectFolderIds", "{projectFolderIds}", "star", "${star}"})
    @RequestMapping(value={"/api/interests/star-project-folders"})
    @ResponseStatus(value=HttpStatus.OK)
    public void starProjectFolder(HttpServletRequest req, @RequestParam List<String> projectFolderIds, @RequestParam boolean star) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            for (String projectFolderId : projectFolderIds) {
                this.permissionsService.checkProjectFolderPrivilege(authCtx, projectFolderId, Privileges.ProjectFolderLevelPrivilegeType.READ);
            }
        }
        for (String projectFolderId : projectFolderIds) {
            this.interestsService.setProjectFolderStar_NT(authCtx, projectFolderId, star);
        }
    }

    @AuditedCall(value={"msgType", "interests-users-list", "objectId", "${objectId}", "projectKey", "${projectKey}", "workspaceKey", "${workspaceKey}"})
    @RequestMapping(value={"/api/interests/list-watching-users"})
    public void listWatchingUsers(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String objectType, @RequestParam String objectId, @RequestParam(required=false) String workspaceKey) throws Exception {
        List<PublicUser> out;
        try (Transaction ignored = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        Set<String> logins = this.interestsService.getEffectiveWatchingUsers_NT(ITaggingService.TaggableType.valueOf(objectType), projectKey, objectId, null, workspaceKey);
        try (Transaction ignored = this.transactionService.beginRead();){
            out = this.usersService.getPublicUsers(logins);
        }
        InterestsController.writeJSON((HttpServletResponse)resp, out);
    }

    @AuditedCall(value={"msgType", "interests-users-list", "objectId", "${objectId}", "projectKey", "${projectKey}", "workspaceKey", "${workspaceKey}"})
    @RequestMapping(value={"/api/interests/list-users-with-star"})
    public void listUsersWithStar(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String objectType, @RequestParam String objectId, @RequestParam(required=false) String workspaceKey) throws Exception {
        List<PublicUser> out;
        try (Transaction ignored = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        List<String> logins = this.interestsService.getUsersWithStar_NT(ITaggingService.TaggableType.valueOf(objectType), projectKey, objectId, workspaceKey);
        try (Transaction ignored = this.transactionService.beginRead();){
            out = this.usersService.getPublicUsers(logins);
        }
        InterestsController.writeJSON((HttpServletResponse)resp, out);
    }

    private AuthCtx checkReadDashboardPermission(HttpServletRequest req, List<TaggableObjectsService.TaggableObjectRef> items) throws IOException, DKUSecurityException {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            for (TaggableObjectsService.TaggableObjectRef ref : items) {
                AnyLoc loc = ref.getLoc().resolved();
                this.permissionsService.checkReadDashboardPermission(authCtx, loc.getProjectKey(), ref.type, loc.getId());
            }
        }
        return authCtx;
    }

    private Set<String> listImpactedProjects(List<TaggableObjectsService.TaggableObjectRef> items) {
        HashSet<String> authorizedProjectKeys = new HashSet<String>();
        for (TaggableObjectsService.TaggableObjectRef ref : items) {
            if (!StringUtils.isNotBlank((String)ref.projectKey)) continue;
            AnyLoc loc = ref.getLoc().resolved();
            authorizedProjectKeys.add(ref.projectKey);
            authorizedProjectKeys.add(loc.getProjectKey());
        }
        return authorizedProjectKeys;
    }

    private Set<String> listImpactedWorkspaces(List<TaggableObjectsService.TaggableObjectRef> items) {
        HashSet<String> authorizedWorkspaceKeys = new HashSet<String>();
        for (TaggableObjectsService.TaggableObjectRef ref : items) {
            if (!StringUtils.isNotBlank((String)ref.workspaceKey)) continue;
            authorizedWorkspaceKeys.add(ref.workspaceKey);
        }
        return authorizedWorkspaceKeys;
    }
}

