/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.apideployer.datamodel.actual.APIServiceDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.actual.APIServiceEndpointMonitoring;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentBasicInfo;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentLightStatus;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractPublishedItemLightStatus;
import com.dataiku.dip.apideployer.datamodel.actual.PublishedApiServicePackageInfo;
import com.dataiku.dip.apideployer.deployments.APIServiceDeploymentsService;
import com.dataiku.dip.apideployer.deployments.ProjectDeploymentsService;
import com.dataiku.dip.apideployer.deployments.QueryableEndpoint;
import com.dataiku.dip.apideployer.published.PublishedAPIServicesService;
import com.dataiku.dip.apideployer.published.PublishedProjectsService;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.nodeclients.APIDeployerClientProxyUser;
import com.dataiku.dip.nodeclients.ProjectDeployerClientProxyUser;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.openapi.OpenAPIHelper;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dss.shadelib.io.swagger.models.Operation;
import com.dataiku.dss.shadelib.io.swagger.models.Swagger;
import com.dataiku.lambda.model.serverconfig.LambdaEndpointConfig;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class InternalDeployerController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private PublishedProjectsService publishedProjectsService;
    @Autowired
    private PublishedAPIServicesService publishedAPIServicesService;
    @Autowired
    private ProjectDeploymentsService projectDeploymentsService;
    @Autowired
    private APIServiceDeploymentsService apiServiceDeploymentsService;

    @AuditedCall(value={"msgType", "list-published-projects"})
    @RequestMapping(value={"/api/project-deployer/client/published-projects/list-light-status"})
    @ResponseBody
    public List<? extends AbstractPublishedItemLightStatus> listPublishedProjectLightStatus(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx user;
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        gs.deployerClientSettings.check();
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        GeneralSettingsDAO.DeployerRef ref = gs.deployerClientSettings.getRef();
        switch (ref.mode) {
            case DISABLED: {
                throw ErrorContext.iae((String)"Deployer support is disabled");
            }
            case LOCAL: {
                return this.publishedProjectsService.listLightStatusUnsafe_NT_Check(user);
            }
            case REMOTE: {
                try (ProjectDeployerClientProxyUser client = new ProjectDeployerClientProxyUser(ref, user);){
                    List<AbstractPublishedItemLightStatus.PublishedProjectLightStatus> list = client.listPublishedProjectLightStatus();
                    return list;
                }
            }
        }
        throw ErrorContext.iaef((String)"Invalid mode for Deployer: %s", (Object)((Object)ref.mode), (Object[])new Object[0]);
    }

    @AuditedCall(value={"msgType", "list-published-services"})
    @RequestMapping(value={"/api/api-deployer/client/published-api-services/list-light-status"})
    @ResponseBody
    public List<? extends AbstractPublishedItemLightStatus> listPublishedServiceLightStatus(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx user;
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        gs.deployerClientSettings.check();
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        GeneralSettingsDAO.DeployerRef ref = gs.deployerClientSettings.getRef();
        switch (ref.mode) {
            case DISABLED: {
                throw ErrorContext.iae((String)"Deployer support is disabled");
            }
            case LOCAL: {
                return this.publishedAPIServicesService.listLightStatusUnsafe_NT_Check(user);
            }
            case REMOTE: {
                try (APIDeployerClientProxyUser client = new APIDeployerClientProxyUser(ref, user);){
                    List<AbstractPublishedItemLightStatus.PublishedAPIServiceLightStatus> list = client.listPublishedServiceLightStatus();
                    return list;
                }
            }
        }
        throw ErrorContext.iaef((String)"Invalid mode for Deployer: %s", (Object)((Object)ref.mode), (Object[])new Object[0]);
    }

    @AuditedCall(value={"msgType", "list-project-deployments"})
    @RequestMapping(value={"/api/project-deployer/client/deployments/list-light-status"})
    @ResponseBody
    public List<? extends AbstractDeploymentLightStatus> listProjectDeploymentLightStatus(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx user;
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        gs.deployerClientSettings.check();
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        GeneralSettingsDAO.DeployerRef ref = gs.deployerClientSettings.getRef();
        switch (ref.mode) {
            case DISABLED: {
                throw ErrorContext.iae((String)"Deployer support is disabled");
            }
            case LOCAL: {
                return this.projectDeploymentsService.listLightStatusUnsafe_NT_Check(user);
            }
            case REMOTE: {
                try (ProjectDeployerClientProxyUser client = new ProjectDeployerClientProxyUser(ref, user);){
                    List<AbstractDeploymentLightStatus.ProjectDeploymentLightStatus> list = client.listDeploymentLightStatus();
                    return list;
                }
            }
        }
        throw ErrorContext.iaef((String)"Invalid mode for Deployer: %s", (Object)((Object)ref.mode), (Object[])new Object[0]);
    }

    @AuditedCall(value={"msgType", "list-api-deployments"})
    @RequestMapping(value={"/api/api-deployer/client/deployments/list-light-status"})
    @ResponseBody
    public List<? extends AbstractDeploymentLightStatus> listApiDeploymentLightStatus(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx user;
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        gs.deployerClientSettings.check();
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        GeneralSettingsDAO.DeployerRef ref = gs.deployerClientSettings.getRef();
        switch (ref.mode) {
            case DISABLED: {
                throw ErrorContext.iae((String)"Deployer support is disabled");
            }
            case LOCAL: {
                return this.apiServiceDeploymentsService.listLightStatusUnsafe_NT_Check(user);
            }
            case REMOTE: {
                try (APIDeployerClientProxyUser client = new APIDeployerClientProxyUser(ref, user);){
                    List<AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus> list = client.listDeploymentLightStatus();
                    return list;
                }
            }
        }
        throw ErrorContext.iaef((String)"Invalid mode for Deployer: %s", (Object)((Object)ref.mode), (Object[])new Object[0]);
    }

    @AuditedCall(value={"msgType", "published-service-get-heavy-status", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/api-deployer/client/deployments/status"})
    @ResponseBody
    public APIServiceDeploymentHeavyStatus getApiServiceDeploymentHeavyStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId) throws Exception {
        AuthCtx user;
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        gs.deployerClientSettings.check();
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        GeneralSettingsDAO.DeployerRef ref = gs.deployerClientSettings.getRef();
        switch (ref.mode) {
            case DISABLED: {
                throw ErrorContext.iae((String)"Deployer support is disabled");
            }
            case LOCAL: {
                return this.apiServiceDeploymentsService.getHeavyStatus_Unsafe_NT_Check(user, deploymentId, true);
            }
            case REMOTE: {
                try (APIDeployerClientProxyUser client = new APIDeployerClientProxyUser(ref, user);){
                    APIServiceDeploymentHeavyStatus aPIServiceDeploymentHeavyStatus = client.getDeploymentHeavyStatus(deploymentId);
                    return aPIServiceDeploymentHeavyStatus;
                }
            }
        }
        throw ErrorContext.iaef((String)"Invalid mode for Deployer: %s", (Object)((Object)ref.mode), (Object[])new Object[0]);
    }

    @AuditedCall(value={"msgType", "list-api-deployments"})
    @RequestMapping(value={"/api/api-deployer/client/endpoints/list"})
    @ResponseBody
    public List<Endpoint> listEndpoints(HttpServletRequest req) throws Exception {
        List<AbstractDeploymentLightStatus> deployments;
        List<QueryableEndpoint> queryableEndpoints;
        AuthCtx user;
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        gs.deployerClientSettings.check();
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        ArrayList ret = new ArrayList();
        GeneralSettingsDAO.DeployerRef ref = gs.deployerClientSettings.getRef();
        switch (ref.mode) {
            case DISABLED: {
                throw ErrorContext.iae((String)"Deployer support is disabled");
            }
            case LOCAL: {
                queryableEndpoints = this.apiServiceDeploymentsService.listEndpointsQueryableThroughDeployer_Check(user);
                break;
            }
            case REMOTE: {
                try (APIDeployerClientProxyUser client = new APIDeployerClientProxyUser(ref, user);){
                    queryableEndpoints = client.listEndpointsQueryableThroughDeployer();
                    break;
                }
            }
            default: {
                throw ErrorContext.iaef((String)"Invalid mode for Deployer: %s", (Object)((Object)ref.mode), (Object[])new Object[0]);
            }
        }
        queryableEndpoints.forEach(endpoint -> {
            Endpoint queryableEndpoint = new Endpoint();
            queryableEndpoint.type = endpoint.type;
            queryableEndpoint.deploymentId = endpoint.deploymentId;
            queryableEndpoint.endpointId = endpoint.endpointId;
            queryableEndpoint.infrastructureId = endpoint.infrastructureId;
            queryableEndpoint.hasUsePermission = true;
            queryableEndpoint.description = endpoint.description;
            queryableEndpoint.hasOpenAPIDocumentation = endpoint.hasOpenAPIDocumentation;
            ret.add(queryableEndpoint);
        });
        Set queryableDeploymentIds = queryableEndpoints.stream().map(queryableEndpoint -> queryableEndpoint.deploymentId).collect(Collectors.toSet());
        switch (ref.mode) {
            case LOCAL: {
                deployments = this.apiServiceDeploymentsService.listLightStatusUnsafe_NT_Check(user);
                break;
            }
            case REMOTE: {
                try (APIDeployerClientProxyUser client = new APIDeployerClientProxyUser(ref, user);){
                    deployments = client.listDeploymentLightStatus();
                    break;
                }
            }
            default: {
                throw ErrorContext.iaef((String)"Invalid mode for Deployer: %s", (Object)((Object)ref.mode), (Object[])new Object[0]);
            }
        }
        for (AbstractDeploymentLightStatus deployment : deployments) {
            if (queryableDeploymentIds.contains(deployment.deploymentBasicInfo.id) || deployment.deploymentBasicInfo instanceof AbstractDeploymentBasicInfo.DatabricksDeploymentBasicInfo) continue;
            AbstractDeploymentBasicInfo.AbstractAPIServiceDeploymentBasicInfo deploymentBasicInfo = (AbstractDeploymentBasicInfo.AbstractAPIServiceDeploymentBasicInfo)deployment.deploymentBasicInfo;
            String deployedGeneration = deploymentBasicInfo.generationsMapping.getEntries().get((int)0).generation;
            PublishedApiServicePackageInfo publishedPackageInfo = deployment.packages.stream().filter(packageInfo -> packageInfo.id.equals(deployedGeneration)).findFirst().orElse(null);
            if (publishedPackageInfo == null) continue;
            publishedPackageInfo.endpoints.forEach(endpoint -> {
                Endpoint nonQueryableEndpoint = new Endpoint();
                nonQueryableEndpoint.type = endpoint.type;
                nonQueryableEndpoint.deploymentId = deployment.deploymentBasicInfo.id;
                nonQueryableEndpoint.endpointId = endpoint.id;
                nonQueryableEndpoint.infrastructureId = deployment.infraBasicInfo.id;
                nonQueryableEndpoint.hasUsePermission = false;
                try {
                    Swagger swagger;
                    Operation endpointOperation;
                    if (publishedPackageInfo.hasOpenAPIDoc && (endpointOperation = OpenAPIHelper.getEndpointOperation(swagger = OpenAPIHelper.getSwagger(publishedPackageInfo.openAPIDocContent), endpoint.id, endpoint.type)) != null) {
                        nonQueryableEndpoint.hasOpenAPIDocumentation = true;
                        nonQueryableEndpoint.description = endpointOperation.getDescription();
                    }
                }
                catch (Exception e) {
                    logger.info((Object)"Could not parse the openAPI documentation for endpoint %s of deployment %s, skipping".formatted(nonQueryableEndpoint.endpointId, nonQueryableEndpoint.deploymentId));
                }
                ret.add(nonQueryableEndpoint);
            });
        }
        return ret.stream().sorted(Comparator.comparing(Endpoint::hasUsePermission).thenComparing(Endpoint::hasOpenAPIDocumentation).reversed().thenComparing(Endpoint::getDeploymentId).thenComparing(Endpoint::getEndpointId)).collect(Collectors.toList());
    }

    @AuditedCall(value={"msgType", "api-services-monitoring"})
    @RequestMapping(value={"/api/api-deployer/client/api-services/monitoring"})
    @ResponseBody
    public APIServiceEndpointMonitoring getServiceEndpointMonitoring(HttpServletRequest req, HttpServletResponse resp, String apiServiceId, String endpointId) throws Exception {
        AuthCtx user;
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        gs.deployerClientSettings.check();
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        GeneralSettingsDAO.DeployerRef ref = gs.deployerClientSettings.getRef();
        switch (ref.mode) {
            case DISABLED: {
                throw ErrorContext.iae((String)"Deployer support is disabled");
            }
            case LOCAL: {
                return this.publishedAPIServicesService.getServiceEndpointMonitoring_NT(apiServiceId, endpointId, user);
            }
            case REMOTE: {
                try (APIDeployerClientProxyUser client = new APIDeployerClientProxyUser(ref, user);){
                    APIServiceEndpointMonitoring aPIServiceEndpointMonitoring = client.getServiceEndpointMonitoring(apiServiceId, endpointId);
                    return aPIServiceEndpointMonitoring;
                }
            }
        }
        throw ErrorContext.iaef((String)"Invalid mode for Deployer: %s", (Object)((Object)ref.mode), (Object[])new Object[0]);
    }

    private static class Endpoint {
        public LambdaEndpointConfig.EndpointType type;
        public String deploymentId;
        public String endpointId;
        public String infrastructureId;
        public String description = "No OpenAPI documentation";
        public boolean hasOpenAPIDocumentation;
        public boolean hasUsePermission;

        private Endpoint() {
        }

        public String getDeploymentId() {
            return this.deploymentId;
        }

        public String getEndpointId() {
            return this.endpointId;
        }

        public boolean hasOpenAPIDocumentation() {
            return this.hasOpenAPIDocumentation;
        }

        public boolean hasUsePermission() {
            return this.hasUsePermission;
        }
    }
}

