/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications;

import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.notifications.HrefContext;
import com.dataiku.dip.server.notifications.HrefMarkupFormatter;
import com.dataiku.dip.server.notifications.MarkupFormatter;
import com.dataiku.dip.server.notifications.NoLinkMarkupFormatter;
import com.dataiku.dip.server.notifications.backend.GeneralSettingsChangedEvent;
import com.dataiku.dip.server.notifications.backend.UserChangedEvent;
import com.dataiku.dip.server.notifications.markups.Markup;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MarkupFormattersService {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private UsersDAO usersDAO;
    @Autowired
    private PubSubService pubSub;
    private LoadingCache<Markup, MarkupFormatter> linkFactories = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Markup, MarkupFormatter>(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public MarkupFormatter load(Markup markup) {
            try (Transaction ignored = MarkupFormattersService.this.transactionService.beginRead();){
                GeneralSettingsDAO.GeneralSettings settings = MarkupFormattersService.this.generalSettingsDAO.read();
                if (StringUtils.isBlank((String)settings.studioExternalUrl)) {
                    logger.warn((Object)"DSS external URL is not set: cannot generate links to your instance");
                    NoLinkMarkupFormatter noLinkMarkupFormatter = new NoLinkMarkupFormatter(markup, MarkupFormattersService.this.usersDAO.listUsers());
                    return noLinkMarkupFormatter;
                }
                HrefContext href = new HrefContext(settings.studioExternalUrl);
                HrefMarkupFormatter hrefMarkupFormatter = new HrefMarkupFormatter(href, markup, MarkupFormattersService.this.usersDAO.listUsers());
                return hrefMarkupFormatter;
            }
            catch (Exception e) {
                logger.info((Object)"Failed to create link factory", (Throwable)e);
                return new NoLinkMarkupFormatter(markup, new ArrayList<UsersDAO.User>());
            }
        }
    });
    private static Logger logger = Logger.getLogger((String)"dku.notifications.links");

    public MarkupFormatter getMarkupFormatter(Markup markup) {
        return (MarkupFormatter)this.linkFactories.getUnchecked((Object)markup);
    }

    @PostConstruct
    public void init() {
        logger.debug((Object)"Init links service");
        SpringUtils.getInstance().autowire((Object)this);
        this.pubSub.subscribe("general-settings-changed", (DSSEventListener)new DSSEventListener<GeneralSettingsChangedEvent>(){

            public void on(GeneralSettingsChangedEvent evt) {
                MarkupFormattersService.this.linkFactories.invalidateAll();
            }
        });
        this.pubSub.subscribe("user-edited", (DSSEventListener)new DSSEventListener<UserChangedEvent>(){

            public void on(UserChangedEvent evt) {
                MarkupFormattersService.this.linkFactories.invalidateAll();
            }
        });
        logger.debug((Object)"Done init links service");
    }
}

