/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.FlowSavedModel;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetSparkInspector;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ServiceUtils {
    static DKULogger logger = DKULogger.getLogger((String)"dku.serviceutils");

    public static EngineUsability canSQL(AuthCtx authCtx, JobActivity activity, DatasetsDAO datasetsDAO) throws IOException, DKUSecurityException {
        List sourceDatasetsInMainRole = activity.getSubgraph().getSourcesWithRoles().stream().filter(s -> s.role == null || s.role.equals("main")).filter(s -> s.computable instanceof FlowDataset).map(s -> (FlowDataset)s.computable).collect(Collectors.toList());
        return ServiceUtils.areUsingSameSqlAbleConnection(sourceDatasetsInMainRole, authCtx, datasetsDAO);
    }

    public static DatasetInspector.SQLAbleFlavor getSQLAbleFlavor(AuthCtx authCtx, JobActivity activity, DatasetsDAO datasetsDAO) throws IOException, DKUSecurityException {
        List sourceDatasetsInMainRole = activity.getSubgraph().getSourcesWithRoles().stream().filter(s -> s.role == null || s.role.equals("main")).filter(s -> s.computable instanceof FlowDataset).map(s -> (FlowDataset)s.computable).collect(Collectors.toList());
        return ServiceUtils.getSQLAbleFlavor(sourceDatasetsInMainRole, authCtx, datasetsDAO);
    }

    public static DatasetInspector.SQLAbleFlavor getSQLAbleFlavor(AuthCtx authCtx, FlowRecipe recipe, DatasetsDAO datasetsDAO) throws IOException, DKUSecurityException {
        ArrayList<Object> computables = new ArrayList<Object>();
        List sourcesInMainRole = recipe.getSourcesWithRoles().stream().filter(s -> s.role == null || s.role.equals("main")).map(s -> s.computable).collect(Collectors.toList());
        computables.addAll(sourcesInMainRole);
        computables.addAll(recipe.getTargets());
        return ServiceUtils.getSQLAbleFlavor(computables, authCtx, datasetsDAO);
    }

    public static DatasetInspector.SQLAbleFlavor getSQLAbleFlavor(List<? extends FlowComputable> computables, AuthCtx authCtx, DatasetsDAO datasetsDAO) throws IOException, DKUSecurityException {
        DatasetInspector.SQLAbleFlavor flavor = null;
        for (FlowComputable flowComputable : computables) {
            if (flowComputable instanceof FlowSavedModel) continue;
            if (!(flowComputable instanceof FlowDataset)) {
                return null;
            }
            FlowDataset fdsource = (FlowDataset)flowComputable;
            Dataset dataset = fdsource.getMandatoryUnsafe(datasetsDAO);
            flavor = DatasetInspector.getSQLAbleFlavorForSQLAbleDataset(authCtx, dataset);
        }
        return flavor;
    }

    @VisibleForTesting
    static EngineUsability areUsingSameSqlAbleConnection(List<? extends FlowComputable> computables, AuthCtx authCtx, DatasetsDAO datasetsDAO) throws IOException, DKUSecurityException {
        Dataset sourceDataset = null;
        String sourceConnection = null;
        for (FlowComputable flowComputable : computables) {
            if (flowComputable instanceof FlowSavedModel) continue;
            if (!(flowComputable instanceof FlowDataset)) {
                return EngineUsability.no("'%s' is not a dataset", flowComputable.getGraphId());
            }
            Dataset currentDataset = ((FlowDataset)flowComputable).getMandatoryUnsafe(datasetsDAO);
            if (!DatasetInspector.isSQLAbleAndSQLTable(authCtx, currentDataset)) {
                return EngineUsability.no("Dataset '%s' is not a SQL table dataset", currentDataset.getName());
            }
            if (DatasetInspector.isSQLTableConfig(currentDataset.getModel()) && currentDataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).variablesExpansionLoopConfig.isEnabled()) {
                return EngineUsability.no("Repeating SQL dataset is enabled on %s", currentDataset.getName());
            }
            String currentConnection = DatasetInspector.getSQLConnectionNameForSQLAbleDatasetOrHive(authCtx, currentDataset);
            if (sourceConnection == null) {
                sourceDataset = currentDataset;
                sourceConnection = currentConnection;
                continue;
            }
            if (sourceConnection.equals(currentConnection)) continue;
            return EngineUsability.no("At least two datasets are from different connections ('%s' for dataset '%s' and '%s' for dataset '%s')", sourceConnection, sourceDataset.getName(), currentConnection, currentDataset.getName());
        }
        return EngineUsability.yes();
    }

    public static EngineUsability canFullSQL(AuthCtx authCtx, JobActivity activity, DatasetsDAO datasetsDAO) throws IOException, DKUSecurityException {
        Stream<FlowComputable> mainSources = activity.getSubgraph().getSourcesWithRoles().stream().filter(fcwr -> "main".equals(fcwr.role)).map(fcwr -> fcwr.computable);
        Stream<FlowComputable> targets = activity.getSubgraph().getTargetsWithRoles().stream().map(fcwr -> fcwr.computable);
        List computables = Stream.concat(mainSources, targets).collect(Collectors.toList());
        return ServiceUtils.areUsingSameSqlAbleConnection(computables, authCtx, datasetsDAO);
    }

    public static boolean canFullSQL(AuthCtx authCtx, FlowRecipe recipe, DatasetsDAO datasetsDAO) throws IOException, DKUSecurityException {
        ArrayList<FlowComputable> computables = new ArrayList<FlowComputable>(recipe.getSources());
        computables.addAll(recipe.getTargets());
        return ServiceUtils.areUsingSameSqlAbleConnection(computables, authCtx, datasetsDAO).canUse();
    }

    public static EngineUsability canHive(AuthCtx authCtx, JobActivity activity, DatasetsDAO datasetsDAO) throws IOException {
        return ServiceUtils.inputsOnHive(authCtx, activity, datasetsDAO).and(ServiceUtils.outputsOnHDFS(activity, datasetsDAO));
    }

    public static boolean canHiveCLILocal(JobActivity activity, DatasetsDAO datasetsDAO) throws IOException {
        return ServiceUtils.inputsOnHDFS(activity, datasetsDAO) && ServiceUtils.outputsOnHDFS(activity, datasetsDAO).canUse();
    }

    public static EngineUsability canImpala(AuthCtx authCtx, JobActivity activity, DatasetsDAO datasetsDAO) throws IOException {
        return ServiceUtils.inputsOnHive(authCtx, activity, datasetsDAO);
    }

    public static DatasetSparkInspector.SparkFastPathStatus canLikelySparkFastPathRead(AuthCtx authCtx, JobActivity activity, DatasetsDAO datasetsDAO) throws IOException, DKUSecurityException {
        List computables = Stream.concat(activity.getSubgraph().getAllSources().stream(), activity.getSubgraph().getAllTargets().stream()).map(x -> x.computable).collect(Collectors.toList());
        DatasetSparkInspector.SparkFastPathStatus ret = ServiceUtils.canLikelySparkFastPathRead(computables, authCtx, datasetsDAO);
        if (ret.ok && activity.getSubgraph() instanceof RecipeRunnableSubgraph) {
            SerializedRecipe sr = ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe().getModel();
            for (SerializedRecipe.RecipeOutput output : sr.getFlatOutputs()) {
                SerializedDataset sd;
                if (!output.appendMode || (sd = (SerializedDataset)datasetsDAO.getOrNull(AnyLoc.resolveSmart(sr.projectKey, output.ref))) == null || sd.type == null) continue;
                switch (sd.type) {
                    case "Azure": 
                    case "S3": 
                    case "GCS": 
                    case "HDFS": {
                        ret = DatasetSparkInspector.SparkFastPathStatus.nok("Output " + output.ref + " is in append-mode");
                    }
                }
            }
        }
        return ret;
    }

    private static DatasetSparkInspector.SparkFastPathStatus canLikelySparkFastPathRead(List<? extends FlowComputable> computables, AuthCtx authCtx, DatasetsDAO datasetsDAO) throws IOException, DKUSecurityException {
        for (FlowComputable flowComputable : computables) {
            if (flowComputable instanceof FlowSavedModel) continue;
            if (!(flowComputable instanceof FlowDataset)) {
                return DatasetSparkInspector.SparkFastPathStatus.nok("Input is not a dataset");
            }
            Dataset dataset = ((FlowDataset)flowComputable).getMandatoryUnsafe(datasetsDAO);
            DatasetSparkInspector.SparkFastPathStatus status = DatasetSparkInspector.isLikelySparkFastReadable(authCtx, dataset);
            if (status.ok) continue;
            return status;
        }
        return DatasetSparkInspector.SparkFastPathStatus.ok();
    }

    public static boolean optimizableForGlobalMetastore(JobActivity activity, DatasetsDAO datasetsDAO) throws IOException {
        for (FlowDataset fd : activity.getSubgraph().getSourceDatasets()) {
            Dataset source = fd.getMandatoryUnsafe(datasetsDAO);
            if (!DatasetInspector.isHiveTable(source)) continue;
            return true;
        }
        return false;
    }

    private static EngineUsability inputsOnHive(AuthCtx authCtx, JobActivity activity, DatasetsDAO datasetsDAO) throws IOException {
        for (FlowDataset fd : activity.getSubgraph().getSourceDatasets()) {
            Dataset source = fd.getMandatoryUnsafe(datasetsDAO);
            if (!DatasetInspector.isHDFSDatasetOrHiveTableDataset(source)) {
                return EngineUsability.no("Input dataset '%s' should be an HDFS dataset or a Hive table dataset", source.getName());
            }
            HiveSchemaHandler.HiveCompatibilityStatus compatibility = HiveSchemaHandler.isCompatible(authCtx, source);
            if (compatibility.compatible) continue;
            return EngineUsability.no("Input dataset '%s' is incompatible with Hive : %s", source.getName(), compatibility.reason);
        }
        return EngineUsability.yes();
    }

    private static boolean inputsOnHDFS(JobActivity activity, DatasetsDAO datasetsDAO) throws IOException {
        for (FlowDataset fd : activity.getSubgraph().getSourceDatasets()) {
            Dataset source = fd.getMandatory(datasetsDAO);
            if (DatasetInspector.canHDFS(source)) continue;
            return false;
        }
        return true;
    }

    private static EngineUsability outputsOnHDFS(JobActivity activity, DatasetsDAO datasetsDAO) throws IOException {
        for (FlowDataset fd : activity.getSubgraph().getTargetsDatasets()) {
            Dataset source = fd.getMandatory(datasetsDAO);
            if (DatasetInspector.canHDFS(source)) continue;
            return EngineUsability.no("Output dataset '%s' is not an HDFS dataset", source.getName());
        }
        return EngineUsability.yes();
    }

    public static Dataset getDataset(JobActivity activity, DatasetsDAO datasetsDAO, String datasetName) throws IOException {
        RecipeRunnableSubgraph subgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        String projectKey = subgraph.getRecipe().getProjectKey();
        SerializedDataset sd = (SerializedDataset)datasetsDAO.getMandatory(DatasetLocUtils.resolveSmart(projectKey, datasetName));
        return Dataset.fromSerialized(sd);
    }

    public static boolean canSqlOnDatabricks(AuthCtx authCtx, JobActivity activity, DatasetsDAO datasetsDAO) throws IOException, DKUSecurityException {
        for (FlowDataset fd : activity.getSubgraph().getSourceDatasets()) {
            Dataset source = fd.getMandatory(datasetsDAO);
            if (DatasetHandlerFactory.getMeta(source) == BuiltinSQLDatasets.DATABRICKS_META) continue;
            return false;
        }
        return ServiceUtils.canSQL(authCtx, activity, datasetsDAO).canUse();
    }

    public static class EngineUsability {
        private boolean canUse;
        private String reason;

        public boolean canUse() {
            return this.canUse;
        }

        public String getReason() {
            return this.reason;
        }

        public static EngineUsability no(String reason, String ... args) {
            EngineUsability ret = new EngineUsability();
            ret.reason = String.format(reason, args);
            return ret;
        }

        public static EngineUsability yes() {
            EngineUsability ret = new EngineUsability();
            ret.canUse = true;
            return ret;
        }

        EngineUsability and(EngineUsability other) {
            boolean bl = this.canUse = this.canUse && other.canUse;
            if (other.reason != null) {
                this.reason = this.reason == null ? other.reason : this.reason.concat(" and " + other.reason);
            }
            return this;
        }
    }
}

