/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.sampleio;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.io.BinaryStreamDecoder;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class SampleReader
implements AutoCloseable {
    private final BinaryStreamDecoder decoder;
    private Dataset sourceDataset;
    private StreamingEndpoint sourceStreamingEndpoint;
    private long maxRows = -1L;

    public SampleReader(File inputFile, Dataset sourceDataset) throws IOException {
        this(inputFile);
        this.sourceDataset = sourceDataset;
    }

    public SampleReader(File inputFile, Dataset sourceDataset, long maxRows) throws IOException {
        this(inputFile);
        this.sourceDataset = sourceDataset;
        this.maxRows = maxRows;
    }

    public SampleReader(File inputFile, StreamingEndpoint sourceStreamingEndpoint) throws IOException {
        this(inputFile);
        this.sourceStreamingEndpoint = sourceStreamingEndpoint;
    }

    public SampleReader(File inputFile) throws IOException {
        BufferedInputStream rawInputStream = new BufferedInputStream(new FileInputStream(inputFile));
        if (((InputStream)rawInputStream).read() != 68 || ((InputStream)rawInputStream).read() != 83 || ((InputStream)rawInputStream).read() != 83) {
            ((InputStream)rawInputStream).close();
            throw new IOException("Bad magic");
        }
        byte version = (byte)((InputStream)rawInputStream).read();
        if (version == 49) {
            this.decoder = new BinaryStreamDecoder(rawInputStream);
        } else if (version == 50) {
            this.decoder = new BinaryStreamDecoder(new GZIPInputStream(rawInputStream));
        } else {
            ((InputStream)rawInputStream).close();
            throw new IOException("Unsupported version");
        }
    }

    public MemTable readAsMemtable() throws IOException {
        MemTable memTable = new MemTable();
        int nbColumns = (int)this.decoder.readVIntSlow();
        for (int i = 0; i < nbColumns; ++i) {
            int colNameLengthBytes = (int)this.decoder.readVIntSlow();
            String colName = this.decoder.readUTF8(colNameLengthBytes);
            memTable.column(colName);
        }
        boolean endOfFileReached = false;
        while (!(endOfFileReached || this.maxRows > 0L && (long)memTable.nrows() >= this.maxRows)) {
            endOfFileReached = this.readRows(memTable, nbColumns);
        }
        return memTable;
    }

    private boolean readRows(MemTable memTable, int nbColumns) throws IOException {
        int[] cellLengths = new int[nbColumns];
        try {
            for (int col = 0; col < nbColumns; ++col) {
                cellLengths[col] = (int)this.decoder.readVIntSlow();
            }
            int bufLenBytes = (int)this.decoder.readVIntSlow();
            String rowBuf = this.decoder.readUTF8(bufLenBytes);
            Row row = memTable.row(cellLengths, rowBuf.toCharArray());
            if (this.sourceDataset != null && this.sourceDataset.getPartitioningSchema().isPartitioned()) {
                row.getRowContext().sourcePartitioningScheme = this.sourceDataset.getPartitioningSchema();
            }
            memTable.appendRow(row);
            return false;
        }
        catch (EOFException eof) {
            return true;
        }
    }

    @Override
    public void close() throws IOException {
        this.decoder.close();
    }
}

