/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.sql;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import org.apache.log4j.Logger;

public class FinalSchemaCaster {
    ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
    private static Logger logger = Logger.getLogger((String)"dip.shaker.sql.cast");

    public SQLQueryWithSchema getCasted(SQLQueryWithSchema chain, Schema outputSchema) throws CodedException {
        SQLQueryWithSchema finalSQB = chain.makeEmptySubquery();
        for (SchemaColumn columnInOutput : outputSchema.getColumns()) {
            SchemaColumn columnInChain = chain.getCurrentColumn(columnInOutput.getName());
            if (columnInChain == null) {
                throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Unable to find column " + columnInOutput.getName() + " in script output");
            }
            if (columnInChain.getType() == columnInOutput.getType()) {
                finalSQB.addColumn(columnInChain);
                finalSQB.select(columnInChain.getName());
                continue;
            }
            if (columnInChain.getType() == Type.STRING && columnInOutput.getType().isTemporal() && (chain.getDialect() == null || !chain.getDialect().canCastDSSFormatToTemporal())) {
                logger.warn((Object)("Adding implicit cast from string to " + columnInOutput.getType().getName() + ". This might not be supported by the database"));
            }
            ExpressionBuilder col = chain.col(columnInChain.getName());
            ExpressionBuilder untypedCol = chain.col(columnInChain.getName());
            col.expr.outputType.dssType = columnInChain.getType();
            if (columnInChain.getType() == Type.STRING && columnInOutput.getType().isNumeric()) {
                ExpressionBuilder cond = this.ebf.or(col.isnull(), untypedCol.castToString(100).eq(this.ebf.cst("")));
                int nullMaxLength = columnInChain.getMaxLength() < 0 ? 1 : columnInChain.getMaxLength();
                col = col.cast(columnInOutput.getType(), columnInOutput.getMaxLength()).nullWhen(cond, columnInOutput.getType(), nullMaxLength);
                finalSQB.select(col, columnInChain.getName());
            } else {
                finalSQB.select(col.cast(columnInOutput.getType(), columnInOutput.getMaxLength()), columnInChain.getName());
            }
            SchemaColumn updatedColumn = new SchemaColumn(columnInOutput);
            updatedColumn.setName(columnInChain.getName());
            finalSQB.addColumn(updatedColumn);
        }
        return finalSQB;
    }
}

