/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.pivot.backend.sql.utils.QueryUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.SQLServerSQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import java.lang.invoke.StringConcatFactory;
import java.sql.SQLWarning;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FabricWarehouseSQLDialect
extends SQLServerSQLDialect {
    private static final Logger logger = Logger.getLogger((String)"dku.sql.fabric.warehouse");

    @Override
    public String getValueAsSQLString(Type type, String value) {
        if (type == Type.DOUBLE) {
            try {
                double d = Double.parseDouble(value);
                if (Double.isNaN(d) || Double.isInfinite(d)) {
                    return null;
                }
            }
            catch (NumberFormatException d) {
                // empty catch block
            }
        }
        if (type == Type.FLOAT) {
            try {
                float f = Float.parseFloat(value);
                if (Float.isNaN(f) || Float.isInfinite(f)) {
                    return null;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return super.getValueAsSQLString(type, value);
    }

    @Override
    public DSSTypeSQLMapping getSQLType(SchemaColumn schemaColumn, Dataset dataset) {
        switch (schemaColumn.getType()) {
            case STRING: {
                return new DSSTypeSQLMapping(Type.STRING, 12, "varchar(" + (schemaColumn.getMaxLength() > 0 && schemaColumn.getMaxLength() <= this.getMaxPossibleVarcharLen() ? schemaColumn.getMaxLength() : this.getMaxPossibleVarcharLen()) + ")", new Integer[]{2003, 1111, 1, -15, 12, -1, -16, 91, 93, 92});
            }
            case DATE: {
                return new DSSTypeSQLMapping(Type.DATE, 93, "datetime2(3)", new Integer[]{91, 93});
            }
            case DATEONLY: {
                return new DSSTypeSQLMapping(Type.DATEONLY, 91, "date", new Integer[]{93});
            }
            case DATETIMENOTZ: {
                return new DSSTypeSQLMapping(Type.DATETIMENOTZ, 93, "datetime2(3)", new Integer[]{91});
            }
        }
        return super.getSQLType(schemaColumn, dataset);
    }

    @Override
    public int getMaxPossibleVarcharLen() {
        return 8000;
    }

    @Override
    public String getId() {
        return "FabricWarehouse";
    }

    @Override
    public String getSafeRandomTemporaryTableName(String prefix) {
        return QueryUtils.safeRandomIdentifier(prefix);
    }

    @Override
    public String[] createTemporaryTableAs(SQLUtils.SQLTable table, String selectExpr) {
        return new String[]{"CREATE TABLE " + this.getQuotedTableFullName(table) + " AS " + selectExpr};
    }

    @Override
    public boolean considerTypeTimestampAsDate() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTableIfNeeded(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, Dataset dataset, boolean dropPartitionedTableOnSchemaMismatch, InfoMessage.InfoMessages messages) throws Exception {
        try {
            conn.setAutoCommit(false);
            super.createTableIfNeeded(authCtx, connData, conn, dataset, dropPartitionedTableOnSchemaMismatch, messages);
        }
        finally {
            conn.setAutoCommit(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropAndRecreateTableOrPartition(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, Dataset dataset, Partition partition, boolean dropPartitionedTableOnSchemaMismatch, InfoMessage.InfoMessages messages) throws Exception {
        try {
            conn.setAutoCommit(false);
            super.dropAndRecreateTableOrPartition(authCtx, connData, conn, dataset, partition, dropPartitionedTableOnSchemaMismatch, messages);
        }
        finally {
            conn.setAutoCommit(true);
        }
    }

    @Override
    public boolean supportsCommitAndRollback() {
        return false;
    }

    @Override
    protected void initOperators() {
        super.initOperators();
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.IS_BLANK, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
                ExpressionBuilder col = ebf.expr(args[0]);
                if (args[0].outputType.dssType == Type.STRING) {
                    return this.toSQLWithBrackets(col.isnull().or((ExpressionBuilder[])new ExpressionBuilder[]{ebf.expr((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"DATALENGTH(\u0001)=0"}, (String)this.toSQLNoBrackets((QueryAst.Expr)args[0]))))}).expr);
                }
                return this.toSQLWithBrackets(col.isnull().or((ExpressionBuilder[])new ExpressionBuilder[]{col.castToString((int)100).length().nullUnsafeEq((Object)ebf.cst((Object)Integer.valueOf((int)0)))}).expr);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.TRY_PARSE, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                String input = this.toSQLNoBrackets(args[0]);
                Type requestedType = this.getParamAs(args[1], Type.class);
                if (requestedType == Type.DATE) {
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    String sqlFormat = FabricWarehouseSQLDialect.this.toDateFormat(jodaFormat, true);
                    String converted = "TRY_CONVERT(datetime2, " + input + ", " + sqlFormat + ")";
                    if (StringUtils.equals((String)"UTC", (String)timezoneId)) {
                        return converted;
                    }
                    DateTimeZone timezone = StringUtils.isNotBlank((String)timezoneId) ? DateTimeZone.forID((String)timezoneId) : DateTimeZone.getDefault();
                    int offset = -timezone.getOffset(0L) / 1000 / 60;
                    logger.warn((Object)("Daylight savings are not handled in MS Fabric Warehouses zone conversions. Conversion of " + this.toSQLNoBrackets(args[0]) + " may contain values off by 1 hour."));
                    return "DATEADD(MINUTE, " + offset + "," + converted + ")";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.CHAR, "CHAR", QueryUtils.Arity.UNARY);
    }

    @Override
    public boolean filterWarning(SQLWarning warning) {
        return warning.getErrorCode() == 24528 && warning.getMessage() != null && warning.getMessage().startsWith("Statement ID:");
    }
}

