/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.bigquery;

import com.dataiku.dip.antlrgrammars.BigQuerySQLBaseVisitor;
import com.dataiku.dip.antlrgrammars.BigQuerySQLLexer;
import com.dataiku.dip.antlrgrammars.BigQuerySQLParser;
import com.dataiku.dip.utils.DKULogger;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;

public class BigQueryCreateTableParser {
    private final String sql;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.bigquery.parser");

    public BigQueryCreateTableParser(String sql) {
        this.sql = sql;
    }

    public Map<String, String> getFieldTypes() {
        BigQuerySQLParser parser = this.initializeParser();
        BigQuerySQLParser.StatementContext createTable = parser.statement();
        BigQuerySQLParser.Table_field_listContext fields = createTable.table_field_list();
        HashMap<String, String> ret = new HashMap<String, String>();
        for (BigQuerySQLParser.Table_fieldContext field : fields.table_field()) {
            this.handle(field, ret);
        }
        return ret;
    }

    private void handle(BigQuerySQLParser.Table_fieldContext field, Map<String, String> ret) {
        if (field.column() != null) {
            this.handle(field.column(), ret);
        }
    }

    private void handle(BigQuerySQLParser.ColumnContext field, Map<String, String> ret) {
        String name = this.identifierName(field.column_name().identifier());
        String type = this.datatypeString(field.column_schema().datatype());
        ret.put(name, type);
    }

    private String datatypeString(BigQuerySQLParser.DatatypeContext datatype) {
        BigQuerySQLBaseVisitor<String> builder = new BigQuerySQLBaseVisitor<String>(){

            public String visitTerminal(TerminalNode terminalNode) {
                return terminalNode.getText();
            }

            @Override
            public String visitTyped_field(BigQuerySQLParser.Typed_fieldContext typed_field) {
                ParseTree i = typed_field.getChild(0);
                String identifier = (String)i.accept((ParseTreeVisitor)this);
                ParseTree d = typed_field.getChild(1);
                String datatype = (String)d.accept((ParseTreeVisitor)this);
                return identifier + " " + datatype;
            }

            protected String aggregateResult(String a, String b) {
                return a == null ? b : (b == null ? a : a + b);
            }
        };
        return (String)builder.visit((ParseTree)datatype);
    }

    private String identifierName(BigQuerySQLParser.IdentifierContext identifier) {
        if (identifier.QUOTED_IDENTIFIER() != null) {
            String name = identifier.QUOTED_IDENTIFIER().getText();
            return name.substring(1, name.length() - 1);
        }
        return identifier.UNQUOTED_IDENTIFIER().getText();
    }

    protected BigQuerySQLParser initializeParser() {
        logger.info((Object)("Initialize create table parser for `" + this.sql + "'"));
        BigQuerySQLLexer lexer = new BigQuerySQLLexer((CharStream)CharStreams.fromString((String)this.sql));
        BigQuerySQLParser parser = new BigQuerySQLParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        BaseErrorListener errorListener = new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                Object message;
                IntervalSet expectedTokens = ((BigQuerySQLParser)recognizer).getExpectedTokens();
                if (((CommonToken)offendingSymbol).getType() == -1) {
                    TreeSet<String> expectedTokensNames = new TreeSet<String>();
                    for (Integer expectedToken : expectedTokens.toSet()) {
                        expectedTokensNames.add(recognizer.getVocabulary().getDisplayName(expectedToken.intValue()));
                    }
                    message = "Unexpected end of expression, expected : " + String.join((CharSequence)", ", expectedTokensNames);
                } else {
                    message = String.format("Did not recognize expression \"%s\" at %d:%d", ((CommonToken)offendingSymbol).getText(), line, charPositionInLine);
                }
                logger.warnV("BigQuery CREATE TABLE parsing error : %s at %d:%d, original message:%s", new Object[]{message, line, charPositionInLine, msg});
                throw new RuntimeException((String)message);
            }
        };
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        return parser;
    }
}

