/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.queries;

import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QuerySQLWriter;
import com.google.common.base.Preconditions;
import java.util.Random;

public class QueryUtils {
    private static final String chars = "azertyuiopqsdfghjklmwxcvbn0123456789";
    private static final Random rd = new Random();

    public static Type getKnownOutputType(OperatorType op, Object[] args, ExpressionBuilder[] dssArgs) {
        switch (op) {
            case CAST: {
                Object requestedTypeObj;
                Object object = requestedTypeObj = args != null && args.length >= 2 ? args[1] : null;
                if (requestedTypeObj == null) {
                    Object object2 = requestedTypeObj = dssArgs != null && dssArgs.length >= 2 ? dssArgs[1].expr : null;
                }
                if (requestedTypeObj instanceof Type) {
                    return (Type)requestedTypeObj;
                }
                if (requestedTypeObj instanceof String) {
                    String requestedTypeName = ((String)requestedTypeObj).toLowerCase();
                    if (!Type.exists((String)requestedTypeName)) {
                        throw new SQLGenerationException("Invalid type for cast: " + requestedTypeName);
                    }
                    return Type.forName((String)requestedTypeName);
                }
                if (requestedTypeObj instanceof QueryAst.ConstExpr) {
                    return Type.forName((String)((QueryAst.ConstExpr)requestedTypeObj).value.toString().toLowerCase());
                }
                return null;
            }
            case SUBSTR: 
            case UPPER: 
            case LOWER: 
            case TRIM: 
            case CONCAT: 
            case REPLACE: 
            case REGEXP_REPLACE: 
            case REGEXP_SUBSTR: 
            case TRANSLATE: {
                return Type.STRING;
            }
            case ALL: 
            case ANY: 
            case IN: 
            case IS_BLANK: 
            case IS_NON_BLANK: 
            case EQ: 
            case NE: 
            case NULL_UNSAFE_EQ: 
            case GT: 
            case LT: 
            case GE: 
            case LE: 
            case STARTS_WITH: 
            case ENDS_WITH: 
            case LIKE: 
            case REGEX_LIKE: 
            case CONTAINS: 
            case ISNULL: 
            case ISNOTNULL: 
            case EXISTS: 
            case ISNULLOREMPTY: 
            case NOT: 
            case OR: 
            case AND: 
            case ISTRUE: 
            case ISFALSE: {
                return Type.BOOLEAN;
            }
            case TO_ARRAY: {
                return Type.ARRAY;
            }
        }
        return null;
    }

    public static boolean isBooleanCondition(QueryAst.Expr expr) {
        if (expr instanceof QueryAst.OperatorExpr) {
            return QueryUtils.isBooleanCondition(((QueryAst.OperatorExpr)expr).op);
        }
        return false;
    }

    public static boolean isBooleanCondition(OperatorType op) {
        switch (op) {
            case IN: 
            case IS_BLANK: 
            case IS_NON_BLANK: 
            case EQ: 
            case NE: 
            case NULL_UNSAFE_EQ: 
            case GT: 
            case LT: 
            case GE: 
            case LE: 
            case STARTS_WITH: 
            case ENDS_WITH: 
            case LIKE: 
            case REGEX_LIKE: 
            case CONTAINS: 
            case ISNULL: 
            case ISNOTNULL: 
            case EXISTS: 
            case ISNULLOREMPTY: 
            case NOT: 
            case OR: 
            case AND: 
            case ISTRUE: 
            case ISFALSE: {
                return true;
            }
        }
        return false;
    }

    public static String safeRandomIdentifier(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        for (int i = 0; i < 10; ++i) {
            sb.append(chars.charAt(rd.nextInt(chars.length())));
        }
        return sb.toString();
    }

    private static int safeArgCount(QueryAst.Expr[] args) {
        return args != null ? args.length : 0;
    }

    public static enum OperatorType {
        PLUS,
        MINUS,
        TIMES,
        DIV,
        MOD,
        QUOTIENT,
        ALL,
        ANY,
        IN,
        INTER,
        UNION,
        UNION_ALL,
        ABS,
        SIGN,
        FLOOR,
        CEIL,
        ROUND,
        TRUNC,
        EVEN,
        ODD,
        SQRT,
        EXP,
        LN,
        LOG,
        POW,
        RAND,
        FACT,
        COMBIN,
        IS_BLANK,
        IS_NON_BLANK,
        HASH,
        COUNT,
        DISTINCT,
        AVG,
        MIN,
        MAX,
        SUM,
        STDDEV_SAMP,
        STDDEV_POP,
        VARIANCE_SAMP,
        VARIANCE_POP,
        MEDIAN,
        AGG_CONCAT,
        COLLECT_STRING_LIST,
        COLLECT_STRING_SET,
        ARRAY_TO_STRING,
        TO_ARRAY,
        COS,
        SIN,
        TAN,
        ACOS,
        ASIN,
        ATAN,
        ATAN2,
        COSH,
        SINH,
        TANH,
        DEGREES,
        RADIANS,
        LENGTH,
        SUBSTR,
        UPPER,
        LOWER,
        TRIM,
        CONCAT,
        REPLACE,
        REGEXP_REPLACE,
        TRANSLATE,
        COALESCE,
        GREATEST,
        LEAST,
        SET_CASE_SENSITIVITY,
        RANK,
        DENSE_RANK,
        ROW_NUMBER,
        FIRST_VALUE,
        LAST_VALUE,
        LAG,
        LEAD,
        CUME_DIST,
        NTILE,
        PERCENTILE_APPROX_AGG,
        PERCENTILE_APPROX_WIN,
        PERCENTILE_CONT,
        UNIQUE_ID,
        CAST,
        TRY_PARSE,
        PARSE,
        FORMAT,
        DATEDIFF,
        DATETRUNC,
        DATEONLYTRUNC,
        DATETIMENOTZTRUNC,
        DATEPART,
        DATEONLYPART,
        DATETIMENOTZPART,
        EXTRACT_FROM_INTERVAL,
        FROM_TIMEZONE,
        FROM_TIMEZONE_NTZ,
        MSS_TO_EPOCH,
        MSS_TO_DATEONLY_EPOCH,
        MSS_TO_DATETIMENOTZ_EPOCH,
        STRING_TO_DATE,
        STRING_TO_TIMESTAMPTZ,
        STRING_TO_TIMESTAMP,
        DATE_ADD,
        NOW,
        NULL,
        NULL_WHEN,
        DEC2HEX,
        INDEX_OF,
        LAST_INDEX_OF,
        REVERSE_STR,
        CASE_WHEN,
        DEFAULT_IF_NULL_OR_EMPTY,
        SWITCH_WHEN,
        SPLIT,
        GET,
        SPLIT_PART,
        EQ,
        NE,
        NULL_UNSAFE_EQ,
        GT,
        LT,
        GE,
        LE,
        STARTS_WITH,
        ENDS_WITH,
        LIKE,
        REGEX_LIKE,
        REGEXP_SUBSTR,
        CONTAINS,
        ISNULL,
        ISNOTNULL,
        EXISTS,
        ISNULLOREMPTY,
        NOT,
        OR,
        AND,
        ISTRUE,
        ISFALSE,
        MD5,
        SHA256,
        SHA512,
        ORD,
        CHAR,
        FLOAT_DIV,
        CAST_BOOL_TO_COLUMN,
        ST_EQUALS,
        ST_DWITHIN,
        ST_BEYOND,
        ST_WITHIN,
        ST_CROSSES,
        ST_TOUCHES,
        ST_CONTAINS,
        ST_DISJOINT,
        ST_OVERLAPS,
        ST_INTERSECTS,
        ST_AREA,
        ST_LENGTH,
        ST_CENTROID,
        ST_BUFFER,
        ST_SIMPLIFY,
        ST_ENVELOPE,
        ST_TRANSFORM,
        ST_MAKEVALID,
        ST_ASTEXT,
        ST_DISTANCE,
        TO_BASE64,
        TO_JSON_STRING,
        JSON_ARRAY_SUM,
        JSON_ARRAY_COUNT,
        AVG_DIV;

    }

    public static class SQLGenerationException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        public SQLGenerationException(String msg) {
            super(msg);
        }
    }

    public static class QueryOperator
    extends Operator {
        public QueryOperator(SQLDialect dialect, OperatorType type, String name, Arity arity, int priority) {
            super(dialect, type, name, arity, priority);
        }

        @Override
        public String apply(QueryAst.Expr[] args) {
            this.validateNumberOfParameters(args);
            StringBuilder output = new StringBuilder();
            boolean first = true;
            if (this.arity == Arity.UNARY) {
                throw new SQLGenerationException("Unary operators on queries are not supported");
            }
            if (args != null) {
                for (QueryAst.Expr arg : args) {
                    if (!first) {
                        output.append("\n" + this.name + "\n");
                    }
                    output.append(this.toSQLNoBrackets(arg));
                    first = false;
                }
            }
            return output.toString();
        }
    }

    public static class Operator
    extends AbstractOperator {
        public int ePriority;
        public OperatorPosition position;
        public boolean associative;

        public Operator(SQLDialect dialect, OperatorType type, String name, Arity arity, int priority) {
            this(dialect, type, name, arity, priority, false);
        }

        public Operator(SQLDialect dialect, OperatorType type, String name, Arity arity, int priority, boolean associative) {
            this.dialect = dialect;
            this.name = name;
            this.type = type;
            this.arity = arity;
            this.ePriority = priority;
            this.associative = associative;
        }

        public Operator(SQLDialect dialect, OperatorType type, String name, Arity arity, int priority, OperatorPosition position) {
            this.dialect = dialect;
            this.name = name;
            this.type = type;
            this.arity = arity;
            this.ePriority = priority;
            this.position = position;
        }

        @Override
        protected String fullName() {
            return "SQL operator " + (this.name != null ? this.name : String.valueOf((Object)this.type));
        }

        protected String toSQLWithBracketsIfNeeded(QueryAst.Expr expr, int iPriority) {
            return this.requiresBrackets(expr, iPriority) ? this.toSQLWithBrackets(expr) : this.toSQLNoBrackets(expr);
        }

        @Override
        public String apply(QueryAst.Expr[] args) {
            this.validateNumberOfParameters(args);
            StringBuilder output = new StringBuilder();
            boolean first = true;
            if (this.arity == Arity.UNARY) {
                assert (args != null);
                if (this.position == OperatorPosition.BEFORE) {
                    output.append(this.name + " ");
                }
                output.append(this.toSQLWithBracketsIfNeeded(args[0], this.ePriority));
                if (this.position == OperatorPosition.AFTER) {
                    output.append(" " + this.name);
                }
            } else if (args != null) {
                for (QueryAst.Expr arg : args) {
                    if (!first) {
                        output.append(" " + this.name + " ");
                    }
                    output.append(this.toSQLWithBracketsIfNeeded(arg, this.ePriority));
                    first = false;
                }
            }
            return output.toString();
        }

        protected boolean requiresBrackets(QueryAst.Expr expr) {
            return this.requiresBrackets(expr, this.ePriority);
        }

        protected boolean requiresBrackets(QueryAst.Expr expr, int iPriority) {
            if (expr instanceof QueryAst.InlineExpr) {
                return true;
            }
            if (expr instanceof QueryAst.OperatorExpr) {
                QueryAst.OperatorExpr opExp = (QueryAst.OperatorExpr)expr;
                AbstractOperator aOp = this.dialect.getOperator(opExp.op);
                if (!(aOp instanceof Operator)) {
                    return false;
                }
                if (this == aOp) {
                    return !this.associative;
                }
                int childPrioriry = ((Operator)this.dialect.getOperator((OperatorType)opExp.op)).ePriority;
                if (childPrioriry > iPriority) {
                    return true;
                }
                return childPrioriry >= iPriority;
            }
            return false;
        }
    }

    public static class Function
    extends AbstractOperator {
        public Function(SQLDialect dialect, OperatorType type, String name, Arity arity) {
            this.dialect = dialect;
            this.name = name;
            this.arity = arity;
            this.type = type;
        }

        public Function(SQLDialect dialect, OperatorType type, Arity arity) {
            this(dialect, type, null, arity);
        }

        @Override
        public String apply(QueryAst.Expr[] args) {
            this.validateNumberOfParameters(args);
            StringBuilder sb = new StringBuilder();
            sb.append(this.name);
            sb.append('(');
            boolean first = true;
            if (args != null) {
                for (QueryAst.Expr arg : args) {
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(this.toSQLNoBrackets(arg));
                    first = false;
                }
            }
            sb.append(')');
            return sb.toString();
        }

        @Override
        protected String fullName() {
            return "SQL function " + (this.name != null ? this.name : String.valueOf((Object)this.type));
        }
    }

    public static abstract class AbstractOperator {
        protected SQLDialect dialect;
        protected String name;
        public Arity arity;
        public OperatorType type;

        public abstract String apply(QueryAst.Expr[] var1);

        public String toSQLNoBrackets(QueryAst.Expr expr) {
            return QuerySQLWriter.generateSafeSQL(this.dialect, expr);
        }

        public String toSQLWithBrackets(QueryAst.Expr expr) {
            return "(" + this.toSQLNoBrackets(expr) + ")";
        }

        public <T> T getParamAs(QueryAst.Expr arg, Class<T> clazz) {
            return this.getParamAs(arg, clazz, false);
        }

        public <T> T getParamAs(QueryAst.Expr arg, Class<T> clazz, boolean nullIfBadType) {
            Preconditions.checkNotNull((Object)arg);
            if (arg instanceof QueryAst.ConstExpr) {
                QueryAst.ConstExpr ce = (QueryAst.ConstExpr)arg;
                if (ce.value == null) {
                    return null;
                }
                if (clazz.isAssignableFrom(ce.value.getClass())) {
                    return (T)ce.value;
                }
                if (nullIfBadType) {
                    return null;
                }
                throw new SQLGenerationException("Parameter of class " + ce.value.getClass().getName() + " requested as " + clazz.getName());
            }
            throw new SQLGenerationException("Only ConstExpr can contain arbitraty typed field. Got type: " + arg.getClass().getName());
        }

        protected Type getCastTargetType(QueryAst.Expr arg) {
            Object requestedTypeObj = this.getParamAs(arg, Object.class);
            if (requestedTypeObj instanceof Type) {
                return (Type)requestedTypeObj;
            }
            if (requestedTypeObj instanceof String) {
                String requestedTypeName = ((String)requestedTypeObj).toLowerCase();
                if (!Type.exists((String)requestedTypeName)) {
                    throw new SQLGenerationException("Invalid type for cast: " + requestedTypeName);
                }
                return Type.forName((String)requestedTypeName);
            }
            if (requestedTypeObj == null) {
                throw new SQLGenerationException("Invalid cast: target type not specified");
            }
            throw new SQLGenerationException("Invalid cast: Type provided as " + requestedTypeObj.getClass().getCanonicalName());
        }

        protected abstract String fullName();

        public void validateNumberOfParameters(QueryAst.Expr[] args) {
            int argsCount = QueryUtils.safeArgCount(args);
            if (!this.checkNumberOfParameters(argsCount)) {
                throw new SQLGenerationException(String.format("Wrong number of arguments given to %s: %d", this.fullName(), argsCount));
            }
        }

        public boolean hasMultipleArgument(QueryAst.Expr[] args) {
            if (args.length > 1 && args[1] instanceof QueryAst.InlineExpr) {
                String value = ((QueryAst.InlineExpr)args[1]).expr;
                return Boolean.parseBoolean(value);
            }
            return false;
        }

        protected void validateMinNumberOfParameters(QueryAst.Expr[] args, int minCount) {
            int argsCount = QueryUtils.safeArgCount(args);
            if (argsCount < minCount) {
                throw new SQLGenerationException(String.format("%s expects at least %d arguments but got %d", this.fullName(), minCount, argsCount));
            }
        }

        protected void validateMinMaxNumberOfParameters(QueryAst.Expr[] args, int minCount, int maxCount) {
            int argsCount = QueryUtils.safeArgCount(args);
            if (argsCount < minCount) {
                throw new SQLGenerationException(String.format("%s expects at least %d arguments but got %d", this.fullName(), minCount, argsCount));
            }
            if (argsCount > maxCount) {
                throw new SQLGenerationException(String.format("%s expects at most %d arguments but got %d", this.fullName(), maxCount, argsCount));
            }
        }

        protected boolean checkNumberOfParameters(int nArgs) {
            switch (this.arity) {
                case NO_ARG: {
                    return nArgs == 0;
                }
                case UNARY: {
                    return nArgs == 1;
                }
                case BINARY: {
                    return nArgs == 2;
                }
                case TERNARY: {
                    return nArgs == 3;
                }
                case NARY: {
                    return nArgs > 0;
                }
            }
            return true;
        }
    }

    public static enum Arity {
        UNARY,
        BINARY,
        TERNARY,
        NO_ARG,
        NARY,
        ANY;

    }

    public static enum OperatorPosition {
        BEFORE,
        AFTER;

    }
}

