/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints.kafka;

import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.streaming.endpoints.kafka.JSONKafkaFormat;
import com.dataiku.dip.streaming.endpoints.kafka.SingleValueKafkaFormat;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class KafkaStreamingEndpointParams
extends StreamingEndpoint.StreamingEndpointParams {
    public String connection;
    public String topic;
    public String formatType = "json";
    public JsonObject formatParams = JSON.toJsonObject((Object)new JSONKafkaFormat.JSONKafkaFormatParams());
    public String keyFormatType = "single";
    public JsonObject keyFormatParams = JSON.toJsonObject((Object)new SingleValueKafkaFormat.SingleValueKafkaFormatParams());
    public String timestampColumn;
    public ConsumerParams consumerParams = new ConsumerParams();
    public ProducerParams producerParams = new ProducerParams();
    public KsqlParams ksqlParams = new KsqlParams();

    @Override
    public String getConnection() {
        return this.connection;
    }

    @Override
    public void setConnection(String connection) {
        this.connection = connection;
    }

    public boolean mergeDetectedSettings(KsqlParamsChanges detected) {
        boolean changed = this.ksqlParams.mergeDetectedSettings(detected);
        if ("single".equals(this.keyFormatType)) {
            SingleValueKafkaFormat.SingleValueKafkaFormatParams keyParams = (SingleValueKafkaFormat.SingleValueKafkaFormatParams)JSON.parse((String)JSON.json((Object)this.keyFormatParams), SingleValueKafkaFormat.SingleValueKafkaFormatParams.class);
            if (this.ksqlParams.windowType != KsqlWindowType.NONE && keyParams.columnType != SingleValueKafkaFormat.KeyType.BYTEARRAY) {
                keyParams.columnType = SingleValueKafkaFormat.KeyType.BYTEARRAY;
                this.keyFormatParams = JSON.toJsonObject((Object)keyParams);
                changed = true;
            }
            if (this.ksqlParams.windowType == KsqlWindowType.NONE && detected.keyType != null && detected.keyType != keyParams.columnType) {
                keyParams.columnType = detected.keyType;
                this.keyFormatParams = JSON.toJsonObject((Object)keyParams);
                changed = true;
            }
            if (!StringUtils.defaultIfEmpty((String)detected.keyName, (String)"ROWKEY").equals(StringUtils.defaultIfEmpty((String)keyParams.columnName, (String)"ROWKEY"))) {
                keyParams.columnName = detected.keyName;
                this.keyFormatParams = JSON.toJsonObject((Object)keyParams);
                changed = true;
            }
        }
        return changed;
    }

    public static class ConsumerParams {
        public List<SimpleKeyValue> properties = new ArrayList<SimpleKeyValue>();
        public boolean ignoreTombstones = true;
    }

    public static class ProducerParams {
        public boolean provideTimestamp;
    }

    public static class KsqlParams {
        public KsqlSyncType syncAs = KsqlSyncType.STREAM;
        public SingleValueKafkaFormat.KeyType keyType;
        public KsqlWindowType windowType = KsqlWindowType.NONE;
        public List<SimpleKeyValue> properties = new ArrayList<SimpleKeyValue>();
        public String timestamp;
        public String timestampFormat;

        public String getPropertyValue(String key, String defaultValue) {
            SimpleKeyValue property = this.getPropertyOrNull(key);
            if (property != null) {
                return StringUtils.defaultIfEmpty((String)property.value, (String)defaultValue);
            }
            return defaultValue;
        }

        public SimpleKeyValue getPropertyOrNull(String key) {
            for (SimpleKeyValue property : this.properties) {
                if (!StringUtils.equalsIgnoreCase((String)key, (String)property.key)) continue;
                return property;
            }
            return null;
        }

        public boolean removeProperty(String key) {
            Iterator<SimpleKeyValue> it = this.properties.iterator();
            int removed = 0;
            while (it.hasNext()) {
                SimpleKeyValue property = it.next();
                if (!StringUtils.equalsIgnoreCase((String)key, (String)property.key)) continue;
                it.remove();
                ++removed;
            }
            return removed > 0;
        }

        public boolean mergeDetectedSettings(KsqlParamsChanges detected) {
            boolean changed = false;
            if (detected.syncAs != null && this.syncAs != detected.syncAs) {
                this.syncAs = detected.syncAs;
                changed = true;
            }
            if (detected.keyType != null && this.keyType != detected.keyType) {
                this.keyType = detected.keyType;
                changed = true;
            }
            if (detected.windowType != null && this.windowType != detected.windowType) {
                this.windowType = detected.windowType;
                changed = true;
            }
            return changed;
        }
    }

    public static class KsqlParamsChanges {
        public KsqlSyncType syncAs;
        public SingleValueKafkaFormat.KeyType keyType;
        public KsqlWindowType windowType;
        public String keyName;
    }

    public static enum KsqlWindowType {
        NONE,
        TUMBLING,
        HOPPING,
        SESSION;

    }

    public static enum KsqlSyncType {
        STREAM,
        TABLE;

    }
}

