/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.streamlit;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppHandler;
import com.dataiku.dip.webapps.streamlit.StreamlitWebAppMeta;
import java.io.File;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractStreamlitWebAppHandler
extends WebAppHandler {
    @Autowired
    protected VariablesService variablesService;
    protected final StreamlitWebAppMeta.StreamlitWebAppParams params;
    private static final String MAIN_PYTHON_FILE_NAME = "backend.py";
    private static final String CONFIG_FILE_NAME = "config.toml";

    AbstractStreamlitWebAppHandler(WebApp webapp) {
        this.webapp = webapp;
        this.params = webapp.getParamsAs(StreamlitWebAppMeta.StreamlitWebAppParams.class);
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public void initWebApp() throws IOException {
    }

    @Override
    public void initCustomWebApp() throws IOException {
    }

    protected File getMainPythonFile(File directory) {
        return new File(directory, MAIN_PYTHON_FILE_NAME);
    }

    protected File getConfigFile(File directory) {
        return new File(directory, CONFIG_FILE_NAME);
    }

    protected RelFile getMainPythonRelFile(RelFile directory) {
        return directory.append(new String[]{MAIN_PYTHON_FILE_NAME});
    }

    protected RelFile getConfigRelFile(RelFile directory) {
        return directory.append(new String[]{CONFIG_FILE_NAME});
    }
}

