/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class SharedSecretUtils {
    private static Logger logger = Logger.getLogger((String)"dip.shared.secret");

    public static synchronized String getSharedSecretOrNull() {
        return SharedSecretUtils.getSharedSecret(true, false);
    }

    public static synchronized String getSharedSecret(boolean canCreate) {
        return SharedSecretUtils.getSharedSecret(false, canCreate);
    }

    private static synchronized String getSharedSecret(boolean isOptional, boolean canCreate) {
        try {
            String sharedSecret = null;
            File f = DKUApp.getFile("run/shared-secret.txt");
            if (f.exists() && f.length() > 0L) {
                logger.trace((Object)"Read shared secret from existing file");
                sharedSecret = DKUFileUtils.readFileToStringUTF8((File)f);
            } else if (canCreate) {
                logger.info((Object)"Create shared secret file");
                sharedSecret = SecretKeyGenerator.generate(64);
                DKUFileUtils.writeFileUTF8((File)f, (String)sharedSecret);
            } else {
                if (isOptional) {
                    return null;
                }
                logger.error((Object)"Missing shared secret file, and current process has no right to recreate it");
                throw new IOException("File " + f.getAbsolutePath() + " is missing or empty (maybe as a result of hard power-off of the machine). Remove and restart DSS.");
            }
            return sharedSecret.trim();
        }
        catch (IOException e) {
            throw new Error("Unexpected error", e);
        }
    }
}

