/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.security.SecurityCodes;
import com.dataiku.dip.utils.StringUtils;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

public class PasswordUtils {
    static SecureRandom sr;

    private static byte[] generateSalt(int size) {
        byte[] salt = new byte[size];
        sr.nextBytes(salt);
        return salt;
    }

    public static String encryptPassword(String unencryptedPassword) {
        try {
            byte[] bsalt = PasswordUtils.generateSalt(8);
            int iterations = 10000;
            char[] chars = unencryptedPassword.toCharArray();
            PBEKeySpec spec = new PBEKeySpec(chars, bsalt, iterations, 512);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            byte[] hash = skf.generateSecret(spec).getEncoded();
            return "pbkdf2:" + iterations + ":" + Hex.encodeHexString((byte[])bsalt) + ":" + Hex.encodeHexString((byte[])hash);
        }
        catch (Exception e) {
            throw new Error("Can't encrypt password", e);
        }
    }

    public static boolean verifyPassword(String unencryptedPassword, String encryptedPassword) throws CodedException {
        try {
            if (StringUtils.nullIfBlank((String)encryptedPassword) == null) {
                return false;
            }
            String[] parts = encryptedPassword.split(":");
            if (parts.length < 2) {
                throw new CodedException((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_INVALID_PASSWORD, "Invalid encrypted password");
            }
            String algorithm = parts[0];
            if (algorithm.equalsIgnoreCase("pbkdf2")) {
                if (parts.length != 4) {
                    throw new CodedException((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_INVALID_PASSWORD, "Invalid encrypted password");
                }
                int iterations = Integer.parseInt(parts[1]);
                byte[] storedSalt = Hex.decodeHex((char[])parts[2].toCharArray());
                byte[] storedHash = Hex.decodeHex((char[])parts[3].toCharArray());
                PBEKeySpec spec = new PBEKeySpec(unencryptedPassword.toCharArray(), storedSalt, iterations, storedHash.length * 8);
                SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
                byte[] computedHash = skf.generateSecret(spec).getEncoded();
                return Arrays.equals(computedHash, storedHash);
            }
            if (algorithm.equalsIgnoreCase("md5")) {
                if (parts.length != 3) {
                    throw new CodedException((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_INVALID_PASSWORD, "Invalid encrypted password");
                }
                String storedSalt = parts[1];
                String storedHash = parts[2];
                String computedHash = DigestUtils.md5Hex((String)(storedSalt + unencryptedPassword));
                return computedHash.equals(storedHash);
            }
            throw new CodedException((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_INVALID_PASSWORD, "Invalid password algorithm");
        }
        catch (DecoderException e) {
            return false;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new Error("Can't verify password", e);
        }
    }

    static {
        try {
            sr = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("Can't initialize password security", e);
        }
    }
}

