/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.catalog;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dataflow.exec.AbstractCodeBasedActivityRunner;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.fs.HDFSableDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.sek.SparkSQLValidationContext;
import com.dataiku.dip.sek.SparkSQLValidator$;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.spark.FastPathHandler;
import com.dataiku.dip.spark.FlowDatasetRef;
import com.dataiku.dip.spark.HadoopFormatsSupport$;
import com.dataiku.dip.spark.catalog.DSSCSVTable;
import com.dataiku.dip.spark.catalog.DSSDeltaTable;
import com.dataiku.dip.spark.catalog.DSSHadoopTable;
import com.dataiku.dip.spark.catalog.DSSIntercomClientFactory;
import com.dataiku.dip.spark.catalog.DSSJsonTable;
import com.dataiku.dip.spark.catalog.DSSOrcTable;
import com.dataiku.dip.spark.catalog.DSSParquetTable;
import com.dataiku.dip.spark.catalog.DSSTable;
import com.dataiku.dip.spark.catalog.DSSTableCatalog$;
import com.dataiku.dip.spark.package$;
import com.dataiku.dip.variables.HierarchicalVariablesContext;
import com.dataiku.dip.variables.ManualVariablesService;
import com.dataiku.dip.variables.ThreadLocalManualVariablesService;
import com.dataiku.dip.variables.VariablesService;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.util.HashMap;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.execution.datasources.PartitionPath;
import org.apache.spark.sql.execution.datasources.PartitionSpec;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t\u001db\u0001B\u0013'\u0001EBQa\u0013\u0001\u0005\u00021Cqa\u0014\u0001A\u0002\u0013%\u0001\u000bC\u0004_\u0001\u0001\u0007I\u0011B0\t\r\u0019\u0004\u0001\u0015)\u0003R\u0011\u001d9\u0007\u00011A\u0005\nACq\u0001\u001b\u0001A\u0002\u0013%\u0011\u000e\u0003\u0004l\u0001\u0001\u0006K!\u0015\u0005\bY\u0002\u0001\r\u0011\"\u0003n\u0011\u001d\t\b\u00011A\u0005\nIDa\u0001\u001e\u0001!B\u0013q\u0007bB;\u0001\u0001\u0004%IA\u001e\u0005\b{\u0002\u0001\r\u0011\"\u0003\u007f\u0011\u001d\t\t\u0001\u0001Q!\n]Dq!a\u0001\u0001\t\u0003\n)\u0001C\u0004\u0002\b\u0001!\t%!\u0003\t\u000f\u0005u\u0001\u0001\"\u0003\u0002 !9\u0011Q\u0006\u0001\u0005\n\u0005=\u0002bBA\u001e\u0001\u0011\u0005\u0013Q\b\u0005\b\u0003\u000b\u0002A\u0011IA$\u0011\u001d\t)\u0006\u0001C!\u0003/Bq!a\u0019\u0001\t\u0003\t)\u0007C\u0004\u0002z\u0001!\t%a\u001f\t\u000f\u0005=\u0006\u0001\"\u0011\u00022\"9\u0011Q\u0019\u0001\u0005B\u0005\u001d\u0007bBAf\u0001\u0011\u0005\u0013Q\u001a\u0005\b\u0003+\u0004A\u0011IAl\u0011\u001d\t)\u000e\u0001C!\u00037Dq!!9\u0001\t\u0003\n\u0019\u000fC\u0004\u0002h\u0002!\t%!;\t\u000f\u0005=\b\u0001\"\u0011\u0002r\"9!\u0011\u0001\u0001\u0005B\t\rqa\u0002B\u0004M!\u0005!\u0011\u0002\u0004\u0007K\u0019B\tAa\u0003\t\r-\u000bC\u0011\u0001B\n\u0011%\u0011)\"\tb\u0001\n\u0003\u00119\u0002\u0003\u0005\u0003&\u0005\u0002\u000b\u0011\u0002B\r\u0005=!5k\u0015+bE2,7)\u0019;bY><'BA\u0014)\u0003\u001d\u0019\u0017\r^1m_\u001eT!!\u000b\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u0005-b\u0013a\u00013ja*\u0011QFL\u0001\bI\u0006$\u0018-[6v\u0015\u0005y\u0013aA2p[\u000e\u00011\u0003\u0002\u00013u!\u0003\"a\r\u001d\u000e\u0003QR!!\u000e\u001c\u0002\t1\fgn\u001a\u0006\u0002o\u0005!!.\u0019<b\u0013\tIDG\u0001\u0004PE*,7\r\u001e\t\u0003w\u0019k\u0011\u0001\u0010\u0006\u0003OuR!AP \u0002\u0013\r|gN\\3di>\u0014(B\u0001!B\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003S\tS!a\u0011#\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0015aA8sO&\u0011q\t\u0010\u0002\r)\u0006\u0014G.Z\"bi\u0006dwn\u001a\t\u0003w%K!A\u0013\u001f\u0003%M+\b\u000f]8siNt\u0015-\\3ta\u0006\u001cWm]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035\u0003\"A\u0014\u0001\u000e\u0003\u0019\n1bY1uC2|wMT1nKV\t\u0011\u000b\u0005\u0002S7:\u00111+\u0017\t\u0003)^k\u0011!\u0016\u0006\u0003-B\na\u0001\u0010:p_Rt$\"\u0001-\u0002\u000bM\u001c\u0017\r\\1\n\u0005i;\u0016A\u0002)sK\u0012,g-\u0003\u0002];\n11\u000b\u001e:j]\u001eT!AW,\u0002\u001f\r\fG/\u00197pO:\u000bW.Z0%KF$\"\u0001\u00193\u0011\u0005\u0005\u0014W\"A,\n\u0005\r<&\u0001B+oSRDq!Z\u0002\u0002\u0002\u0003\u0007\u0011+A\u0002yIE\nAbY1uC2|wMT1nK\u0002\n\u0011cY8oi\u0016DH\u000f\u0015:pU\u0016\u001cGoS3z\u0003U\u0019wN\u001c;fqR\u0004&o\u001c6fGR\\U-_0%KF$\"\u0001\u00196\t\u000f\u00154\u0011\u0011!a\u0001#\u0006\u00112m\u001c8uKb$\bK]8kK\u000e$8*Z=!\u00035\u0019G.[3oi\u001a\u000b7\r^8ssV\ta\u000e\u0005\u0002O_&\u0011\u0001O\n\u0002\u0019\tN\u001b\u0016J\u001c;fe\u000e|Wn\u00117jK:$h)Y2u_JL\u0018!E2mS\u0016tGOR1di>\u0014\u0018p\u0018\u0013fcR\u0011\u0001m\u001d\u0005\bK&\t\t\u00111\u0001o\u00039\u0019G.[3oi\u001a\u000b7\r^8ss\u0002\naa\u00197jK:$X#A<\u0011\u0005a\\X\"A=\u000b\u0005iT\u0013a\u0001:qG&\u0011A0\u001f\u0002\u001d)&\u001c7.\u001a;CCN,G-\u00138uKJ\u001cw.\\!Q\u0013\u000ec\u0017.\u001a8u\u0003)\u0019G.[3oi~#S-\u001d\u000b\u0003A~Dq!\u001a\u0007\u0002\u0002\u0003\u0007q/A\u0004dY&,g\u000e\u001e\u0011\u0002\t9\fW.\u001a\u000b\u0002#\u0006Q\u0011N\\5uS\u0006d\u0017N_3\u0015\u000b\u0001\fY!!\u0004\t\r\u0005\rq\u00021\u0001R\u0011\u001d\tya\u0004a\u0001\u0003#\tqa\u001c9uS>t7\u000f\u0005\u0003\u0002\u0014\u0005eQBAA\u000b\u0015\r\t9bP\u0001\u0005kRLG.\u0003\u0003\u0002\u001c\u0005U!\u0001G\"bg\u0016Len]3og&$\u0018N^3TiJLgnZ'ba\u0006Iq-\u001a;DY&,g\u000e\u001e\u000b\u0003\u0003C\u0001b!YA\u0012o\u0006\u001d\u0012bAA\u0013/\n1A+\u001e9mKJ\u00022!YA\u0015\u0013\r\tYc\u0016\u0002\b\u0005>|G.Z1o\u0003E9W\r^+S\u0019\u000e+'\u000f^!oIB\u000bG\u000f[\u000b\u0003\u0003c\u0001\u0002\"YA\u001a\u0003o\t\u0016qG\u0005\u0004\u0003k9&A\u0002+va2,7\u0007E\u00024\u0003sI!\u0001\u0018\u001b\u0002!\u0011,g-Y;mi:\u000bW.Z:qC\u000e,GCAA !\u0011\t\u0017\u0011I)\n\u0007\u0005\rsKA\u0003BeJ\f\u00170\u0001\u0006mSN$H+\u00192mKN$B!!\u0013\u0002RA)\u0011-!\u0011\u0002LA\u00191(!\u0014\n\u0007\u0005=CH\u0001\u0006JI\u0016tG/\u001b4jKJDq!a\u0015\u0014\u0001\u0004\ty$A\u0005oC6,7\u000f]1dK\u0006IAn\\1e)\u0006\u0014G.\u001a\u000b\u0005\u00033\ny\u0006E\u0002<\u00037J1!!\u0018=\u0005\u0015!\u0016M\u00197f\u0011\u001d\t\t\u0007\u0006a\u0001\u0003\u0017\n!\"\u001b3f]RLg-[3s\u0003)\u0011W/\u001b7e)\u0006\u0014G.\u001a\u000b\u0007\u00033\n9'!\u001b\t\u000f\u0005\u0005T\u00031\u0001\u0002L!9\u00111N\u000bA\u0002\u00055\u0014AA:e!\u0011\ty'!\u001e\u000e\u0005\u0005E$bAA:U\u0005I1m\u001c:f[>$W\r\\\u0005\u0005\u0003o\n\tHA\tTKJL\u0017\r\\5{K\u0012$\u0015\r^1tKR\f1b\u0019:fCR,G+\u00192mKRQ\u0011\u0011LA?\u0003\u007f\ny)!)\t\u000f\u0005\u0005d\u00031\u0001\u0002L!9\u0011\u0011\u0011\fA\u0002\u0005\r\u0015AC:ueV\u001cG\u000fV=qKB!\u0011QQAF\u001b\t\t9IC\u0002\u0002\n~\nQ\u0001^=qKNLA!!$\u0002\b\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000f\u0005Ee\u00031\u0001\u0002\u0014\u0006QAO]1og\u001a|'/\\:\u0011\u000b\u0005\f\t%!&\u0011\t\u0005]\u0015QT\u0007\u0003\u00033S1!a'>\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\t\u0005}\u0015\u0011\u0014\u0002\n)J\fgn\u001d4pe6Dq!a)\u0017\u0001\u0004\t)+A\u0002nCB\u0004b!a*\u0002,F\u000bVBAAU\u0015\r\t9BN\u0005\u0005\u0003[\u000bIKA\u0002NCB\f!\"\u00197uKJ$\u0016M\u00197f)\u0019\tI&a-\u00026\"9\u0011\u0011M\fA\u0002\u0005-\u0003bBA\\/\u0001\u0007\u0011\u0011X\u0001\ri\u0006\u0014G.Z\"iC:<Wm\u001d\t\u0006C\u0006m\u0016qX\u0005\u0004\u0003{;&A\u0003\u001fsKB,\u0017\r^3e}A\u00191(!1\n\u0007\u0005\rGHA\u0006UC\ndWm\u00115b]\u001e,\u0017!\u00033s_B$\u0016M\u00197f)\u0011\t9#!3\t\u000f\u0005\u0005\u0004\u00041\u0001\u0002L\u0005Y!/\u001a8b[\u0016$\u0016M\u00197f)\u0015\u0001\u0017qZAi\u0011\u001d\t\t'\u0007a\u0001\u0003\u0017Bq!a5\u001a\u0001\u0004\tY%A\u0006jI\u0016tG/\u001b4jKJ\f\u0014A\u00047jgRt\u0015-\\3ta\u0006\u001cWm\u001d\u000b\u0003\u00033\u0004R!YA!\u0003\u007f!B!!7\u0002^\"9\u0011q\\\u000eA\u0002\u0005}\u0012aB:ue&twm]\u0001\u0016Y>\fGMT1nKN\u0004\u0018mY3NKR\fG-\u0019;b)\u0011\t)+!:\t\u000f\u0005MC\u00041\u0001\u0002@\u0005y1M]3bi\u0016t\u0015-\\3ta\u0006\u001cW\rF\u0003a\u0003W\fi\u000fC\u0004\u0002`v\u0001\r!a\u0010\t\u000f\u0005\rV\u00041\u0001\u0002&\u0006q\u0011\r\u001c;fe:\u000bW.Z:qC\u000e,G#\u00021\u0002t\u0006U\bbBAp=\u0001\u0007\u0011q\b\u0005\b\u0003ot\u0002\u0019AA}\u0003Aq\u0017-\\3ta\u0006\u001cWm\u00115b]\u001e,7\u000fE\u0003b\u0003w\u000bY\u0010E\u0002<\u0003{L1!a@=\u0005=q\u0015-\\3ta\u0006\u001cWm\u00115b]\u001e,\u0017!\u00043s_Bt\u0015-\\3ta\u0006\u001cW\r\u0006\u0003\u0002(\t\u0015\u0001bBAp?\u0001\u0007\u0011qH\u0001\u0010\tN\u001bF+\u00192mK\u000e\u000bG/\u00197pOB\u0011a*I\n\u0004C\t5\u0001cA1\u0003\u0010%\u0019!\u0011C,\u0003\r\u0005s\u0017PU3g)\t\u0011I!\u0001\u0004m_\u001e<WM]\u000b\u0003\u00053\u0001BAa\u0007\u0003\"5\u0011!Q\u0004\u0006\u0004\u0005?\u0011\u0015!\u00027pORR\u0017\u0002\u0002B\u0012\u0005;\u0011a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000f\t")
public class DSSTableCatalog
implements TableCatalog,
SupportsNamespaces {
    private String catalogName = null;
    private String contextProjectKey = null;
    private DSSIntercomClientFactory com$dataiku$dip$spark$catalog$DSSTableCatalog$$clientFactory = null;
    private TicketBasedIntercomAPIClient client = null;

    public static Logger logger() {
        return DSSTableCatalog$.MODULE$.logger();
    }

    public boolean namespaceExists(String[] x$1) {
        return super.namespaceExists(x$1);
    }

    public void invalidateTable(Identifier x$1) {
        super.invalidateTable(x$1);
    }

    public boolean tableExists(Identifier x$1) {
        return super.tableExists(x$1);
    }

    private String catalogName() {
        return this.catalogName;
    }

    private void catalogName_$eq(String x$1) {
        this.catalogName = x$1;
    }

    private String contextProjectKey() {
        return this.contextProjectKey;
    }

    private void contextProjectKey_$eq(String x$1) {
        this.contextProjectKey = x$1;
    }

    public DSSIntercomClientFactory com$dataiku$dip$spark$catalog$DSSTableCatalog$$clientFactory() {
        return this.com$dataiku$dip$spark$catalog$DSSTableCatalog$$clientFactory;
    }

    private void com$dataiku$dip$spark$catalog$DSSTableCatalog$$clientFactory_$eq(DSSIntercomClientFactory x$1) {
        this.com$dataiku$dip$spark$catalog$DSSTableCatalog$$clientFactory = x$1;
    }

    private TicketBasedIntercomAPIClient client() {
        return this.client;
    }

    private void client_$eq(TicketBasedIntercomAPIClient x$1) {
        this.client = x$1;
    }

    public String name() {
        Predef$.MODULE$.require(this.catalogName() != null, (Function0 & Serializable & scala.Serializable)() -> "The DSS table catalog is not initialed");
        return this.catalogName();
    }

    public void initialize(String name, CaseInsensitiveStringMap options) {
        Predef$.MODULE$.assert(this.catalogName() == null, (Function0 & Serializable & scala.Serializable)() -> "The DSS table catalog is already initialed");
        this.catalogName_$eq(name);
        this.contextProjectKey_$eq(com.dataiku.dip.remoterun.package$.MODULE$.getProjectFromEnv());
        String apiTicket = com.dataiku.dip.remoterun.package$.MODULE$.getOrElse("DKU_API_TICKET", null);
        Tuple3<String, String, String> tuple3 = this.getURLCertAndPath();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String apiUrl = (String)tuple3._1();
        String apiServerCert = (String)tuple3._2();
        String apiPath = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)apiUrl, (Object)apiServerCert, (Object)apiPath);
        String apiUrl2 = (String)tuple32._1();
        String apiServerCert2 = (String)tuple32._2();
        String apiPath2 = (String)tuple32._3();
        this.com$dataiku$dip$spark$catalog$DSSTableCatalog$$clientFactory_$eq(new DSSIntercomClientFactory(apiUrl2, apiServerCert2, apiTicket, this.contextProjectKey(), apiPath2));
    }

    private Tuple2<TicketBasedIntercomAPIClient, Object> getClient() {
        SparkSQLValidationContext sparkSqlValCtx = (SparkSQLValidationContext)SparkSQLValidator$.MODULE$.context().get();
        if (sparkSqlValCtx != null) {
            DSSIntercomClientFactory valClientFactory = new DSSIntercomClientFactory(this.com$dataiku$dip$spark$catalog$DSSTableCatalog$$clientFactory().apiUrl(), this.com$dataiku$dip$spark$catalog$DSSTableCatalog$$clientFactory().apiServerCert(), sparkSqlValCtx.apiTicket(), sparkSqlValCtx.projectKey(), this.com$dataiku$dip$spark$catalog$DSSTableCatalog$$clientFactory().apiPath());
            return new Tuple2((Object)valClientFactory.build(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        if (this.client() == null) {
            this.client_$eq(this.com$dataiku$dip$spark$catalog$DSSTableCatalog$$clientFactory().build());
        }
        return new Tuple2((Object)this.client(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    private Tuple3<String, String, String> getURLCertAndPath() {
        Tuple4 tuple4;
        Tuple4 tuple42;
        Some some;
        String string;
        Option<String> option = com.dataiku.dip.remoterun.package$.MODULE$.get("DKU_SERVER_KIND");
        if (option instanceof Some && "JEK".equals(string = (String)(some = (Some)option).value())) {
            DSSTableCatalog$.MODULE$.logger().info((Object)"Catalog for job");
            String apiHost = com.dataiku.dip.remoterun.package$.MODULE$.getOrElse("DKU_SERVER_HOST", InetAddress.getLocalHost().getHostName());
            int apiPort = new StringOps(Predef$.MODULE$.augmentString(com.dataiku.dip.remoterun.package$.MODULE$.getOrElse("DKU_SERVER_PORT", "0"))).toInt();
            String apiProtocol = com.dataiku.dip.remoterun.package$.MODULE$.getOrElse("DKU_SERVER_PROTOCOL", "http");
            AbstractCodeBasedActivityRunner.FlowSpec flowSpec = (AbstractCodeBasedActivityRunner.FlowSpec)com.dataiku.dip.remoterun.package$.MODULE$.getFlowSpec().getOrElse((Function0 & Serializable & scala.Serializable)() -> null);
            String apiPath = flowSpec.tintercomAPIBase;
            String activityId = flowSpec.currentActivityId;
            DSSTableCatalog$.MODULE$.logger().info((Object)new StringBuilder(48).append("Init: running in flow, JEK port = ").append(apiPort).append(" activityId = ").append(activityId).toString());
            tuple42 = new Tuple4((Object)apiProtocol, (Object)apiHost, (Object)BoxesRunTime.boxToInteger((int)apiPort), (Object)apiPath);
        } else {
            String apiPath = "dip/api/tintercom";
            String apiHost = com.dataiku.dip.remoterun.package$.MODULE$.getOrElse("DKU_BACKEND_HOST", InetAddress.getLocalHost().getHostName());
            int apiPort = new StringOps(Predef$.MODULE$.augmentString(com.dataiku.dip.remoterun.package$.MODULE$.getOrElse("DKU_BACKEND_PORT", "0"))).toInt();
            String apiProtocol = com.dataiku.dip.remoterun.package$.MODULE$.getOrElse("DKU_SERVER_PROTOCOL", "http");
            DSSTableCatalog$.MODULE$.logger().info((Object)new StringBuilder(53).append("Init: not running in flow (type is ").append(com.dataiku.dip.remoterun.package$.MODULE$.get("DKU_SERVER_KIND")).append("), backend port = ").append(apiPort).toString());
            tuple42 = tuple4 = new Tuple4((Object)apiProtocol, (Object)apiHost, (Object)BoxesRunTime.boxToInteger((int)apiPort), (Object)apiPath);
        }
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        String apiProtocol = (String)tuple4._1();
        String apiHost = (String)tuple4._2();
        int apiPort = BoxesRunTime.unboxToInt((Object)tuple4._3());
        String apiPath = (String)tuple4._4();
        Tuple4 tuple43 = new Tuple4((Object)apiProtocol, (Object)apiHost, (Object)BoxesRunTime.boxToInteger((int)apiPort), (Object)apiPath);
        String apiProtocol2 = (String)tuple43._1();
        String apiHost2 = (String)tuple43._2();
        int apiPort2 = BoxesRunTime.unboxToInt((Object)tuple43._3());
        String apiPath2 = (String)tuple43._4();
        String effectiveApiHost = com.dataiku.dip.remoterun.package$.MODULE$.getOrElse("DKU_TUNNEL_HOST", apiHost2);
        int effectiveApiPort = new StringOps(Predef$.MODULE$.augmentString(com.dataiku.dip.remoterun.package$.MODULE$.getOrElse("DKU_TUNNEL_PORT", Integer.toString(apiPort2)))).toInt();
        DSSTableCatalog$.MODULE$.logger().info((Object)new StringBuilder(30).append("Init: effective api ").append(effectiveApiHost).append(":").append(effectiveApiPort).append("/basePath").toString());
        String apiServerCert = com.dataiku.dip.remoterun.package$.MODULE$.getOrElse("DKU_SERVER_CERT", null);
        return new Tuple3((Object)new StringBuilder(4).append(apiProtocol2).append("://").append(effectiveApiHost).append(":").append(effectiveApiPort).toString(), (Object)apiServerCert, (Object)apiPath2);
    }

    public String[] defaultNamespace() {
        if (this.contextProjectKey() == null || this.contextProjectKey().isEmpty()) {
            return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        }
        return (String[])((Object[])new String[]{this.contextProjectKey()});
    }

    public Identifier[] listTables(String[] namespace) {
        Identifier[] identifierArray;
        if (namespace == null || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespace)).isEmpty()) {
            throw new UnsupportedOperationException("Can't list all tables, a non-empty namespace is required");
        }
        DSSTableCatalog$.MODULE$.logger().info((Object)new StringBuilder(15).append("List tables in ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespace)).mkString(", ")).toString());
        String projectKey = namespace[0];
        Tuple2<TicketBasedIntercomAPIClient, Object> tuple2 = this.getClient();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TicketBasedIntercomAPIClient client = (TicketBasedIntercomAPIClient)tuple2._1();
        boolean doClose = tuple2._2$mcZ$sp();
        Tuple2 tuple22 = new Tuple2((Object)client, (Object)BoxesRunTime.boxToBoolean((boolean)doClose));
        TicketBasedIntercomAPIClient client2 = (TicketBasedIntercomAPIClient)tuple22._1();
        boolean doClose2 = tuple22._2$mcZ$sp();
        try {
            java.util.List datasetNames = (java.util.List)client2.getForm(new StringBuilder(14).append(this.com$dataiku$dip$spark$catalog$DSSTableCatalog$$clientFactory().apiPath()).append("/datasets/list").toString(), java.util.List.class, new Object[]{"projectKey", projectKey});
            identifierArray = (Identifier[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(datasetNames).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> Identifier.of((String[])namespace, (String)x$4), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Identifier.class));
        }
        finally {
            if (doClose2) {
                client2.close();
            }
        }
        return identifierArray;
    }

    public Table loadTable(Identifier identifier) {
        Table table;
        DSSTableCatalog$.MODULE$.logger().info((Object)new StringBuilder(14).append("Get table ").append(identifier.name()).append(" in ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])identifier.namespace())).mkString(", ")).toString());
        String projectKey = identifier.namespace()[0];
        String datasetName = identifier.name();
        try {
            Tuple2<TicketBasedIntercomAPIClient, Object> tuple2 = this.getClient();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TicketBasedIntercomAPIClient client = (TicketBasedIntercomAPIClient)tuple2._1();
            boolean doClose = tuple2._2$mcZ$sp();
            Tuple2 tuple22 = new Tuple2((Object)client, (Object)BoxesRunTime.boxToBoolean((boolean)doClose));
            TicketBasedIntercomAPIClient client2 = (TicketBasedIntercomAPIClient)tuple22._1();
            boolean doClose2 = tuple22._2$mcZ$sp();
            try {
                SerializedDataset sd = (SerializedDataset)client2.getForm(new StringBuilder(22).append(this.com$dataiku$dip$spark$catalog$DSSTableCatalog$$clientFactory().apiPath()).append("/datasets/read-config/").toString(), SerializedDataset.class, new Object[]{"projectKey", projectKey, "datasetName", datasetName});
                table = this.buildTable(identifier, sd);
            }
            finally {
                if (doClose2) {
                    client2.close();
                }
            }
        }
        catch (Throwable t) {
            DSSTableCatalog$.MODULE$.logger().error((Object)"Failed to load table", t);
            throw new NoSuchTableException(identifier);
        }
        return table;
    }

    public Table buildTable(Identifier identifier, SerializedDataset sd) {
        Tuple2 tuple2;
        Object object;
        java.util.Map perProjectVariables;
        java.util.Map map;
        Dataset dataset = Dataset.fromSerialized((SerializedDataset)sd);
        SamplingParam sampling = null;
        List<String> partitions = null;
        String filterExpression = null;
        List<String> columnNames = null;
        SQLContext sqlContext = ((SparkSession)SparkSession$.MODULE$.getActiveSession().get()).sqlContext();
        VariablesService variablesService = (VariablesService)SpringUtils.getBean(VariablesService.class);
        if (variablesService instanceof ManualVariablesService) {
            ManualVariablesService manualVariablesService = (ManualVariablesService)variablesService;
            map = manualVariablesService.perProject;
        } else if (variablesService instanceof ThreadLocalManualVariablesService) {
            ThreadLocalManualVariablesService threadLocalManualVariablesService = (ThreadLocalManualVariablesService)variablesService;
            if (threadLocalManualVariablesService.perProject.get() == null) {
                threadLocalManualVariablesService.perProject.set(new HashMap());
            }
            map = (java.util.Map)threadLocalManualVariablesService.perProject.get();
        } else {
            DSSTableCatalog$.MODULE$.logger().warn((Object)new StringBuilder(66).append("Can't set project variables for the table, variables service is a ").append(variablesService.getClass().getCanonicalName()).toString());
            map = perProjectVariables = null;
        }
        if (perProjectVariables != null && !perProjectVariables.containsKey(sd.projectKey)) {
            Tuple2<TicketBasedIntercomAPIClient, Object> tuple22 = this.getClient();
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            TicketBasedIntercomAPIClient client = (TicketBasedIntercomAPIClient)tuple22._1();
            boolean doClose = tuple22._2$mcZ$sp();
            Tuple2 tuple23 = new Tuple2((Object)client, (Object)BoxesRunTime.boxToBoolean((boolean)doClose));
            TicketBasedIntercomAPIClient client2 = (TicketBasedIntercomAPIClient)tuple23._1();
            boolean doClose2 = tuple23._2$mcZ$sp();
            try {
                DSSTableCatalog$.MODULE$.logger().info((Object)new StringBuilder(27).append("Load project variables for ").append(sd.projectKey).toString());
                object = perProjectVariables.put(sd.projectKey, client2.postFormToJSON(new StringBuilder(34).append(this.com$dataiku$dip$spark$catalog$DSSTableCatalog$$clientFactory().apiPath()).append("/variables/get-context-for-project").toString(), HierarchicalVariablesContext.class, new Object[]{"projectKey", sd.projectKey}));
            }
            finally {
                if (doClose2) {
                    client2.close();
                }
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        if ((tuple2 = new FastPathHandler<Table>(this, identifier, sd, dataset){
            private final /* synthetic */ DSSTableCatalog $outer;
            private final Identifier identifier$1;
            private final SerializedDataset sd$1;
            private final Dataset dataset$1;

            public boolean canUnnestJson() {
                return false;
            }

            public Tuple2<Table, FlowDatasetRef.InputDatasetDataframeReadMode> getAsRemote(SQLContext sqlContext, Dataset dataset, SamplingParam sampling, List<String> partitions, List<String> columnNames, String filterExpression) {
                return new Tuple2((Object)new DSSTable(this.identifier$1, this.sd$1, this.$outer.com$dataiku$dip$spark$catalog$DSSTableCatalog$$clientFactory()), (Object)FlowDatasetRef.InputDatasetDataframeReadMode.REMOTE);
            }

            public SamplingParam getAsRemote$default$3() {
                return null;
            }

            public List<String> getAsRemote$default$4() {
                return null;
            }

            public List<String> getAsRemote$default$5() {
                return null;
            }

            public String getAsRemote$default$6() {
                return null;
            }

            public Tuple2<Table, FlowDatasetRef.InputDatasetDataframeReadMode> getAsHiveserver2(SQLContext sqlContext, Dataset dataset, SamplingParam sampling, List<String> partitions, List<String> columnNames, String filterExpression) {
                DSSTableCatalog$.MODULE$.logger().warn((Object)new StringBuilder(116).append("get ").append(dataset.getFullName()).append(": Reading a Hive table as a remote dataframe. Computation will not be distributed: no fast-path from DSS catalog").toString());
                return new Tuple2((Object)new DSSTable(this.identifier$1, this.sd$1, this.$outer.com$dataiku$dip$spark$catalog$DSSTableCatalog$$clientFactory()), (Object)FlowDatasetRef.InputDatasetDataframeReadMode.REMOTE);
            }

            public SamplingParam getAsHiveserver2$default$3() {
                return null;
            }

            public List<String> getAsHiveserver2$default$4() {
                return null;
            }

            public List<String> getAsHiveserver2$default$5() {
                return null;
            }

            public String getAsHiveserver2$default$6() {
                return null;
            }

            public Tuple2<Table, FlowDatasetRef.InputDatasetDataframeReadMode> getAsHadoopFromHDFSable(SQLContext sqlContext, Dataset dataset, HDFSableDatasetHandler dsh, SamplingParam sampling, List<String> columnNames, List<String> partitions, String filterExpression) {
                DSSTableCatalog$.MODULE$.logger().warn((Object)"Access to a HDFS dataset via the DSS catalog without native format.");
                return new Tuple2((Object)new DSSHadoopTable(this.identifier$1, this.sd$1, this.$outer.com$dataiku$dip$spark$catalog$DSSTableCatalog$$clientFactory()), (Object)FlowDatasetRef.InputDatasetDataframeReadMode.HADOOP_RDD);
            }

            public List<String> getAsHadoopFromHDFSable$default$5() {
                return null;
            }

            public List<String> getAsHadoopFromHDFSable$default$6() {
                return null;
            }

            public String getAsHadoopFromHDFSable$default$7() {
                return null;
            }

            public Table makeTableWithDSSPartitionSpecIfNeeded(HDFSableDatasetHandler handler, Seq<String> paths, Function2<Option<PartitionSpec>, Seq<String>, Table> makeTable) {
                PartitioningScheme partitioning = handler.getDataset().getPartitioningSchema();
                if (partitioning != null && partitioning.isPartitioned()) {
                    String rootPath = handler.getFullyQualifiedRootPath();
                    String rootPathNT = rootPath.endsWith("/") ? rootPath.substring(0, rootPath.length() - 1) : rootPath;
                    Seq cleanPathsWithinRoot = (Seq)((TraversableLike)paths.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.substring(rootPathNT.length()), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.replaceAll("/+", "/"), Seq$.MODULE$.canBuildFrom());
                    Seq cleanPaths = (Seq)cleanPathsWithinRoot.map((Function1 & Serializable & scala.Serializable)x$9 -> new StringBuilder(0).append(rootPathNT).append((String)x$9).toString(), Seq$.MODULE$.canBuildFrom());
                    FilePartitioner partitioner = new FilePartitioner(partitioning);
                    Buffer partitions = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(partitioner.getPartitionsFromFiles((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)cleanPathsWithinRoot.map((Function1 & Serializable & scala.Serializable)p -> new FSPath(p, 0L, 0L), Seq$.MODULE$.canBuildFrom())).asJava())).asScala();
                    PartitionPath[] partitionPaths = (PartitionPath[])((TraversableOnce)((GenericTraversableTemplate)partitions.map((Function1 & Serializable & scala.Serializable)p -> {
                        Buffer dimensionIds = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitioning.getDimensionNames()).asScala()).map((Function1 & Serializable & scala.Serializable)n -> ((DimensionValue)p.getDimensionValues().get(n)).id(), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$10 -> UTF8String.fromString((String)x$10), Buffer$.MODULE$.canBuildFrom());
                        return (PartitionPath[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(p.getAllPaths()).asScala()).map((Function1 & Serializable & scala.Serializable)path -> new PartitionPath(InternalRow$.MODULE$.fromSeq((Seq)dimensionIds), new Path(new StringBuilder(0).append(rootPathNT).append(path.path()).toString())), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(PartitionPath.class));
                    }, Buffer$.MODULE$.canBuildFrom())).flatten((Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef($anon$1.$anonfun$makeTableWithDSSPartitionSpecIfNeeded$9(xs)))).toArray(ClassTag$.MODULE$.apply(PartitionPath.class));
                    StructType partitionColumns = StructType$.MODULE$.apply((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitioning.getDimensionNames()).asScala()).map((Function1 & Serializable & scala.Serializable)x$11 -> new StructField(x$11, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Buffer$.MODULE$.canBuildFrom()));
                    PartitionSpec partitionSpec = new PartitionSpec(partitionColumns, (Seq)Predef$.MODULE$.wrapRefArray((Object[])partitionPaths));
                    return (Table)makeTable.apply((Object)new Some((Object)partitionSpec), (Object)cleanPaths);
                }
                return (Table)makeTable.apply((Object)None$.MODULE$, paths);
            }

            public Tuple2<Table, FlowDatasetRef.InputDatasetDataframeReadMode> getAsCsv(SQLContext sqlContext, HDFSableDatasetHandler handler, List<String> partitions, StructType schema, SamplingParam sampling, List<SchemaColumn> schemaColumns, scala.collection.immutable.Map<String, String> options, Seq<String> paths) {
                HashMap<String, String> optionsMap = new HashMap<String, String>();
                optionsMap.putAll((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(options).asJava());
                Object object = new StringOps(Predef$.MODULE$.augmentString(sqlContext.getConf("spark.dku.use.recursiveFileLookup", "true"))).toBoolean() ? optionsMap.put("recursiveFileLookup", "true") : BoxedUnit.UNIT;
                Table table = this.makeTableWithDSSPartitionSpecIfNeeded(handler, paths, (Function2<Option<PartitionSpec>, Seq<String>, Table>)(Function2 & Serializable & scala.Serializable)(dssSpecifiedPartitionSpec, cleanPaths) -> new DSSCSVTable(new StringBuilder(4).append("CSV ").append($this.sd$1.getFullName()).toString(), (SparkSession)SparkSession$.MODULE$.getActiveSession().get(), new CaseInsensitiveStringMap((java.util.Map)optionsMap), (Seq<String>)cleanPaths, (Option<StructType>)new Some((Object)package$.MODULE$.dkuToSpark($this.dataset$1.getSchema())), (Option<PartitionSpec>)dssSpecifiedPartitionSpec));
                return new Tuple2((Object)table, (Object)FlowDatasetRef.InputDatasetDataframeReadMode.CSV_FAST_PATH);
            }

            public Tuple2<Table, FlowDatasetRef.InputDatasetDataframeReadMode> getAsJson(SQLContext sqlContext, HDFSableDatasetHandler handler, List<String> partitions, StructType schema, SamplingParam sampling, List<SchemaColumn> schemaColumns, scala.collection.immutable.Map<String, String> options, Seq<String> paths) {
                HashMap<String, String> optionsMap = new HashMap<String, String>();
                optionsMap.putAll((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(options).asJava());
                Object object = new StringOps(Predef$.MODULE$.augmentString(sqlContext.getConf("spark.dku.use.recursiveFileLookup", "true"))).toBoolean() ? optionsMap.put("recursiveFileLookup", "true") : BoxedUnit.UNIT;
                Object object2 = HadoopFormatsSupport$.MODULE$.isJsonInputMultiline(sqlContext) ? optionsMap.put("multiLine", "true") : BoxedUnit.UNIT;
                Table table = this.makeTableWithDSSPartitionSpecIfNeeded(handler, paths, (Function2<Option<PartitionSpec>, Seq<String>, Table>)(Function2 & Serializable & scala.Serializable)(dssSpecifiedPartitionSpec, cleanPaths) -> new DSSJsonTable(new StringBuilder(5).append("Json ").append($this.sd$1.getFullName()).toString(), (SparkSession)SparkSession$.MODULE$.getActiveSession().get(), new CaseInsensitiveStringMap((java.util.Map)optionsMap), (Seq<String>)cleanPaths, (Option<StructType>)new Some((Object)package$.MODULE$.dkuToSpark($this.dataset$1.getSchema())), (Option<PartitionSpec>)dssSpecifiedPartitionSpec));
                return new Tuple2((Object)table, (Object)FlowDatasetRef.InputDatasetDataframeReadMode.JSON_FAST_PATH);
            }

            public Tuple2<Table, FlowDatasetRef.InputDatasetDataframeReadMode> getAsParquet(SQLContext sqlContext, HDFSableDatasetHandler handler, List<String> partitions, StructType schema, SamplingParam sampling, List<SchemaColumn> schemaColumns, boolean inferSchema, Seq<String> paths) {
                HashMap<String, String> optionsMap = new HashMap<String, String>();
                Object object = new StringOps(Predef$.MODULE$.augmentString(sqlContext.getConf("spark.dku.use.recursiveFileLookup", "true"))).toBoolean() ? optionsMap.put("recursiveFileLookup", "true") : BoxedUnit.UNIT;
                None$ userDefinedSchema = inferSchema ? None$.MODULE$ : new Some((Object)package$.MODULE$.dkuToSpark(this.dataset$1.getSchema()));
                Table table = this.makeTableWithDSSPartitionSpecIfNeeded(handler, paths, (Function2<Option<PartitionSpec>, Seq<String>, Table>)((Function2 & Serializable & scala.Serializable)(arg_0, arg_1) -> $anon$1.$anonfun$getAsParquet$1(this, optionsMap, (Option)userDefinedSchema, arg_0, arg_1)));
                return new Tuple2((Object)table, (Object)FlowDatasetRef.InputDatasetDataframeReadMode.PARQUET_FAST_PATH);
            }

            public Tuple2<Table, FlowDatasetRef.InputDatasetDataframeReadMode> getAsORC(SQLContext sqlContext, HDFSableDatasetHandler handler, List<String> partitions, StructType schema, SamplingParam sampling, List<SchemaColumn> schemaColumns, boolean inferSchema, Seq<String> paths) {
                HashMap<String, String> optionsMap = new HashMap<String, String>();
                Object object = new StringOps(Predef$.MODULE$.augmentString(sqlContext.getConf("spark.dku.use.recursiveFileLookup", "true"))).toBoolean() ? optionsMap.put("recursiveFileLookup", "true") : BoxedUnit.UNIT;
                None$ userDefinedSchema = inferSchema ? None$.MODULE$ : new Some((Object)package$.MODULE$.dkuToSpark(this.dataset$1.getSchema()));
                Table table = this.makeTableWithDSSPartitionSpecIfNeeded(handler, paths, (Function2<Option<PartitionSpec>, Seq<String>, Table>)((Function2 & Serializable & scala.Serializable)(arg_0, arg_1) -> $anon$1.$anonfun$getAsORC$1(this, optionsMap, (Option)userDefinedSchema, arg_0, arg_1)));
                return new Tuple2((Object)table, (Object)FlowDatasetRef.InputDatasetDataframeReadMode.ORC_FAST_PATH);
            }

            public Tuple2<Table, FlowDatasetRef.InputDatasetDataframeReadMode> getAsDelta(SQLContext sqlContext, HDFSableDatasetHandler handler, String path, List<String> partitions, StructType schema, SamplingParam sampling, List<SchemaColumn> schemaColumns) {
                DSSDeltaTable table = new DSSDeltaTable(new StringBuilder(7).append("Delta  ").append(this.sd$1.getFullName()).toString(), (SparkSession)SparkSession$.MODULE$.getActiveSession().get(), CaseInsensitiveStringMap.empty(), path);
                return new Tuple2((Object)((Object)table), (Object)FlowDatasetRef.InputDatasetDataframeReadMode.DELTA_LAKE);
            }

            public Tuple2<Table, FlowDatasetRef.InputDatasetDataframeReadMode> getAsSnowflake(SQLContext sqlContext, AbstractSQLTableDatasetHandler datasetHandler, StructType schema, List<String> partitions, SamplingParam sampling, List<SchemaColumn> schemaColumns, String filterExpression, boolean inferSchema, scala.collection.immutable.Map<String, String> options, String sql) {
                DSSTableCatalog$.MODULE$.logger().warn((Object)new StringBuilder(123).append("get ").append(this.dataset$1.getFullName()).append(": Reading a Snowflake dataset as a remote dataframe. Computation will not be distributed: no fast-path from DSS catalog").toString());
                return new Tuple2((Object)new DSSTable(this.identifier$1, this.sd$1, this.$outer.com$dataiku$dip$spark$catalog$DSSTableCatalog$$clientFactory()), (Object)FlowDatasetRef.InputDatasetDataframeReadMode.REMOTE);
            }

            public Tuple2<Table, FlowDatasetRef.InputDatasetDataframeReadMode> getAsSQL(SQLContext sqlContext, AbstractSQLTableDatasetHandler datasetHandler, StructType schema, List<String> partitions, SamplingParam sampling, List<SchemaColumn> schemaColumns, String filterExpression, boolean inferSchema, String jdbcUrl, String jdbcDriver, scala.collection.immutable.Map<String, String> jdbcOptions, String sql) {
                DSSTableCatalog$.MODULE$.logger().warn((Object)new StringBuilder(117).append("get ").append(this.dataset$1.getFullName()).append(": Reading a SQL dataset as a remote dataframe. Computation will not be distributed: no fast-path from DSS catalog").toString());
                return new Tuple2((Object)new DSSTable(this.identifier$1, this.sd$1, this.$outer.com$dataiku$dip$spark$catalog$DSSTableCatalog$$clientFactory()), (Object)FlowDatasetRef.InputDatasetDataframeReadMode.REMOTE);
            }

            public static final /* synthetic */ Object[] $anonfun$makeTableWithDSSPartitionSpecIfNeeded$9(PartitionPath[] xs) {
                return Predef$.MODULE$.refArrayOps((Object[])xs);
            }

            public static final /* synthetic */ DSSParquetTable $anonfun$getAsParquet$1($anon$1 $this, HashMap optionsMap$3, Option userDefinedSchema$1, Option dssSpecifiedPartitionSpec, Seq cleanPaths) {
                return new DSSParquetTable(new StringBuilder(8).append("Parquet ").append($this.sd$1.getFullName()).toString(), (SparkSession)SparkSession$.MODULE$.getActiveSession().get(), new CaseInsensitiveStringMap((java.util.Map)optionsMap$3), (Seq<String>)cleanPaths, (Option<StructType>)userDefinedSchema$1, (Option<PartitionSpec>)dssSpecifiedPartitionSpec);
            }

            public static final /* synthetic */ DSSOrcTable $anonfun$getAsORC$1($anon$1 $this, HashMap optionsMap$4, Option userDefinedSchema$2, Option dssSpecifiedPartitionSpec, Seq cleanPaths) {
                return new DSSOrcTable(new StringBuilder(4).append("ORC ").append($this.sd$1.getFullName()).toString(), (SparkSession)SparkSession$.MODULE$.getActiveSession().get(), new CaseInsensitiveStringMap((java.util.Map)optionsMap$4), (Seq<String>)cleanPaths, (Option<StructType>)userDefinedSchema$2, (Option<PartitionSpec>)dssSpecifiedPartitionSpec);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.identifier$1 = identifier$1;
                this.sd$1 = sd$1;
                this.dataset$1 = dataset$1;
                super("table");
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$makeTableWithDSSPartitionSpecIfNeeded$1(java.lang.String java.lang.String ), $anonfun$makeTableWithDSSPartitionSpecIfNeeded$2(java.lang.String ), $anonfun$makeTableWithDSSPartitionSpecIfNeeded$3(java.lang.String java.lang.String ), $anonfun$makeTableWithDSSPartitionSpecIfNeeded$4(java.lang.String ), $anonfun$makeTableWithDSSPartitionSpecIfNeeded$5(com.dataiku.dip.partitioning.PartitioningScheme java.lang.String com.dataiku.dip.partitioning.FilePartition ), $anonfun$makeTableWithDSSPartitionSpecIfNeeded$9$adapted(org.apache.spark.sql.execution.datasources.PartitionPath[] ), $anonfun$makeTableWithDSSPartitionSpecIfNeeded$10(java.lang.String ), $anonfun$getAsCsv$1(com.dataiku.dip.spark.catalog.DSSTableCatalog$$anon$1 java.util.HashMap scala.Option scala.collection.Seq ), $anonfun$getAsJson$1(com.dataiku.dip.spark.catalog.DSSTableCatalog$$anon$1 java.util.HashMap scala.Option scala.collection.Seq ), $anonfun$getAsParquet$1(com.dataiku.dip.spark.catalog.DSSTableCatalog$$anon$1 java.util.HashMap scala.Option scala.Option scala.collection.Seq ), $anonfun$getAsORC$1(com.dataiku.dip.spark.catalog.DSSTableCatalog$$anon$1 java.util.HashMap scala.Option scala.Option scala.collection.Seq ), $anonfun$makeTableWithDSSPartitionSpecIfNeeded$6(com.dataiku.dip.partitioning.FilePartition java.lang.String ), $anonfun$makeTableWithDSSPartitionSpecIfNeeded$7(java.lang.String ), $anonfun$makeTableWithDSSPartitionSpecIfNeeded$8(scala.collection.mutable.Buffer java.lang.String com.dataiku.dip.fs.FSPath )}, serializedLambda);
            }
        }.get(sqlContext, dataset, sampling, partitions, columnNames, filterExpression)) == null) {
            throw new MatchError(tuple2);
        }
        Table table = (Table)tuple2._1();
        FlowDatasetRef.InputDatasetDataframeReadMode mode = (FlowDatasetRef.InputDatasetDataframeReadMode)tuple2._2();
        Tuple2 tuple24 = new Tuple2((Object)table, (Object)mode);
        Table table2 = (Table)tuple24._1();
        FlowDatasetRef.InputDatasetDataframeReadMode mode2 = (FlowDatasetRef.InputDatasetDataframeReadMode)tuple24._2();
        DSSTableCatalog$.MODULE$.logger().info((Object)new StringBuilder(15).append("Built table as ").append(mode2).toString());
        return table2;
    }

    public Table createTable(Identifier identifier, StructType structType, Transform[] transforms, java.util.Map<String, String> map) {
        throw new UnsupportedOperationException("Create not allowed");
    }

    public Table alterTable(Identifier identifier, Seq<TableChange> tableChanges) {
        throw new UnsupportedOperationException("Alter not allowed");
    }

    public boolean dropTable(Identifier identifier) {
        throw new UnsupportedOperationException("Drop not allowed");
    }

    public void renameTable(Identifier identifier, Identifier identifier1) {
        throw new UnsupportedOperationException("Rename not allowed");
    }

    public String[][] listNamespaces() {
        String[][] stringArray;
        DSSTableCatalog$.MODULE$.logger().info((Object)"List namespaces ");
        Tuple2<TicketBasedIntercomAPIClient, Object> tuple2 = this.getClient();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TicketBasedIntercomAPIClient client = (TicketBasedIntercomAPIClient)tuple2._1();
        boolean doClose = tuple2._2$mcZ$sp();
        Tuple2 tuple22 = new Tuple2((Object)client, (Object)BoxesRunTime.boxToBoolean((boolean)doClose));
        TicketBasedIntercomAPIClient client2 = (TicketBasedIntercomAPIClient)tuple22._1();
        boolean doClose2 = tuple22._2$mcZ$sp();
        try {
            java.util.List projectKeys = (java.util.List)client2.getForm(new StringBuilder(25).append(this.com$dataiku$dip$spark$catalog$DSSTableCatalog$$clientFactory().apiPath()).append("/projects/list-accessible").toString(), java.util.List.class, new Object[0]);
            stringArray = (String[][])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(projectKeys).asScala()).map((Function1 & Serializable & scala.Serializable)projectKey -> (String[])((Object[])new String[]{projectKey}), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        }
        finally {
            if (doClose2) {
                client2.close();
            }
        }
        return stringArray;
    }

    public String[][] listNamespaces(String[] strings) {
        throw new UnsupportedOperationException("No namespace nesting");
    }

    public java.util.Map<String, String> loadNamespaceMetadata(String[] namespace) {
        java.util.Map map;
        if (namespace == null || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespace)).isEmpty()) {
            throw new UnsupportedOperationException("Can't get namespace metadata, a non-empty namespace is required");
        }
        DSSTableCatalog$.MODULE$.logger().info((Object)new StringBuilder(27).append("Get namespace metadata for ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespace)).mkString(", ")).toString());
        String projectKey = namespace[0];
        Tuple2<TicketBasedIntercomAPIClient, Object> tuple2 = this.getClient();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TicketBasedIntercomAPIClient client = (TicketBasedIntercomAPIClient)tuple2._1();
        boolean doClose = tuple2._2$mcZ$sp();
        Tuple2 tuple22 = new Tuple2((Object)client, (Object)BoxesRunTime.boxToBoolean((boolean)doClose));
        TicketBasedIntercomAPIClient client2 = (TicketBasedIntercomAPIClient)tuple22._1();
        boolean doClose2 = tuple22._2$mcZ$sp();
        try {
            SerializedProject sp2 = (SerializedProject)client2.getForm(new StringBuilder(13).append(this.com$dataiku$dip$spark$catalog$DSSTableCatalog$$clientFactory().apiPath()).append("/projects/get").toString(), SerializedProject.class, new Object[]{"projectKey", projectKey});
            map = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"projectKey"), (Object)projectKey), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"owner"), (Object)sp2.owner)}))).asJava();
        }
        finally {
            if (doClose2) {
                client2.close();
            }
        }
        return map;
    }

    public void createNamespace(String[] strings, java.util.Map<String, String> map) {
        throw new UnsupportedOperationException("Create namespace not allowed");
    }

    public void alterNamespace(String[] strings, Seq<NamespaceChange> namespaceChanges) {
        throw new UnsupportedOperationException("Alter namespace not allowed");
    }

    public boolean dropNamespace(String[] strings) {
        throw new UnsupportedOperationException("Drop namespace not allowed");
    }

    public void alterNamespace(String[] strings, NamespaceChange[] namespaceChanges) {
        this.alterNamespace(strings, (Seq<NamespaceChange>)Predef$.MODULE$.wrapRefArray((Object[])namespaceChanges));
    }

    public Table alterTable(Identifier identifier, TableChange[] tableChanges) {
        return this.alterTable(identifier, (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])tableChanges));
    }
}

