/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.ldif.anonymizer;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.ldif.anonymizer.AbstractAnonymizer;

public class BinaryAnonymizer
extends AbstractAnonymizer<byte[]> {
    protected Map<Integer, byte[]> latestBytesMap = new HashMap<Integer, byte[]>();

    public BinaryAnonymizer() {
        this.latestBytesMap = new HashMap<Integer, byte[]>();
    }

    public BinaryAnonymizer(Map<Integer, byte[]> latestBytesMap) {
        this.latestBytesMap = latestBytesMap == null ? new HashMap<Integer, byte[]>() : latestBytesMap;
    }

    @Override
    public Attribute anonymize(Map<Value, Value> valueMap, Set<Value> valueSet, Attribute attribute) {
        DefaultAttribute result = new DefaultAttribute(attribute.getAttributeType());
        for (Value value : attribute) {
            byte[] bytesValue = value.getBytes();
            byte[] newValue = this.computeNewValue(bytesValue);
            try {
                result.add(new byte[][]{newValue});
                Value anonValue = new Value(attribute.getAttributeType(), newValue);
                valueMap.put(value, anonValue);
                valueSet.add(anonValue);
            }
            catch (LdapInvalidAttributeValueException e) {
                throw new RuntimeException(I18n.err(I18n.ERR_13436_ERROR_ANONYMIZING_VALUE, value));
            }
        }
        return result;
    }

    @Override
    public Map<Integer, byte[]> getLatestBytesMap() {
        return this.latestBytesMap;
    }

    @Override
    public void setLatestBytesMap(Map<Integer, byte[]> latestBytesMap) {
        this.latestBytesMap = latestBytesMap;
    }
}

