/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.signoff;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.signoff.SignoffConfiguration;
import com.dataiku.gh.core.models.signoff.SignoffConfigurationId;
import com.dataiku.gh.core.storage.signoff.ISignoffsConfigurationsDAO;
import com.dataiku.gh.core.storage.sql.AbstractItemBasedDAO;
import com.dataiku.gh.core.storage.sql.model.QSignoffConfigurations;
import com.dataiku.gh.core.storage.sql.model.QSignoffConfigurationsHistory;
import com.dataiku.gh.core.storage.sql.signoff.SignoffConfigurationRowMapper;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.DslExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class SignoffsConfigurationsDAO
extends AbstractItemBasedDAO<SignoffConfigurationId, SignoffConfiguration, SignoffConfiguration>
implements ISignoffsConfigurationsDAO {
    @Autowired
    private SignoffConfigurationRowMapper signoffConfigurationRowMapper;
    public static final String SIGNOFFS_CONFIGURATIONS_BY_BLUEPRINT_VERSION_SUBQUERY_ALIAS = "signoffs_configurations_by_blueprint_version_subquery_alias";
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.storage.signoffs-configurations");

    @Override
    protected EntityType getEntityType() {
        return EntityType.SIGNOFF_CONFIGURATION;
    }

    @Override
    protected RowMapper<SignoffConfiguration> getRowMapper() {
        return this.signoffConfigurationRowMapper;
    }

    @Override
    protected SignoffConfigurationId getId(SignoffConfiguration item) {
        return item.id;
    }

    @Override
    protected RelationalPathBase<?> getItemTablePath() {
        return QSignoffConfigurations.signoffConfigurations;
    }

    @Override
    protected SimplePath<Object> getItemTableJsonColumnPath() {
        return QSignoffConfigurations.signoffConfigurations.signoffConfigurationJson;
    }

    @Override
    protected RelationalPathBase<?> getHistoryTablePath() {
        return QSignoffConfigurationsHistory.signoffConfigurationsHistory;
    }

    @Override
    protected SimplePath<Object> getHistoryRevisionColumnPath() {
        return QSignoffConfigurationsHistory.signoffConfigurationsHistory._revisionJson;
    }

    @Override
    protected SimplePath<Object> getHistoryJsonColumnPath() {
        return QSignoffConfigurationsHistory.signoffConfigurationsHistory.signoffConfigurationJson;
    }

    @Override
    protected Predicate getIdCondition(SignoffConfigurationId signoffConfigurationId) {
        return this.equalsBlueprintVersionId(signoffConfigurationId.blueprintVersionId).and((Predicate)QSignoffConfigurations.signoffConfigurations.signoffConfigurationStepId.eq((Object)signoffConfigurationId.stepId));
    }

    @Override
    public List<SignoffConfiguration> listByBlueprintVersion(BlueprintVersionId blueprintVersionId) throws IOException {
        try {
            SQLQuery query = (SQLQuery)this.buildBaseSelectQuery().where((Predicate)this.equalsBlueprintVersionId(blueprintVersionId));
            return this.querydslJdbcTemplate.query(query, this.signoffConfigurationRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public void deleteByBlueprintVersion(BlueprintVersionId blueprintVersionId) throws IOException {
        SQLDeleteClause where = (SQLDeleteClause)this.sqlQueryFactory.delete(this.getItemTablePath()).where((Predicate)this.equalsBlueprintVersionId(blueprintVersionId));
        this.batchDelete(where);
    }

    @Override
    public void lockByBlueprintVersion(BlueprintVersionId blueprintVersionId) throws IOException {
        try {
            SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QSignoffConfigurations.signoffConfigurations)).where((Predicate)this.equalsBlueprintVersionId(blueprintVersionId))).forUpdate();
            this.querydslJdbcTemplate.queryForList(query);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public void deleteAllButSteps(BlueprintVersionId blueprintVersionId, List<String> existingStepIds) throws IOException {
        SQLDeleteClause where = (SQLDeleteClause)this.sqlQueryFactory.delete(this.getItemTablePath()).where((Predicate)this.equalsBlueprintVersionId(blueprintVersionId).and((Predicate)QSignoffConfigurations.signoffConfigurations.signoffConfigurationStepId.notIn(existingStepIds)));
        this.batchDelete(where);
    }

    private BooleanExpression equalsBlueprintVersionId(BlueprintVersionId id) {
        return QSignoffConfigurations.signoffConfigurations.signoffConfigurationBlueprintId.eq((Object)id.blueprintId).and((Predicate)QSignoffConfigurations.signoffConfigurations.signoffConfigurationVersionId.eq((Object)id.versionId));
    }

    public static DslExpression<?> buildSignoffsConfigurationsByBlueprintVersionSubQuery(Expression<String> blueprintId, Expression<String> versionId) {
        return QueryBuilderUtils.coalesceToJsonbEmptyArray((Expression)((SQLQuery)((SQLQuery)SQLExpressions.select(QueryBuilderUtils.jsonAgg(QSignoffConfigurations.signoffConfigurations.signoffConfigurationJson, null)).from((Expression)QSignoffConfigurations.signoffConfigurations)).where((Predicate)QSignoffConfigurations.signoffConfigurations.signoffConfigurationBlueprintId.eq(blueprintId).and((Predicate)QSignoffConfigurations.signoffConfigurations.signoffConfigurationVersionId.eq(versionId)))).groupBy(new Expression[]{QSignoffConfigurations.signoffConfigurations.signoffConfigurationBlueprintId, QSignoffConfigurations.signoffConfigurations.signoffConfigurationVersionId})).as(SIGNOFFS_CONFIGURATIONS_BY_BLUEPRINT_VERSION_SUBQUERY_ALIAS);
    }
}

