/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.com.nimbusds.jose.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.snowflake.ingest.internal.com.nimbusds.jose.shaded.json.JSONObject;
import net.snowflake.ingest.internal.com.nimbusds.jose.shaded.json.parser.JSONParser;
import net.snowflake.ingest.internal.com.nimbusds.jose.util.Base64URL;

public class JSONObjectUtils {
    public static Map<String, Object> parse(String s2) throws ParseException {
        Object o;
        try {
            o = new JSONParser(640).parse(s2);
        }
        catch (net.snowflake.ingest.internal.com.nimbusds.jose.shaded.json.parser.ParseException e) {
            throw new ParseException("Invalid JSON: " + e.getMessage(), 0);
        }
        catch (Exception e) {
            throw new ParseException("Unexpected exception: " + e.getMessage(), 0);
        }
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new ParseException("JSON entity is not an object", 0);
    }

    @Deprecated
    public static Map<String, Object> parseJSONObject(String s2) throws ParseException {
        return JSONObjectUtils.parse(s2);
    }

    private static <T> T getGeneric(Map<String, Object> o, String key, Class<T> clazz) throws ParseException {
        if (o.get(key) == null) {
            return null;
        }
        Object value = o.get(key);
        if (!clazz.isAssignableFrom(value.getClass())) {
            throw new ParseException("Unexpected type of JSON object member with key \"" + key + "\"", 0);
        }
        return (T)value;
    }

    public static boolean getBoolean(Map<String, Object> o, String key) throws ParseException {
        Boolean value = JSONObjectUtils.getGeneric(o, key, Boolean.class);
        if (value == null) {
            throw new ParseException("JSON object member with key \"" + key + "\" is missing or null", 0);
        }
        return value;
    }

    public static int getInt(Map<String, Object> o, String key) throws ParseException {
        Number value = JSONObjectUtils.getGeneric(o, key, Number.class);
        if (value == null) {
            throw new ParseException("JSON object member with key \"" + key + "\" is missing or null", 0);
        }
        return value.intValue();
    }

    public static long getLong(Map<String, Object> o, String key) throws ParseException {
        Number value = JSONObjectUtils.getGeneric(o, key, Number.class);
        if (value == null) {
            throw new ParseException("JSON object member with key \"" + key + "\" is missing or null", 0);
        }
        return value.longValue();
    }

    public static float getFloat(Map<String, Object> o, String key) throws ParseException {
        Number value = JSONObjectUtils.getGeneric(o, key, Number.class);
        if (value == null) {
            throw new ParseException("JSON object member with key \"" + key + "\" is missing or null", 0);
        }
        return value.floatValue();
    }

    public static double getDouble(Map<String, Object> o, String key) throws ParseException {
        Number value = JSONObjectUtils.getGeneric(o, key, Number.class);
        if (value == null) {
            throw new ParseException("JSON object member with key \"" + key + "\" is missing or null", 0);
        }
        return value.doubleValue();
    }

    public static String getString(Map<String, Object> o, String key) throws ParseException {
        return JSONObjectUtils.getGeneric(o, key, String.class);
    }

    public static URI getURI(Map<String, Object> o, String key) throws ParseException {
        String value = JSONObjectUtils.getString(o, key);
        if (value == null) {
            return null;
        }
        try {
            return new URI(value);
        }
        catch (URISyntaxException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    public static List<Object> getJSONArray(Map<String, Object> o, String key) throws ParseException {
        return JSONObjectUtils.getGeneric(o, key, List.class);
    }

    public static String[] getStringArray(Map<String, Object> o, String key) throws ParseException {
        List<Object> jsonArray = JSONObjectUtils.getJSONArray(o, key);
        if (jsonArray == null) {
            return null;
        }
        try {
            return jsonArray.toArray(new String[0]);
        }
        catch (ArrayStoreException e) {
            throw new ParseException("JSON object member with key \"" + key + "\" is not an array of strings", 0);
        }
    }

    public static List<String> getStringList(Map<String, Object> o, String key) throws ParseException {
        String[] array = JSONObjectUtils.getStringArray(o, key);
        if (array == null) {
            return null;
        }
        return Arrays.asList(array);
    }

    public static Map<String, Object> getJSONObject(Map<String, Object> o, String key) throws ParseException {
        return JSONObjectUtils.getGeneric(o, key, JSONObject.class);
    }

    public static Base64URL getBase64URL(Map<String, Object> o, String key) throws ParseException {
        String value = JSONObjectUtils.getString(o, key);
        if (value == null) {
            return null;
        }
        return new Base64URL(value);
    }

    public static String toJSONString(Map<String, ?> o) {
        return JSONObject.toJSONString(o);
    }

    public static Map<String, Object> newJSONObject() {
        return new HashMap<String, Object>();
    }

    private JSONObjectUtils() {
    }
}

